/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.protocol.BatchFileAckMessage;
import com.file.netty.protocol.BatchFileInfoMessage;
import com.file.netty.protocol.CompressedBatchCompleteMessage;
import com.file.netty.protocol.CompressedBatchDataMessage;
import com.file.netty.protocol.CompressedBatchManifestAckMessage;
import com.file.netty.protocol.CompressedBatchManifestMessage;
import com.file.netty.protocol.EncryptedMessage;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileEntryInfo;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.FileSkipMessage;
import com.file.netty.protocol.FolderCompleteAckMessage;
import com.file.netty.protocol.FolderCompleteMessage;
import com.file.netty.protocol.FolderInfoAckMessage;
import com.file.netty.protocol.FolderInfoMessage;
import com.file.netty.protocol.HeartbeatMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import com.file.netty.protocol.RegisterMessage;
import com.file.netty.protocol.RegisterResultMessage;
import com.file.netty.protocol.TransferAckMessage;
import com.file.netty.protocol.TransferCompleteMessage;
import com.file.netty.protocol.TransferStatsMessage;
import com.file.netty.utils.EncryptionUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.nutz.json.Json;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageDecoder.class);
    private SecretKey decryptionKey;
    private boolean decryptionEnabled = true;

    public JsonMessageDecoder() {
        this.decryptionKey = EncryptionUtils.getDefaultKey();
    }

    public JsonMessageDecoder(SecretKey decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int length = in.readInt();
        if (length > 0x6400000) {
            in.resetReaderIndex();
            throw new IllegalArgumentException("\u6d88\u606f\u5927\u5c0f\u8d85\u8fc7\u9650\u5236: " + length + " bytes");
        }
        if (in.readableBytes() < length) {
            logger.warn("\u274c \u6d88\u606f\u4e0d\u5b8c\u6574: \u9700\u8981{}\u5b57\u8282, \u4f46\u53ea\u6709{}\u5b57\u8282\u53ef\u8bfb", (Object)length, (Object)in.readableBytes());
            in.resetReaderIndex();
            return;
        }
        byte[] data = new byte[length];
        in.readBytes(data);
        logger.info("\u2705 \u6210\u529f\u8bfb\u53d6\u6d88\u606f\u6570\u636e: \u58f0\u660e\u957f\u5ea6={}, \u5b9e\u9645\u8bfb\u53d6={}", (Object)length, (Object)data.length);
        try {
            Message message;
            String json = new String(data, "UTF-8");
            logger.info("\ud83d\udccb JSON\u5b57\u7b26\u4e32\u957f\u5ea6={}, \u524d100\u5b57\u7b26: {}", (Object)json.length(), (Object)(json.length() > 100 ? json.substring(0, 100) + "..." : json));
            Message processedMessage = message = this.parseJsonToMessage(json);
            if (this.decryptionEnabled) {
                processedMessage = this.processDecryptedMessage(message);
            }
            out.add(processedMessage);
            logger.info("\ud83d\udce8 \u89e3\u7801\u6d88\u606f: {}", (Object)processedMessage.getType());
        }
        catch (Exception e) {
            logger.error("JSON\u89e3\u7801\u5931\u8d25", e);
            throw e;
        }
    }

    private Message parseJsonToMessage(String json) throws Exception {
        NutMap jsonMap = Json.fromJson(NutMap.class, (CharSequence)json);
        String type = jsonMap.getString("type");
        String sessionId = jsonMap.getString("sessionId");
        NutMap dataMap = jsonMap.getAs("data", NutMap.class);
        MessageType messageType = MessageType.valueOf(type);
        Message message = this.createMessageByType(messageType, dataMap);
        message.setSessionId(sessionId);
        return message;
    }

    private Message createMessageByType(MessageType type, NutMap dataMap) throws Exception {
        switch (type) {
            case REGISTER: {
                return new RegisterMessage(null);
            }
            case REGISTER_RESULT: {
                return new RegisterResultMessage(null, dataMap.getBoolean("success"));
            }
            case JOIN: {
                return new JoinMessage(null);
            }
            case JOIN_RESULT: {
                return new JoinResultMessage(null, dataMap.getBoolean("success"));
            }
            case FILE_INFO: {
                return new FileInfoMessage(null, dataMap.getString("fileName"), dataMap.getLong("fileSize"), dataMap.getInt("chunks"), dataMap.getInt("chunkSize"), dataMap.getString("md5"));
            }
            case FILE_CHUNK: {
                byte[] chunkData = Base64.getDecoder().decode(dataMap.getString("data"));
                return new FileChunkMessage(null, dataMap.getInt("chunkIndex"), chunkData);
            }
            case FOLDER_INFO: {
                return this.parseFolderInfoMessage(dataMap);
            }
            case FOLDER_INFO_ACK: {
                return new FolderInfoAckMessage(null);
            }
            case FOLDER_COMPLETE: {
                return new FolderCompleteMessage(null, dataMap.getString("folderName"), dataMap.getInt("totalFiles"), dataMap.getLong("totalSize"));
            }
            case FOLDER_COMPLETE_ACK: {
                return new FolderCompleteAckMessage(null, dataMap.getString("folderName"), dataMap.getInt("receivedFiles"), dataMap.getInt("skippedFiles"), dataMap.getLong("receivedBytes"));
            }
            case TRANSFER_COMPLETE: {
                return new TransferCompleteMessage(null);
            }
            case TRANSFER_ACK: {
                return new TransferAckMessage(null);
            }
            case ERROR: {
                return new ErrorMessage(null, dataMap.getString("errorMsg"));
            }
            case HEARTBEAT: {
                return new HeartbeatMessage();
            }
            case ENCRYPTED_DATA: {
                return this.parseEncryptedMessage(dataMap);
            }
            case FILE_SKIP: {
                return new FileSkipMessage(null, dataMap.getString("fileName"), dataMap.getString("reason"), dataMap.getLong("fileSize"));
            }
            case BATCH_FILE_INFO: {
                return this.parseBatchFileInfoMessage(dataMap);
            }
            case BATCH_FILE_ACK: {
                return this.parseBatchFileAckMessage(dataMap);
            }
            case COMPRESSED_BATCH_MANIFEST: {
                return this.parseCompressedBatchManifestMessage(dataMap);
            }
            case COMPRESSED_BATCH_MANIFEST_ACK: {
                return this.parseCompressedBatchManifestAckMessage(dataMap);
            }
            case COMPRESSED_BATCH_DATA: {
                return this.parseCompressedBatchDataMessage(dataMap);
            }
            case COMPRESSED_BATCH_COMPLETE: {
                return this.parseCompressedBatchCompleteMessage(dataMap);
            }
            case TRANSFER_STATS: {
                return this.parseTransferStatsMessage(dataMap);
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6d88\u606f\u7c7b\u578b: " + (Object)((Object)type));
    }

    private FolderInfoMessage parseFolderInfoMessage(NutMap dataMap) throws Exception {
        String folderName = dataMap.getString("folderName");
        int totalFiles = dataMap.getInt("totalFiles");
        long totalSize = dataMap.getLong("totalSize");
        int chunkSize = dataMap.getInt("chunkSize");
        ArrayList<String> emptyDirectories = (ArrayList<String>)dataMap.get("emptyDirectories");
        if (emptyDirectories == null) {
            emptyDirectories = new ArrayList<String>();
        }
        return new FolderInfoMessage(null, folderName, emptyDirectories, totalFiles, totalSize, chunkSize);
    }

    private List<FileEntryInfo> parseFileEntries(List<NutMap> entriesMapList) throws Exception {
        ArrayList<FileEntryInfo> entries = new ArrayList<FileEntryInfo>();
        if (entriesMapList != null) {
            for (NutMap entryMap : entriesMapList) {
                String relativePath = entryMap.getString("relativePath");
                long fileSize = entryMap.getLong("fileSize");
                boolean isDirectory = entryMap.getBoolean("isDirectory");
                entries.add(new FileEntryInfo(relativePath, fileSize, isDirectory));
            }
        }
        return entries;
    }

    private EncryptedMessage parseEncryptedMessage(NutMap dataMap) throws Exception {
        MessageType originalType = MessageType.valueOf(dataMap.getString("originalType"));
        byte[] encryptedData = Base64.getDecoder().decode(dataMap.getString("encryptedData"));
        byte[] iv = Base64.getDecoder().decode(dataMap.getString("iv"));
        return new EncryptedMessage(null, originalType, encryptedData, iv);
    }

    private Message processDecryptedMessage(Message message) {
        if (EncryptionUtils.isEncryptedMessage(message)) {
            try {
                EncryptedMessage encryptedMsg = (EncryptedMessage)message;
                logger.info("\ud83d\udd13 \u5f00\u59cb\u89e3\u5bc6\u6d88\u606f\uff0c\u539f\u59cb\u7c7b\u578b: {}", (Object)encryptedMsg.getOriginalType());
                Message decryptedMsg = EncryptionUtils.decryptMessage(encryptedMsg, this.decryptionKey);
                logger.info("\u2705 \u6d88\u606f\u89e3\u5bc6\u6210\u529f: ENCRYPTED_DATA -> {}", (Object)decryptedMsg.getType());
                return decryptedMsg;
            }
            catch (Exception e) {
                logger.error("\u274c \u6d88\u606f\u89e3\u5bc6\u5931\u8d25", e);
                return message;
            }
        }
        return message;
    }

    public void setDecryptionKey(SecretKey key) {
        this.decryptionKey = key;
    }

    public void setDecryptionEnabled(boolean enabled) {
        this.decryptionEnabled = enabled;
    }

    private BatchFileInfoMessage parseBatchFileInfoMessage(NutMap dataMap) throws Exception {
        int batchId = dataMap.getInt("batchId");
        long totalSize = dataMap.getLong("totalSize");
        int totalFiles = dataMap.getInt("totalFiles");
        List filesMapList = (List)dataMap.get("files");
        List<BatchFileInfoMessage.BatchFileEntry> files = this.parseBatchFileEntries(filesMapList);
        return new BatchFileInfoMessage(null, files, batchId);
    }

    private BatchFileAckMessage parseBatchFileAckMessage(NutMap dataMap) throws Exception {
        int batchId = dataMap.getInt("batchId");
        boolean allProcessed = dataMap.getBoolean("allProcessed");
        List acceptedFiles = (List)dataMap.get("acceptedFiles");
        List skippedFiles = (List)dataMap.get("skippedFiles");
        Map errorFiles = (Map)dataMap.get("errorFiles");
        BatchFileAckMessage message = new BatchFileAckMessage(null, batchId, acceptedFiles, skippedFiles, errorFiles);
        message.setAllProcessed(allProcessed);
        return message;
    }

    private List<BatchFileInfoMessage.BatchFileEntry> parseBatchFileEntries(List<NutMap> entriesMapList) throws Exception {
        ArrayList<BatchFileInfoMessage.BatchFileEntry> entries = new ArrayList<BatchFileInfoMessage.BatchFileEntry>();
        if (entriesMapList != null) {
            for (NutMap entryMap : entriesMapList) {
                String fileName = entryMap.getString("fileName");
                long fileSize = entryMap.getLong("fileSize");
                String md5 = entryMap.getString("md5");
                int chunks = entryMap.getInt("chunks");
                int chunkSize = entryMap.getInt("chunkSize");
                entries.add(new BatchFileInfoMessage.BatchFileEntry(fileName, fileSize, md5, chunks, chunkSize));
            }
        }
        return entries;
    }

    private CompressedBatchManifestMessage parseCompressedBatchManifestMessage(NutMap dataMap) throws Exception {
        logger.info("\ud83d\udce5 \u5f00\u59cb\u89e3\u6790\u538b\u7f29\u6279\u6b21\u6e05\u5355: \u4f7f\u7528Nutz JSON\u5e93");
        int batchId = dataMap.getInt("batchId");
        String batchName = dataMap.getString("batchName");
        long totalOriginalSize = dataMap.getLong("totalOriginalSize");
        long estimatedCompressedSize = dataMap.getLong("estimatedCompressedSize");
        double estimatedCompressionRatio = dataMap.getDouble("estimatedCompressionRatio");
        int currentBatchIndex = dataMap.getInt("currentBatchIndex");
        int totalBatches = dataMap.getInt("totalBatches");
        List filesMapList = (List)dataMap.get("files");
        logger.info("\ud83d\udd0d \u89e3\u6790\u538b\u7f29\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6587\u4ef6\u6570={}", (Object)batchId, (Object)(filesMapList != null ? filesMapList.size() : 0));
        ArrayList<CompressedBatchManifestMessage.BatchFileManifest> files = new ArrayList<CompressedBatchManifestMessage.BatchFileManifest>();
        if (filesMapList != null) {
            for (NutMap fileMap : filesMapList) {
                String relativePath = fileMap.getString("relativePath");
                long fileSize = fileMap.getLong("fileSize");
                String md5 = fileMap.getString("md5");
                long lastModified = fileMap.getLong("lastModified");
                boolean isTextFile = fileMap.getBoolean("isTextFile");
                files.add(new CompressedBatchManifestMessage.BatchFileManifest(relativePath, fileSize, md5, lastModified, isTextFile));
            }
        }
        logger.info("\u2705 \u89e3\u6790\u538b\u7f29\u6279\u6b21\u6e05\u5355\u5b8c\u6210: \u6279\u6b21ID={}, \u89e3\u6790\u51fa\u6587\u4ef6\u6570={}", (Object)batchId, (Object)files.size());
        CompressedBatchManifestMessage message = new CompressedBatchManifestMessage(null, batchId, batchName, files, currentBatchIndex, totalBatches);
        message.setTotalOriginalSize(totalOriginalSize);
        message.setEstimatedCompressedSize(estimatedCompressedSize);
        message.setEstimatedCompressionRatio(estimatedCompressionRatio);
        return message;
    }

    private CompressedBatchManifestAckMessage parseCompressedBatchManifestAckMessage(NutMap dataMap) throws Exception {
        int batchId = dataMap.getInt("batchId");
        boolean acceptBatch = dataMap.getBoolean("acceptBatch");
        String rejectReason = dataMap.getString("rejectReason");
        List requiredFiles = (List)dataMap.get("requiredFiles");
        List skippedFiles = (List)dataMap.get("skippedFiles");
        Map errorFiles = (Map)dataMap.get("errorFiles");
        CompressedBatchManifestAckMessage message = new CompressedBatchManifestAckMessage(null, batchId, requiredFiles, skippedFiles, errorFiles);
        message.setAcceptBatch(acceptBatch);
        if (rejectReason != null) {
            message.setRejectReason(rejectReason);
        }
        long requiredTotalSize = dataMap.getLong("requiredTotalSize");
        long skippedTotalSize = dataMap.getLong("skippedTotalSize");
        message.setStatistics(requiredTotalSize, skippedTotalSize);
        return message;
    }

    private CompressedBatchDataMessage parseCompressedBatchDataMessage(NutMap dataMap) throws Exception {
        int batchId = dataMap.getInt("batchId");
        String compressedFileName = dataMap.getString("compressedFileName");
        long originalSize = dataMap.getLong("originalSize");
        long compressedSize = dataMap.getLong("compressedSize");
        String compressionMd5 = dataMap.getString("compressionMd5");
        int fileCount = dataMap.getInt("fileCount");
        return new CompressedBatchDataMessage(null, batchId, compressedFileName, originalSize, compressedSize, compressionMd5, fileCount);
    }

    private CompressedBatchCompleteMessage parseCompressedBatchCompleteMessage(NutMap dataMap) throws Exception {
        int batchId = dataMap.getInt("batchId");
        boolean success = dataMap.getBoolean("success");
        int processedFiles = dataMap.getInt("processedFiles");
        int failedFiles = dataMap.getInt("failedFiles");
        long processedSize = dataMap.getLong("processedSize");
        long processingTimeMs = dataMap.getLong("processingTimeMs");
        String errorMessage = dataMap.getString("errorMessage");
        Map failedFileReasons = (Map)dataMap.get("failedFileReasons");
        CompressedBatchCompleteMessage message = new CompressedBatchCompleteMessage(null, batchId, success);
        message.setProcessedFiles(processedFiles);
        message.setFailedFiles(failedFiles);
        message.setProcessedSize(processedSize);
        message.setProcessingTimeMs(processingTimeMs);
        if (errorMessage != null) {
            message.setErrorMessage(errorMessage);
        }
        if (failedFileReasons != null && !failedFileReasons.isEmpty()) {
            message.setFailedFileReasons(failedFileReasons);
        }
        return message;
    }

    private TransferStatsMessage parseTransferStatsMessage(NutMap dataMap) throws Exception {
        int totalBatches = dataMap.getInt("totalBatches");
        int totalSingleFiles = dataMap.getInt("totalSingleFiles");
        return new TransferStatsMessage(totalBatches, totalSingleFiles);
    }
}

