/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.protocol.BatchFileAckMessage;
import com.file.netty.protocol.BatchFileInfoMessage;
import com.file.netty.protocol.CompressedBatchCompleteMessage;
import com.file.netty.protocol.CompressedBatchDataMessage;
import com.file.netty.protocol.CompressedBatchManifestAckMessage;
import com.file.netty.protocol.CompressedBatchManifestMessage;
import com.file.netty.protocol.EncryptedMessage;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.FileSkipMessage;
import com.file.netty.protocol.FolderCompleteAckMessage;
import com.file.netty.protocol.FolderCompleteMessage;
import com.file.netty.protocol.FolderInfoAckMessage;
import com.file.netty.protocol.FolderInfoMessage;
import com.file.netty.protocol.HeartbeatMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.RegisterMessage;
import com.file.netty.protocol.RegisterResultMessage;
import com.file.netty.protocol.TransferAckMessage;
import com.file.netty.protocol.TransferCompleteMessage;
import com.file.netty.protocol.TransferStatsMessage;
import com.file.netty.utils.EncryptionUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageEncoder
extends MessageToByteEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageEncoder.class);
    private SecretKey encryptionKey;
    private boolean encryptionEnabled = true;

    public JsonMessageEncoder() {
        this.encryptionKey = EncryptionUtils.getDefaultKey();
    }

    public JsonMessageEncoder(SecretKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) throws Exception {
        Message processedMessage = msg;
        if (this.encryptionEnabled) {
            processedMessage = EncryptionUtils.encryptMessage(msg, this.encryptionKey);
        }
        try {
            String json = this.messageToJson(processedMessage);
            byte[] data = json.getBytes("UTF-8");
            out.writeInt(data.length);
            out.writeBytes(data);
            logger.debug("\u7f16\u7801\u6d88\u606f: {} -> {} bytes", (Object)processedMessage.getType(), (Object)data.length);
        }
        catch (Exception e) {
            logger.error("JSON\u7f16\u7801\u5931\u8d25: {}", (Object)msg.getType(), (Object)e);
            throw e;
        }
    }

    private String messageToJson(Message message) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"type\":\"").append(message.getType().name()).append("\",");
        json.append("\"sessionId\":").append(this.quote(message.getSessionId())).append(",");
        json.append("\"data\":");
        switch (message.getType()) {
            case REGISTER: {
                json.append(this.registerMessageToJson((RegisterMessage)message));
                break;
            }
            case REGISTER_RESULT: {
                json.append(this.registerResultMessageToJson((RegisterResultMessage)message));
                break;
            }
            case JOIN: {
                json.append(this.joinMessageToJson((JoinMessage)message));
                break;
            }
            case JOIN_RESULT: {
                json.append(this.joinResultMessageToJson((JoinResultMessage)message));
                break;
            }
            case FILE_INFO: {
                json.append(this.fileInfoMessageToJson((FileInfoMessage)message));
                break;
            }
            case FILE_CHUNK: {
                json.append(this.fileChunkMessageToJson((FileChunkMessage)message));
                break;
            }
            case FOLDER_INFO: {
                json.append(this.folderInfoMessageToJson((FolderInfoMessage)message));
                break;
            }
            case FOLDER_INFO_ACK: {
                json.append(this.folderInfoAckMessageToJson((FolderInfoAckMessage)message));
                break;
            }
            case FOLDER_COMPLETE: {
                json.append(this.folderCompleteMessageToJson((FolderCompleteMessage)message));
                break;
            }
            case FOLDER_COMPLETE_ACK: {
                json.append(this.folderCompleteAckMessageToJson((FolderCompleteAckMessage)message));
                break;
            }
            case TRANSFER_COMPLETE: {
                json.append(this.transferCompleteMessageToJson((TransferCompleteMessage)message));
                break;
            }
            case TRANSFER_ACK: {
                json.append(this.transferAckMessageToJson((TransferAckMessage)message));
                break;
            }
            case ERROR: {
                json.append(this.errorMessageToJson((ErrorMessage)message));
                break;
            }
            case HEARTBEAT: {
                json.append(this.heartbeatMessageToJson((HeartbeatMessage)message));
                break;
            }
            case ENCRYPTED_DATA: {
                json.append(this.encryptedMessageToJson((EncryptedMessage)message));
                break;
            }
            case FILE_SKIP: {
                json.append(this.fileSkipMessageToJson((FileSkipMessage)message));
                break;
            }
            case BATCH_FILE_INFO: {
                json.append(this.batchFileInfoMessageToJson((BatchFileInfoMessage)message));
                break;
            }
            case BATCH_FILE_ACK: {
                json.append(this.batchFileAckMessageToJson((BatchFileAckMessage)message));
                break;
            }
            case COMPRESSED_BATCH_MANIFEST: {
                json.append(this.compressedBatchManifestMessageToJson((CompressedBatchManifestMessage)message));
                break;
            }
            case COMPRESSED_BATCH_MANIFEST_ACK: {
                json.append(this.compressedBatchManifestAckMessageToJson((CompressedBatchManifestAckMessage)message));
                break;
            }
            case COMPRESSED_BATCH_DATA: {
                json.append(this.compressedBatchDataMessageToJson((CompressedBatchDataMessage)message));
                break;
            }
            case COMPRESSED_BATCH_COMPLETE: {
                json.append(this.compressedBatchCompleteMessageToJson((CompressedBatchCompleteMessage)message));
                break;
            }
            case TRANSFER_STATS: {
                json.append(this.transferStatsMessageToJson((TransferStatsMessage)message));
                break;
            }
            default: {
                json.append("{}");
            }
        }
        json.append("}");
        return json.toString();
    }

    private String registerMessageToJson(RegisterMessage msg) {
        return "{}";
    }

    private String registerResultMessageToJson(RegisterResultMessage msg) {
        return "{\"success\":" + msg.isSuccess() + "}";
    }

    private String joinMessageToJson(JoinMessage msg) {
        return "{}";
    }

    private String joinResultMessageToJson(JoinResultMessage msg) {
        return "{\"success\":" + msg.isSuccess() + "}";
    }

    private String fileInfoMessageToJson(FileInfoMessage msg) {
        return "{\"fileName\":" + this.quote(msg.getFileName()) + ",\"fileSize\":" + msg.getFileSize() + ",\"chunks\":" + msg.getChunks() + ",\"chunkSize\":" + msg.getChunkSize() + ",\"md5\":" + this.quote(msg.getMd5()) + "}";
    }

    private String fileChunkMessageToJson(FileChunkMessage msg) {
        String base64Data = Base64.getEncoder().encodeToString(msg.getData());
        return "{\"chunkIndex\":" + msg.getChunkIndex() + ",\"data\":" + this.quote(base64Data) + "}";
    }

    private String folderInfoMessageToJson(FolderInfoMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"folderName\":").append(this.quote(msg.getFolderName())).append(",");
        json.append("\"totalFiles\":").append(msg.getTotalFiles()).append(",");
        json.append("\"totalSize\":").append(msg.getTotalSize()).append(",");
        json.append("\"chunkSize\":").append(msg.getChunkSize()).append(",");
        json.append("\"emptyDirectories\":[");
        List<String> emptyDirectories = msg.getEmptyDirectories();
        for (int i = 0; i < emptyDirectories.size(); ++i) {
            String emptyDir = emptyDirectories.get(i);
            json.append(this.quote(emptyDir));
            if (i >= emptyDirectories.size() - 1) continue;
            json.append(",");
        }
        json.append("]}");
        return json.toString();
    }

    private String folderInfoAckMessageToJson(FolderInfoAckMessage msg) {
        return "{}";
    }

    private String folderCompleteMessageToJson(FolderCompleteMessage msg) {
        return "{\"folderName\":" + this.quote(msg.getFolderName()) + ",\"totalFiles\":" + msg.getTotalFiles() + ",\"totalSize\":" + msg.getTotalSize() + "}";
    }

    private String folderCompleteAckMessageToJson(FolderCompleteAckMessage msg) {
        return "{\"folderName\":" + this.quote(msg.getFolderName()) + ",\"receivedFiles\":" + msg.getReceivedFiles() + ",\"skippedFiles\":" + msg.getSkippedFiles() + ",\"receivedBytes\":" + msg.getReceivedBytes() + "}";
    }

    private String transferCompleteMessageToJson(TransferCompleteMessage msg) {
        return "{}";
    }

    private String transferAckMessageToJson(TransferAckMessage msg) {
        return "{}";
    }

    private String errorMessageToJson(ErrorMessage msg) {
        return "{\"errorMsg\":" + this.quote(msg.getErrorMsg()) + "}";
    }

    private String heartbeatMessageToJson(HeartbeatMessage msg) {
        return "{}";
    }

    private String encryptedMessageToJson(EncryptedMessage msg) {
        String encryptedData = Base64.getEncoder().encodeToString(msg.getEncryptedData());
        String iv = Base64.getEncoder().encodeToString(msg.getIv());
        return "{\"originalType\":\"" + msg.getOriginalType().name() + "\",\"encryptedData\":" + this.quote(encryptedData) + ",\"iv\":" + this.quote(iv) + "}";
    }

    private String fileSkipMessageToJson(FileSkipMessage msg) {
        return "{\"fileName\":" + this.quote(msg.getFileName()) + ",\"reason\":" + this.quote(msg.getReason()) + ",\"fileSize\":" + msg.getFileSize() + "}";
    }

    private String quote(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public void setEncryptionKey(SecretKey key) {
        this.encryptionKey = key;
    }

    public void setEncryptionEnabled(boolean enabled) {
        this.encryptionEnabled = enabled;
    }

    private String batchFileInfoMessageToJson(BatchFileInfoMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"batchId\":").append(msg.getBatchId()).append(",");
        json.append("\"totalSize\":").append(msg.getTotalSize()).append(",");
        json.append("\"totalFiles\":").append(msg.getTotalFiles()).append(",");
        json.append("\"files\":[");
        List<BatchFileInfoMessage.BatchFileEntry> files = msg.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            if (i > 0) {
                json.append(",");
            }
            BatchFileInfoMessage.BatchFileEntry entry = files.get(i);
            json.append("{");
            json.append("\"fileName\":").append(this.quote(entry.getFileName())).append(",");
            json.append("\"fileSize\":").append(entry.getFileSize()).append(",");
            json.append("\"md5\":").append(this.quote(entry.getMd5())).append(",");
            json.append("\"chunks\":").append(entry.getChunks()).append(",");
            json.append("\"chunkSize\":").append(entry.getChunkSize()).append(",");
            json.append("\"isEmpty\":").append(entry.isEmpty());
            json.append("}");
        }
        json.append("]}");
        return json.toString();
    }

    private String batchFileAckMessageToJson(BatchFileAckMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"batchId\":").append(msg.getBatchId()).append(",");
        json.append("\"allProcessed\":").append(msg.isAllProcessed()).append(",");
        json.append("\"acceptedFiles\":[");
        List<String> acceptedFiles = msg.getAcceptedFiles();
        if (acceptedFiles != null) {
            for (int i = 0; i < acceptedFiles.size(); ++i) {
                if (i > 0) {
                    json.append(",");
                }
                json.append(this.quote(acceptedFiles.get(i)));
            }
        }
        json.append("],");
        json.append("\"skippedFiles\":[");
        List<String> skippedFiles = msg.getSkippedFiles();
        if (skippedFiles != null) {
            for (int i = 0; i < skippedFiles.size(); ++i) {
                if (i > 0) {
                    json.append(",");
                }
                json.append(this.quote(skippedFiles.get(i)));
            }
        }
        json.append("],");
        json.append("\"errorFiles\":{");
        Map<String, String> errorFiles = msg.getErrorFiles();
        if (errorFiles != null) {
            int count = 0;
            for (Map.Entry<String, String> entry : errorFiles.entrySet()) {
                if (count > 0) {
                    json.append(",");
                }
                json.append(this.quote(entry.getKey())).append(":").append(this.quote(entry.getValue()));
                ++count;
            }
        }
        json.append("}");
        json.append("}");
        return json.toString();
    }

    private String compressedBatchManifestMessageToJson(CompressedBatchManifestMessage msg) {
        NutMap dataMap = new NutMap();
        dataMap.put("batchId", msg.getBatchId());
        dataMap.put("batchName", msg.getBatchName());
        dataMap.put("totalOriginalSize", msg.getTotalOriginalSize());
        dataMap.put("estimatedCompressedSize", msg.getEstimatedCompressedSize());
        dataMap.put("estimatedCompressionRatio", msg.getEstimatedCompressionRatio());
        dataMap.put("currentBatchIndex", msg.getCurrentBatchIndex());
        dataMap.put("totalBatches", msg.getTotalBatches());
        List<CompressedBatchManifestMessage.BatchFileManifest> files = msg.getFiles();
        if (files != null) {
            logger.info("\ud83d\udd0d \u7f16\u7801\u538b\u7f29\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6587\u4ef6\u6570={}", (Object)msg.getBatchId(), (Object)files.size());
            ArrayList<NutMap> filesMapList = new ArrayList<NutMap>();
            for (CompressedBatchManifestMessage.BatchFileManifest file : files) {
                NutMap fileMap = new NutMap();
                fileMap.put("relativePath", file.getRelativePath());
                fileMap.put("fileSize", file.getFileSize());
                fileMap.put("md5", file.getMd5());
                fileMap.put("lastModified", file.getLastModified());
                fileMap.put("isTextFile", file.isTextFile());
                filesMapList.add(fileMap);
            }
            dataMap.put("files", filesMapList);
        } else {
            logger.warn("\u26a0\ufe0f \u7f16\u7801\u538b\u7f29\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6587\u4ef6\u5217\u8868\u4e3anull!", (Object)msg.getBatchId());
            dataMap.put("files", new ArrayList());
        }
        String jsonStr = Json.toJson(dataMap, JsonFormat.compact());
        logger.info("\ud83d\udce4 \u7f16\u7801\u5b8c\u6210: \u6279\u6b21ID={}, JSON\u957f\u5ea6={}, \u6587\u4ef6\u6570={}", msg.getBatchId(), jsonStr.length(), files != null ? files.size() : 0);
        return jsonStr;
    }

    private String compressedBatchManifestAckMessageToJson(CompressedBatchManifestAckMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"batchId\":").append(msg.getBatchId()).append(",");
        json.append("\"acceptBatch\":").append(msg.isAcceptBatch()).append(",");
        if (msg.getRejectReason() != null) {
            json.append("\"rejectReason\":").append(this.quote(msg.getRejectReason())).append(",");
        }
        json.append("\"requiredTotalSize\":").append(msg.getRequiredTotalSize()).append(",");
        json.append("\"skippedTotalSize\":").append(msg.getSkippedTotalSize()).append(",");
        json.append("\"requiredFiles\":[");
        List<String> requiredFiles = msg.getRequiredFiles();
        if (requiredFiles != null) {
            for (int i = 0; i < requiredFiles.size(); ++i) {
                if (i > 0) {
                    json.append(",");
                }
                json.append(this.quote(requiredFiles.get(i)));
            }
        }
        json.append("],");
        json.append("\"skippedFiles\":[");
        List<String> skippedFiles = msg.getSkippedFiles();
        if (skippedFiles != null) {
            for (int i = 0; i < skippedFiles.size(); ++i) {
                if (i > 0) {
                    json.append(",");
                }
                json.append(this.quote(skippedFiles.get(i)));
            }
        }
        json.append("],");
        json.append("\"errorFiles\":{");
        Map<String, String> errorFiles = msg.getErrorFiles();
        if (errorFiles != null) {
            int count = 0;
            for (Map.Entry<String, String> entry : errorFiles.entrySet()) {
                if (count > 0) {
                    json.append(",");
                }
                json.append(this.quote(entry.getKey())).append(":").append(this.quote(entry.getValue()));
                ++count;
            }
        }
        json.append("}");
        json.append("}");
        return json.toString();
    }

    private String compressedBatchDataMessageToJson(CompressedBatchDataMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"batchId\":").append(msg.getBatchId()).append(",");
        json.append("\"compressedFileName\":").append(this.quote(msg.getCompressedFileName())).append(",");
        json.append("\"originalSize\":").append(msg.getOriginalSize()).append(",");
        json.append("\"compressedSize\":").append(msg.getCompressedSize()).append(",");
        json.append("\"compressionMd5\":").append(this.quote(msg.getCompressionMd5())).append(",");
        json.append("\"fileCount\":").append(msg.getFileCount());
        json.append("}");
        return json.toString();
    }

    private String compressedBatchCompleteMessageToJson(CompressedBatchCompleteMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"batchId\":").append(msg.getBatchId()).append(",");
        json.append("\"success\":").append(msg.isSuccess()).append(",");
        json.append("\"processedFiles\":").append(msg.getProcessedFiles()).append(",");
        json.append("\"failedFiles\":").append(msg.getFailedFiles()).append(",");
        json.append("\"processedSize\":").append(msg.getProcessedSize()).append(",");
        json.append("\"processingTimeMs\":").append(msg.getProcessingTimeMs()).append(",");
        if (msg.getErrorMessage() != null) {
            json.append("\"errorMessage\":").append(this.quote(msg.getErrorMessage())).append(",");
        }
        json.append("\"failedFileReasons\":{");
        Map<String, String> failedFileReasons = msg.getFailedFileReasons();
        if (failedFileReasons != null) {
            int count = 0;
            for (Map.Entry<String, String> entry : failedFileReasons.entrySet()) {
                if (count > 0) {
                    json.append(",");
                }
                json.append(this.quote(entry.getKey())).append(":").append(this.quote(entry.getValue()));
                ++count;
            }
        }
        json.append("}");
        json.append("}");
        return json.toString();
    }

    private String transferStatsMessageToJson(TransferStatsMessage msg) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"totalBatches\":").append(msg.getTotalBatches()).append(",");
        json.append("\"totalSingleFiles\":").append(msg.getTotalSingleFiles());
        json.append("}");
        return json.toString();
    }
}

