/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.config;

import com.file.netty.config.RelayPriority;

public class RelayInfo {
    private final String host;
    private final int port;
    private final RelayPriority priority;
    private final String name;
    private long lastConnectTime = 0L;
    private int failureCount = 0;
    private boolean isHealthy = true;

    public RelayInfo(String host, int port, RelayPriority priority) {
        this(host, port, priority, host + ":" + port);
    }

    public RelayInfo(String host, int port, RelayPriority priority, String name) {
        this.host = host;
        this.port = port;
        this.priority = priority;
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RelayPriority getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public void updateLastConnectTime() {
        this.lastConnectTime = System.currentTimeMillis();
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void incrementFailureCount() {
        ++this.failureCount;
        if (this.failureCount >= 3) {
            this.isHealthy = false;
        }
    }

    public void resetFailureCount() {
        this.failureCount = 0;
        this.isHealthy = true;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public int getConnectionScore() {
        int score = this.priority.getWeight();
        if (!this.isHealthy) {
            score -= 100;
        }
        return Math.max(score -= this.failureCount * 10, 0);
    }

    public String toString() {
        return String.format("RelayInfo{%s, priority=%s, healthy=%s, failures=%d}", new Object[]{this.name, this.priority, this.isHealthy, this.failureCount});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelayInfo relayInfo = (RelayInfo)o;
        return this.port == relayInfo.port && this.host.equals(relayInfo.host);
    }

    public int hashCode() {
        return this.host.hashCode() * 31 + this.port;
    }
}

