/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.discovery;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastDiscoverer {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastDiscoverer.class);
    private static final int BROADCAST_PORT = 8901;
    private static final int SOCKET_TIMEOUT_MS = 1000;
    private DatagramSocket socket;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile String discovered_relay_host;
    private volatile int discovered_relay_port;
    private volatile boolean service_found = false;
    private CountDownLatch discovery_latch;
    private String target_session_id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSessionId(String sessionId, long timeout) {
        try {
            this.target_session_id = sessionId;
            this.service_found = false;
            this.discovery_latch = new CountDownLatch(1);
            logger.info("\u5f00\u59cb\u5e7f\u64ad\u53d1\u73b0\u4f1a\u8bddID: {}", (Object)sessionId);
            if (this.start_listening()) {
                long startTime = System.currentTimeMillis();
                boolean discovered = false;
                int dotCount = 0;
                while (!(System.currentTimeMillis() - startTime >= timeout || (discovered = this.discovery_latch.await(500L, TimeUnit.MILLISECONDS)) && this.service_found)) {
                    if (dotCount >= 10) continue;
                    System.out.print(".");
                    ++dotCount;
                }
                if (discovered && this.service_found) {
                    logger.info("\u901a\u8fc7\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1: {}:{}", (Object)this.discovered_relay_host, (Object)this.discovered_relay_port);
                    boolean bl = true;
                    return bl;
                }
            }
            logger.info("\u672a\u901a\u8fc7\u5e7f\u64ad\u53d1\u73b0\u5339\u914d\u7684\u670d\u52a1");
            boolean startTime = false;
            return startTime;
        }
        catch (Exception e) {
            logger.error("\u5e7f\u64ad\u53d1\u73b0\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.stop();
        }
    }

    private boolean start_listening() {
        try {
            try {
                this.socket = new DatagramSocket(8901);
            }
            catch (BindException e) {
                logger.warn("\u7aef\u53e3 {} \u5df2\u88ab\u5360\u7528\uff0c\u4f7f\u7528\u52a8\u6001\u7aef\u53e3", (Object)8901);
                this.socket = new DatagramSocket(0);
            }
            this.socket.setSoTimeout(1000);
            this.running.set(true);
            new Thread(this::receive_loop, "BroadcastReceiver").start();
            logger.info("\u5e7f\u64ad\u76d1\u542c\u5df2\u542f\u52a8\uff0c\u7aef\u53e3: {}", (Object)8901);
            return true;
        }
        catch (SocketException e) {
            logger.error("\u542f\u52a8\u5e7f\u64ad\u76d1\u542c\u5931\u8d25", e);
            return false;
        }
    }

    private void receive_loop() {
        byte[] buffer = new byte[1024];
        while (this.running.get()) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                String message = new String(packet.getData(), 0, packet.getLength());
                String source_ip = packet.getAddress().getHostAddress();
                logger.debug("\u6536\u5230\u5e7f\u64ad\u6d88\u606f: {} \u6765\u81ea {}", (Object)message, (Object)source_ip);
                this.process_broadcast_message(message, source_ip);
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                if (!this.running.get()) break;
                logger.error("\u63a5\u6536\u5e7f\u64ad\u6d88\u606f\u9519\u8bef", e);
                break;
            }
        }
        logger.info("\u5e7f\u64ad\u63a5\u6536\u7ebf\u7a0b\u5df2\u9000\u51fa");
    }

    private void process_broadcast_message(String message, String source_ip) {
        try {
            String device_name;
            String[] parts = message.split(":");
            if (parts.length < 2) {
                logger.debug("\u5e7f\u64ad\u6d88\u606f\u683c\u5f0f\u4e0d\u6b63\u786e: {}", (Object)message);
                return;
            }
            String session_id = parts[0];
            int port = Integer.parseInt(parts[1]);
            String string = device_name = parts.length > 2 ? parts[2] : "Unknown";
            if (!this.target_session_id.equals(session_id)) {
                logger.debug("\u4f1a\u8bddID\u4e0d\u5339\u914d: \u671f\u671b={}, \u6536\u5230={}", (Object)this.target_session_id, (Object)session_id);
                return;
            }
            String target_ip = source_ip;
            String declared_ip = null;
            if (parts.length >= 4 && !parts[3].trim().isEmpty()) {
                declared_ip = parts[3].trim();
                logger.debug("\u6d88\u606f\u4e2d\u58f0\u660e\u7684IP: {}, UDP\u5305\u6e90IP: {}", (Object)declared_ip, (Object)source_ip);
            }
            if (this.isLoopbackAddress(source_ip) && declared_ip != null && this.isValidIP(declared_ip) && !this.isLoopbackAddress(declared_ip)) {
                target_ip = declared_ip;
                logger.info("UDP\u6e90IP\u662f\u56de\u73af\u5730\u5740\uff0c\u4f7f\u7528\u6d88\u606f\u58f0\u660e\u7684IP: {}", (Object)target_ip);
            } else if (declared_ip != null && this.isValidIP(declared_ip)) {
                if (this.isInSameSubnet(source_ip, declared_ip)) {
                    logger.info("UDP\u6e90IP\u548c\u58f0\u660eIP\u5728\u540c\u4e00\u5b50\u7f51\uff0c\u4f7f\u7528\u66f4\u53ef\u9760\u7684UDP\u6e90IP: {}", (Object)source_ip);
                } else {
                    logger.warn("UDP\u6e90IP({})\u548c\u58f0\u660eIP({})\u4e0d\u5728\u540c\u4e00\u5b50\u7f51\uff0c\u4f7f\u7528UDP\u6e90IP", (Object)source_ip, (Object)declared_ip);
                }
            } else {
                logger.info("\u4f7f\u7528UDP\u5305\u7684\u771f\u5b9e\u6e90IP: {}", (Object)source_ip);
            }
            if (!this.isValidIP(target_ip)) {
                logger.warn("\u6700\u7ec8\u9009\u62e9\u7684IP\u5730\u5740\u65e0\u6548: {}, \u56de\u9000\u5230UDP\u6e90IP: {}", (Object)target_ip, (Object)source_ip);
                target_ip = source_ip;
            }
            this.discovered_relay_host = target_ip;
            this.discovered_relay_port = port;
            this.service_found = true;
            logger.info("\u53d1\u73b0\u5339\u914d\u7684\u670d\u52a1: \u4f1a\u8bddID={}, \u8bbe\u5907\u540d={}, \u6700\u7ec8\u5730\u5740={}:{} (UDP\u6e90:{}, \u58f0\u660e:{})", session_id, device_name, target_ip, port, source_ip, declared_ip);
            this.discovery_latch.countDown();
        }
        catch (NumberFormatException e) {
            logger.debug("\u89e3\u6790\u7aef\u53e3\u53f7\u5931\u8d25: {}", (Object)message);
        }
        catch (Exception e) {
            logger.debug("\u89e3\u6790\u5e7f\u64ad\u6d88\u606f\u5931\u8d25: {} - {}", (Object)message, (Object)e.getMessage());
        }
    }

    private boolean isLoopbackAddress(String ip) {
        return ip != null && (ip.equals("127.0.0.1") || ip.equals("localhost") || ip.startsWith("127."));
    }

    private boolean isInSameSubnet(String ip1, String ip2) {
        if (ip1 == null || ip2 == null) {
            return false;
        }
        try {
            String[] parts1 = ip1.split("\\.");
            String[] parts2 = ip2.split("\\.");
            if (parts1.length != 4 || parts2.length != 4) {
                return false;
            }
            return parts1[0].equals(parts2[0]) && parts1[1].equals(parts2[1]) && parts1[2].equals(parts2[2]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isValidIP(String ip) {
        if (ip == null || ip.trim().isEmpty()) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(ip.trim());
            return addr instanceof Inet4Address;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        this.running.set(false);
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public String getDiscoveredRelayHost() {
        return this.discovered_relay_host;
    }

    public int getDiscoveredRelayPort() {
        return this.discovered_relay_port;
    }
}

