/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import java.io.Serializable;
import java.util.List;

public class CompressedBatchManifestMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private int batchId;
    private String batchName;
    private List<BatchFileManifest> files;
    private long totalOriginalSize;
    private long estimatedCompressedSize;
    private double estimatedCompressionRatio;
    private int currentBatchIndex;
    private int totalBatches;

    public CompressedBatchManifestMessage() {
        super(MessageType.COMPRESSED_BATCH_MANIFEST);
    }

    public CompressedBatchManifestMessage(String sessionId, int batchId, String batchName, List<BatchFileManifest> files) {
        super(MessageType.COMPRESSED_BATCH_MANIFEST, sessionId);
        this.batchId = batchId;
        this.batchName = batchName;
        this.files = files;
        this.totalOriginalSize = files.stream().mapToLong(BatchFileManifest::getFileSize).sum();
        this.estimatedCompressionRatio = this.estimateCompressionRatio(files);
        this.estimatedCompressedSize = (long)((double)this.totalOriginalSize * this.estimatedCompressionRatio);
        this.currentBatchIndex = 1;
        this.totalBatches = 1;
    }

    public CompressedBatchManifestMessage(String sessionId, int batchId, String batchName, List<BatchFileManifest> files, int currentBatchIndex, int totalBatches) {
        this(sessionId, batchId, batchName, files);
        this.currentBatchIndex = currentBatchIndex;
        this.totalBatches = totalBatches;
    }

    private double estimateCompressionRatio(List<BatchFileManifest> files) {
        long textFileSize = 0L;
        long binaryFileSize = 0L;
        for (BatchFileManifest file : files) {
            if (file.isTextFile()) {
                textFileSize += file.getFileSize();
                continue;
            }
            binaryFileSize += file.getFileSize();
        }
        long totalSize = textFileSize + binaryFileSize;
        if (totalSize == 0L) {
            return 0.5;
        }
        double avgRatio = ((double)textFileSize * 0.3 + (double)binaryFileSize * 0.8) / (double)totalSize;
        return Math.max(0.1, Math.min(0.9, avgRatio));
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public List<BatchFileManifest> getFiles() {
        return this.files;
    }

    public void setFiles(List<BatchFileManifest> files) {
        this.files = files;
    }

    public long getTotalOriginalSize() {
        return this.totalOriginalSize;
    }

    public void setTotalOriginalSize(long totalOriginalSize) {
        this.totalOriginalSize = totalOriginalSize;
    }

    public long getEstimatedCompressedSize() {
        return this.estimatedCompressedSize;
    }

    public void setEstimatedCompressedSize(long estimatedCompressedSize) {
        this.estimatedCompressedSize = estimatedCompressedSize;
    }

    public double getEstimatedCompressionRatio() {
        return this.estimatedCompressionRatio;
    }

    public void setEstimatedCompressionRatio(double estimatedCompressionRatio) {
        this.estimatedCompressionRatio = estimatedCompressionRatio;
    }

    public int getCurrentBatchIndex() {
        return this.currentBatchIndex;
    }

    public void setCurrentBatchIndex(int currentBatchIndex) {
        this.currentBatchIndex = currentBatchIndex;
    }

    public int getTotalBatches() {
        return this.totalBatches;
    }

    public void setTotalBatches(int totalBatches) {
        this.totalBatches = totalBatches;
    }

    public int getFileCount() {
        return this.files != null ? this.files.size() : 0;
    }

    public static class BatchFileManifest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String relativePath;
        private long fileSize;
        private String md5;
        private long lastModified;
        private boolean isTextFile;

        public BatchFileManifest() {
        }

        public BatchFileManifest(String relativePath, long fileSize, String md5, long lastModified, boolean isTextFile) {
            this.relativePath = relativePath;
            this.fileSize = fileSize;
            this.md5 = md5;
            this.lastModified = lastModified;
            this.isTextFile = isTextFile;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public boolean isTextFile() {
            return this.isTextFile;
        }

        public void setTextFile(boolean textFile) {
            this.isTextFile = textFile;
        }
    }
}

