/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;

public class TransferStatsMessage
extends Message {
    private final int totalBatches;
    private final int totalSingleFiles;

    public TransferStatsMessage(int totalBatches, int totalSingleFiles) {
        super(MessageType.TRANSFER_STATS);
        this.totalBatches = totalBatches;
        this.totalSingleFiles = totalSingleFiles;
    }

    public TransferStatsMessage(String sessionId, int totalBatches, int totalSingleFiles) {
        super(MessageType.TRANSFER_STATS, sessionId);
        this.totalBatches = totalBatches;
        this.totalSingleFiles = totalSingleFiles;
    }

    public int getTotalBatches() {
        return this.totalBatches;
    }

    public int getTotalSingleFiles() {
        return this.totalSingleFiles;
    }

    public String toString() {
        return String.format("TransferStatsMessage{totalBatches=%d, totalSingleFiles=%d}", this.totalBatches, this.totalSingleFiles);
    }
}

