/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.receiver;

import com.file.netty.codec.CodecFactory;
import com.file.netty.protocol.BatchFileAckMessage;
import com.file.netty.protocol.BatchFileInfoMessage;
import com.file.netty.protocol.CompressedBatchCompleteMessage;
import com.file.netty.protocol.CompressedBatchDataMessage;
import com.file.netty.protocol.CompressedBatchManifestAckMessage;
import com.file.netty.protocol.CompressedBatchManifestMessage;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.FileSkipMessage;
import com.file.netty.protocol.FolderCompleteAckMessage;
import com.file.netty.protocol.FolderCompleteMessage;
import com.file.netty.protocol.FolderInfoAckMessage;
import com.file.netty.protocol.FolderInfoMessage;
import com.file.netty.protocol.HeartbeatMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import com.file.netty.protocol.TransferAckMessage;
import com.file.netty.protocol.TransferStatsMessage;
import com.file.netty.utils.BatchCompressor;
import com.file.netty.utils.BatchProgressTracker;
import com.file.netty.utils.DynamicTimeoutCalculator;
import com.file.netty.utils.FileSizeCategory;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.UnifiedHashCalculator;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderReceiver {
    private static final Logger logger = LoggerFactory.getLogger(FolderReceiver.class);
    private String host;
    private int port;
    private final String saveDir;
    private Channel channel;
    private String sessionId;
    private EventLoopGroup group;
    private CountDownLatch connectionLatch;
    private String folderName;
    private int totalFiles;
    private long totalSize;
    private int chunkSize;
    private List<String> emptyDirectories;
    private Map<String, FileMetadata> fileMetadataMap = new ConcurrentHashMap<String, FileMetadata>();
    private AtomicInteger filesReceived = new AtomicInteger(0);
    private final AtomicInteger skippedFiles = new AtomicInteger(0);
    private final AtomicLong skippedSize = new AtomicLong(0L);
    private boolean autoDiscoverRelay = true;
    private String discoveredRelayHost = null;
    private int discoveredRelayPort = -1;
    private boolean isUsingLocalRelay = false;
    private boolean isUsingPublicRelay = false;
    private volatile boolean folderInfoReceived = false;
    private volatile boolean transferCompleted = false;
    private volatile boolean connectionActive = false;
    private volatile boolean codeInvalid = false;
    private volatile boolean folderCompleteHandled = false;
    private final AtomicInteger pendingFileChecks = new AtomicInteger(0);
    private final Map<Integer, List<BatchFileInfoMessage.BatchFileEntry>> activeBatches = new ConcurrentHashMap<Integer, List<BatchFileInfoMessage.BatchFileEntry>>();
    private BatchProgressTracker batchProgressTracker;
    private final Map<FileSizeCategory, AtomicInteger> categoryBatchCounters = new ConcurrentHashMap<FileSizeCategory, AtomicInteger>();
    private final Map<Integer, CompressedBatchManifestMessage> activeCompressedBatches = new ConcurrentHashMap<Integer, CompressedBatchManifestMessage>();
    private final ExecutorService compressedBatchExecutor = Executors.newFixedThreadPool(4);
    private final Set<String> batchProcessedFiles = ConcurrentHashMap.newKeySet();
    private static final Map<String, String> fileHashCache = new ConcurrentHashMap<String, String>();
    private static final long HASH_CACHE_MAX_SIZE = 10000L;
    private final AtomicInteger cacheHitCount = new AtomicInteger(0);
    private final Set<Integer> processedBatchIds = ConcurrentHashMap.newKeySet();
    private volatile int totalBatches = 0;
    private volatile int totalSingleFiles = 0;
    private volatile int currentBatchIndex = 0;
    private volatile int currentSingleFileIndex = 0;
    private volatile boolean transferStatsReceived = false;
    private volatile int maxBatchId = 0;
    private volatile boolean isInSingleFileReceiveMode = false;
    private volatile int currentSingleFilesTotal = 0;
    private volatile boolean hasShownSingleFileTransferTitle = false;
    private final List<String> singleFileList = new ArrayList<String>();
    private volatile boolean allBatchesCompleted = false;
    private volatile boolean singleFileTransferCompleted = false;
    private final Object batchCompletionLock = new Object();
    private volatile boolean batchOutputComplete = false;
    private final Map<Integer, String> batchCompletionMessages = new ConcurrentHashMap<Integer, String>();
    private volatile int finalSingleFileCount = 0;
    private final AtomicInteger singleFileCounter = new AtomicInteger(0);
    private final Map<String, Double> fileTransferSpeeds = new ConcurrentHashMap<String, Double>();
    private volatile double averageNetworkSpeed = 0.0;
    private volatile DynamicTimeoutCalculator.NetworkCondition currentNetworkCondition = DynamicTimeoutCalculator.NetworkCondition.UNKNOWN;
    private volatile int currentDynamicTimeout = 30;
    private volatile long lastActivityTime;
    private static final long CONNECTION_TIMEOUT = 30000L;
    private volatile String currentProcessingFile = null;
    private final List<FileInfoMessage> pendingFileMessages = Collections.synchronizedList(new ArrayList());
    private long folderStartTime;
    private long actualTransferStartTime;
    private final Semaphore md5Semaphore = new Semaphore(Runtime.getRuntime().availableProcessors(), true);
    private final ExecutorService md5ExecutorService = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), r -> {
        Thread t = new Thread(r);
        t.setName("MD5-Calculator-" + t.getId());
        t.setDaemon(true);
        return t;
    });

    public void onCodeInvalid() {
        this.codeInvalid = true;
        if (this.connectionLatch != null && this.connectionLatch.getCount() > 0L) {
            this.connectionLatch.countDown();
        }
        logger.info("\u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u7a0b\u5e8f\u5c06\u5728 1 \u79d2\u540e\u9000\u51fa...");
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }).start();
    }

    public void updateLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    public FolderReceiver(String host, int port, String saveDir, boolean autoDiscoverRelay) {
        this.host = host;
        this.port = port;
        this.saveDir = saveDir;
        this.autoDiscoverRelay = autoDiscoverRelay;
        this.connectionLatch = new CountDownLatch(1);
    }

    private void waitForTransferCompletion() {
        if (this.channel != null) {
            try {
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u4f20\u8f93\u5b8c\u6210\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws Exception {
        this.group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        try {
            boolean connected = false;
            if (this.autoDiscoverRelay && this.discoveredRelayHost != null && this.discoveredRelayPort > 0) {
                logger.info("\u5c1d\u8bd5\u8fde\u63a5\u53d1\u73b0\u7684\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)this.discoveredRelayHost, (Object)this.discoveredRelayPort);
                System.out.println("\ud83d\udd0d \u5c1d\u8bd5\u8fde\u63a5\u53d1\u73b0\u7684\u670d\u52a1: " + this.discoveredRelayHost + ":" + this.discoveredRelayPort);
                connected = this.connectToRelay(this.discoveredRelayHost, this.discoveredRelayPort);
                if (connected) {
                    this.isUsingLocalRelay = true;
                    logger.info("\u6210\u529f\u8fde\u63a5\u5230\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668");
                    System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230\u672c\u5730\u670d\u52a1");
                } else {
                    logger.warn("\u8fde\u63a5\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25");
                    System.out.println("\u26a0\ufe0f \u672c\u5730\u8fde\u63a5\u5931\u8d25\uff0c\u5c1d\u8bd5\u516c\u5171\u4e2d\u7ee7...");
                    connected = this.connectToRelay("relay.daodaovps.com", 8001);
                    if (!connected) {
                        System.out.println("\u274c \u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668");
                        throw new Exception("\u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668");
                    }
                    this.isUsingPublicRelay = true;
                    logger.info("\u6210\u529f\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
                    System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
                }
            } else {
                logger.info("\u4f7f\u7528\u6307\u5b9a\u7684\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)this.host, (Object)this.port);
                System.out.println("\u5c1d\u8bd5\u8fde\u63a5\u6307\u5b9a\u7684\u670d\u52a1: " + this.host + ":" + this.port);
                connected = this.connectToRelay(this.host, this.port);
                if (!connected) {
                    logger.warn("\u8fde\u63a5\u6307\u5b9a\u7684\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25");
                    System.out.println("\u26a0\ufe0f \u672c\u5730\u8fde\u63a5\u5931\u8d25\uff0c\u5c1d\u8bd5\u516c\u5171\u4e2d\u7ee7...");
                    connected = this.connectToRelay("relay.daodaovps.com", 8001);
                    if (!connected) {
                        System.out.println("\u274c \u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668");
                        throw new Exception("\u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668");
                    }
                    this.isUsingPublicRelay = true;
                    logger.info("\u6210\u529f\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
                    System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
                }
            }
            logger.info("\u7b49\u5f85\u8fde\u63a5\u5efa\u7acb...");
            boolean connectionEstablished = this.connectionLatch.await(30L, TimeUnit.SECONDS);
            if (!connectionEstablished) {
                logger.error("\u8fde\u63a5\u8d85\u65f6");
                System.out.println("\u8fde\u63a5\u8d85\u65f6\uff0c\u4f20\u8f93\u5931\u8d25");
                throw new Exception("\u8fde\u63a5\u8d85\u65f6");
            }
            this.startConnectionMonitor();
            this.monitorChannelStatus();
            this.waitForTransferCompletion();
            return;
        }
        finally {
            this.shutdown();
        }
    }

    private void closeCurrentConnection() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close().sync();
            }
            catch (InterruptedException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.md5ExecutorService != null && !this.md5ExecutorService.isShutdown()) {
            this.md5ExecutorService.shutdown();
            try {
                if (!this.md5ExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.md5ExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.md5ExecutorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void startConnectionMonitor() {
        this.lastActivityTime = System.currentTimeMillis();
        new Thread(() -> {
            while (this.connectionActive && !this.transferCompleted) {
                try {
                    Thread.sleep(5000L);
                    long now = System.currentTimeMillis();
                    long elapsed = now - this.lastActivityTime;
                    if (elapsed <= 30000L) continue;
                    logger.error("\u8fde\u63a5\u8d85\u65f6: {} \u6beb\u79d2\u5185\u6ca1\u6709\u63a5\u6536\u5230\u6d88\u606f", (Object)elapsed);
                    logger.info("\u8fde\u63a5\u4f3c\u4e4e\u5df2\u65ad\u5f00\uff0c\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5...");
                    if (!this.isUsingLocalRelay) continue;
                    this.switchToPublicRelay();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }).start();
    }

    private boolean connectToRelay(String relayHost, int relayPort) {
        try {
            logger.info("\u5c1d\u8bd5\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668: " + relayHost + ":" + relayPort);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x800000)).option(ChannelOption.SO_RCVBUF, 0x800000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, FolderReceiver.this.currentDynamicTimeout, 0));
                    CodecFactory.addClientCodec(p);
                }
            });
            ChannelFuture future = b.connect(relayHost, relayPort);
            future.awaitUninterruptibly(5000L);
            if (future.isSuccess()) {
                this.channel = future.channel();
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)relayHost, (Object)relayPort);
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
                this.connectionActive = true;
                this.performNetworkSpeedDetection();
                this.joinSession();
                this.channel.closeFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        FolderReceiver.this.connectionActive = false;
                        FolderReceiver.this.closeAllFiles();
                    }
                });
                this.host = relayHost;
                this.port = relayPort;
                return true;
            }
            logger.warn("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}:{}", (Object)relayHost, (Object)relayPort);
            return false;
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), e);
            return false;
        }
    }

    public void joinSession() {
        if (this.channel != null && this.channel.isActive()) {
            JoinMessage joinMsg = new JoinMessage(this.sessionId);
            this.channel.writeAndFlush(joinMsg);
            logger.info("\u53d1\u9001\u52a0\u5165\u4f1a\u8bdd\u8bf7\u6c42, \u4f1a\u8bddID: {}", (Object)this.sessionId);
        }
    }

    public void sessionJoined() {
        this.connectionLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFolderInfo(FolderInfoMessage msg) {
        this.folderName = msg.getFolderName();
        this.emptyDirectories = msg.getEmptyDirectories();
        this.totalFiles = msg.getTotalFiles();
        this.totalSize = msg.getTotalSize();
        this.chunkSize = msg.getChunkSize();
        logger.info("\ud83d\ude80 \u63a5\u6536\u4f18\u5316\u540e\u7684\u6587\u4ef6\u5939\u4fe1\u606f\uff0c\u7a7a\u76ee\u5f55\u6570\u91cf: {}", (Object)this.emptyDirectories.size());
        List<String> list = this.singleFileList;
        synchronized (list) {
            this.singleFileList.clear();
            this.finalSingleFileCount = 0;
            logger.info("\ud83d\udd27 \u5355\u6587\u4ef6\u5217\u8868\u5df2\u521d\u59cb\u5316\uff0c\u5c06\u5728\u6279\u6b21\u5904\u7406\u65f6\u52a8\u6001\u66f4\u65b0");
        }
        this.createEmptyDirectories();
        this.folderStartTime = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8bb0\u5f55\u4f20\u8f93\u65f6\u95f4\uff0c\u63a5\u6536\u5230\u6587\u4ef6\u5939\u4fe1\u606f: {}", (Object)this.folderName);
        this.folderInfoReceived = true;
        logger.info("\u63a5\u6536\u6587\u4ef6\u5939\u4fe1\u606f: \u6587\u4ef6\u5939\u540d={}, \u603b\u6587\u4ef6\u6570={}, \u603b\u5927\u5c0f={}", this.folderName, this.totalFiles, FileTransferUtils.formatFileSize(this.totalSize));
        System.out.println("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udce5 \u5f85\u63a5\u6536\u6587\u4ef6\u5939");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\u23f3 \u51c6\u5907\u63a5\u6536\u6587\u4ef6\u5939: " + this.folderName);
        System.out.println("\ud83d\udcca \u603b\u6587\u4ef6\u6570: " + this.totalFiles);
        System.out.println("\ud83d\udcca \u603b\u5927\u5c0f: " + FileTransferUtils.formatFileSize(this.totalSize));
        System.out.println("\ud83d\udcc1 \u4fdd\u5b58\u4f4d\u7f6e: " + new File(this.saveDir, this.folderName).getAbsolutePath());
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        FolderInfoAckMessage ackMsg = new FolderInfoAckMessage(this.sessionId);
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush(ackMsg);
            logger.info("\u5df2\u53d1\u9001\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4\u6d88\u606f");
        } else {
            logger.error("\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u53d1\u9001\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4\u6d88\u606f");
        }
        if (!this.pendingFileMessages.isEmpty()) {
            logger.info("\u5904\u7406\u6682\u5b58\u7684 {} \u4e2a\u6587\u4ef6\u4fe1\u606f\u6d88\u606f", (Object)this.pendingFileMessages.size());
            for (FileInfoMessage pendingMsg : this.pendingFileMessages) {
                try {
                    this.handleFileInfo(pendingMsg);
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u6682\u5b58\u7684\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", (Object)pendingMsg.getFileName(), (Object)e);
                }
            }
            this.pendingFileMessages.clear();
        }
    }

    public void ensureFileDirectory(String relativePath) {
        File rootFolder = new File(this.saveDir, this.folderName);
        File file = new File(rootFolder, relativePath);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            if (parentDir.mkdirs()) {
                logger.debug("\u6309\u9700\u521b\u5efa\u6587\u4ef6\u76ee\u5f55: {}", (Object)parentDir.getAbsolutePath());
            } else {
                logger.error("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u5931\u8d25: {}", (Object)parentDir.getAbsolutePath());
            }
        }
    }

    private void createEmptyDirectories() {
        if (this.emptyDirectories == null || this.emptyDirectories.isEmpty()) {
            logger.info("\u2705 \u65e0\u7a7a\u76ee\u5f55\u9700\u8981\u521b\u5efa");
            return;
        }
        File rootFolder = new File(this.saveDir, this.folderName);
        if (!rootFolder.exists() && !rootFolder.mkdirs()) {
            logger.error("\u521b\u5efa\u6839\u6587\u4ef6\u5939\u5931\u8d25: {}", (Object)rootFolder.getAbsolutePath());
            return;
        }
        int createdCount = 0;
        for (String emptyDirPath : this.emptyDirectories) {
            File dir = new File(rootFolder, emptyDirPath);
            if (dir.exists()) continue;
            if (dir.mkdirs()) {
                ++createdCount;
                logger.debug("\u521b\u5efa\u7a7a\u76ee\u5f55: {}", (Object)dir.getAbsolutePath());
                continue;
            }
            logger.error("\u521b\u5efa\u7a7a\u76ee\u5f55\u5931\u8d25: {}", (Object)dir.getAbsolutePath());
        }
        logger.info("\u2705 \u7a7a\u76ee\u5f55\u521b\u5efa\u5b8c\u6210\uff0c\u5171\u521b\u5efa {} \u4e2a\u7a7a\u76ee\u5f55", (Object)createdCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFileInfo(FileInfoMessage msg) throws IOException {
        File file;
        List<String> list;
        if (!this.folderInfoReceived) {
            logger.info("\u6536\u5230\u6587\u4ef6\u4fe1\u606f\u4f46\u5c1a\u672a\u6536\u5230\u6587\u4ef6\u5939\u4fe1\u606f\uff0c\u6682\u5b58: {}", (Object)msg.getFileName());
            this.pendingFileMessages.add(msg);
            return;
        }
        String relativePath = msg.getFileName();
        relativePath = FileTransferUtils.normalizePath(relativePath);
        this.ensureFileDirectory(relativePath);
        int totalChunks = msg.getChunks();
        long fileSize = msg.getFileSize();
        String expectedMd5 = msg.getMd5();
        if (this.actualTransferStartTime == 0L) {
            this.actualTransferStartTime = System.currentTimeMillis();
            logger.info("\u5f00\u59cb\u8bb0\u5f55\u5b9e\u9645\u4f20\u8f93\u65f6\u95f4\uff0c\u7b2c\u4e00\u4e2a\u6587\u4ef6: {}", (Object)relativePath);
        }
        if (!relativePath.matches("batch_\\d+\\.pack") && !this.hasShownSingleFileTransferTitle) {
            System.out.println("\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            System.out.println("\ud83d\udcc4 \u9636\u6bb52: \u5355\u6587\u4ef6\u63a5\u6536\u5f00\u59cb");
            System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            this.isInSingleFileReceiveMode = true;
            this.hasShownSingleFileTransferTitle = true;
            this.singleFileCounter.set(0);
            this.currentSingleFileIndex = 0;
            list = this.singleFileList;
            synchronized (list) {
                this.singleFileList.clear();
            }
            System.out.println("\ud83d\udcc4 \u5355\u6587\u4ef6\u4f20\u8f93\u5f00\u59cb...");
            logger.info("\ud83d\udd27 \u8fdb\u5165\u5355\u6587\u4ef6\u63a5\u6536\u6a21\u5f0f");
        }
        if (!relativePath.matches("batch_\\d+\\.pack")) {
            list = this.singleFileList;
            synchronized (list) {
                boolean isNewFile;
                String fileName = new File(relativePath).getName();
                boolean bl = isNewFile = !this.singleFileList.contains(fileName);
                if (isNewFile) {
                    this.singleFileList.add(fileName);
                    logger.debug("\ud83d\udd27 \u8bb0\u5f55\u5355\u6587\u4ef6: {} (\u603b\u8ba1: {})", (Object)fileName, (Object)this.calculateActualSingleFileCount());
                    if (this.isInSingleFileReceiveMode) {
                        this.currentSingleFileIndex = this.singleFileCounter.incrementAndGet();
                        int displayTotal = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                        logger.debug("\ud83d\udd27 \u5355\u6587\u4ef6\u7d22\u5f15\u9012\u589e: {}/{} for {}", this.currentSingleFileIndex, displayTotal, fileName);
                    }
                }
            }
        }
        int fileChunkSize = msg.getChunkSize();
        logger.info("\u6536\u5230\u6587\u4ef6\u4fe1\u606f: {}, \u5927\u5c0f: {}, \u5757\u6570: {}, \u5757\u5927\u5c0f: {}, MD5: {}", relativePath, FileTransferUtils.formatFileSize(fileSize), totalChunks, fileChunkSize, expectedMd5);
        long fileProcessStartTime = System.currentTimeMillis();
        logger.info("\ud83d\udcca \u5f00\u59cb\u5904\u7406\u6587\u4ef6: {} (\u5e8f\u53f7: {}/{})", relativePath, this.filesReceived.get() + 1, this.totalFiles);
        if (relativePath.matches("batch_\\d+\\.pack")) {
            logger.debug("\u5ffd\u7565\u538b\u7f29\u6279\u6b21\u6587\u4ef6\u7684FILE_INFO\u6d88\u606f: {}", (Object)relativePath);
            return;
        }
        if (this.batchProcessedFiles.contains(relativePath)) {
            logger.debug("\u5ffd\u7565\u5df2\u901a\u8fc7\u6279\u6b21\u5904\u7406\u7684\u6587\u4ef6: {}", (Object)relativePath);
            this.skippedFiles.incrementAndGet();
            this.skippedSize.addAndGet(fileSize);
            return;
        }
        if (this.currentProcessingFile != null && !this.activeCompressedBatches.isEmpty()) {
            logger.warn("\u68c0\u6d4b\u5230\u538b\u7f29\u6587\u4ef6\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u7b49\u5f85\u5b8c\u6210\u540e\u5904\u7406\u65b0\u6587\u4ef6: {}", (Object)relativePath);
            this.pendingFileMessages.add(msg);
            return;
        }
        this.currentProcessingFile = relativePath;
        FileMetadata metadata = new FileMetadata(relativePath, fileSize, totalChunks, fileChunkSize, expectedMd5);
        this.fileMetadataMap.put(relativePath, metadata);
        File folder = new File(this.saveDir, this.folderName);
        String systemPath = relativePath.replace('/', File.separatorChar);
        metadata.file = file = new File(folder, systemPath);
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55: " + parentDir.getAbsolutePath());
        }
        logger.info("\ud83d\udcca \u51c6\u5907\u8fdb\u884c\u53bb\u91cd\u68c0\u67e5: {} (\u6587\u4ef6\u5927\u5c0f: {})", (Object)relativePath, (Object)fileSize);
        this.checkFileSkipAsync(msg.getSessionId(), file, fileSize, expectedMd5, relativePath);
        logger.info("\ud83d\udcca \u53bb\u91cd\u68c0\u67e5\u5df2\u542f\u52a8: {}", (Object)relativePath);
    }

    public void handleFileChunk(FileChunkMessage msg) throws IOException {
        int chunkIndex = msg.getChunkIndex();
        byte[] data = msg.getData();
        FileMetadata currentFile = null;
        String targetFile = null;
        if (this.currentProcessingFile != null) {
            currentFile = this.fileMetadataMap.get(this.currentProcessingFile);
            targetFile = this.currentProcessingFile;
        }
        if (currentFile == null || currentFile.isCompleted()) {
            FileMetadata metadata;
            FileMetadata bestMatch = null;
            String bestFile = null;
            if (chunkIndex == 0) {
                for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
                    metadata = entry.getValue();
                    if (metadata.chunksReceived.get() != 0 || metadata.isCompleted() || metadata.totalChunks <= 0 || metadata.isCompressedPackage) continue;
                    bestMatch = metadata;
                    bestFile = entry.getKey();
                    logger.debug("\u627e\u5230\u65b0\u6587\u4ef6\u5f00\u59cb\u4f20\u8f93: {}", (Object)bestFile);
                    break;
                }
            }
            if (bestMatch == null) {
                for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
                    metadata = entry.getValue();
                    if (metadata.isCompleted() || chunkIndex >= metadata.totalChunks || metadata.receivedChunks.containsKey(chunkIndex) || metadata.isCompressedPackage) continue;
                    bestMatch = metadata;
                    bestFile = entry.getKey();
                    logger.debug("\u5339\u914d\u5230\u90e8\u5206\u63a5\u6536\u6587\u4ef6: {} (\u7f3a\u5c11\u5757: {})", (Object)bestFile, (Object)chunkIndex);
                    break;
                }
            }
            if (bestMatch != null) {
                currentFile = bestMatch;
                this.currentProcessingFile = targetFile = bestFile;
            }
        }
        if (currentFile == null) {
            logger.debug("\u672a\u627e\u5230\u5339\u914d\u7684\u6587\u4ef6\u6765\u5904\u7406\u5757\u6570\u636e - \u5757\u7d22\u5f15: {}", (Object)chunkIndex);
            return;
        }
        if (currentFile.fileSize == 0L || currentFile.totalChunks == 0) {
            logger.debug("\u8df3\u8fc7\u7a7a\u6587\u4ef6\u7684\u5757\u5904\u7406: {}", (Object)currentFile.relativePath);
            return;
        }
        if (chunkIndex < 0 || chunkIndex >= currentFile.totalChunks) {
            logger.warn("\u6536\u5230\u65e0\u6548\u5757\u7d22\u5f15: {} - \u6587\u4ef6: {}, \u603b\u5757\u6570: {}", chunkIndex, currentFile.relativePath, currentFile.totalChunks);
            return;
        }
        long position = (long)chunkIndex * (long)currentFile.chunkSize;
        if (position >= currentFile.fileSize) {
            logger.warn("\u8df3\u8fc7\u8d85\u51fa\u8303\u56f4\u7684\u5757: {} - \u7d22\u5f15: {}, \u4f4d\u7f6e: {}, \u6587\u4ef6\u5927\u5c0f: {}", currentFile.relativePath, chunkIndex, position, currentFile.fileSize);
            return;
        }
        int writeSize = (int)Math.min((long)data.length, currentFile.fileSize - position);
        if (writeSize <= 0 || writeSize > data.length) {
            logger.error("\u6570\u636e\u5757\u5927\u5c0f\u65e0\u6548: {} - \u7d22\u5f15: {}, \u6570\u636e\u957f\u5ea6: {}, \u8ba1\u7b97\u5199\u5165\u5927\u5c0f: {}", currentFile.relativePath, chunkIndex, data.length, writeSize);
            return;
        }
        try {
            long currentTime;
            long elapsedTime;
            ByteBuffer buffer = ByteBuffer.wrap(data, 0, writeSize);
            currentFile.fileChannel.position(position);
            int bytesWritten = currentFile.fileChannel.write(buffer);
            if (bytesWritten != writeSize) {
                logger.error("\u5199\u5165\u4e0d\u5b8c\u6574: {} - \u9884\u671f: {}, \u5b9e\u9645: {}", currentFile.relativePath, writeSize, bytesWritten);
                currentFile.hasError = true;
                return;
            }
            currentFile.receivedChunks.putIfAbsent(chunkIndex, Boolean.TRUE);
            int received = currentFile.chunksReceived.incrementAndGet();
            if (currentFile.startTime == 0L) {
                currentFile.startTime = System.currentTimeMillis();
            }
            if ((elapsedTime = (currentTime = System.currentTimeMillis()) - currentFile.startTime) > 0L) {
                boolean isLastChunk;
                long bytesReceived = (long)received * (long)writeSize;
                double progressPercent = (double)received / (double)currentFile.totalChunks * 100.0;
                double speedMBps = (double)bytesReceived / 1024.0 / 1024.0 / ((double)elapsedTime / 1000.0);
                boolean shouldShowConsoleProgress = false;
                boolean shouldLogProgress = false;
                boolean bl = isLastChunk = received == currentFile.totalChunks;
                if (currentFile.totalChunks >= 200) {
                    shouldShowConsoleProgress = !isLastChunk && received % 5 == 0;
                    shouldLogProgress = !isLastChunk && received % 50 == 0;
                } else if (currentFile.totalChunks >= 50) {
                    shouldShowConsoleProgress = !isLastChunk && received % 3 == 0;
                    shouldLogProgress = !isLastChunk && received % 25 == 0;
                } else if (currentFile.totalChunks >= 10) {
                    shouldShowConsoleProgress = !isLastChunk && received % 2 == 0;
                    shouldLogProgress = !isLastChunk && received % 10 == 0;
                } else {
                    shouldShowConsoleProgress = !isLastChunk;
                    boolean bl2 = shouldLogProgress = !isLastChunk && (received == 1 || received == currentFile.totalChunks / 2);
                }
                if (shouldLogProgress) {
                    logger.debug("\u6587\u4ef6\u63a5\u6536\u8fdb\u5ea6: {} - {}%, \u901f\u5ea6: {:.2f} MB/s, \u5757: {}/{}", currentFile.relativePath, String.format("%.2f", progressPercent), speedMBps, received, currentFile.totalChunks);
                }
                if (shouldShowConsoleProgress && (!currentFile.isBatchFile || currentFile.isCompressedPackage)) {
                    long transferredBytes = bytesReceived;
                    String transferredSize = FileTransferUtils.formatFileSize(transferredBytes);
                    String totalSize = FileTransferUtils.formatFileSize(currentFile.fileSize);
                    if (currentFile.isCompressedPackage) {
                        long remainingBytes = currentFile.fileSize - transferredBytes;
                        String etaString = "";
                        if (speedMBps > 0.1) {
                            long etaSeconds = (long)((double)remainingBytes / (speedMBps * 1024.0 * 1024.0));
                            etaString = etaSeconds < 3600L ? String.format(" | ETA: %dm%ds", etaSeconds / 60L, etaSeconds % 60L) : String.format(" | ETA: %dh%dm", etaSeconds / 3600L, etaSeconds % 3600L / 60L);
                        }
                        System.out.printf("\r\ud83d\udce6 \u63a5\u6536\u8fdb\u5ea6: %s | %s/%s (%.1f%%) | %.2f MB/s%s | \u5757:%d/%d", currentFile.relativePath, transferredSize, totalSize, progressPercent, speedMBps, etaString, received, currentFile.totalChunks);
                    } else {
                        int displayTotalFiles;
                        int displayFileIndex;
                        if (this.isInSingleFileReceiveMode) {
                            displayFileIndex = this.currentSingleFileIndex;
                            displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                        } else {
                            displayFileIndex = this.filesReceived.get() + this.skippedFiles.get() + 1;
                            displayTotalFiles = this.totalFiles;
                        }
                        System.out.printf("\r\ud83d\udce5 \u63a5\u6536\u8fdb\u5ea6 (%d/%d): %s | %s/%s (%.2f%%) | %d/%d \u5757 | %.2f MB/s", displayFileIndex, displayTotalFiles, currentFile.relativePath, transferredSize, totalSize, progressPercent, received, currentFile.totalChunks, speedMBps);
                    }
                    System.out.flush();
                }
            }
            if (received == currentFile.totalChunks && this.isFileCompletelyReceived(currentFile)) {
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - currentFile.startTime;
                double finalSpeedMBps = totalTime > 0L ? (double)currentFile.fileSize / 1024.0 / 1024.0 / ((double)totalTime / 1000.0) : 0.0;
                this.recordTransferSpeed(currentFile.relativePath, finalSpeedMBps, currentFile.fileSize);
                System.out.print("\r\u001b[K");
                if (currentFile.isCompressedPackage) {
                    String totalSize = FileTransferUtils.formatFileSize(currentFile.fileSize);
                    String duration = this.formatDuration(totalTime);
                    System.out.printf("\ud83d\udce6 \u63a5\u6536\u8fdb\u5ea6: %s | %s (100%%) | %.2f MB/s | \u7528\u65f6:%s\n", currentFile.relativePath, totalSize, finalSpeedMBps, duration);
                } else if (!currentFile.isBatchFile) {
                    int displayTotalFiles;
                    int displayFileIndex;
                    String totalSize = FileTransferUtils.formatFileSize(currentFile.fileSize);
                    if (this.isInSingleFileReceiveMode) {
                        displayFileIndex = this.currentSingleFileIndex;
                        displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                    } else {
                        displayFileIndex = this.filesReceived.get() + this.skippedFiles.get() + 1;
                        displayTotalFiles = this.totalFiles;
                    }
                    System.out.printf("\ud83d\udce5 \u63a5\u6536\u8fdb\u5ea6 (%d/%d): %s | %s (100%%) | %.2f MB/s\n", displayFileIndex, displayTotalFiles, currentFile.relativePath, totalSize, finalSpeedMBps);
                }
                this.onFileReceived(currentFile);
            } else if (received == currentFile.totalChunks) {
                logger.warn("\u6587\u4ef6\u5757\u63a5\u6536\u5b8c\u6210\u4f46\u5b8c\u6574\u6027\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u4f20\u6216\u8d85\u65f6: {}", (Object)currentFile.relativePath);
                currentFile.hasError = true;
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6587\u4ef6\u5757\u65f6\u51fa\u73b0\u5f02\u5e38: {} - \u5757\u7d22\u5f15: {}, \u9519\u8bef: {}", currentFile.relativePath, chunkIndex, e.getMessage(), e);
            currentFile.hasError = true;
        }
    }

    private void onFileReceived(FileMetadata file) {
        logger.info("\u6587\u4ef6\u63a5\u6536\u5b8c\u6210\uff0c\u51c6\u5907\u8fdb\u884c\u5b8c\u6574\u6027\u9a8c\u8bc1: {}", (Object)file.relativePath);
        try {
            String receivedMd5;
            if (file.hasError) {
                logger.error("\u6587\u4ef6 {} \u5728\u4f20\u8f93\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff0c\u8df3\u8fc7MD5\u9a8c\u8bc1", (Object)file.relativePath);
                System.out.printf("\u6587\u4ef6\u63a5\u6536\u5931\u8d25: %s - \u4f20\u8f93\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\n\n", file.relativePath);
                this.closeFileAndSync(file);
                int received = this.filesReceived.incrementAndGet();
                return;
            }
            this.closeFileAndSync(file);
            if (file.fileSize == 0L) {
                receivedMd5 = "d41d8cd98f00b204e9800998ecf8427e";
                logger.info("\u7a7a\u6587\u4ef6\u65e0\u9700\u8ba1\u7b97MD5\uff0c\u4f7f\u7528\u6807\u51c6\u7a7a\u6587\u4ef6MD5\u503c");
            } else {
                receivedMd5 = this.calculateFileHashSafely(file.file);
            }
            logger.info("\u6587\u4ef6MD5\u6821\u9a8c\u503c: {}", (Object)receivedMd5);
            boolean isValid = true;
            if (file.expectedMd5 != null && !file.expectedMd5.isEmpty() && !file.expectedMd5.equals(receivedMd5)) {
                logger.error("\u6587\u4ef6MD5\u4e0d\u5339\u914d: {} - \u9884\u671f: {}, \u5b9e\u9645: {}", file.relativePath, file.expectedMd5, receivedMd5);
                isValid = false;
                file.hasError = true;
                System.out.printf("\u6587\u4ef6\u63a5\u6536\u5931\u8d25: %s - MD5\u6821\u9a8c\u5931\u8d25\n\n", file.relativePath);
                System.out.println(file.expectedMd5);
                System.out.println(receivedMd5);
                return;
            }
            logger.info("\u6587\u4ef6\u9a8c\u8bc1\u6210\u529f: {} - \u5927\u5c0f: {}, MD5: {}", file.relativePath, FileTransferUtils.formatFileSize(file.fileSize), receivedMd5);
            if (file.relativePath.startsWith("batch_") && (file.relativePath.endsWith(".pack") || file.relativePath.endsWith(".lz4") || file.relativePath.endsWith(".zip"))) {
                logger.info("\ud83d\udddc\ufe0f \u68c0\u6d4b\u5230\u538b\u7f29\u6279\u6b21\u6587\u4ef6: {}", (Object)file.relativePath);
                try {
                    String batchIdStr;
                    String fileName = file.relativePath;
                    if (fileName.endsWith(".pack")) {
                        batchIdStr = fileName.substring(6, fileName.length() - 5);
                    } else if (fileName.endsWith(".lz4")) {
                        batchIdStr = fileName.substring(6, fileName.length() - 4);
                    } else if (fileName.endsWith(".zip")) {
                        batchIdStr = fileName.substring(6, fileName.length() - 4);
                    } else {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6279\u6b21\u6587\u4ef6\u683c\u5f0f: " + fileName);
                    }
                    int batchId = Integer.parseInt(batchIdStr);
                    this.handleCompressedFileComplete(file.relativePath, file.file.getAbsolutePath(), batchId);
                    return;
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u538b\u7f29\u6279\u6b21\u6587\u4ef6\u540d\u5931\u8d25: {}", (Object)file.relativePath, (Object)e);
                }
            }
            TransferAckMessage ackMsg = new TransferAckMessage(this.sessionId);
            this.channel.writeAndFlush(ackMsg);
            logger.info("\u5df2\u53d1\u9001\u6587\u4ef6\u63a5\u6536\u786e\u8ba4\u6d88\u606f: {}", (Object)file.relativePath);
            int received = this.filesReceived.incrementAndGet();
            int totalProcessed = received + this.skippedFiles.get();
            double progress = (double)totalProcessed / (double)this.totalFiles * 100.0;
            if (!file.isBatchFile) {
                int displayTotalFiles;
                int displayFileIndex;
                if (this.isInSingleFileReceiveMode) {
                    displayFileIndex = this.currentSingleFileIndex;
                    displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                } else {
                    displayFileIndex = totalProcessed;
                    displayTotalFiles = this.totalFiles;
                }
                System.out.printf("\u2705 \u63a5\u6536\u5b8c\u6210 (%d/%d): %s\n\n", displayFileIndex, displayTotalFiles, file.relativePath);
                logger.debug("\ud83d\udd27 \u5355\u6587\u4ef6 {} \u63a5\u6536\u5b8c\u6210 ({}/{})", file.relativePath, this.currentSingleFileIndex, this.calculateActualSingleFileCount());
            }
            this.currentProcessingFile = null;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6587\u4ef6\u63a5\u6536\u5b8c\u6210\u65f6\u51fa\u9519: {}", (Object)file.relativePath, (Object)e);
            file.hasError = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFolderComplete(FolderCompleteMessage msg) {
        if (this.folderCompleteHandled) {
            logger.debug("\u5df2\u5904\u7406\u8fc7\u6587\u4ef6\u5939\u5b8c\u6210\u6d88\u606f\uff0c\u5ffd\u7565\u91cd\u590d\u6d88\u606f");
            return;
        }
        this.folderCompleteHandled = true;
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - (this.actualTransferStartTime > 0L ? this.actualTransferStartTime : this.folderStartTime);
        if (totalTime < 1000L) {
            logger.warn("\u8ba1\u7b97\u7684\u4f20\u8f93\u65f6\u95f4\u8fc7\u77ed ({}ms)\uff0c\u4f7f\u75281\u79d2\u4f5c\u4e3a\u6700\u5c0f\u503c", (Object)totalTime);
            totalTime = 1000L;
        }
        double speedMBps = this.calculateTransferSpeed(this.totalSize, totalTime);
        logger.info("\u6536\u5230\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\u6d88\u606f: {}, \u603b\u6587\u4ef6\u6570: {}, \u603b\u5927\u5c0f: {}, \u603b\u8017\u65f6: {} \u79d2, \u5e73\u5747\u901f\u5ea6: {:.2f} MB/s", msg.getFolderName(), msg.getTotalFiles(), FileTransferUtils.formatFileSize(msg.getTotalSize()), (double)totalTime / 1000.0, speedMBps);
        int receivedCount = this.filesReceived.get();
        int skippedCount = this.skippedFiles.get();
        int totalProcessedCount = receivedCount + skippedCount;
        if (totalProcessedCount < msg.getTotalFiles()) {
            logger.warn("\u6587\u4ef6\u5939\u4f20\u8f93\u4e0d\u5b8c\u6574: \u5df2\u5904\u7406 {}/{} \u6587\u4ef6 (\u63a5\u6536: {}, \u8df3\u8fc7: {})", totalProcessedCount, msg.getTotalFiles(), receivedCount, skippedCount);
        } else {
            logger.info("\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210: \u5df2\u5904\u7406 {}/{} \u6587\u4ef6 (\u63a5\u6536: {}, \u8df3\u8fc7: {})", totalProcessedCount, msg.getTotalFiles(), receivedCount, skippedCount);
        }
        this.transferCompleted = true;
        if (this.isInSingleFileReceiveMode && !this.singleFileList.isEmpty()) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.printf("\u2705 \u5355\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210: %d \u4e2a\u6587\u4ef6\n", this.calculateActualSingleFileCount());
                System.out.flush();
            }
            logger.info("\ud83d\udd27 \u5355\u6587\u4ef6\u63a5\u6536\u6a21\u5f0f\u5b8c\u6210: {} \u4e2a\u6587\u4ef6", (Object)this.calculateActualSingleFileCount());
        }
        this.completeBatchTransfer();
        this.waitForPendingFileChecks();
        this.printEnhancedFolderReceiveComplete(this.folderName, this.filesReceived.get(), this.skippedFiles.get(), this.totalFiles, this.totalSize, this.skippedSize.get(), this.saveDir, totalTime, speedMBps);
        FolderCompleteAckMessage ackMsg = new FolderCompleteAckMessage(this.sessionId, this.folderName, this.filesReceived.get(), this.skippedFiles.get(), this.totalSize - this.skippedSize.get());
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush(ackMsg).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    logger.info("\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\u786e\u8ba4\u6d88\u606f\u5df2\u53d1\u9001");
                    new Thread(() -> {
                        try {
                            Thread.sleep(2000L);
                            if (this.channel != null && this.channel.isActive()) {
                                this.channel.close();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }).start();
                } else {
                    logger.error("\u53d1\u9001\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\u786e\u8ba4\u6d88\u606f\u5931\u8d25", future.cause());
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
            }));
        }
    }

    private double calculateTransferSpeed(long bytes, long timeMs) {
        if (timeMs <= 0L) {
            return 0.0;
        }
        return (double)bytes / 1024.0 / 1024.0 / ((double)timeMs / 1000.0);
    }

    private void waitForPendingFileChecks() {
        int maxWaitTime = 30000;
        int waitInterval = 100;
        int totalWaited = 0;
        while (this.pendingFileChecks.get() > 0 && totalWaited < maxWaitTime) {
            try {
                Thread.sleep(waitInterval);
                if ((totalWaited += waitInterval) % 1000 != 0) continue;
                logger.info("\u7b49\u5f85\u5f02\u6b65\u6587\u4ef6\u68c0\u67e5\u5b8c\u6210: \u5269\u4f59 {} \u4e2a, \u5df2\u7b49\u5f85 {} \u79d2", (Object)this.pendingFileChecks.get(), (Object)(totalWaited / 1000));
            }
            catch (InterruptedException e) {
                logger.warn("\u7b49\u5f85\u5f02\u6b65\u6587\u4ef6\u68c0\u67e5\u65f6\u88ab\u4e2d\u65ad");
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.pendingFileChecks.get() > 0) {
            logger.warn("\u7b49\u5f85\u5f02\u6b65\u6587\u4ef6\u68c0\u67e5\u8d85\u65f6\uff0c\u4ecd\u6709 {} \u4e2a\u672a\u5b8c\u6210", (Object)this.pendingFileChecks.get());
        } else {
            logger.info("\u6240\u6709\u5f02\u6b65\u6587\u4ef6\u68c0\u67e5\u5df2\u5b8c\u6210");
        }
    }

    private void closeFile(FileMetadata file) {
        if (file.fileChannel != null) {
            try {
                file.fileChannel.force(false);
                file.fileChannel.close();
                file.fileChannel = null;
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u901a\u9053\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            }
        }
        if (file.fos != null) {
            try {
                file.fos.flush();
                file.fos.close();
                file.fos = null;
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            }
        }
    }

    private void closeAllFiles() {
        for (FileMetadata file : this.fileMetadataMap.values()) {
            this.closeFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileSkipAsync(String sessionId, File file, long fileSize, String expectedMd5, String relativePath) {
        if (fileSize == 0L) {
            try {
                int displayTotalFiles;
                int displayFileIndex;
                logger.debug("\ud83d\udd04 \u5904\u7406\u7a7a\u6587\u4ef6\uff08\u65b0\u6d41\u7a0b\uff09: {}", (Object)relativePath);
                if (file.exists() && file.length() == 0L) {
                    int displayTotalFiles2;
                    int displayFileIndex2;
                    int fileNumber = this.filesReceived.get() + this.skippedFiles.get() + 1;
                    FileSkipMessage skipMsg = new FileSkipMessage(sessionId, relativePath, "\u6587\u4ef6\u5df2\u5b58\u5728\u4e14MD5\u76f8\u540c", fileSize);
                    this.channel.writeAndFlush(skipMsg);
                    this.markFileAsSkipped(relativePath, fileSize);
                    this.currentProcessingFile = null;
                    logger.debug("\ud83d\udd04 \u7a7a\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u76f4\u63a5\u8df3\u8fc7: {}", (Object)relativePath);
                    if (this.isInSingleFileReceiveMode) {
                        displayFileIndex2 = this.currentSingleFileIndex;
                        displayTotalFiles2 = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                    } else {
                        displayFileIndex2 = fileNumber;
                        displayTotalFiles2 = this.totalFiles;
                    }
                    System.out.printf("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6 (%d/%d): %s (\u5df2\u5b58\u5728\u76f8\u540c\u6587\u4ef6)\n\n", displayFileIndex2, displayTotalFiles2, relativePath);
                    return;
                }
                FileMetadata metadata = this.fileMetadataMap.get(relativePath);
                if (metadata == null) {
                    logger.error("\u7a7a\u6587\u4ef6\u5143\u6570\u636e\u4e22\u5931: {}", (Object)relativePath);
                    return;
                }
                File parentDir = file.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (file.exists()) {
                    logger.debug("\u5220\u9664\u5df2\u5b58\u5728\u7684\u6587\u4ef6\u8fdb\u884c\u91cd\u65b0\u521b\u5efa: {}", (Object)file.getAbsolutePath());
                    file.delete();
                }
                file.createNewFile();
                logger.debug("\ud83d\udd04 \u7a7a\u6587\u4ef6\u521b\u5efa\u5b8c\u6210: {}", (Object)file.getAbsolutePath());
                int received = this.filesReceived.incrementAndGet();
                int totalProcessed = received + this.skippedFiles.get();
                double progress = (double)totalProcessed / (double)this.totalFiles * 100.0;
                if (this.isInSingleFileReceiveMode) {
                    displayFileIndex = this.currentSingleFileIndex;
                    displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                } else {
                    displayFileIndex = totalProcessed;
                    displayTotalFiles = this.totalFiles;
                }
                System.out.printf("\u2705 \u63a5\u6536\u5b8c\u6210 (%d/%d): %s | \u7a7a\u6587\u4ef6\n\n", displayFileIndex, displayTotalFiles, relativePath);
                if (this.isInSingleFileReceiveMode && displayFileIndex == displayTotalFiles) {
                    PrintStream printStream = System.out;
                    synchronized (printStream) {
                        System.out.printf("\u2705 %d \u4e2a\u6587\u4ef6\u63a5\u6536\u5b8c\u6210\n", displayTotalFiles);
                        System.out.flush();
                    }
                    this.isInSingleFileReceiveMode = false;
                    logger.info("\ud83d\udd27 \u5355\u6587\u4ef6\u63a5\u6536\u6a21\u5f0f\u5b8c\u6210: {} \u4e2a\u6587\u4ef6 (\u7a7a\u6587\u4ef6)", (Object)displayTotalFiles);
                }
                TransferAckMessage ackMsg = new TransferAckMessage(sessionId);
                this.channel.writeAndFlush(ackMsg);
                logger.debug("\ud83d\udd04 \u7a7a\u6587\u4ef6ACK\u5df2\u53d1\u9001: {}", (Object)relativePath);
                this.currentProcessingFile = null;
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7a7a\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)relativePath, (Object)e);
            }
            return;
        }
        this.pendingFileChecks.incrementAndGet();
        new Thread(() -> {
            try {
                this.md5Semaphore.acquire();
                try {
                    if (this.shouldSkipFile(file, fileSize, expectedMd5)) {
                        int displayTotalFiles;
                        int displayFileIndex;
                        FileSkipMessage skipMsg = new FileSkipMessage(sessionId, relativePath, "\u6587\u4ef6\u5df2\u5b58\u5728\u4e14MD5\u76f8\u540c", fileSize);
                        this.channel.writeAndFlush(skipMsg);
                        int fileNumber = this.filesReceived.get() + this.skippedFiles.get() + 1;
                        this.markFileAsSkipped(relativePath, fileSize);
                        this.currentProcessingFile = null;
                        logger.info("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6: {} (\u6587\u4ef6\u5df2\u5b58\u5728\u4e14MD5\u76f8\u540c)", (Object)relativePath);
                        if (this.isInSingleFileReceiveMode) {
                            displayFileIndex = this.currentSingleFileIndex;
                            displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                        } else {
                            displayFileIndex = fileNumber;
                            displayTotalFiles = this.totalFiles;
                        }
                        System.out.printf("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6 (%d/%d): %s (\u5df2\u5b58\u5728\u76f8\u540c\u6587\u4ef6)\n\n", displayFileIndex, displayTotalFiles, relativePath);
                        return;
                    }
                }
                finally {
                    this.md5Semaphore.release();
                }
                this.continueFileReceive(file, fileSize, expectedMd5, relativePath, sessionId);
            }
            catch (Exception e) {
                logger.error("\u5f02\u6b65\u68c0\u67e5\u6587\u4ef6\u8df3\u8fc7\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)relativePath, (Object)e);
                try {
                    this.continueFileReceive(file, fileSize, expectedMd5, relativePath, sessionId);
                }
                catch (IOException ioEx) {
                    logger.error("\u7ee7\u7eed\u6587\u4ef6\u63a5\u6536\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)relativePath, (Object)ioEx);
                }
            }
            finally {
                int remaining = this.pendingFileChecks.decrementAndGet();
                logger.debug("\u6587\u4ef6\u68c0\u67e5\u5b8c\u6210: {}, \u5269\u4f59\u5f85\u5904\u7406: {}", (Object)relativePath, (Object)remaining);
            }
        }, "MD5-Check-" + relativePath).start();
    }

    private void continueFileReceive(File file, long fileSize, String expectedMd5, String relativePath, String sessionId) throws IOException {
        logger.info("\ud83d\udce4 \u53d1\u9001\u6587\u4ef6\u51c6\u5907\u5c31\u7eea\u6d88\u606f: {}", (Object)relativePath);
        FileMetadata metadata = this.fileMetadataMap.get(relativePath);
        if (metadata == null) {
            logger.error("\u6587\u4ef6\u5143\u6570\u636e\u4e22\u5931: {}", (Object)relativePath);
            return;
        }
        if (file.exists()) {
            logger.info("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\u4f46\u9700\u8981\u91cd\u65b0\u4f20\u8f93\uff0c\u5c06\u5220\u9664: {}", (Object)file.getAbsolutePath());
            if (!file.delete()) {
                logger.warn("\u65e0\u6cd5\u5220\u9664\u5df2\u5b58\u5728\u7684\u6587\u4ef6: {}", (Object)file.getAbsolutePath());
            }
        }
        if (fileSize == 0L) {
            logger.error("\u7a7a\u6587\u4ef6\u4e0d\u5e94\u8be5\u8fdb\u5165continueFileReceive\u65b9\u6cd5: {}", (Object)relativePath);
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.setLength(fileSize);
        }
        metadata.fos = new FileOutputStream(file);
        metadata.fileChannel = metadata.fos.getChannel();
        logger.info("\u51c6\u5907\u63a5\u6536\u6587\u4ef6: {} - \u5df2\u5206\u914d\u7a7a\u95f4: {}, \u5757\u6570: {}", relativePath, FileTransferUtils.formatFileSize(fileSize), metadata.totalChunks);
        TransferAckMessage readyMsg = new TransferAckMessage(sessionId);
        this.channel.writeAndFlush(readyMsg);
        logger.info("\u5df2\u53d1\u9001\u6587\u4ef6\u51c6\u5907\u5c31\u7eea\u786e\u8ba4: {}", (Object)relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSingleFileTransferPhase() {
        if (!this.hasShownSingleFileTransferTitle) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                System.out.println("\ud83d\udcc4 \u9636\u6bb52: \u5355\u6587\u4ef6\u63a5\u6536\u5f00\u59cb");
                System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                System.out.println("\ud83d\udcc4 \u5355\u6587\u4ef6\u4f20\u8f93\u5f00\u59cb...");
                System.out.flush();
                this.isInSingleFileReceiveMode = true;
                this.hasShownSingleFileTransferTitle = true;
                this.singleFileCounter.set(0);
                logger.info("\ud83d\udd27 \u4e3b\u52a8\u89e6\u53d1\u5355\u6587\u4ef6\u63a5\u6536\u6a21\u5f0f");
            }
        }
    }

    private int calculateActualSingleFileCount() {
        if (this.transferStatsReceived) {
            logger.debug("\ud83d\udd27 \u4f7f\u7528\u4ece\u53d1\u9001\u7aef\u63a5\u6536\u7684\u51c6\u786e\u5355\u6587\u4ef6\u6570\u91cf: {} \u4e2a\u6587\u4ef6", (Object)this.totalSingleFiles);
            return this.totalSingleFiles;
        }
        logger.debug("\ud83d\udd27 \u7b49\u5f85\u4ece\u53d1\u9001\u7aef\u63a5\u6536\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f...");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSkipFile(File targetFile, long expectedSize, String expectedMd5) {
        if (!targetFile.getName().matches("batch_\\d+\\.pack") && (this.maxBatchId == 0 || this.allBatchesCompleted)) {
            List<String> list = this.singleFileList;
            synchronized (list) {
                if (!this.singleFileList.contains(targetFile.getName())) {
                    this.singleFileList.add(targetFile.getName());
                    if (this.calculateActualSingleFileCount() == 1 && !this.hasShownSingleFileTransferTitle) {
                        Object object = this.batchCompletionLock;
                        synchronized (object) {
                            while (!this.batchOutputComplete && !this.activeCompressedBatches.isEmpty()) {
                                try {
                                    logger.debug("\ud83d\udd27 \u7b49\u5f85\u6279\u6b21\u8f93\u51fa\u5b8c\u6210...");
                                    this.batchCompletionLock.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                        }
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        object = System.out;
                        synchronized (object) {
                            if (!this.hasShownSingleFileTransferTitle) {
                                for (int i = 1; i <= this.maxBatchId; ++i) {
                                    String message = this.batchCompletionMessages.get(i);
                                    if (message == null) continue;
                                    System.out.println(message);
                                    if (i >= this.maxBatchId) continue;
                                    System.out.println();
                                }
                                if (!this.batchCompletionMessages.isEmpty()) {
                                    System.out.println();
                                }
                                System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                                System.out.println("\ud83d\udcc4 \u9636\u6bb52: \u5355\u6587\u4ef6\u63a5\u6536\u5f00\u59cb");
                                System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                                int currentSingleFileCount = this.calculateActualSingleFileCount();
                                if (currentSingleFileCount == 1) {
                                    int estimatedCount = this.calculateActualSingleFileCount();
                                    currentSingleFileCount = Math.max(currentSingleFileCount, estimatedCount);
                                }
                                System.out.println("\ud83d\udcc4 \u5355\u6587\u4ef6\u4f20\u8f93\u5f00\u59cb...");
                                System.out.flush();
                                this.isInSingleFileReceiveMode = true;
                                this.hasShownSingleFileTransferTitle = true;
                                this.singleFileCounter.set(0);
                                logger.info("\ud83d\udd27 \u5728\u7b2c\u4e00\u4e2a\u5355\u6587\u4ef6\u5904\u7406\u65f6\u663e\u793a\u9636\u6bb5\u6807\u9898: {} \u4e2a\u6587\u4ef6", (Object)currentSingleFileCount);
                            }
                        }
                    }
                }
                this.currentSingleFileIndex = this.singleFileList.indexOf(targetFile.getName()) + 1;
                if (this.currentSingleFileIndex <= 0) {
                    logger.warn("\ud83d\udd27 \u6587\u4ef6 {} \u4e0d\u5728\u5355\u6587\u4ef6\u5217\u8868\u4e2d\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7d22\u5f15", (Object)targetFile.getName());
                    this.currentSingleFileIndex = 1;
                }
                logger.debug("\ud83d\udd27 \u5355\u6587\u4ef6\u7d22\u5f15: {}/{} for {} (\u5217\u8868\u5927\u5c0f: {})", this.currentSingleFileIndex, this.calculateActualSingleFileCount(), targetFile.getName(), this.calculateActualSingleFileCount());
            }
        }
        if (!targetFile.getName().matches("batch_\\d+\\.pack") && !this.allBatchesCompleted) {
            logger.debug("\ud83d\udd27 \u6279\u6b21\u5904\u7406\u5c1a\u672a\u5b8c\u6210\uff0c\u6682\u65f6\u8df3\u8fc7\u5355\u6587\u4ef6\u68c0\u6d4b: {}", (Object)targetFile.getName());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        try {
            if (!targetFile.exists()) {
                logger.debug("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u4f20\u8f93: {}", (Object)targetFile.getName());
                return false;
            }
            long existingSize = targetFile.length();
            if (existingSize != expectedSize) {
                logger.debug("\u6587\u4ef6\u5927\u5c0f\u4e0d\u5339\u914d\uff0c\u9700\u8981\u4f20\u8f93: {} (\u73b0\u6709: {}, \u671f\u671b: {})", targetFile.getName(), existingSize, expectedSize);
                return false;
            }
            String existingMd5 = null;
            try {
                if (targetFile.length() == 0L) {
                    existingMd5 = "d41d8cd98f00b204e9800998ecf8427e";
                    logger.debug("\ud83d\udd0d 0\u5b57\u8282\u6587\u4ef6\u5feb\u901f\u6821\u9a8c: {}", (Object)targetFile.getName());
                } else {
                    int displayTotalFiles;
                    int displayFileIndex;
                    logger.debug("\ud83d\udd0d \u6b63\u5728\u6821\u9a8c\u73b0\u6709\u6587\u4ef6: {}", (Object)targetFile.getName());
                    if (this.isInSingleFileReceiveMode) {
                        displayFileIndex = this.currentSingleFileIndex;
                        displayTotalFiles = this.transferStatsReceived ? this.totalSingleFiles : this.calculateActualSingleFileCount();
                    } else {
                        displayFileIndex = this.filesReceived.get() + this.skippedFiles.get() + 1;
                        displayTotalFiles = this.totalFiles;
                    }
                    System.out.printf("\ud83d\udd0d \u6821\u9a8c\u6587\u4ef6 (%d/%d): %s (\u5927\u5c0f: %s)\n", displayFileIndex, displayTotalFiles, targetFile.getName(), this.formatFileSize(targetFile.length()));
                    long startTime = System.currentTimeMillis();
                    existingMd5 = FileTransferUtils.calculateFileMD5(targetFile);
                    long endTime = System.currentTimeMillis();
                    logger.debug("MD5\u8ba1\u7b97\u5b8c\u6210: {} \u8017\u65f6: {}ms", (Object)targetFile.getName(), (Object)(endTime - startTime));
                }
            }
            catch (Exception e) {
                logger.warn("\u8ba1\u7b97\u6587\u4ef6MD5\u5931\u8d25\uff0c\u5c06\u91cd\u65b0\u4f20\u8f93: {} - {}", (Object)targetFile.getName(), (Object)e.getMessage());
                return false;
            }
            if (expectedMd5 != null && expectedMd5.equals(existingMd5)) {
                logger.info("\u2705 MD5\u5339\u914d\uff0c\u53ef\u8df3\u8fc7\u6587\u4ef6: {}", (Object)targetFile.getName());
                return true;
            }
            logger.debug("MD5\u4e0d\u5339\u914d\uff0c\u9700\u8981\u4f20\u8f93: {} (\u73b0\u6709: {}, \u671f\u671b: {})", targetFile.getName(), existingMd5, expectedMd5);
            return false;
        }
        catch (Exception e) {
            logger.warn("\u68c0\u67e5\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5c06\u91cd\u65b0\u4f20\u8f93: {} - {}", (Object)targetFile.getName(), (Object)e.getMessage());
            return false;
        }
    }

    private void markFileAsSkipped(String relativePath, long fileSize) {
        this.skippedFiles.incrementAndGet();
        this.skippedSize.addAndGet(fileSize);
        int totalProcessed = this.filesReceived.get() + this.skippedFiles.get();
        double progress = (double)totalProcessed / (double)this.totalFiles * 100.0;
        logger.info("\ud83d\udcca \u6587\u4ef6\u8df3\u8fc7\u7edf\u8ba1: \u5df2\u8df3\u8fc7 {} \u4e2a\u6587\u4ef6, \u8282\u7701 {} \u4f20\u8f93, \u603b\u8fdb\u5ea6: {:.1f}%", this.skippedFiles.get(), this.formatFileSize(this.skippedSize.get()), progress);
    }

    private String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", (double)size / 1024.0 / 1024.0);
        }
        return String.format("%.2f GB", (double)size / 1024.0 / 1024.0 / 1024.0);
    }

    private void printEnhancedFolderReceiveComplete(String folderName, int receivedFiles, int skippedFiles, int totalFiles, long totalSize, long skippedSize, String saveDir, long totalTime, double speedMBps) {
        int transferredFiles = receivedFiles;
        long transferredSize = totalSize - skippedSize;
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\ud83c\udf89 \u6587\u4ef6\u5939\u63a5\u6536\u5b8c\u6210");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc1 " + folderName);
        System.out.printf("\ud83d\udcca \u603b\u5171 %d \u4e2a\u6587\u4ef6  \ud83d\udce6 %s  \u23f0 %.2f \u79d2%n", totalFiles, this.formatFileSize(totalSize), (double)totalTime / 1000.0);
        if (skippedFiles > 0) {
            System.out.printf("\ud83d\udce5 \u65b0\u63a5\u6536: %d \u4e2a\u6587\u4ef6  \ud83d\udce6 %s  \u26a1 %.2f MB/s%n", transferredFiles, this.formatFileSize(transferredSize), speedMBps);
            System.out.printf("\u23ed\ufe0f \u5df2\u8df3\u8fc7: %d \u4e2a\u6587\u4ef6  \ud83d\udce6 %s (\u6587\u4ef6\u5df2\u5b58\u5728)%n", skippedFiles, this.formatFileSize(skippedSize));
        } else {
            System.out.printf("\ud83d\udce5 \u5168\u90e8\u63a5\u6536  \u26a1 %.2f MB/s%n", speedMBps);
        }
        System.out.println("\ud83d\udcc1 \u4fdd\u5b58\u4f4d\u7f6e: " + new File(saveDir, folderName).getAbsolutePath());
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    public void shutdown() {
        this.closeAllFiles();
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    public boolean isTransferCompleted() {
        return this.transferCompleted;
    }

    public void switchToPublicRelay() {
        if (this.codeInvalid) {
            logger.info("\u914d\u5bf9\u7801\u5df2\u786e\u8ba4\u65e0\u6548\uff0c\u4e0d\u518d\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7");
            logger.info("\u914d\u5bf9\u7801\u65e0\u6548\uff0c\u7a0b\u5e8f\u5373\u5c06\u9000\u51fa");
            return;
        }
        if (this.isUsingPublicRelay || this.isTransferCompleted()) {
            logger.info("\u4e0d\u9700\u8981\u5207\u6362\u5230\u516c\u7f51\u4e2d\u7ee7\uff1a{}", (Object)(this.isTransferCompleted() ? "\u4f20\u8f93\u5df2\u5b8c\u6210" : "\u5df2\u5728\u4f7f\u7528\u516c\u7f51\u4e2d\u7ee7"));
            return;
        }
        logger.info("\u5207\u6362\u5230\u516c\u7f51\u4e2d\u7ee7\u670d\u52a1\u5668");
        logger.info("\u6b63\u5728\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668...");
        this.closeCurrentConnection();
        if (this.connectToRelay("relay.daodaovps.com", 8001)) {
            this.isUsingLocalRelay = false;
            this.isUsingPublicRelay = true;
            logger.info("\u6210\u529f\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
        } else {
            logger.info("\u65e0\u6cd5\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\uff0c\u4f20\u8f93\u5931\u8d25");
        }
    }

    private void monitorChannelStatus() {
        new Thread(() -> {
            while (this.connectionActive && !this.transferCompleted) {
                try {
                    FileMetadata currentFile;
                    Thread.sleep(5000L);
                    int currentReceived = this.filesReceived.get();
                    int currentSkipped = this.skippedFiles.get();
                    int totalProcessed = currentReceived;
                    double progressPercent = (double)totalProcessed / (double)this.totalFiles * 100.0;
                    logger.info("\ud83d\udcca \u901a\u9053\u72b6\u6001\u76d1\u63a7: \u8fde\u63a5={}, \u6d3b\u8dc3={}, \u5df2\u5904\u7406={}/{} \u6587\u4ef6 (\u63a5\u6536:{}, \u8df3\u8fc7:{}, \u8fdb\u5ea6:{:.2f}%), \u5f53\u524d\u5904\u7406={}", this.channel != null, this.channel != null && this.channel.isActive(), totalProcessed, this.totalFiles, currentReceived, currentSkipped, progressPercent, this.currentProcessingFile);
                    if (this.currentProcessingFile == null || (currentFile = this.fileMetadataMap.get(this.currentProcessingFile)) == null) continue;
                    logger.info("\u5f53\u524d\u6587\u4ef6\u72b6\u6001: \u6587\u4ef6={}, \u63a5\u6536\u8fdb\u5ea6={}/{} \u5757 ({}%)", this.currentProcessingFile, currentFile.chunksReceived.get(), currentFile.totalChunks, String.format("%.2f", (double)currentFile.chunksReceived.get() / (double)currentFile.totalChunks * 100.0));
                }
                catch (InterruptedException e) {
                    logger.info("\u901a\u9053\u76d1\u63a7\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                    break;
                }
                catch (Exception e) {
                    logger.error("\u901a\u9053\u76d1\u63a7\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            logger.info("\u901a\u9053\u76d1\u63a7\u7ebf\u7a0b\u9000\u51fa: connectionActive={}, transferCompleted={}", (Object)this.connectionActive, (Object)this.transferCompleted);
        }).start();
    }

    public void setExistingConnection(Channel channel, String sessionId) {
        this.channel = channel;
        this.sessionId = sessionId;
        this.connectionActive = true;
    }

    public void handleMessage(Message msg) throws Exception {
        if (msg.getType() == MessageType.FOLDER_INFO) {
            this.handleFolderInfo((FolderInfoMessage)msg);
        } else if (msg.getType() == MessageType.FILE_INFO) {
            this.handleFileInfo((FileInfoMessage)msg);
        } else if (msg.getType() == MessageType.FILE_CHUNK) {
            this.handleFileChunk((FileChunkMessage)msg);
        } else if (msg.getType() != MessageType.TRANSFER_COMPLETE) {
            if (msg.getType() == MessageType.FOLDER_COMPLETE) {
                this.handleFolderComplete((FolderCompleteMessage)msg);
            } else if (msg.getType() == MessageType.BATCH_FILE_INFO) {
                this.handleBatchFileInfo((BatchFileInfoMessage)msg);
            } else if (msg.getType() == MessageType.COMPRESSED_BATCH_MANIFEST) {
                this.handleCompressedBatchManifest((CompressedBatchManifestMessage)msg);
            } else if (msg.getType() == MessageType.COMPRESSED_BATCH_DATA) {
                this.handleCompressedBatchData((CompressedBatchDataMessage)msg);
            } else if (msg.getType() == MessageType.TRANSFER_STATS) {
                this.handleTransferStats((TransferStatsMessage)msg);
            } else if (msg.getType() == MessageType.ERROR) {
                ErrorMessage errorMsg = (ErrorMessage)msg;
                logger.error("\u6536\u5230\u9519\u8bef\u6d88\u606f: {}", (Object)errorMsg.getErrorMsg());
                logger.info("\u670d\u52a1\u5668\u9519\u8bef: " + errorMsg.getErrorMsg());
            }
        }
    }

    public int getReceivedFiles() {
        return this.filesReceived.get();
    }

    public int getSkippedFiles() {
        return this.skippedFiles.get();
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    private boolean isFileCompletelyReceived(FileMetadata file) {
        try {
            if (file.fileChannel != null) {
                file.fileChannel.force(false);
                logger.debug("\u5df2\u5f3a\u5236\u5237\u65b0\u6587\u4ef6\u7f13\u5b58\u5230\u78c1\u76d8: {}", (Object)file.relativePath);
            }
            if (!file.file.exists()) {
                logger.error("\u6587\u4ef6\u63a5\u6536\u540e\u4e0d\u5b58\u5728: {}", (Object)file.relativePath);
                return false;
            }
            long actualSize = file.file.length();
            if (actualSize != file.fileSize) {
                logger.error("\u6587\u4ef6\u5927\u5c0f\u4e0d\u5339\u914d: {} - \u9884\u671f: {}, \u5b9e\u9645: {}", file.relativePath, file.fileSize, actualSize);
                return false;
            }
            if (file.receivedChunks.size() != file.totalChunks) {
                logger.error("\u63a5\u6536\u7684\u5757\u6570\u91cf\u4e0d\u5b8c\u6574: {} - \u9884\u671f: {}, \u5b9e\u9645: {}", file.relativePath, file.totalChunks, file.receivedChunks.size());
                return false;
            }
            for (int i = 0; i < file.totalChunks; ++i) {
                if (file.receivedChunks.containsKey(i)) continue;
                logger.error("\u7f3a\u5c11\u5757\u7d22\u5f15: {} - \u5757: {}", (Object)file.relativePath, (Object)i);
                return false;
            }
            logger.debug("\u6587\u4ef6\u5b8c\u6574\u6027\u9a8c\u8bc1\u901a\u8fc7: {} (\u5927\u5c0f: {}, \u5757\u6570: {})", file.relativePath, actualSize, file.totalChunks);
            return true;
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u6587\u4ef6\u5b8c\u6574\u6027\u65f6\u53d1\u751f\u5f02\u5e38: {} - {}", file.relativePath, e.getMessage(), e);
            return false;
        }
    }

    public void handleBatchFileInfo(BatchFileInfoMessage msg) throws Exception {
        logger.info("\ud83d\udce6 \u6536\u5230\u6279\u91cf\u6587\u4ef6\u4fe1\u606f\uff1a\u6279\u6b21ID={}, \u6587\u4ef6\u6570={}, \u603b\u5927\u5c0f={}", msg.getBatchId(), msg.getTotalFiles(), FileTransferUtils.formatBytes(msg.getTotalSize()));
        if (msg.getBatchId() == 1) {
            System.out.println("\ud83d\udce6 \u5f00\u59cb\u63a5\u6536\u6279\u91cf\u6587\u4ef6\u4f20\u8f93...");
        }
        if (!this.folderInfoReceived) {
            logger.warn("\u6536\u5230\u6279\u91cf\u6587\u4ef6\u4fe1\u606f\u4f46\u5c1a\u672a\u6536\u5230\u6587\u4ef6\u5939\u4fe1\u606f\uff0c\u5ffd\u7565\u6279\u6b21: {}", (Object)msg.getBatchId());
            return;
        }
        List<BatchFileInfoMessage.BatchFileEntry> batchFiles = msg.getFiles();
        this.activeBatches.put(msg.getBatchId(), batchFiles);
        logger.debug("\u5f00\u59cb\u540c\u6b65\u5904\u7406\u6279\u6b21 {}\uff0c\u5305\u542b {} \u4e2a\u6587\u4ef6", (Object)msg.getBatchId(), (Object)batchFiles.size());
        long startTime = System.currentTimeMillis();
        try {
            this.processBatchFiles(msg.getBatchId(), batchFiles);
            long elapsed = System.currentTimeMillis() - startTime;
            logger.debug("\u6279\u6b21 {} \u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6: {} \u6beb\u79d2", (Object)msg.getBatchId(), (Object)elapsed);
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - startTime;
            logger.error("\u5904\u7406\u6279\u6b21 {} \u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8017\u65f6: {} \u6beb\u79d2", msg.getBatchId(), elapsed, e);
            throw e;
        }
    }

    private void processBatchFiles(int batchId, List<BatchFileInfoMessage.BatchFileEntry> batchFiles) throws Exception {
        ArrayList<String> acceptedFiles = new ArrayList<String>();
        ArrayList<String> skippedFiles = new ArrayList<String>();
        HashMap<String, String> errorFiles = new HashMap<String, String>();
        FileSizeCategory category = this.determineBatchCategory(batchFiles);
        AtomicInteger categoryCounter = this.categoryBatchCounters.computeIfAbsent(category, k -> new AtomicInteger(0));
        int sequentialBatchNum = categoryCounter.incrementAndGet();
        if (this.batchProgressTracker == null || !category.equals((Object)this.batchProgressTracker.getCategory())) {
            if (this.batchProgressTracker != null) {
                this.batchProgressTracker.complete();
            }
            this.batchProgressTracker = new BatchProgressTracker(category, 0);
        }
        this.batchProgressTracker.startBatch(sequentialBatchNum, batchFiles.size());
        int fileIndex = 0;
        for (BatchFileInfoMessage.BatchFileEntry entry : batchFiles) {
            this.batchProgressTracker.updateCurrentFile(++fileIndex, entry.getFileName());
            try {
                String relativePath = FileTransferUtils.normalizePath(entry.getFileName());
                File targetFile = new File(new File(this.saveDir, this.folderName), relativePath);
                boolean shouldSkip = false;
                if (targetFile.exists() && targetFile.length() == entry.getFileSize()) {
                    if (entry.getFileSize() == 0L) {
                        shouldSkip = true;
                    } else {
                        String existingMd5 = FileTransferUtils.calculateFileMD5(targetFile);
                        if (entry.getMd5().equals(existingMd5)) {
                            shouldSkip = true;
                        }
                    }
                }
                if (shouldSkip) {
                    skippedFiles.add(entry.getFileName());
                    this.skippedFiles.incrementAndGet();
                    this.skippedSize.addAndGet(entry.getFileSize());
                    logger.debug("\u6279\u6b21\u6587\u4ef6\u8df3\u8fc7: {} (\u5df2\u5b58\u5728\uff0cMD5\u5339\u914d)", (Object)entry.getFileName());
                    continue;
                }
                acceptedFiles.add(entry.getFileName());
                this.createFileMetadataForBatch(entry, relativePath, targetFile);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u6279\u6b21\u6587\u4ef6 {} \u65f6\u51fa\u9519", (Object)entry.getFileName(), (Object)e);
                errorFiles.put(entry.getFileName(), e.getMessage());
            }
        }
        BatchFileAckMessage ackMsg = new BatchFileAckMessage(this.sessionId, batchId, acceptedFiles, skippedFiles, errorFiles);
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush(ackMsg);
            logger.info("\u5df2\u53d1\u9001\u6279\u91cf\u6587\u4ef6\u786e\u8ba4\uff1a\u6279\u6b21={}, \u63a5\u53d7={}, \u8df3\u8fc7={}, \u9519\u8bef={}", batchId, acceptedFiles.size(), skippedFiles.size(), errorFiles.size());
        }
        int totalAccepted = acceptedFiles.size();
        int totalSkipped = skippedFiles.size();
        int totalError = errorFiles.size();
        long transmittedBytes = acceptedFiles.stream().mapToLong(f -> batchFiles.stream().filter(entry -> entry.getFileName().equals(f)).mapToLong(BatchFileInfoMessage.BatchFileEntry::getFileSize).findFirst().orElse(0L)).sum();
        if (this.batchProgressTracker != null) {
            this.batchProgressTracker.completeBatch(totalAccepted, totalSkipped, totalError, transmittedBytes);
        }
    }

    private void createFileMetadataForBatch(BatchFileInfoMessage.BatchFileEntry entry, String relativePath, File targetFile) throws IOException {
        File parentDir = targetFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55: " + parentDir.getAbsolutePath());
        }
        FileMetadata metadata = new FileMetadata(relativePath, entry.getFileSize(), entry.getChunks(), entry.getChunkSize(), entry.getMd5());
        metadata.file = targetFile;
        metadata.startTime = System.currentTimeMillis();
        metadata.transferLatch = new CountDownLatch(1);
        metadata.isBatchFile = true;
        if (entry.getFileSize() > 0L) {
            metadata.fos = new FileOutputStream(targetFile);
            metadata.fileChannel = metadata.fos.getChannel();
        }
        this.fileMetadataMap.put(relativePath, metadata);
        logger.debug("\u4e3a\u6279\u6b21\u6587\u4ef6\u521b\u5efa\u5143\u6570\u636e: {}", (Object)relativePath);
    }

    public void completeBatchTransfer() {
        if (this.batchProgressTracker != null) {
            this.batchProgressTracker.complete();
        }
    }

    private FileSizeCategory determineBatchCategory(List<BatchFileInfoMessage.BatchFileEntry> batchFiles) {
        if (batchFiles == null || batchFiles.isEmpty()) {
            return FileSizeCategory.SMALL;
        }
        int microCount = 0;
        int tinyCount = 0;
        int smallCount = 0;
        int mediumCount = 0;
        int largeCount = 0;
        int hugeCount = 0;
        int massiveCount = 0;
        for (BatchFileInfoMessage.BatchFileEntry entry : batchFiles) {
            FileSizeCategory fileCategory = FileSizeCategory.categorizeFile(entry.getFileSize());
            switch (fileCategory) {
                case MICRO: {
                    ++microCount;
                    break;
                }
                case TINY: {
                    ++tinyCount;
                    break;
                }
                case SMALL: {
                    ++smallCount;
                    break;
                }
                case MEDIUM: {
                    ++mediumCount;
                    break;
                }
                case LARGE: {
                    ++largeCount;
                    break;
                }
                case HUGE: {
                    ++hugeCount;
                    break;
                }
                case MASSIVE: {
                    ++massiveCount;
                }
            }
        }
        int maxCount = Math.max(massiveCount, Math.max(hugeCount, Math.max(largeCount, Math.max(mediumCount, Math.max(smallCount, Math.max(tinyCount, microCount))))));
        if (massiveCount == maxCount) {
            return FileSizeCategory.MASSIVE;
        }
        if (hugeCount == maxCount) {
            return FileSizeCategory.HUGE;
        }
        if (largeCount == maxCount) {
            return FileSizeCategory.LARGE;
        }
        if (mediumCount == maxCount) {
            return FileSizeCategory.MEDIUM;
        }
        if (smallCount == maxCount) {
            return FileSizeCategory.SMALL;
        }
        if (tinyCount == maxCount) {
            return FileSizeCategory.TINY;
        }
        return FileSizeCategory.MICRO;
    }

    public void handleTransferStats(TransferStatsMessage msg) {
        this.totalBatches = msg.getTotalBatches();
        this.totalSingleFiles = msg.getTotalSingleFiles();
        this.transferStatsReceived = true;
        logger.info("\ud83d\udcca \u6536\u5230\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f: {} \u4e2a\u6279\u6b21\u5305 + {} \u4e2a\u5355\u6587\u4ef6", (Object)this.totalBatches, (Object)this.totalSingleFiles);
        this.currentBatchIndex = 0;
        this.currentSingleFileIndex = 0;
    }

    public void handleCompressedBatchManifest(CompressedBatchManifestMessage msg) throws Exception {
        int displayTotalBatches;
        boolean isFirstTime = !this.processedBatchIds.contains(msg.getBatchId());
        this.maxBatchId = Math.max(this.maxBatchId, msg.getBatchId());
        System.out.println("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        if (isFirstTime) {
            ++this.currentBatchIndex;
            displayTotalBatches = this.transferStatsReceived ? this.totalBatches : msg.getTotalBatches();
            System.out.printf("\ud83d\udd0d \u7b2c%d/%d\u6279\u6b21\u5305 - \u6e05\u5355\u68c0\u67e5\u53bb\u91cd\n", this.currentBatchIndex, displayTotalBatches);
            this.processedBatchIds.add(msg.getBatchId());
        } else {
            displayTotalBatches = this.transferStatsReceived ? this.totalBatches : msg.getTotalBatches();
            System.out.printf("\ud83d\udce6 \u7b2c%d/%d\u6279\u6b21\u5305\u5f00\u59cb\u63a5\u6536\n", this.currentBatchIndex, displayTotalBatches);
        }
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        long totalBatchSize = msg.getFiles().stream().mapToLong(f -> f.getFileSize()).sum();
        System.out.printf("\ud83d\udcec \u6536\u5230\u6279\u6b21\u6e05\u5355: %s (%d \u4e2a\u6587\u4ef6, %s)\n", msg.getBatchName(), msg.getFiles().size(), FileTransferUtils.formatBytes(totalBatchSize));
        System.out.flush();
        logger.info("\ud83d\udddc\ufe0f \u6536\u5230\u538b\u7f29\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6587\u4ef6\u6570={}, \u9884\u4f30\u538b\u7f29\u540e\u5927\u5c0f={}", msg.getBatchId(), msg.getFiles().size(), FileTransferUtils.formatBytes(msg.getEstimatedCompressedSize()));
        if (isFirstTime) {
            int batchTimeout = this.calculateCompressedBatchTimeout(msg.getEstimatedCompressedSize(), msg.getFiles().size());
            this.updateDynamicTimeout(msg.getEstimatedCompressedSize(), DynamicTimeoutCalculator.TransferType.COMPRESSED_BATCH);
        }
        if (!this.folderInfoReceived) {
            logger.warn("\u6536\u5230\u538b\u7f29\u6279\u6b21\u6e05\u5355\u4f46\u5c1a\u672a\u6536\u5230\u6587\u4ef6\u5939\u4fe1\u606f\uff0c\u62d2\u7edd\u6279\u6b21: {}", (Object)msg.getBatchId());
            this.sendCompressedBatchReject(msg.getSessionId(), msg.getBatchId(), "\u6587\u4ef6\u5939\u4fe1\u606f\u5c1a\u672a\u63a5\u6536");
            return;
        }
        this.compressedBatchExecutor.submit(() -> {
            try {
                System.out.printf("\ud83d\udccb %s: \u5f00\u59cb\u5904\u7406\u6e05\u5355\uff0c\u8bf7\u7a0d\u5019...\n", msg.getBatchName());
                System.out.flush();
                this.processCompressedBatchManifest(msg);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u538b\u7f29\u6279\u6b21\u6e05\u5355\u5f02\u5e38: \u6279\u6b21ID={}", (Object)msg.getBatchId(), (Object)e);
                try {
                    this.sendCompressedBatchReject(msg.getSessionId(), msg.getBatchId(), "\u5904\u7406\u6e05\u5355\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                }
                catch (Exception ex) {
                    logger.error("\u53d1\u9001\u62d2\u7edd\u6d88\u606f\u5931\u8d25", ex);
                }
            }
        });
    }

    private void processCompressedBatchManifest(CompressedBatchManifestMessage msg) throws Exception {
        List<CompressedBatchManifestMessage.BatchFileManifest> fileList = msg.getFiles();
        System.out.printf("\ud83d\udd0d %s: \u63a5\u6536\u5230\u6e05\u5355 - \u6279\u6b21ID: %d, \u6587\u4ef6\u5217\u8868: %s\n", msg.getBatchName(), msg.getBatchId(), fileList == null ? "null" : "\u975enull");
        if (fileList == null || fileList.isEmpty()) {
            System.out.printf("\u274c %s: \u8b66\u544a - \u63a5\u6536\u5230\u7a7a\u6e05\u5355\uff01\u62d2\u7edd\u6279\u6b21\u4f20\u8f93\n", msg.getBatchName());
            this.sendCompressedBatchReject(msg.getSessionId(), msg.getBatchId(), "\u63a5\u6536\u5230\u7a7a\u6e05\u5355");
            return;
        }
        int totalFiles = fileList.size();
        long totalSize = fileList.stream().mapToLong(f -> f.getFileSize()).sum();
        System.out.printf("\ud83d\udce6 %s: \u5f00\u59cb\u672c\u5730\u53bb\u91cd\u68c0\u67e5 (%d \u4e2a\u6587\u4ef6, %s)\n", msg.getBatchName(), totalFiles, FileTransferUtils.formatBytes(totalSize));
        System.out.flush();
        File folder = new File(this.saveDir, this.folderName);
        ArrayList<String> requiredFiles = new ArrayList<String>();
        ArrayList<String> skippedFiles = new ArrayList<String>();
        HashMap<String, String> errorFiles = new HashMap<String, String>();
        AtomicLong requiredTotalSize = new AtomicLong(0L);
        AtomicLong skippedTotalSize = new AtomicLong(0L);
        AtomicInteger processedCount = new AtomicInteger(0);
        long startTime = System.currentTimeMillis();
        if (totalFiles >= 100) {
            double avgFileSize = (double)totalSize / (double)totalFiles;
            int estimatedMs = (int)((double)totalFiles * 0.5 + (double)(totalSize / 0x6400000L * 1000L));
            System.out.printf("\ud83d\udd0d \u5f00\u59cb\u53bb\u91cd\u68c0\u67e5: %d \u4e2a\u6587\u4ef6 (\u5e73\u5747%s\uff0c\u9884\u8ba1%.1f\u79d2)\n", totalFiles, FileTransferUtils.formatBytes((long)avgFileSize), (double)estimatedMs / 1000.0);
        } else {
            System.out.printf("\ud83d\udd0d \u5f00\u59cb\u53bb\u91cd\u68c0\u67e5: %d \u4e2a\u6587\u4ef6\n", totalFiles);
        }
        ForkJoinPool customThreadPool = new ForkJoinPool(Math.min(4, Runtime.getRuntime().availableProcessors()));
        try {
            ((ForkJoinTask)customThreadPool.submit(() -> fileList.parallelStream().forEach(fileManifest -> {
                try {
                    Object cacheKey;
                    String relativePath = fileManifest.getRelativePath();
                    String systemPath = relativePath.replace('/', File.separatorChar);
                    File file = new File(folder, systemPath);
                    if (file.exists()) {
                        if (file.length() == fileManifest.getFileSize()) {
                            if (fileManifest.getFileSize() < 100L) {
                                List list = skippedFiles;
                                synchronized (list) {
                                    skippedFiles.add(relativePath);
                                    skippedTotalSize.addAndGet(fileManifest.getFileSize());
                                }
                            } else {
                                cacheKey = file.getAbsolutePath() + "_" + file.lastModified() + "_" + file.length();
                                String existingMd5 = fileHashCache.get(cacheKey);
                                if (existingMd5 == null) {
                                    existingMd5 = FileTransferUtils.calculateFileMD5(file);
                                    if ((long)fileHashCache.size() < 10000L) {
                                        fileHashCache.put((String)cacheKey, existingMd5);
                                    }
                                } else {
                                    this.cacheHitCount.incrementAndGet();
                                }
                                if (existingMd5.equals(fileManifest.getMd5())) {
                                    List list = skippedFiles;
                                    synchronized (list) {
                                        skippedFiles.add(relativePath);
                                        skippedTotalSize.addAndGet(fileManifest.getFileSize());
                                    }
                                } else {
                                    List list = requiredFiles;
                                    synchronized (list) {
                                        requiredFiles.add(relativePath);
                                        requiredTotalSize.addAndGet(fileManifest.getFileSize());
                                    }
                                }
                            }
                        } else {
                            cacheKey = requiredFiles;
                            synchronized (cacheKey) {
                                requiredFiles.add(relativePath);
                                requiredTotalSize.addAndGet(fileManifest.getFileSize());
                            }
                        }
                    } else {
                        cacheKey = requiredFiles;
                        synchronized (cacheKey) {
                            requiredFiles.add(relativePath);
                            requiredTotalSize.addAndGet(fileManifest.getFileSize());
                        }
                    }
                    int processed = processedCount.incrementAndGet();
                    if (totalFiles >= 100 && processed % Math.max(1, totalFiles / 20) == 0) {
                        double progress = (double)processed / (double)totalFiles * 100.0;
                        System.out.printf("\r\ud83d\udd0d \u53bb\u91cd\u68c0\u67e5: %d/%d (%.1f%%)", processed, totalFiles, progress);
                        System.out.flush();
                    }
                }
                catch (Exception e) {
                    Map map = errorFiles;
                    synchronized (map) {
                        errorFiles.put(fileManifest.getRelativePath(), e.getMessage());
                    }
                }
            }))).get();
        }
        catch (Exception e) {
            logger.error("\u53bb\u91cd\u68c0\u67e5\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
            throw e;
        }
        finally {
            customThreadPool.shutdown();
        }
        if (totalFiles >= 100) {
            System.out.print("\r                                                            \r");
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        System.out.printf("\u2705 %s: \u53bb\u91cd\u68c0\u67e5\u5b8c\u6210 (\u8017\u65f6:%.1fs)\n", msg.getBatchName(), (double)elapsedTime / 1000.0);
        System.out.printf("\ud83d\udcca \u9700\u8981\u4f20\u8f93: %d \u4e2a\u6587\u4ef6 (%s)\n", requiredFiles.size(), FileTransferUtils.formatBytes(requiredTotalSize.get()));
        System.out.printf("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6: %d \u4e2a\u6587\u4ef6 (%s)\n", skippedFiles.size(), FileTransferUtils.formatBytes(skippedTotalSize.get()));
        if (!errorFiles.isEmpty()) {
            System.out.printf("\u274c \u68c0\u67e5\u9519\u8bef: %d \u4e2a\u6587\u4ef6\n", errorFiles.size());
        }
        CompressedBatchManifestAckMessage ackMessage = new CompressedBatchManifestAckMessage(msg.getSessionId(), msg.getBatchId(), requiredFiles, skippedFiles, errorFiles);
        ackMessage.setStatistics(requiredTotalSize.get(), skippedTotalSize.get());
        this.activeCompressedBatches.put(msg.getBatchId(), msg);
        if (requiredFiles.isEmpty()) {
            System.out.printf("\u2705 %s: \u6240\u6709\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u4f20\u8f93\n", msg.getBatchName());
        } else {
            System.out.printf("\ud83d\udce4 %s: \u5df2\u786e\u8ba4\uff0c\u7b49\u5f85\u6279\u6b21\u5305 (%d \u4e2a\u6587\u4ef6\u9700\u8981\u4f20\u8f93)\n", msg.getBatchName(), requiredFiles.size());
        }
        System.out.flush();
        this.channel.writeAndFlush(ackMessage);
    }

    public void handleCompressedBatchData(CompressedBatchDataMessage msg) throws Exception {
        logger.info("\ud83d\udddc\ufe0f \u6536\u5230\u538b\u7f29\u6279\u6b21\u6570\u636e\u6d88\u606f: \u6279\u6b21ID={}, \u6587\u4ef6\u540d={}, {}", msg.getBatchId(), msg.getCompressedFileName(), msg.getCompressionSummary());
        logger.info("\u7b80\u5316\u6d41\u7a0b\uff1a\u76f4\u63a5\u63a5\u6536\u6279\u6b21 {}", (Object)msg.getBatchId());
        String tempDir = System.getProperty("java.io.tmpdir");
        String extension = msg.getCompressedFileName().endsWith(".pack") ? ".pack" : (msg.getCompressedFileName().endsWith(".zip") ? ".zip" : ".lz4");
        String tempCompressedFile = new File(tempDir, "croc_received_" + msg.getBatchId() + "_" + System.currentTimeMillis() + extension).getAbsolutePath();
        int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(msg.getCompressedSize());
        FileMetadata compressedFileMetadata = new FileMetadata(msg.getCompressedFileName(), msg.getCompressedSize(), FileTransferUtils.calculateChunks(msg.getCompressedSize(), optimalChunkSize), optimalChunkSize, msg.getCompressionMd5());
        compressedFileMetadata.file = new File(tempCompressedFile);
        File parentDir = compressedFileMetadata.file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        compressedFileMetadata.fos = new FileOutputStream(compressedFileMetadata.file);
        compressedFileMetadata.fileChannel = compressedFileMetadata.fos.getChannel();
        compressedFileMetadata.isBatchFile = false;
        compressedFileMetadata.isCompressedPackage = true;
        compressedFileMetadata.startTime = System.currentTimeMillis();
        this.fileMetadataMap.put(msg.getCompressedFileName(), compressedFileMetadata);
        this.currentProcessingFile = msg.getCompressedFileName();
        this.channel.writeAndFlush(new TransferAckMessage(msg.getSessionId()));
    }

    public void handleCompressedFileComplete(String compressedFileName, String tempFilePath, int batchId) {
        this.compressedBatchExecutor.submit(() -> {
            block25: {
                try {
                    logger.info("\ud83d\udddc\ufe0f \u5f00\u59cb\u89e3\u538b\u7f29\u6279\u6b21: \u6279\u6b21ID={}", (Object)batchId);
                    File folder = new File(this.saveDir, this.folderName);
                    BatchCompressor.DecompressionResult result = BatchCompressor.decompressBatch(tempFilePath, folder.getAbsolutePath());
                    logger.info("\ud83d\udddc\ufe0f \u89e3\u538b\u7f29\u5b8c\u6210: \u6279\u6b21ID={}, \u6587\u4ef6\u6570={}, \u603b\u5927\u5c0f={}, \u8017\u65f6={}ms", batchId, result.getProcessedFiles(), FileTransferUtils.formatBytes(result.getTotalSize()), result.getDecompressionTimeMs());
                    String completionMessage = String.format("\u2705 \u6279\u6b21%d \u89e3\u538b\u5b8c\u6210: %d \u4e2a\u6587\u4ef6, %s, \u8017\u65f6 %d ms\n\u2705 \u7b2c%d\u4e2a\u538b\u7f29\u6279\u6b21\u5b8c\u6210", batchId, result.getProcessedFiles(), FileTransferUtils.formatFileSize(result.getTotalSize()), result.getDecompressionTimeMs(), batchId);
                    this.batchCompletionMessages.put(batchId, completionMessage);
                    logger.info("\ud83d\udd27 \u6279\u6b21{} \u89e3\u538b\u5b8c\u6210: {} \u4e2a\u6587\u4ef6, {}, \u8017\u65f6 {}ms (\u5df2\u5b58\u50a8\u6d88\u606f\uff0c\u7b49\u5f85\u96c6\u4e2d\u663e\u793a)", batchId, result.getProcessedFiles(), FileTransferUtils.formatBytes(result.getTotalSize()), result.getDecompressionTimeMs());
                    new File(tempFilePath).delete();
                    this.activeCompressedBatches.remove(batchId);
                    if (this.activeCompressedBatches.isEmpty() && batchId == this.maxBatchId) {
                        this.allBatchesCompleted = true;
                        logger.info("\ud83d\udd27 \u6240\u6709\u6279\u6b21\u5904\u7406\u5b8c\u6210\uff0c\u7b49\u5f85\u5355\u6587\u4ef6\u5904\u7406\u65f6\u663e\u793a\u9636\u6bb5\u6807\u9898");
                        Object object = this.singleFileList;
                        synchronized (object) {
                            int originalSize = this.calculateActualSingleFileCount();
                            this.singleFileList.removeIf(fileName -> this.batchProcessedFiles.stream().anyMatch(path -> new File((String)path).getName().equals(fileName)));
                            this.finalSingleFileCount = this.singleFileList.size();
                            logger.info("\ud83d\udd27 \u66f4\u65b0\u5355\u6587\u4ef6\u5217\u8868: {} -> {} \u4e2a\u6587\u4ef6 (\u79fb\u9664\u4e86{}\u4e2a\u6279\u6b21\u5904\u7406\u7684\u6587\u4ef6)", originalSize, this.finalSingleFileCount, originalSize - this.finalSingleFileCount);
                        }
                        object = this.batchCompletionLock;
                        synchronized (object) {
                            this.batchOutputComplete = true;
                            this.batchCompletionLock.notifyAll();
                        }
                    }
                    CompressedBatchCompleteMessage completeMessage = CompressedBatchCompleteMessage.createSuccess(this.sessionId, batchId, result.getProcessedFiles(), result.getTotalSize(), result.getDecompressionTimeMs());
                    this.channel.writeAndFlush(completeMessage);
                    logger.info("\u2705 \u538b\u7f29\u6279\u6b21\u5904\u7406\u5b8c\u6210: \u6279\u6b21ID={}", (Object)batchId);
                    if (compressedFileName.equals(this.currentProcessingFile)) {
                        this.currentProcessingFile = null;
                        logger.debug("\u5df2\u91cd\u7f6ecurrentProcessingFile\u72b6\u6001");
                    }
                    this.fileMetadataMap.remove(compressedFileName);
                    logger.debug("\u5df2\u4ecefileMetadataMap\u4e2d\u79fb\u9664\u538b\u7f29\u6587\u4ef6: {}", (Object)compressedFileName);
                    CompressedBatchManifestMessage manifest = this.activeCompressedBatches.get(batchId);
                    if (manifest != null) {
                        for (CompressedBatchManifestMessage.BatchFileManifest fileManifest : manifest.getFiles()) {
                            String batchFilePath = fileManifest.getRelativePath();
                            if (!this.fileMetadataMap.containsKey(batchFilePath)) continue;
                            this.fileMetadataMap.remove(batchFilePath);
                            logger.debug("\u5df2\u6e05\u7406\u538b\u7f29\u6279\u6b21\u6587\u4ef6\u5143\u6570\u636e: {}", (Object)batchFilePath);
                        }
                    }
                    if (this.pendingFileMessages.isEmpty()) break block25;
                    logger.info("\u538b\u7f29\u5904\u7406\u5b8c\u6210\uff0c\u5f00\u59cb\u5904\u7406\u6682\u5b58\u7684 {} \u4e2a\u6587\u4ef6\u6d88\u606f", (Object)this.pendingFileMessages.size());
                    ArrayList<FileInfoMessage> toProcess = new ArrayList<FileInfoMessage>(this.pendingFileMessages);
                    this.pendingFileMessages.clear();
                    for (FileInfoMessage pendingMsg : toProcess) {
                        try {
                            this.handleFileInfo(pendingMsg);
                        }
                        catch (Exception e) {
                            logger.error("\u5904\u7406\u6682\u5b58\u6587\u4ef6\u6d88\u606f\u5931\u8d25: {}", (Object)pendingMsg.getFileName(), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.printf("\u274c \u6279\u6b21%d \u5904\u7406\u5931\u8d25: %s\n", batchId, e.getMessage());
                    logger.error("\u538b\u7f29\u6279\u6b21\u5904\u7406\u5931\u8d25\u8be6\u60c5", e);
                    try {
                        CompressedBatchCompleteMessage failureMessage = CompressedBatchCompleteMessage.createFailure(this.sessionId, batchId, "\u89e3\u538b\u7f29\u5931\u8d25: " + e.getMessage());
                        this.channel.writeAndFlush(failureMessage);
                    }
                    catch (Exception ex) {
                        logger.error("\u53d1\u9001\u5931\u8d25\u6d88\u606f\u5f02\u5e38", ex);
                    }
                    try {
                        new File(tempFilePath).delete();
                    }
                    catch (Exception ex) {
                        logger.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", (Object)tempFilePath, (Object)ex);
                    }
                    this.activeCompressedBatches.remove(batchId);
                    if (compressedFileName.equals(this.currentProcessingFile)) {
                        this.currentProcessingFile = null;
                        logger.debug("\u9519\u8bef\u5904\u7406\uff1a\u5df2\u91cd\u7f6ecurrentProcessingFile\u72b6\u6001");
                    }
                    this.fileMetadataMap.remove(compressedFileName);
                    logger.debug("\u9519\u8bef\u5904\u7406\uff1a\u5df2\u4ecefileMetadataMap\u4e2d\u79fb\u9664\u538b\u7f29\u6587\u4ef6: {}", (Object)compressedFileName);
                    CompressedBatchManifestMessage manifest = this.activeCompressedBatches.get(batchId);
                    if (manifest != null) {
                        for (CompressedBatchManifestMessage.BatchFileManifest fileManifest : manifest.getFiles()) {
                            String batchFilePath = fileManifest.getRelativePath();
                            if (!this.fileMetadataMap.containsKey(batchFilePath)) continue;
                            this.fileMetadataMap.remove(batchFilePath);
                            logger.debug("\u9519\u8bef\u5904\u7406\uff1a\u5df2\u6e05\u7406\u538b\u7f29\u6279\u6b21\u6587\u4ef6\u5143\u6570\u636e: {}", (Object)batchFilePath);
                        }
                    }
                    if (this.pendingFileMessages.isEmpty()) break block25;
                    logger.info("\u538b\u7f29\u5904\u7406\u5931\u8d25\uff0c\u4ecd\u9700\u5904\u7406\u6682\u5b58\u7684 {} \u4e2a\u6587\u4ef6\u6d88\u606f", (Object)this.pendingFileMessages.size());
                    ArrayList<FileInfoMessage> toProcess = new ArrayList<FileInfoMessage>(this.pendingFileMessages);
                    this.pendingFileMessages.clear();
                    for (FileInfoMessage pendingMsg : toProcess) {
                        try {
                            this.handleFileInfo(pendingMsg);
                        }
                        catch (Exception ex) {
                            logger.error("\u5904\u7406\u6682\u5b58\u6587\u4ef6\u6d88\u606f\u5931\u8d25: {}", (Object)pendingMsg.getFileName(), (Object)ex);
                        }
                    }
                }
            }
        });
    }

    private void sendCompressedBatchReject(String sessionId, int batchId, String reason) throws Exception {
        CompressedBatchManifestAckMessage rejectMessage = CompressedBatchManifestAckMessage.createReject(sessionId, batchId, reason);
        this.channel.writeAndFlush(rejectMessage);
        logger.info("\u53d1\u9001\u538b\u7f29\u6279\u6b21\u62d2\u7edd: \u6279\u6b21ID={}, \u539f\u56e0={}", (Object)batchId, (Object)reason);
    }

    private void sendCompressedBatchError(String sessionId, int batchId, String error) throws Exception {
        CompressedBatchCompleteMessage errorMessage = CompressedBatchCompleteMessage.createFailure(sessionId, batchId, error);
        this.channel.writeAndFlush(errorMessage);
        logger.error("\u53d1\u9001\u538b\u7f29\u6279\u6b21\u9519\u8bef: \u6279\u6b21ID={}, \u9519\u8bef={}", (Object)batchId, (Object)error);
    }

    private String formatDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return milliseconds + "ms";
        }
        if (milliseconds < 60000L) {
            return String.format("%.1fs", (double)milliseconds / 1000.0);
        }
        if (milliseconds < 3600000L) {
            long minutes = milliseconds / 60000L;
            long seconds = milliseconds % 60000L / 1000L;
            return String.format("%dm%ds", minutes, seconds);
        }
        long hours = milliseconds / 3600000L;
        long minutes = milliseconds % 3600000L / 60000L;
        return String.format("%dh%dm", hours, minutes);
    }

    private void updateDynamicTimeout(long dataSize, DynamicTimeoutCalculator.TransferType transferType) {
        int newTimeout = DynamicTimeoutCalculator.calculateTimeout(dataSize, transferType, this.currentNetworkCondition, this.averageNetworkSpeed);
        if (newTimeout != this.currentDynamicTimeout) {
            logger.info("\u52a8\u6001\u66f4\u65b0\u8d85\u65f6\u65f6\u95f4: {}s -> {}s (\u6570\u636e\u5927\u5c0f: {}, \u7c7b\u578b: {}, \u7f51\u7edc: {})", new Object[]{this.currentDynamicTimeout, newTimeout, FileTransferUtils.formatFileSize(dataSize), transferType, this.currentNetworkCondition});
            this.currentDynamicTimeout = newTimeout;
        }
    }

    private void recordTransferSpeed(String fileName, double speedMBps, long fileSize) {
        if (fileSize > 0x100000L && speedMBps > 0.01) {
            this.fileTransferSpeeds.put(fileName, speedMBps);
            if (this.fileTransferSpeeds.size() > 20) {
                String oldestFile = this.fileTransferSpeeds.keySet().iterator().next();
                this.fileTransferSpeeds.remove(oldestFile);
            }
            this.averageNetworkSpeed = this.fileTransferSpeeds.values().stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            this.currentNetworkCondition = DynamicTimeoutCalculator.assessNetworkCondition(this.averageNetworkSpeed);
            logger.debug("\u8bb0\u5f55\u4f20\u8f93\u901f\u5ea6: {} - {:.2f} MB/s, \u5e73\u5747\u901f\u5ea6: {:.2f} MB/s, \u7f51\u7edc\u72b6\u51b5: {}", new Object[]{fileName, speedMBps, this.averageNetworkSpeed, this.currentNetworkCondition});
        }
    }

    private int calculateCompressedBatchTimeout(long compressedSize, int fileCount) {
        DynamicTimeoutCalculator.BatchTransferTimeout batchTimeout = new DynamicTimeoutCalculator.BatchTransferTimeout(compressedSize, fileCount, DynamicTimeoutCalculator.TransferType.COMPRESSED_BATCH);
        if (this.averageNetworkSpeed > 0.0) {
            batchTimeout.withHistoricalSpeed(this.averageNetworkSpeed);
        } else {
            batchTimeout.withNetworkCondition(this.currentNetworkCondition);
        }
        int timeout = batchTimeout.calculate();
        logger.info("\u8ba1\u7b97\u538b\u7f29\u6279\u6b21\u8d85\u65f6: {} - {}", (Object)timeout, (Object)batchTimeout.getDescription());
        return timeout;
    }

    private void performNetworkSpeedDetection() {
        long heartbeatStart = System.currentTimeMillis();
        HeartbeatMessage heartbeat = new HeartbeatMessage();
        heartbeat.setSessionId(this.sessionId);
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush(heartbeat).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    long rtt = System.currentTimeMillis() - heartbeatStart;
                    this.assessNetworkLatency(rtt);
                } else {
                    logger.warn("\u5fc3\u8df3\u53d1\u9001\u5931\u8d25\uff0c\u65e0\u6cd5\u68c0\u6d4b\u7f51\u7edc\u5ef6\u8fdf");
                }
            }));
        }
        if (this.fileTransferSpeeds.isEmpty()) {
            if (this.isUsingLocalRelay) {
                this.currentNetworkCondition = DynamicTimeoutCalculator.NetworkCondition.FAST;
                logger.info("\u68c0\u6d4b\u5230\u672c\u5730\u4e2d\u7ee7\uff0c\u8bbe\u7f6e\u7f51\u7edc\u72b6\u51b5\u4e3aFAST");
            } else if (this.isUsingPublicRelay) {
                this.currentNetworkCondition = DynamicTimeoutCalculator.NetworkCondition.MEDIUM;
                logger.info("\u68c0\u6d4b\u5230\u516c\u5171\u4e2d\u7ee7\uff0c\u8bbe\u7f6e\u7f51\u7edc\u72b6\u51b5\u4e3aMEDIUM");
            } else {
                this.currentNetworkCondition = DynamicTimeoutCalculator.NetworkCondition.SLOW;
                logger.info("\u672a\u77e5\u4e2d\u7ee7\u7c7b\u578b\uff0c\u4fdd\u5b88\u8bbe\u7f6e\u7f51\u7edc\u72b6\u51b5\u4e3aSLOW");
            }
        }
    }

    private void assessNetworkLatency(long rttMs) {
        DynamicTimeoutCalculator.NetworkCondition latencyBasedCondition = rttMs < 50L ? DynamicTimeoutCalculator.NetworkCondition.FAST : (rttMs < 200L ? DynamicTimeoutCalculator.NetworkCondition.MEDIUM : DynamicTimeoutCalculator.NetworkCondition.SLOW);
        if (latencyBasedCondition.ordinal() > this.currentNetworkCondition.ordinal()) {
            logger.info("\u57fa\u4e8e\u7f51\u7edc\u5ef6\u8fdf {}ms \u8c03\u6574\u7f51\u7edc\u72b6\u51b5: {} -> {}", new Object[]{rttMs, this.currentNetworkCondition, latencyBasedCondition});
            this.currentNetworkCondition = latencyBasedCondition;
        }
        logger.debug("\u7f51\u7edc\u5ef6\u8fdf\u68c0\u6d4b: {}ms, \u7f51\u7edc\u72b6\u51b5: {}", (Object)rttMs, (Object)this.currentNetworkCondition);
    }

    private void closeFileAndSync(FileMetadata file) {
        long actualSize;
        if (file.fileChannel != null) {
            try {
                file.fileChannel.force(false);
                logger.debug("\u6587\u4ef6\u901a\u9053\u5f3a\u5236\u5237\u65b0\u5b8c\u6210: {}", (Object)file.relativePath);
                file.fileChannel.close();
                logger.debug("\u6587\u4ef6\u901a\u9053\u5173\u95ed\u5b8c\u6210: {}", (Object)file.relativePath);
                file.fileChannel = null;
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u901a\u9053\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)file.relativePath, (Object)e);
            }
        }
        if (file.fos != null) {
            try {
                file.fos.flush();
                logger.debug("\u6587\u4ef6\u8f93\u51fa\u6d41\u5237\u65b0\u5b8c\u6210: {}", (Object)file.relativePath);
                file.fos.close();
                logger.debug("\u6587\u4ef6\u8f93\u51fa\u6d41\u5173\u95ed\u5b8c\u6210: {}", (Object)file.relativePath);
                file.fos = null;
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)file.relativePath, (Object)e);
            }
        }
        if (file.file != null && file.file.exists() && (actualSize = file.file.length()) != file.fileSize) {
            logger.warn("\u6587\u4ef6\u5927\u5c0f\u4e0d\u5339\u914d: {} - \u9884\u671f: {}, \u5b9e\u9645: {}", file.relativePath, file.fileSize, actualSize);
        }
    }

    private String calculateFileHashSafely(File file) {
        return UnifiedHashCalculator.calculateFileHash(file);
    }

    private static class FileMetadata {
        String relativePath;
        long fileSize;
        int totalChunks;
        int chunkSize;
        FileOutputStream fos;
        FileChannel fileChannel;
        ConcurrentHashMap<Integer, Boolean> receivedChunks = new ConcurrentHashMap();
        AtomicInteger chunksReceived = new AtomicInteger(0);
        File file;
        CountDownLatch transferLatch;
        String expectedMd5;
        boolean hasError = false;
        long startTime = 0L;
        boolean isBatchFile = false;
        boolean isCompressedPackage = false;

        public FileMetadata(String relativePath, long fileSize, int totalChunks, int chunkSize, String expectedMd5) {
            this.relativePath = relativePath;
            this.fileSize = fileSize;
            this.totalChunks = totalChunks;
            this.chunkSize = chunkSize;
            this.expectedMd5 = expectedMd5;
            this.transferLatch = new CountDownLatch(totalChunks);
        }

        public boolean isCompleted() {
            return this.chunksReceived.get() >= this.totalChunks || this.hasError;
        }
    }
}

