/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.relay;

import com.file.netty.codec.CodecFactory;
import com.file.netty.relay.RelayServerHandler;
import com.file.netty.relay.TransferSession;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayServer {
    private static final Logger logger = LoggerFactory.getLogger(RelayServer.class);
    private final int port;
    private final Map<String, TransferSession> sessions = new ConcurrentHashMap<String, TransferSession>();

    public RelayServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, 0, 60));
                    CodecFactory.addRelayCodec(p);
                    p.addLast(new RelayServerHandler(RelayServer.this.sessions));
                }
            }).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, true)).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.SO_SNDBUF, 0x400000).childOption(ChannelOption.SO_RCVBUF, 0x400000).childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x200000).childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 262144).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
            ChannelFuture f = b.bind(this.port).sync();
            logger.info("\u4e2d\u7ee7\u670d\u52a1\u5668\u542f\u52a8\uff0c\u76d1\u542c\u7aef\u53e3: {}", (Object)this.port);
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8001;
        new RelayServer(port).start();
    }
}

