/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.relay;

import io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayServerConfig {
    private static final Logger logger = LoggerFactory.getLogger(RelayServerConfig.class);
    private static final long DEFAULT_MAX_DIRECT_MEMORY = 0x10000000L;
    private static final int DEFAULT_BUFFER_LOW_WATERMARK = 65536;
    private static final int DEFAULT_BUFFER_HIGH_WATERMARK = 262144;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x1400000;
    private static final int DEFAULT_CHUNK_SIZE = 0x100000;
    private static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static long maxDirectMemory = 0x10000000L;
    private static int bufferLowWatermark = 65536;
    private static int bufferHighWatermark = 262144;
    private static int maxMessageSize = 0x1400000;
    public static int chunkSize = 0x100000;
    private static int ioThreads = DEFAULT_IO_THREADS;

    public static boolean hasEnoughDirectMemory(int needSize) {
        boolean hasEnough;
        long usedDirectMemory = PlatformDependent.usedDirectMemory();
        long maxDirectMemory = PlatformDependent.maxDirectMemory();
        long availableDirectMemory = maxDirectMemory - usedDirectMemory;
        boolean bl = hasEnough = availableDirectMemory >= (long)needSize;
        if (!hasEnough) {
            logger.warn("\u76f4\u63a5\u5185\u5b58\u4e0d\u8db3: \u9700\u8981{}KB, \u53ef\u7528{}KB, \u5df2\u7528{}KB, \u6700\u5927{}KB", needSize / 1024, availableDirectMemory / 1024L, usedDirectMemory / 1024L, maxDirectMemory / 1024L);
        }
        return hasEnough;
    }

    public static long getMaxDirectMemory() {
        return maxDirectMemory;
    }

    public static int getBufferLowWatermark() {
        return bufferLowWatermark;
    }

    public static int getBufferHighWatermark() {
        return bufferHighWatermark;
    }

    public static int getMaxMessageSize() {
        return maxMessageSize;
    }

    public static int getChunkSize() {
        return chunkSize;
    }

    public static int getIoThreads() {
        return ioThreads;
    }

    public static void setChunkSize(int chunkSize) {
        RelayServerConfig.chunkSize = chunkSize;
    }

    static {
        try {
            if (System.getProperty("io.netty.maxDirectMemory") == null) {
                System.setProperty("io.netty.maxDirectMemory", String.valueOf(0x10000000L));
                logger.info("\u8bbe\u7f6eNetty\u6700\u5927\u76f4\u63a5\u5185\u5b58\u4e3a: {}MB", (Object)256L);
            } else {
                String strValue = System.getProperty("io.netty.maxDirectMemory");
                try {
                    maxDirectMemory = Long.parseLong(strValue);
                    logger.info("\u4f7f\u7528\u7cfb\u7edf\u8bbe\u7f6e\u7684Netty\u76f4\u63a5\u5185\u5b58\u4e0a\u9650: {}MB", (Object)(maxDirectMemory / 0x100000L));
                }
                catch (NumberFormatException e) {
                    logger.warn("\u65e0\u6cd5\u89e3\u6790io.netty.maxDirectMemory: {}, \u4f7f\u7528\u9ed8\u8ba4\u503c: {}MB", (Object)strValue, (Object)256L);
                }
            }
            System.setProperty("io.netty.allocator.type", "pooled");
            System.setProperty("io.netty.allocator.numHeapArenas", String.valueOf(ioThreads));
            System.setProperty("io.netty.allocator.numDirectArenas", String.valueOf(ioThreads));
            System.setProperty("io.netty.allocator.tinyCacheSize", "0");
            System.setProperty("io.netty.allocator.smallCacheSize", "0");
            System.setProperty("io.netty.allocator.normalCacheSize", "0");
            System.setProperty("io.netty.allocator.maxCachedBufferCapacity", "1024");
            System.setProperty("io.netty.allocator.cacheTrimIntervalMillis", "5000");
            logger.info("\u4e2d\u7ee7\u670d\u52a1\u5668\u914d\u7f6e: \u6700\u5927\u76f4\u63a5\u5185\u5b58={}MB, \u6700\u5927\u6d88\u606f\u5927\u5c0f={}MB, \u5757\u5927\u5c0f={}KB", maxDirectMemory / 0x100000L, maxMessageSize / 0x100000, chunkSize / 1024);
            logger.info("\u7cfb\u7edf\u5185\u5b58\u4fe1\u606f: \u6700\u5927\u5806\u5185\u5b58={}MB, \u53ef\u7528\u5904\u7406\u5668={}", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L), (Object)Runtime.getRuntime().availableProcessors());
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5185\u5b58\u914d\u7f6e\u65f6\u51fa\u9519", e);
        }
    }
}

