/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.relay;

import com.file.netty.protocol.EncryptedMessage;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import com.file.netty.protocol.RegisterResultMessage;
import com.file.netty.relay.RelayServerConfig;
import com.file.netty.relay.TransferSession;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.HandlerExceptionUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RelayServerHandler
extends SimpleChannelInboundHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(RelayServerHandler.class);
    private final Map<String, TransferSession> sessions;

    public RelayServerHandler(Map<String, TransferSession> sessions) {
        this.sessions = sessions;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        switch (msg.getType()) {
            case REGISTER: {
                this.handleRegister(ctx, msg);
                break;
            }
            case JOIN: {
                this.handleJoin(ctx, (JoinMessage)msg);
                break;
            }
            case FILE_INFO: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FILE_INFO\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case FILE_CHUNK: {
                this.handleFileChunkMessage(ctx, (FileChunkMessage)msg);
                break;
            }
            case FOLDER_INFO: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FOLDER_INFO\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case FOLDER_COMPLETE: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FOLDER_COMPLETE\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case TRANSFER_COMPLETE: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230TRANSFER_COMPLETE\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case TRANSFER_ACK: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230TRANSFER_ACK\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case FOLDER_INFO_ACK: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FOLDER_INFO_ACK\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.handleFolderInfoAck(ctx, msg);
                break;
            }
            case ENCRYPTED_DATA: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230ENCRYPTED_DATA\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.handleEncryptedMessage(ctx, (EncryptedMessage)msg);
                break;
            }
            case FILE_SKIP: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FILE_SKIP\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case BATCH_FILE_INFO: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230BATCH_FILE_INFO\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case BATCH_FILE_ACK: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230BATCH_FILE_ACK\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case FOLDER_COMPLETE_ACK: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230FOLDER_COMPLETE_ACK\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case COMPRESSED_BATCH_MANIFEST: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230COMPRESSED_BATCH_MANIFEST\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case COMPRESSED_BATCH_MANIFEST_ACK: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230COMPRESSED_BATCH_MANIFEST_ACK\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case COMPRESSED_BATCH_DATA: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230COMPRESSED_BATCH_DATA\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case COMPRESSED_BATCH_COMPLETE: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230COMPRESSED_BATCH_COMPLETE\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case TRANSFER_STATS: {
                logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u6536\u5230TRANSFER_STATS\u6d88\u606f\uff0c\u4f1a\u8bddID: {}", (Object)msg.getSessionId());
                this.forwardMessage(msg);
                break;
            }
            case HEARTBEAT: {
                break;
            }
            default: {
                logger.warn("\u672a\u5904\u7406\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)msg.getType());
            }
        }
    }

    private void handleEncryptedMessage(ChannelHandlerContext ctx, EncryptedMessage msg) {
        String sessionId = msg.getSessionId();
        TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            logger.warn("\u5c1d\u8bd5\u8f6c\u53d1\u52a0\u5bc6\u6d88\u606f\u5230\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        MessageType originalType = msg.getOriginalType();
        if (originalType == MessageType.FILE_CHUNK) {
            this.handleEncryptedFileChunk(ctx, msg);
            return;
        }
        Channel targetChannel = originalType == MessageType.TRANSFER_ACK ? session.getSenderChannel() : session.getReceiverChannel();
        if (targetChannel != null && targetChannel.isActive()) {
            targetChannel.writeAndFlush(msg);
            logger.debug("\u8f6c\u53d1\u52a0\u5bc6\u6d88\u606f: session={}, \u539f\u59cb\u7c7b\u578b={}", (Object)sessionId, (Object)originalType);
        } else {
            logger.warn("\u76ee\u6807\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u8f6c\u53d1\u52a0\u5bc6\u6d88\u606f: session={}, \u539f\u59cb\u7c7b\u578b={}", (Object)sessionId, (Object)originalType);
        }
    }

    private void handleEncryptedFileChunk(ChannelHandlerContext ctx, final EncryptedMessage msg) {
        int encryptedSize;
        final String sessionId = msg.getSessionId();
        final TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            logger.warn("\u5c1d\u8bd5\u8f6c\u53d1\u52a0\u5bc6\u6587\u4ef6\u5757\u5230\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        Channel targetChannel = session.getReceiverChannel();
        if (targetChannel == null || !targetChannel.isActive()) {
            logger.warn("\u76ee\u6807\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u8f6c\u53d1\u52a0\u5bc6\u6587\u4ef6\u5757: session={}", (Object)sessionId);
            System.out.println("\u26a0\ufe0f \u4e2d\u7ee7\u8f6c\u53d1\u5931\u8d25: \u76ee\u6807\u901a\u9053\u65e0\u6548 (session=" + sessionId + ")");
            return;
        }
        int n = encryptedSize = msg.getEncryptedData() != null ? msg.getEncryptedData().length : 0;
        if (encryptedSize > 0x100000) {
            ChannelConfig config = targetChannel.config();
            config.setWriteBufferHighWaterMark(RelayServerConfig.getBufferHighWatermark());
            config.setWriteBufferLowWaterMark(RelayServerConfig.getBufferLowWatermark());
        }
        targetChannel.writeAndFlush(msg).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    RelayServerHandler.this.handleEncryptedTransferFailure(future.cause(), session, msg);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("\u6210\u529f\u8f6c\u53d1\u52a0\u5bc6\u6587\u4ef6\u5757: session={}, \u5927\u5c0f={}", (Object)sessionId, (Object)encryptedSize);
                }
            }
        });
    }

    private void handleEncryptedTransferFailure(Throwable cause, TransferSession session, EncryptedMessage msg) {
        String sessionId = msg.getSessionId();
        if (cause instanceof OutOfMemoryError || cause.getMessage() != null && cause.getMessage().contains("memory")) {
            logger.error("\u8f6c\u53d1\u52a0\u5bc6\u6587\u4ef6\u5757\u5185\u5b58\u4e0d\u8db3: session={}, \u9519\u8bef={}", (Object)sessionId, (Object)cause.getMessage());
            Channel senderChannel = session.getSenderChannel();
            if (senderChannel != null && senderChannel.isActive()) {
                ErrorMessage errorMsg = new ErrorMessage(sessionId, "\u670d\u52a1\u5668\u5185\u5b58\u4e0d\u8db3\uff0c\u8bf7\u964d\u4f4e\u4f20\u8f93\u901f\u5ea6\u6216\u51cf\u5c0f\u5757\u5927\u5c0f");
                senderChannel.writeAndFlush(errorMsg);
            }
        } else {
            logger.error("\u8f6c\u53d1\u52a0\u5bc6\u6587\u4ef6\u5757\u5931\u8d25: session={}, \u9519\u8bef={}", (Object)sessionId, (Object)cause.getMessage());
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        boolean canWrite = ctx.channel().isWritable();
        Channel targetChannel = null;
        for (Map.Entry<String, TransferSession> entry : this.sessions.entrySet()) {
            TransferSession session = entry.getValue();
            if (ctx.channel() == session.getSenderChannel()) {
                targetChannel = session.getReceiverChannel();
                break;
            }
            if (ctx.channel() != session.getReceiverChannel()) continue;
            targetChannel = session.getSenderChannel();
            break;
        }
        if (targetChannel != null) {
            logger.debug("\u901a\u9053 {} \u53ef\u5199\u6027\u53d8\u66f4\u4e3a: {}, \u8c03\u6574\u76ee\u6807\u901a\u9053 {} \u7684\u81ea\u52a8\u8bfb\u53d6\u8bbe\u7f6e", ctx.channel(), canWrite, targetChannel);
            targetChannel.config().setAutoRead(canWrite);
        }
        super.channelWritabilityChanged(ctx);
    }

    private void handleFileChunkMessage(ChannelHandlerContext ctx, final FileChunkMessage msg) {
        Channel senderChannel;
        final String sessionId = msg.getSessionId();
        final TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            logger.warn("\u5c1d\u8bd5\u8f6c\u53d1\u6587\u4ef6\u5757\u5230\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        Channel targetChannel = session.getReceiverChannel();
        if (targetChannel == null || !targetChannel.isActive()) {
            logger.warn("\u76ee\u6807\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u8f6c\u53d1\u6587\u4ef6\u5757: session={}, \u5757\u7d22\u5f15={}", (Object)sessionId, (Object)msg.getChunkIndex());
            return;
        }
        byte[] data = msg.getData();
        if (data == null) {
            logger.error("\u6536\u5230\u7a7a\u6570\u636e\u5757\uff0c\u65e0\u6cd5\u8f6c\u53d1: sessionId={}, \u5757\u7d22\u5f15={}", (Object)sessionId, (Object)msg.getChunkIndex());
            return;
        }
        int chunkSize = data.length;
        if (chunkSize > 0x100000) {
            ChannelConfig config = targetChannel.config();
            config.setWriteBufferHighWaterMark(RelayServerConfig.getBufferHighWatermark());
            config.setWriteBufferLowWaterMark(RelayServerConfig.getBufferLowWatermark());
        }
        if (!targetChannel.isWritable() && (senderChannel = session.getSenderChannel()) != null && senderChannel.isActive()) {
            ErrorMessage errorMsg = new ErrorMessage(sessionId, "\u63a5\u6536\u7aef\u5904\u7406\u901f\u5ea6\u8f83\u6162\uff0c\u8bf7\u964d\u4f4e\u53d1\u9001\u901f\u7387");
            senderChannel.writeAndFlush(errorMsg);
            logger.debug("\u901a\u77e5\u53d1\u9001\u7aef\u964d\u4f4e\u901f\u7387: session={}, \u5757\u7d22\u5f15={}", (Object)sessionId, (Object)msg.getChunkIndex());
            targetChannel.pipeline().fireChannelWritabilityChanged();
        }
        targetChannel.writeAndFlush(msg).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    RelayServerHandler.this.handleTransferFailure(future.cause(), session, msg);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("\u6210\u529f\u8f6c\u53d1\u6587\u4ef6\u5757: session={}, \u5757\u7d22\u5f15={}", (Object)sessionId, (Object)msg.getChunkIndex());
                }
            }
        });
    }

    private void handleTransferFailure(Throwable cause, TransferSession session, FileChunkMessage msg) {
        String sessionId = msg.getSessionId();
        if (cause instanceof OutOfMemoryError || cause.getMessage() != null && cause.getMessage().contains("memory")) {
            logger.error("\u8f6c\u53d1\u6587\u4ef6\u5757\u5185\u5b58\u4e0d\u8db3: session={}, \u5757\u7d22\u5f15={}, \u9519\u8bef={}", sessionId, msg.getChunkIndex(), cause.getMessage());
            Channel senderChannel = session.getSenderChannel();
            if (senderChannel != null && senderChannel.isActive()) {
                ErrorMessage errorMsg = new ErrorMessage(sessionId, "\u670d\u52a1\u5668\u5185\u5b58\u4e0d\u8db3\uff0c\u8bf7\u964d\u4f4e\u4f20\u8f93\u901f\u5ea6\u6216\u51cf\u5c0f\u5757\u5927\u5c0f");
                senderChannel.writeAndFlush(errorMsg);
            }
        } else {
            logger.error("\u8f6c\u53d1\u6587\u4ef6\u5757\u5931\u8d25: session={}, \u5757\u7d22\u5f15={}, \u9519\u8bef={}", sessionId, msg.getChunkIndex(), cause.getMessage());
        }
    }

    private void handleFolderInfoAck(ChannelHandlerContext ctx, Message msg) {
        String sessionId = msg.getSessionId();
        TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            logger.warn("\u6536\u5230\u9488\u5bf9\u4e0d\u5b58\u5728\u4f1a\u8bdd\u7684\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4: {}", (Object)sessionId);
            return;
        }
        Channel senderChannel = session.getSenderChannel();
        if (senderChannel != null && senderChannel.isActive()) {
            logger.info("\u8f6c\u53d1\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4\u5230\u53d1\u9001\u7aef\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
            senderChannel.writeAndFlush(msg);
        } else {
            logger.warn("\u65e0\u6cd5\u8f6c\u53d1\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4\uff0c\u53d1\u9001\u7aef\u901a\u9053\u65e0\u6548: {}", (Object)sessionId);
            logger.info("\u4f1a\u8bdd\u8be6\u60c5 - ID: {}, \u53d1\u9001\u7aef: {}, \u63a5\u6536\u7aef: {}", sessionId, session.getSenderChannel() != null ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728", session.getReceiverChannel() != null ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728");
        }
    }

    private void handleRegister(ChannelHandlerContext ctx, Message msg) {
        String sessionId;
        if (msg.getSessionId() != null && !msg.getSessionId().isEmpty()) {
            sessionId = msg.getSessionId();
            logger.info("\u4f7f\u7528\u5ba2\u6237\u7aef\u63d0\u4f9b\u7684\u4f1a\u8bddID: {}", (Object)sessionId);
        } else {
            sessionId = FileTransferUtils.generateSessionId();
            logger.info("\u751f\u6210\u65b0\u4f1a\u8bddID: {}", (Object)sessionId);
        }
        if (this.sessions.containsKey(sessionId)) {
            TransferSession existingSession = this.sessions.get(sessionId);
            if (existingSession.getSenderChannel() != null && !existingSession.getSenderChannel().remoteAddress().equals(ctx.channel().remoteAddress())) {
                logger.warn("\u4f1a\u8bddID {} \u5df2\u88ab\u5176\u4ed6\u5ba2\u6237\u7aef\u4f7f\u7528\uff0c\u751f\u6210\u65b0ID", (Object)sessionId);
                sessionId = FileTransferUtils.generateSessionId();
            } else {
                logger.info("\u590d\u7528\u73b0\u6709\u4f1a\u8bddID: {}", (Object)sessionId);
            }
        }
        TransferSession session = new TransferSession(sessionId, ctx.channel());
        this.sessions.put(sessionId, session);
        RegisterResultMessage resultMsg = new RegisterResultMessage(sessionId, true);
        ctx.writeAndFlush(resultMsg);
        logger.info("\u65b0\u4f1a\u8bdd\u6ce8\u518c: {}", (Object)sessionId);
    }

    private void handleJoin(ChannelHandlerContext ctx, JoinMessage msg) {
        String sessionId = msg.getSessionId();
        TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            JoinResultMessage resultMsg = new JoinResultMessage(sessionId, false);
            ctx.writeAndFlush(resultMsg);
            logger.warn("\u5c1d\u8bd5\u52a0\u5165\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        if (session.hasReceiver()) {
            JoinResultMessage resultMsg = new JoinResultMessage(sessionId, false);
            ctx.writeAndFlush(resultMsg);
            logger.warn("\u5c1d\u8bd5\u52a0\u5165\u5df2\u6709\u63a5\u6536\u7aef\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        session.setReceiverChannel(ctx.channel());
        JoinResultMessage resultRecvMsg = new JoinResultMessage(sessionId, true);
        ctx.writeAndFlush(resultRecvMsg);
        session.getSenderChannel().writeAndFlush(resultRecvMsg);
        logger.info("\u63a5\u6536\u7aef\u52a0\u5165\u4f1a\u8bdd: {}", (Object)sessionId);
    }

    private void forwardMessage(Message msg) {
        String sessionId = msg.getSessionId();
        TransferSession session = this.sessions.get(sessionId);
        if (session == null) {
            logger.info("\u5c1d\u8bd5\u8f6c\u53d1\u6d88\u606f\u5230\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
            return;
        }
        Channel targetChannel = null;
        if (msg.getType() == MessageType.TRANSFER_ACK || msg.getType() == MessageType.BATCH_FILE_ACK || msg.getType() == MessageType.FOLDER_COMPLETE_ACK || msg.getType() == MessageType.COMPRESSED_BATCH_MANIFEST_ACK || msg.getType() == MessageType.COMPRESSED_BATCH_COMPLETE || msg.getType() == MessageType.FILE_SKIP) {
            targetChannel = session.getSenderChannel();
        } else if (msg.getType() == MessageType.FILE_INFO || msg.getType() == MessageType.FOLDER_INFO || msg.getType() == MessageType.FOLDER_COMPLETE || msg.getType() == MessageType.TRANSFER_COMPLETE || msg.getType() == MessageType.COMPRESSED_BATCH_MANIFEST || msg.getType() == MessageType.COMPRESSED_BATCH_DATA || msg.getType() == MessageType.TRANSFER_STATS) {
            targetChannel = session.getReceiverChannel();
        }
        if (targetChannel != null && targetChannel.isActive()) {
            targetChannel.writeAndFlush(msg);
            logger.info("\u8f6c\u53d1\u6d88\u606f: session={}, type={}", (Object)sessionId, (Object)msg.getType());
        } else {
            logger.info("\u76ee\u6807\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u8f6c\u53d1\u6d88\u606f: session={}, type={}", (Object)sessionId, (Object)msg.getType());
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        for (Map.Entry<String, TransferSession> entry : this.sessions.entrySet()) {
            ErrorMessage errorMsg;
            TransferSession session = entry.getValue();
            String sessionId = entry.getKey();
            if (ctx.channel() == session.getSenderChannel()) {
                logger.info("\u53d1\u9001\u7aef\u65ad\u5f00\u8fde\u63a5\uff0c\u4f1a\u8bddID: {}", (Object)session.getSessionId());
                if (session.hasReceiver() && session.getReceiverChannel().isActive()) {
                    errorMsg = new ErrorMessage(session.getSessionId(), "\u53d1\u9001\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5");
                    session.getReceiverChannel().writeAndFlush(errorMsg).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                        if (future.isSuccess()) {
                            logger.info("\u6210\u529f\u901a\u77e5\u63a5\u6536\u7aef\u53d1\u9001\u7aef\u65ad\u5f00\uff0c\u4f1a\u8bddID: {}", (Object)session.getSessionId());
                        } else {
                            logger.warn("\u901a\u77e5\u63a5\u6536\u7aef\u53d1\u9001\u7aef\u65ad\u5f00\u5931\u8d25\uff0c\u4f1a\u8bddID: {}, \u539f\u56e0: {}", (Object)session.getSessionId(), (Object)future.cause().getMessage());
                        }
                        this.cleanupSession(sessionId, "\u53d1\u9001\u7aef\u65ad\u5f00");
                    }));
                    continue;
                }
                this.cleanupSession(sessionId, "\u53d1\u9001\u7aef\u65ad\u5f00\uff08\u65e0\u63a5\u6536\u7aef\uff09");
                continue;
            }
            if (!session.hasReceiver() || ctx.channel() != session.getReceiverChannel()) continue;
            logger.info("\u63a5\u6536\u7aef\u65ad\u5f00\u8fde\u63a5\uff0c\u4f1a\u8bddID: {}", (Object)session.getSessionId());
            if (session.getSenderChannel() != null && session.getSenderChannel().isActive()) {
                errorMsg = new ErrorMessage(session.getSessionId(), "\u63a5\u6536\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5");
                session.getSenderChannel().writeAndFlush(errorMsg).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    if (future.isSuccess()) {
                        logger.info("\u6210\u529f\u901a\u77e5\u53d1\u9001\u7aef\u63a5\u6536\u7aef\u65ad\u5f00\uff0c\u4f1a\u8bddID: {}", (Object)session.getSessionId());
                    } else {
                        logger.warn("\u901a\u77e5\u53d1\u9001\u7aef\u63a5\u6536\u7aef\u65ad\u5f00\u5931\u8d25\uff0c\u4f1a\u8bddID: {}, \u539f\u56e0: {}", (Object)session.getSessionId(), (Object)future.cause().getMessage());
                    }
                }));
                session.setReceiverChannel(null);
                logger.info("\u63a5\u6536\u7aef\u901a\u9053\u5df2\u6e05\u7406\uff0c\u4f1a\u8bdd\u4fdd\u7559\u7b49\u5f85\u65b0\u63a5\u6536\u7aef\uff0c\u4f1a\u8bddID: {}", (Object)session.getSessionId());
                continue;
            }
            this.cleanupSession(sessionId, "\u63a5\u6536\u7aef\u65ad\u5f00\uff08\u53d1\u9001\u7aef\u4e5f\u5df2\u65ad\u5f00\uff09");
        }
        super.channelInactive(ctx);
    }

    private void cleanupSession(String sessionId, String reason) {
        TransferSession removedSession = this.sessions.remove(sessionId);
        if (removedSession != null) {
            logger.info("\u4f1a\u8bdd\u5df2\u79fb\u9664: {}, \u539f\u56e0: {}", (Object)sessionId, (Object)reason);
            try {
                if (removedSession.getSenderChannel() != null && removedSession.getSenderChannel().isActive()) {
                    removedSession.getSenderChannel().close();
                }
                if (removedSession.getReceiverChannel() != null && removedSession.getReceiverChannel().isActive()) {
                    removedSession.getReceiverChannel().close();
                }
            }
            catch (Exception e) {
                logger.warn("\u6e05\u7406\u4f1a\u8bdd\u901a\u9053\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        } else {
            logger.debug("\u5c1d\u8bd5\u6e05\u7406\u4e0d\u5b58\u5728\u7684\u4f1a\u8bdd: {}", (Object)sessionId);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (HandlerExceptionUtils.isNormalConnectionClose(cause)) {
            logger.debug("\u5ba2\u6237\u7aef\u6b63\u5e38\u65ad\u5f00\u8fde\u63a5: {}", (Object)cause.getMessage());
        } else {
            System.out.println("\u26a0\ufe0f \u4e2d\u7ee7\u670d\u52a1\u5668\u5f02\u5e38: " + cause.getMessage());
        }
        try {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.close();
            }
        }
        catch (Exception e) {
            logger.debug("\u5173\u95ed\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }
}

