/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.sender;

import com.file.netty.codec.CodecFactory;
import com.file.netty.config.RelayConfig;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.HeartbeatMessage;
import com.file.netty.protocol.RegisterMessage;
import com.file.netty.protocol.TransferCompleteMessage;
import com.file.netty.sender.FileSender_with_local_relay_hanlder;
import com.file.netty.sender.FileSender_with_pub_relay_hanlder;
import com.file.netty.unified.UnifiedSender;
import com.file.netty.utils.ConsoleFormatter;
import com.file.netty.utils.ConsoleUtils;
import com.file.netty.utils.ExitMessageFormatter;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.HandlerExceptionUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSender {
    private static final Logger logger = LoggerFactory.getLogger(FileSender.class);
    private final String host;
    private final int port;
    private final File file;
    private final int threadCount;
    private final int chunkSize;
    private String sessionId;
    private Channel channel;
    private volatile boolean receiverConnected = false;
    private volatile boolean transferComplete = false;
    private ExecutorService executor;
    private CountDownLatch transferLatch;
    private AtomicInteger chunksSent = new AtomicInteger(0);
    private Channel publicRelayChannel;
    private boolean publicRelayConnected = false;
    private String singleSessionId;
    private CountDownLatch receiverLatch = new CountDownLatch(1);
    private Channel activeChannel;
    private volatile String currentSendingFile = null;
    private volatile CountDownLatch currentFileLatch = null;
    private volatile boolean currentFileSkipped = false;
    private final CountDownLatch publicRelayLatch = new CountDownLatch(1);
    private volatile boolean transferSuccessfullyCompleted = false;
    private volatile boolean allDataSent = false;
    private volatile boolean exitMessageShown = false;
    private volatile boolean silentClosing = false;
    private volatile boolean isActiveTransfer = false;
    private UnifiedSender parentSender;
    private long transferStartTime;
    private volatile boolean heartbeatRunning = false;

    public FileSender(String host, int port, File file) {
        this(host, port, file, 4, 262144);
    }

    public FileSender(String host, int port, File file, int threadCount, int chunkSize) {
        this.host = host;
        this.port = port;
        this.file = file;
        this.threadCount = threadCount;
        this.chunkSize = chunkSize;
        this.singleSessionId = FileTransferUtils.generateSessionId();
    }

    public void setParentSender(UnifiedSender parentSender) {
        this.parentSender = parentSender;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.singleSessionId = sessionId;
    }

    public void start() throws Exception {
        if (!this.file.exists() || !this.file.isFile()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6: " + this.file.getAbsolutePath());
        }
        this.startTransfer();
    }

    public void startTransfer() throws Exception {
        if (!this.file.exists() || !this.file.isFile()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6: " + this.file.getAbsolutePath());
        }
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            if ("localhost".equals(this.host) || "127.0.0.1".equals(this.host)) {
                this.connectToLocalRelay(group);
            } else {
                this.connectToSpecificRelay(group, this.host, this.port);
            }
            boolean receiverConnected = this.receiverLatch.await(30L, TimeUnit.MINUTES);
            if (!receiverConnected) {
                logger.warn("\u63a5\u6536\u7aef\u8fde\u63a5\u8d85\u65f6");
                logger.info("\u7b49\u5f85\u63a5\u6536\u7aef\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u786e\u4fdd\u63a5\u6536\u7aef\u6b63\u786e\u8f93\u5165\u63a5\u6536\u7801");
            }
            if (this.channel != null) {
                this.channel.closeFuture().sync();
            }
        }
        finally {
            group.shutdownGracefully();
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }

    public void onReceiverConnectedViaLocal() {
        if (this.receiverConnected) {
            logger.info("\u63a5\u6536\u7aef\u8fde\u63a5\u5df2\u5904\u7406\u8fc7\uff0c\u5ffd\u7565\u91cd\u590d\u8fde\u63a5 - \u672c\u5730\u4e2d\u7ee7: {}:{}", (Object)this.host, (Object)this.port);
            return;
        }
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7\u672c\u5730\u4e2d\u7ee7\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
        String relayInfo = "\u672c\u5730\u4e2d\u7ee7 " + this.host + ":" + this.port;
        if (this.parentSender != null && !this.parentSender.handleGlobalReceiverConnection(relayInfo, this)) {
            logger.info("\u5176\u4ed6\u53d1\u9001\u5668\u5df2\u5904\u7406\u63a5\u6536\u7aef\u8fde\u63a5\uff0c\u672c\u8fde\u63a5\u88ab\u5ffd\u7565");
            return;
        }
        this.isActiveTransfer = true;
        this.activeChannel = this.channel;
        this.onReceiverConnected("\u672c\u5730\u4e2d\u7ee7");
    }

    public void onReceiverConnectedViaPublic() {
        if (this.receiverConnected) {
            logger.info("\u63a5\u6536\u7aef\u8fde\u63a5\u5df2\u5904\u7406\u8fc7\uff0c\u5ffd\u7565\u91cd\u590d\u8fde\u63a5 - \u4e2d\u7ee7: {}:{}", (Object)this.host, (Object)this.port);
            return;
        }
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7\u5916\u90e8\u4e2d\u7ee7\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
        String relayType = this.host.equals("relay.daodaovps.com") && this.port == 8001 ? "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7" : "\u5916\u90e8\u4e2d\u7ee7";
        String relayInfo = relayType + " " + this.host + ":" + this.port;
        if (this.parentSender != null && !this.parentSender.handleGlobalReceiverConnection(relayInfo, this)) {
            logger.info("\u5176\u4ed6\u53d1\u9001\u5668\u5df2\u5904\u7406\u63a5\u6536\u7aef\u8fde\u63a5\uff0c\u672c\u8fde\u63a5\u88ab\u5ffd\u7565");
            return;
        }
        this.isActiveTransfer = true;
        this.activeChannel = this.channel;
        this.onReceiverConnected(relayType);
    }

    private void onReceiverConnected(String relayType) {
        this.receiverConnected = true;
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7{}\u5df2\u8fde\u63a5\uff0c\u5f00\u59cb\u53d1\u9001\u6587\u4ef6...", (Object)relayType);
        System.out.println("\u2705 \u63a5\u6536\u7aef\u5df2\u8fde\u63a5 (" + relayType + ")\uff0c\u5f00\u59cb\u4f20\u8f93\u6587\u4ef6...");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udce4 \u6587\u4ef6\u4f20\u8f93\u8fdb\u5ea6");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        this.transferStartTime = System.currentTimeMillis();
        this.startHeartbeat();
        this.receiverLatch.countDown();
        System.out.println("\ud83d\udd0d \u6b63\u5728\u8ba1\u7b97\u6587\u4ef6\u6821\u9a8c\u503c: " + this.file.getName());
        int totalChunks = FileTransferUtils.calculateChunks(this.file.length(), this.chunkSize);
        String md5 = FileTransferUtils.calculateFileMD5(this.file);
        FileInfoMessage fileInfoMsg = new FileInfoMessage(this.sessionId, this.file.getName(), this.file.length(), totalChunks, this.chunkSize, md5);
        this.activeChannel.writeAndFlush(fileInfoMsg);
        logger.info("\u6587\u4ef6\u4fe1\u606f\u5df2\u53d1\u9001\uff0c\u603b\u5757\u6570: {}", (Object)totalChunks);
        CountDownLatch responseLatch = new CountDownLatch(1);
        this.currentSendingFile = this.file.getName();
        this.currentFileLatch = responseLatch;
        this.currentFileSkipped = false;
        new Thread(() -> {
            block5: {
                logger.info("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u6587\u4ef6\u4f20\u8f93\u8bf7\u6c42: {}", (Object)this.file.getName());
                try {
                    if (responseLatch.await(30L, TimeUnit.SECONDS)) break block5;
                    logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u8d85\u65f6: {}", (Object)this.file.getName());
                    logger.info("\u8d85\u65f6\u540e\u518d\u7b49\u5f851\u79d2\uff0c\u68c0\u67e5\u5ef6\u8fdf\u6d88\u606f...");
                    Thread.sleep(1000L);
                    if (this.currentFileSkipped) {
                        logger.info("\u68c0\u6d4b\u5230\u5ef6\u8fdf\u7684\u6587\u4ef6\u8df3\u8fc7\u6d88\u606f: {}", (Object)this.file.getName());
                        break block5;
                    }
                    logger.error("\u786e\u8ba4\u8d85\u65f6\uff0c\u65e0\u6cd5\u4f20\u8f93\u6587\u4ef6: {}", (Object)this.file.getName());
                    this.onTransferComplete();
                    return;
                }
                catch (InterruptedException e) {
                    logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u65f6\u88ab\u4e2d\u65ad: {}", (Object)this.file.getName(), (Object)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentFileSkipped) {
                logger.info("\u6587\u4ef6\u88ab\u63a5\u6536\u7aef\u8df3\u8fc7: {}", (Object)this.file.getName());
                return;
            }
            logger.info("\u63a5\u6536\u7aef\u786e\u8ba4\u53ef\u4ee5\u4f20\u8f93\u6587\u4ef6: {}", (Object)this.file.getName());
            this.executor = Executors.newFixedThreadPool(this.threadCount);
            this.transferLatch = new CountDownLatch(totalChunks);
            for (int i = 0; i < this.threadCount; ++i) {
                this.executor.submit(new ChunkSender(i, totalChunks, this.threadCount));
            }
        }, "FileResponseWaiter").start();
    }

    private void startHeartbeat() {
        this.heartbeatRunning = true;
        new Thread(() -> {
            try {
                logger.info("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u7ebf\u7a0b\u542f\u52a8");
                while (this.heartbeatRunning && !this.transferComplete) {
                    try {
                        Thread.sleep(10000L);
                        if (!this.heartbeatRunning || this.transferComplete) {
                            logger.debug("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u7ebf\u7a0b\u9000\u51fa\u6761\u4ef6\u6ee1\u8db3\uff0c\u505c\u6b62\u53d1\u9001\u5fc3\u8df3");
                            break;
                        }
                        int sent = this.chunksSent.get();
                        int total = FileTransferUtils.calculateChunks(this.file.length(), this.chunkSize);
                        double progress = total > 0 ? (double)sent / (double)total * 100.0 : 0.0;
                        logger.info("\u5fc3\u8df3\u6587\u4ef6\u4f20\u8f93\u72b6\u6001\uff1a\u5df2\u53d1\u9001 {}/{} \u5757 ({:.2f}%)", sent, total, progress);
                        if (this.activeChannel == null || !this.activeChannel.isActive()) {
                            logger.warn("\u5fc3\u8df3\u53d1\u9001\u5931\u8d25\uff1a\u901a\u9053\u65e0\u6548\uff0c\u505c\u6b62\u5fc3\u8df3");
                            break;
                        }
                        try {
                            HeartbeatMessage heartbeat = new HeartbeatMessage();
                            heartbeat.setSessionId(this.sessionId);
                            this.activeChannel.writeAndFlush(heartbeat).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                                if (future.isSuccess()) {
                                    logger.debug("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u6d88\u606f\u53d1\u9001\u6210\u529f");
                                } else {
                                    logger.debug("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u6d88\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)future.cause().getMessage());
                                }
                            }));
                        }
                        catch (Exception writeEx) {
                            logger.debug("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u6d88\u606f\u5199\u5165\u5f02\u5e38: {}", (Object)writeEx.getMessage());
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("\u53d1\u9001\u5fc3\u8df3\u6d88\u606f\u5f02\u5e38: {}", (Object)e.getMessage());
                    }
                }
                logger.info("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u7ebf\u7a0b\u9000\u51fa: heartbeatRunning={}, transferComplete={}", (Object)this.heartbeatRunning, (Object)this.transferComplete);
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u4f20\u8f93\u5fc3\u8df3\u7ebf\u7a0b\u610f\u5916\u7ec8\u6b62: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                this.heartbeatRunning = false;
            }
        }, "FileTransferHeartbeat").start();
    }

    private void connectToLocalRelay(EventLoopGroup group) throws InterruptedException {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x800000)).option(ChannelOption.SO_RCVBUF, 0x800000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new IdleStateHandler(0, 30, 0));
                CodecFactory.addClientCodec(p);
                p.addLast(new FileSender_with_local_relay_hanlder(FileSender.this));
            }
        });
        this.channel = b.connect(this.host, this.port).sync().channel();
        logger.info("\u8fde\u63a5\u5230\u672c\u5730\u4e2d\u7ee7: {}:{}", (Object)this.host, (Object)this.port);
        RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
        this.channel.writeAndFlush(registerMsg);
        logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u672c\u5730\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
    }

    private void connectToSpecificRelay(EventLoopGroup group, String relayHost, int relayPort) throws Exception {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x800000)).option(ChannelOption.SO_RCVBUF, 0x800000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new IdleStateHandler(0, 30, 0));
                CodecFactory.addClientCodec(p);
                p.addLast(new FileSender_with_pub_relay_hanlder(FileSender.this));
            }
        });
        this.channel = b.connect(relayHost, relayPort).sync().channel();
        RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
        this.channel.writeAndFlush(registerMsg);
        logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u6307\u5b9a\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
    }

    private void connectToPublicRelay() {
        try {
            String publicRelayHost = RelayConfig.getPublicRelayHost();
            int publicRelayPort = RelayConfig.getPublicRelayPort();
            logger.info("\u5c1d\u8bd5\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)publicRelayHost, (Object)publicRelayPort);
            NioEventLoopGroup publicGroup = new NioEventLoopGroup();
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(publicGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x800000)).option(ChannelOption.SO_RCVBUF, 0x800000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, 30, 0));
                    CodecFactory.addClientCodec(p);
                    p.addLast(new FileSender_with_pub_relay_hanlder(FileSender.this));
                }
            });
            this.publicRelayChannel = b.connect(publicRelayHost, publicRelayPort).sync().channel();
            this.publicRelayConnected = true;
            this.publicRelayLatch.countDown();
            if (publicRelayHost.equals("relay.daodaovps.com") && publicRelayPort == 8001) {
                ConsoleUtils.infof("\u5df2\u8fde\u63a5 \u9ed8\u8ba4\u516c\u5171\u4e2d\u7ee7: %s:%d", publicRelayHost, publicRelayPort);
            } else {
                ConsoleUtils.infof("\u5df2\u8fde\u63a5 \u6307\u5b9a\u7684\u4e2d\u7ee7\u670d\u52a1\u5668: %s:%d", publicRelayHost, publicRelayPort);
            }
            RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
            this.publicRelayChannel.writeAndFlush(registerMsg);
            logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u516c\u5171\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
            this.publicRelayConnected = true;
        }
        catch (Exception e) {
            logger.warn("\u8fde\u63a5\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}", (Object)e.getMessage());
            ConsoleUtils.error("\u8fde\u63a5\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25");
        }
    }

    public String getSingleSessionId() {
        return this.singleSessionId;
    }

    public void onFileTransferAck() {
        if (this.currentFileLatch != null) {
            this.currentFileLatch.countDown();
            logger.info("\u63a5\u6536\u5230\u6587\u4ef6\u4f20\u8f93\u786e\u8ba4: {}", (Object)this.currentSendingFile);
        }
    }

    public void onTransferComplete() {
        if (this.transferComplete) {
            return;
        }
        this.transferComplete = true;
        this.transferSuccessfullyCompleted = true;
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - this.transferStartTime;
        double speedMBps = this.calculateTransferSpeed(this.file.length(), totalTime);
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.heartbeatRunning = false;
        logger.info("\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210: {}, \u8017\u65f6: {} \u79d2, \u5e73\u5747\u901f\u5ea6: {:.2f} MB/s", this.file.getName(), (double)totalTime / 1000.0, speedMBps);
        ConsoleFormatter.printFileTransferComplete(this.file, totalTime, speedMBps);
        this.channel.close();
        if (this.publicRelayConnected && this.publicRelayChannel != null) {
            this.publicRelayChannel.close();
        }
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                logger.info("\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\uff0c\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa");
                System.exit(0);
            }
            catch (InterruptedException e) {
                System.exit(0);
            }
        }, "DelayedExit").start();
    }

    private double calculateTransferSpeed(long bytes, long timeMs) {
        if (timeMs <= 0L) {
            return 0.0;
        }
        return (double)bytes / 1024.0 / 1024.0 / ((double)timeMs / 1000.0);
    }

    public void onError(String errorMsg) {
        HandlerExceptionUtils.handleException(null, new RuntimeException(errorMsg), FileSender.class.getName());
    }

    public void onFileSkipped(String fileName, String reason, long fileSize) {
        logger.info("\u6587\u4ef6\u4f20\u8f93\u88ab\u8df3\u8fc7: {} ({}), \u5927\u5c0f: {}", fileName, reason, FileTransferUtils.formatFileSize(fileSize));
        System.out.println("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6: " + fileName + " (\u5df2\u5b58\u5728\u76f8\u540c\u6587\u4ef6)");
        if (this.currentSendingFile != null && this.currentSendingFile.equals(fileName)) {
            this.currentFileSkipped = true;
            if (this.currentFileLatch != null) {
                this.currentFileLatch.countDown();
                logger.info("\u6587\u4ef6\u8df3\u8fc7\uff0c\u53d6\u6d88\u7b49\u5f85\u4f20\u8f93\u786e\u8ba4: {}", (Object)fileName);
            }
            this.currentSendingFile = null;
            this.currentFileLatch = null;
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            logger.info("\u505c\u6b62\u6587\u4ef6\u5757\u53d1\u9001\u7ebf\u7a0b\u6c60");
            this.executor.shutdownNow();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    logger.warn("\u7ebf\u7a0b\u6c60\u5173\u95ed\u8d85\u65f6\uff0c\u5f3a\u5236\u7ec8\u6b62");
                }
            }
            catch (InterruptedException e) {
                logger.warn("\u7b49\u5f85\u7ebf\u7a0b\u6c60\u5173\u95ed\u65f6\u88ab\u4e2d\u65ad");
                Thread.currentThread().interrupt();
            }
        }
        this.onTransferComplete();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.activeChannel = channel;
    }

    public boolean isTransferSuccessfullyCompleted() {
        return this.transferSuccessfullyCompleted;
    }

    public boolean isAllDataSent() {
        return this.allDataSent;
    }

    public synchronized void showExitMessage(String connectionType) {
        if (!this.exitMessageShown) {
            this.exitMessageShown = true;
            ExitMessageFormatter.showConnectionClosed(connectionType);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                    ExitMessageFormatter.showSenderExit();
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    System.exit(0);
                }
            }, "ExitHandler").start();
        }
    }

    public void silentClose() {
        block7: {
            try {
                logger.debug("\u9759\u9ed8\u5173\u95ed\u53d1\u9001\u5668\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
                this.silentClosing = true;
                if (this.channel != null && this.channel.isActive()) {
                    this.channel.close();
                }
                if (this.publicRelayChannel != null && this.publicRelayChannel.isActive()) {
                    this.publicRelayChannel.close();
                }
                if (this.executor == null || this.executor.isShutdown()) break block7;
                this.executor.shutdown();
                try {
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        this.executor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                logger.debug("\u9759\u9ed8\u5173\u95ed\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
    }

    public boolean isSilentClosing() {
        return this.silentClosing;
    }

    public boolean isActiveTransfer() {
        return this.isActiveTransfer;
    }

    private class ChunkSender
    implements Runnable {
        private final int startChunkIndex;
        private final int totalChunks;
        private final int step;

        public ChunkSender(int threadIndex, int totalChunks, int threadCount) {
            this.startChunkIndex = threadIndex;
            this.totalChunks = totalChunks;
            this.step = threadCount;
        }

        @Override
        public void run() {
            try {
                FileInputStream fis = new FileInputStream(FileSender.this.file);
                long startTime = System.currentTimeMillis();
                for (int i = this.startChunkIndex; i < this.totalChunks; i += this.step) {
                    int currentChunkSize;
                    block17: {
                        if (Thread.currentThread().isInterrupted()) {
                            logger.info("\u53d1\u9001\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u505c\u6b62\u53d1\u9001");
                            break;
                        }
                        if (FileSender.this.file.length() == 0L) {
                            logger.info("\u5904\u74060\u5927\u5c0f\u6587\u4ef6: {}", (Object)FileSender.this.file.getName());
                            FileSender.this.transferLatch.countDown();
                            TransferCompleteMessage completeMsg = new TransferCompleteMessage(FileSender.this.sessionId);
                            FileSender.this.activeChannel.writeAndFlush(completeMsg);
                            logger.debug("\u53d1\u9001\u7a7a\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\u6d88\u606f");
                            fis.close();
                            return;
                        }
                        long offset = (long)i * (long)FileSender.this.chunkSize;
                        currentChunkSize = (int)Math.min((long)FileSender.this.chunkSize, FileSender.this.file.length() - offset);
                        if (currentChunkSize <= 0) {
                            FileSender.this.transferLatch.countDown();
                            continue;
                        }
                        byte[] data = new byte[currentChunkSize];
                        fis.getChannel().position(offset);
                        int bytesRead = fis.read(data);
                        if (bytesRead <= 0) continue;
                        FileChunkMessage chunkMsg = new FileChunkMessage(FileSender.this.sessionId, i, data);
                        while (FileSender.this.activeChannel.isActive() && !FileSender.this.activeChannel.isWritable()) {
                            try {
                                Thread.sleep(10L);
                                System.out.print("\r\u23f8\ufe0f  \u7f51\u7edc\u7e41\u5fd9\uff0c\u7b49\u5f85\u53d1\u9001\u901a\u9053\u53ef\u5199...");
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                logger.info("\u53d1\u9001\u7ebf\u7a0b\u7b49\u5f85\u65f6\u88ab\u4e2d\u65ad");
                                break;
                            }
                        }
                        if (!FileSender.this.activeChannel.isActive() || Thread.currentThread().isInterrupted()) break;
                        try {
                            ChannelFuture future = FileSender.this.activeChannel.writeAndFlush(chunkMsg);
                            future.awaitUninterruptibly(5000L);
                            if (!future.isSuccess()) {
                                if (future.cause() == null) break;
                                logger.error("\u53d1\u9001\u6587\u4ef6\u5757\u5931\u8d25: {}", (Object)future.cause().getMessage());
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            logger.error("\u53d1\u9001\u6587\u4ef6\u5757\u65f6\u53d1\u751f\u9519\u8bef", e);
                        }
                        break;
                    }
                    int sent = FileSender.this.chunksSent.incrementAndGet();
                    long now = System.currentTimeMillis();
                    long elapsedTime = now - startTime;
                    if (elapsedTime > 0L) {
                        int displayInterval;
                        long bytesSent = (long)sent * (long)currentChunkSize;
                        double progress = (double)sent / (double)this.totalChunks * 100.0;
                        double speedMBps = (double)bytesSent / 1024.0 / 1024.0 / ((double)elapsedTime / 1000.0);
                        int n = displayInterval = this.totalChunks <= 20 ? 1 : 5;
                        if (sent % displayInterval == 0 || sent == this.totalChunks) {
                            long sentBytes = bytesSent;
                            String sentSize = FileTransferUtils.formatFileSize(sentBytes);
                            String totalSize = FileTransferUtils.formatFileSize(FileSender.this.file.length());
                            System.out.printf("\r\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6: %s | %s/%s (%.1f%%) | %.2f MB/s", FileSender.this.file.getName(), sentSize, totalSize, progress, speedMBps);
                            if (sent == this.totalChunks) {
                                System.out.println();
                            }
                            System.out.flush();
                        }
                    }
                    FileSender.this.transferLatch.countDown();
                }
                fis.close();
                boolean completed = FileSender.this.transferLatch.await(24L, TimeUnit.HOURS);
                if (completed && FileSender.this.chunksSent.get() == this.totalChunks && !Thread.currentThread().isInterrupted()) {
                    FileSender.this.allDataSent = true;
                    TransferCompleteMessage completeMsg = new TransferCompleteMessage(FileSender.this.sessionId);
                    FileSender.this.activeChannel.writeAndFlush(completeMsg);
                    logger.debug("\u53d1\u9001\u4f20\u8f93\u5b8c\u6210\u6d88\u606f");
                }
            }
            catch (InterruptedException e) {
                logger.info("\u53d1\u9001\u7ebf\u7a0b\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6587\u4ef6\u5757\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
        }
    }
}

