/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.unified;

import com.file.netty.config.MultiRelayConfig;
import com.file.netty.config.RelayInfo;
import com.file.netty.config.RelayPriority;
import com.file.netty.discovery.BroadcastPublisher;
import com.file.netty.relay.RelayServer;
import com.file.netty.sender.FileSender;
import com.file.netty.sender.FolderSender;
import com.file.netty.utils.FileTransferUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedSender {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedSender.class);
    private final File sourcePath;
    private TransferType transferType;
    private FileSender fileSender;
    private FolderSender folderSender;
    private int localRelayPort;
    private final int threadCount;
    private final int chunkSize;
    private String sessionId;
    private RelayServer relayServer;
    private BroadcastPublisher broadcastPublisher;
    private volatile boolean receiverConnected = false;
    private static final Object receiverConnectionLock = new Object();
    private volatile boolean globalReceiverConnected = false;
    private volatile String activeRelayInfo = null;
    private final List<Object> allSenderInstances = new CopyOnWriteArrayList<Object>();
    private volatile Object activeSender = null;

    public UnifiedSender(String sourcePath) {
        this(sourcePath, 4, 262144);
    }

    public UnifiedSender(String sourcePath, int threadCount, int chunkSize) {
        this.sourcePath = new File(sourcePath);
        this.threadCount = threadCount;
        this.chunkSize = chunkSize;
        this.sessionId = FileTransferUtils.generateSessionId();
        this.identifyTransferType();
    }

    private void startLocalRelayServer() {
        try {
            String local;
            this.localRelayPort = this.findAvailablePort(10000, 20000);
            this.relayServer = new RelayServer(this.localRelayPort);
            new Thread(() -> {
                try {
                    this.relayServer.start();
                }
                catch (Exception e) {
                    logger.error("\u542f\u52a8\u4e2d\u7ee7\u670d\u52a1\u5668\u7ebf\u7a0b\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                    System.err.println("\u542f\u52a8\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: " + e.getMessage());
                }
            }, "RelayServerThread").start();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(500L);
                System.out.print(".");
            }
            System.out.println();
            String localHost = local = "localhost";
            logger.info("\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668\u5df2\u542f\u52a8: {}:{}", (Object)localHost, (Object)this.localRelayPort);
            this.broadcastPublisher = new BroadcastPublisher();
            boolean published = this.broadcastPublisher.publishService(this.localRelayPort, this.sessionId);
            if (published) {
                logger.info("\u5df2\u901a\u8fc7\u5e7f\u64ad\u53d1\u5e03\u672c\u5730\u4e2d\u7ee7\u670d\u52a1");
                System.out.println("\u2705 \u5df2\u53d1\u5e03\u672c\u5730\u4e2d\u7ee7\u670d\u52a1");
            } else {
                logger.warn("\u5e7f\u64ad\u53d1\u5e03\u5931\u8d25\uff0c\u53ef\u80fd\u5f71\u54cd\u670d\u52a1\u53d1\u73b0");
            }
        }
        catch (Exception e) {
            logger.error("\u542f\u52a8\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            System.err.println("\u65e0\u6cd5\u542f\u52a8\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668: " + e.getMessage());
        }
    }

    public void stopBroadcastService() {
        if (this.broadcastPublisher != null && !this.receiverConnected) {
            this.receiverConnected = true;
            this.broadcastPublisher.stop();
            logger.info("\u63a5\u6536\u7aef\u5df2\u8fde\u63a5\uff0c\u505c\u6b62\u5e7f\u64ad\u670d\u52a1");
            System.out.println("\u2705 \u63a5\u6536\u7aef\u5df2\u8fde\u63a5\uff0c\u505c\u6b62\u5e7f\u64ad\u670d\u52a1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleGlobalReceiverConnection(String relayInfo, Object currentSender) {
        Object object = receiverConnectionLock;
        synchronized (object) {
            if (this.globalReceiverConnected) {
                logger.info("\u63a5\u6536\u7aef\u5df2\u901a\u8fc7\u5176\u4ed6\u4e2d\u7ee7\u8fde\u63a5\uff0c\u5ffd\u7565\u8fde\u63a5: {}", (Object)relayInfo);
                return false;
            }
            this.globalReceiverConnected = true;
            this.activeRelayInfo = relayInfo;
            this.activeSender = currentSender;
            logger.info("\u63a5\u6536\u7aef\u9996\u6b21\u8fde\u63a5\uff0c\u4f7f\u7528\u4e2d\u7ee7: {}", (Object)relayInfo);
            this.stopBroadcastService();
            CompletableFuture.runAsync(this::closeBackupConnections);
            return true;
        }
    }

    public boolean handleGlobalReceiverConnection(String relayInfo) {
        return this.handleGlobalReceiverConnection(relayInfo, null);
    }

    private void closeBackupConnections() {
        try {
            int closedCount = 0;
            ArrayList<Object> backupSenders = new ArrayList<Object>();
            for (Object sender : this.allSenderInstances) {
                if (sender == this.activeSender) continue;
                backupSenders.add(sender);
            }
            for (Object sender : backupSenders) {
                try {
                    if (sender instanceof FileSender) {
                        ((FileSender)sender).silentClose();
                        ++closedCount;
                    } else if (sender instanceof FolderSender) {
                        ((FolderSender)sender).silentClose();
                        ++closedCount;
                    }
                    this.allSenderInstances.remove(sender);
                    logger.debug("\u5df2\u4ece\u7ba1\u7406\u5217\u8868\u79fb\u9664\u5907\u7528\u53d1\u9001\u5668: {}", (Object)sender.getClass().getSimpleName());
                }
                catch (Exception e) {
                    logger.warn("\u5173\u95ed\u5355\u4e2a\u5907\u7528\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
                }
            }
            if (closedCount > 0) {
                logger.info("\u5df2\u9759\u9ed8\u5173\u95ed\u5e76\u79fb\u9664 {} \u4e2a\u5907\u7528\u4e2d\u7ee7\u8fde\u63a5\uff0c\u4fdd\u7559\u6d3b\u8dc3\u8fde\u63a5: {}", (Object)closedCount, (Object)this.activeRelayInfo);
            }
        }
        catch (Exception e) {
            logger.warn("\u5173\u95ed\u5907\u7528\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    private void identifyTransferType() {
        if (this.sourcePath.isFile()) {
            this.transferType = TransferType.FILE;
            logger.info("\u68c0\u6d4b\u5230\u6587\u4ef6\u4f20\u8f93: {}", (Object)this.sourcePath.getAbsolutePath());
        } else if (this.sourcePath.isDirectory()) {
            this.transferType = TransferType.FOLDER;
            logger.info("\u68c0\u6d4b\u5230\u6587\u4ef6\u5939\u4f20\u8f93: {}", (Object)this.sourcePath.getAbsolutePath());
        } else {
            throw new IllegalArgumentException("\u6e90\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u65e0\u6548: " + this.sourcePath.getAbsolutePath());
        }
    }

    public void start() throws Exception {
        this.validateSourcePath();
        this.displayFileInfo();
        System.out.print("\ud83d\ude80 \u542f\u52a8\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668");
        this.startLocalRelayServer();
        this.displaySessionCode();
        this.startSenderToAllRelays();
    }

    private void startSenderToAllRelays() throws Exception {
        List<RelayInfo> allRelays = MultiRelayConfig.getOrderedRelayList();
        ArrayList<String> availableRelays = new ArrayList<String>();
        ArrayList<Object> senderFutures = new ArrayList<Object>();
        System.out.println("\ud83d\udd04 \u51c6\u5907\u8fde\u63a5\u5230\u6240\u6709\u53ef\u7528\u4e2d\u7ee7...");
        if (this.testRelayConnection("localhost", this.localRelayPort)) {
            availableRelays.add("\u672c\u5730\u4e2d\u7ee7: localhost:" + this.localRelayPort);
            Iterator localFuture = this.startSenderAsync("localhost", this.localRelayPort);
            senderFutures.add(localFuture);
        }
        for (RelayInfo relayInfo : allRelays) {
            if (!this.testRelayConnection(relayInfo.getHost(), relayInfo.getPort())) continue;
            String relayType = relayInfo.getPriority() == RelayPriority.DEFAULT ? "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7" : "\u81ea\u5b9a\u4e49\u4e2d\u7ee7";
            availableRelays.add(relayType + ": " + relayInfo.getHost() + ":" + relayInfo.getPort());
            CompletableFuture<Void> relayFuture = this.startSenderAsync(relayInfo.getHost(), relayInfo.getPort());
            senderFutures.add(relayFuture);
        }
        if (availableRelays.isEmpty()) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u7684\u4e2d\u7ee7\u670d\u52a1\u5668");
        }
        System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230 " + availableRelays.size() + " \u4e2a\u4e2d\u7ee7:");
        for (String string : availableRelays) {
            System.out.println("   \ud83d\udce1 " + string);
        }
        System.out.println("\u23f3 \u7b49\u5f85\u63a5\u6536\u7aef\u9009\u62e9\u4e2d\u7ee7\u5e76\u8fde\u63a5...");
        try {
            CompletableFuture<Object> anyComplete = CompletableFuture.anyOf(senderFutures.toArray(new CompletableFuture[0]));
            anyComplete.get();
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f \u4f20\u8f93\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
        }
    }

    private CompletableFuture<Void> startSenderAsync(String relayHost, int relayPort) {
        return CompletableFuture.runAsync(() -> {
            try {
                if (this.transferType == TransferType.FILE) {
                    FileSender asyncFileSender = new FileSender(relayHost, relayPort, this.sourcePath, this.threadCount, this.chunkSize);
                    asyncFileSender.setSessionId(this.sessionId);
                    asyncFileSender.setParentSender(this);
                    FileSender sender = asyncFileSender;
                    this.allSenderInstances.add(sender);
                    asyncFileSender.startTransfer();
                } else {
                    FolderSender asyncFolderSender = new FolderSender(relayHost, relayPort, this.sourcePath, this.chunkSize);
                    asyncFolderSender.setSessionId(this.sessionId);
                    asyncFolderSender.disableRelayServer();
                    asyncFolderSender.setParentSender(this);
                    FolderSender sender = asyncFolderSender;
                    this.allSenderInstances.add(sender);
                    asyncFolderSender.startTransfer();
                }
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5668\u542f\u52a8\u5931\u8d25 {}:{} - {}", relayHost, relayPort, e.getMessage(), e);
            }
        }, ForkJoinPool.commonPool());
    }

    private boolean testRelayConnection(String host, int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), 2000);
            socket.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validateSourcePath() {
        if (!this.sourcePath.exists()) {
            throw new IllegalArgumentException("\u6e90\u8def\u5f84\u4e0d\u5b58\u5728: " + this.sourcePath.getAbsolutePath());
        }
        if (this.transferType == TransferType.FILE && !this.sourcePath.isFile()) {
            throw new IllegalArgumentException("\u6e90\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6: " + this.sourcePath.getAbsolutePath());
        }
        if (this.transferType == TransferType.FOLDER && !this.sourcePath.isDirectory()) {
            throw new IllegalArgumentException("\u6e90\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6\u5939: " + this.sourcePath.getAbsolutePath());
        }
    }

    private void displayFileInfo() {
        if (this.sourcePath.isFile()) {
            System.out.println("\ud83d\udce4 \u51c6\u5907\u53d1\u9001\u6587\u4ef6: " + this.sourcePath.getName());
            System.out.println("\ud83d\udcca \u6587\u4ef6\u5927\u5c0f: " + FileTransferUtils.formatFileSize(this.sourcePath.length()));
        } else if (this.sourcePath.isDirectory()) {
            System.out.println("\ud83d\udcc1 \u51c6\u5907\u53d1\u9001\u6587\u4ef6\u5939: " + this.sourcePath.getName());
            System.out.println("\ud83d\udd0d \u6b63\u5728\u8ba1\u7b97\u6587\u4ef6\u6570\u91cf\u548c\u5927\u5c0f");
            long size = FileTransferUtils.calculateFolderSize(this.sourcePath.getAbsolutePath());
            int files = FileTransferUtils.countFiles(this.sourcePath.getAbsolutePath());
            System.out.println("\ud83d\udcca \u5305\u542b\u6587\u4ef6\u6570: " + files);
            System.out.println("\ud83d\udcca \u603b\u5927\u5c0f: " + FileTransferUtils.formatFileSize(size));
        }
    }

    private void displaySessionCode() {
        System.out.println("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udd11 \u914d\u5bf9\u7801: " + this.sessionId);
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcf1 \u8bf7\u5728\u63a5\u6536\u7aef\u8f93\u5165\u6b64\u914d\u5bf9\u7801\u5f00\u59cb\u4f20\u8f93");
    }

    private void startSenderWithRelay(String relayHost, int relayPort) throws Exception {
        if (this.transferType == TransferType.FILE) {
            this.fileSender = new FileSender(relayHost, relayPort, this.sourcePath, this.threadCount, this.chunkSize);
            this.fileSender.setSessionId(this.sessionId);
            this.fileSender.setParentSender(this);
            this.fileSender.startTransfer();
        } else {
            this.folderSender = new FolderSender(relayHost, relayPort, this.sourcePath, this.chunkSize);
            this.folderSender.setSessionId(this.sessionId);
            this.folderSender.disableRelayServer();
            this.folderSender.setParentSender(this);
            this.folderSender.startTransfer();
        }
    }

    private int findAvailablePort(int minPort, int maxPort) {
        for (int port = minPort; port <= maxPort; ++port) {
            try {
                ServerSocket socket = new ServerSocket(port);
                socket.close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new RuntimeException("\u5728\u8303\u56f4 " + minPort + "-" + maxPort + " \u5185\u672a\u627e\u5230\u53ef\u7528\u7aef\u53e3");
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private static enum TransferType {
        FILE,
        FOLDER;

    }
}

