/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.UnifiedHashCalculator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCompressor {
    private static final Logger logger = LoggerFactory.getLogger(BatchCompressor.class);
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private static final LZ4Compressor compressor = factory.fastCompressor();
    private static final LZ4SafeDecompressor decompressor = factory.safeDecompressor();
    private static final int BUFFER_SIZE = 0x100000;

    public static CompressionResult compressBatch(List<File> files, String baseDir, String outputPath, String metadataJson) throws IOException {
        if (BatchCompressor.shouldUsePackMode(files)) {
            return BatchCompressor.simplePackBatch(files, baseDir, outputPath, metadataJson);
        }
        logger.info("\ud83d\udcc4 \u6587\u4ef6\u4e0d\u6ee1\u8db3\u6253\u5305\u6761\u4ef6\uff0c\u5efa\u8bae\u4f7f\u7528\u5355\u6587\u4ef6\u4f20\u8f93: {} \u4e2a\u6587\u4ef6", (Object)files.size());
        return null;
    }

    @Deprecated
    public static CompressionResult packageBatch(List<File> files, String baseDir, String outputPath, String metadataJson) throws IOException {
        throw new UnsupportedOperationException("\u5df2\u5e9f\u5f03\uff1a\u8bf7\u4f7f\u7528\u5355\u6587\u4ef6\u4f20\u8f93\u66ff\u4ee3\u666e\u901a\u6253\u5305\u6a21\u5f0f");
    }

    @Deprecated
    private static CompressionResult compressBatch(List<File> files, String baseDir, String outputPath, String metadataJson, boolean enableCompression) throws IOException {
        long startTime = System.currentTimeMillis();
        long totalOriginalSize = 0L;
        String modeText = enableCompression ? "\u538b\u7f29" : "\u6253\u5305";
        logger.info("\u5f00\u59cb{}\u6279\u6b21: {} \u4e2a\u6587\u4ef6 \u2192 {}", modeText, files.size(), outputPath);
        try (FileOutputStream fos = new FileOutputStream(outputPath);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            if (!enableCompression) {
                zos.setMethod(0);
            }
            ZipEntry metadataEntry = new ZipEntry("batch_metadata.json");
            byte[] metadataBytes = metadataJson.getBytes("UTF-8");
            if (!enableCompression) {
                metadataEntry.setSize(metadataBytes.length);
                metadataEntry.setCompressedSize(metadataBytes.length);
                CRC32 metadataCrc = new CRC32();
                metadataCrc.update(metadataBytes);
                metadataEntry.setCrc(metadataCrc.getValue());
            }
            zos.putNextEntry(metadataEntry);
            zos.write(metadataBytes);
            zos.closeEntry();
            Path basePath = Paths.get(baseDir, new String[0]);
            ArrayList fileEntries = new ArrayList();
            files.parallelStream().forEach(file -> {
                if (file.exists() && file.isFile()) {
                    try {
                        Path filePath = file.toPath();
                        Path relativePath = basePath.relativize(filePath);
                        String entryName = relativePath.toString().replace('\\', '/');
                        FileEntry entry = new FileEntry();
                        entry.file = file;
                        entry.entryName = entryName;
                        entry.lastModified = file.lastModified();
                        if (!enableCompression) {
                            entry.crc32 = FileTransferUtils.calculateFileCRC32(file);
                        }
                        List list = fileEntries;
                        synchronized (list) {
                            fileEntries.add(entry);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("\u9884\u5904\u7406\u6587\u4ef6\u5931\u8d25: {} - {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                    }
                }
            });
            fileEntries.sort((a, b) -> a.entryName.compareTo(b.entryName));
            for (FileEntry fileEntry : fileEntries) {
                String entryName;
                File file2;
                block41: {
                    int bytesRead;
                    byte[] buffer;
                    BufferedInputStream bis;
                    FileInputStream fis;
                    file2 = fileEntry.file;
                    entryName = fileEntry.entryName;
                    ZipEntry entry = new ZipEntry(entryName);
                    entry.setTime(fileEntry.lastModified);
                    if (enableCompression) {
                        zos.putNextEntry(entry);
                        fis = new FileInputStream(file2);
                        try {
                            bis = new BufferedInputStream(fis);
                            try {
                                buffer = new byte[0x100000];
                                while ((bytesRead = bis.read(buffer)) != -1) {
                                    byte[] compressed = compressor.compress(buffer, 0, bytesRead);
                                    DataOutputStream dos = new DataOutputStream(zos);
                                    dos.writeInt(bytesRead);
                                    dos.writeInt(compressed.length);
                                    zos.write(compressed);
                                }
                                break block41;
                            }
                            finally {
                                bis.close();
                            }
                        }
                        finally {
                            fis.close();
                        }
                    }
                    entry.setSize(file2.length());
                    entry.setCompressedSize(file2.length());
                    entry.setCrc(fileEntry.crc32);
                    zos.putNextEntry(entry);
                    fis = new FileInputStream(file2);
                    try {
                        bis = new BufferedInputStream(fis, 0x100000);
                        try {
                            buffer = new byte[0x100000];
                            while ((bytesRead = bis.read(buffer)) != -1) {
                                zos.write(buffer, 0, bytesRead);
                            }
                        }
                        finally {
                            bis.close();
                        }
                    }
                    finally {
                        fis.close();
                    }
                }
                zos.closeEntry();
                totalOriginalSize += file2.length();
                logger.debug("\u5df2\u6dfb\u52a0\u6587\u4ef6\u5230\u538b\u7f29\u5305: {} ({})", (Object)entryName, (Object)FileTransferUtils.formatBytes(file2.length()));
            }
        }
        long compressionTime = System.currentTimeMillis() - startTime;
        File compressedFile = new File(outputPath);
        long compressedSize = BatchCompressor.verifyAndGetFileSize(compressedFile, totalOriginalSize);
        String compressionMd5 = BatchCompressor.calculateFileHashSafely(compressedFile);
        CompressionResult result = new CompressionResult(outputPath, totalOriginalSize, compressedSize, compressionMd5, compressionTime, false);
        logger.info("\u6279\u6b21{}\u5b8c\u6210: {}", (Object)modeText, (Object)result.getSummary());
        return result;
    }

    private static boolean shouldUsePackMode(List<File> files) {
        int fileCount = files.size();
        long totalSize = files.stream().mapToLong(File::length).sum();
        if (fileCount >= 1) {
            logger.info("\ud83d\ude80 \u7b26\u5408\u6253\u5305\u6761\u4ef6: {} \u4e2a\u6587\u4ef6, \u603b\u5927\u5c0f {} (\u65e0\u6587\u4ef6\u5927\u5c0f\u9650\u5236)", (Object)fileCount, (Object)FileTransferUtils.formatBytes(totalSize));
            return true;
        }
        return false;
    }

    private static CompressionResult simplePackBatch(List<File> files, String baseDir, String outputPath, String metadataJson) throws IOException {
        long startTime = System.currentTimeMillis();
        long totalOriginalSize = 0L;
        logger.info("\ud83d\ude80 \u4f7f\u7528\u7eaf\u6253\u5305\u6a21\u5f0f: {} \u4e2a\u6587\u4ef6\uff08\u65e0\u538b\u7f29\uff0c\u6781\u5c0f\u5f00\u9500\uff09", (Object)files.size());
        System.out.printf("\ud83d\udce6 \u5f00\u59cb\u6253\u5305: %d \u4e2a\u6587\u4ef6...\n", files.size());
        System.out.flush();
        ArrayList<SimplePackEntry> entries = new ArrayList<SimplePackEntry>();
        int processedCount = 0;
        int totalFiles = files.size();
        try (FileOutputStream fos = new FileOutputStream(outputPath);
             BufferedOutputStream bos = new BufferedOutputStream(fos, 0x100000);
             DataOutputStream dos = new DataOutputStream(bos);){
            long currentOffset = 0L;
            byte[] buffer = new byte[65536];
            for (File file : files) {
                String relativePath = BatchCompressor.getRelativePath(file, baseDir);
                long fileSize = file.length();
                entries.add(new SimplePackEntry(relativePath, fileSize, currentOffset));
                try (FileInputStream fis = new FileInputStream(file);){
                    int bytesRead;
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        dos.write(buffer, 0, bytesRead);
                    }
                }
                currentOffset += fileSize;
                totalOriginalSize += fileSize;
                if (++processedCount % 100 != 0 && processedCount != totalFiles) continue;
                double progress = (double)processedCount * 100.0 / (double)totalFiles;
                System.out.printf("\ud83d\udce6 \u6253\u5305\u8fdb\u5ea6: %d/%d (%.1f%%) - \u5df2\u5904\u7406 %s\n", processedCount, totalFiles, progress, FileTransferUtils.formatBytes(totalOriginalSize));
                System.out.flush();
            }
            long indexOffset = currentOffset;
            dos.writeInt(1346454347);
            dos.writeInt(1);
            dos.writeInt(files.size());
            for (SimplePackEntry entry : entries) {
                byte[] pathBytes = entry.relativePath.getBytes("UTF-8");
                dos.writeShort(pathBytes.length);
                dos.write(pathBytes);
                dos.writeLong(entry.fileSize);
                dos.writeLong(entry.offset);
            }
            dos.writeLong(indexOffset);
            dos.writeInt(0x454E44);
            dos.flush();
            bos.flush();
            fos.flush();
            fos.getFD().sync();
        }
        long compressionTime = System.currentTimeMillis() - startTime;
        File packedFile = new File(outputPath);
        long packedSize = BatchCompressor.verifyAndGetFileSize(packedFile, totalOriginalSize);
        String packedMd5 = BatchCompressor.calculateFileHashSafely(packedFile);
        CompressionResult result = new CompressionResult(outputPath, totalOriginalSize, packedSize, packedMd5, compressionTime, true);
        double overhead = (double)(packedSize - totalOriginalSize) / (double)totalOriginalSize * 100.0;
        logger.info("\ud83d\ude80 \u7eaf\u6253\u5305\u5b8c\u6210: {} \u4e2a\u6587\u4ef6, {} \u2192 {} (+{:.1f}% \u5143\u6570\u636e\u5f00\u9500), \u8017\u65f6: {}ms", files.size(), FileTransferUtils.formatBytes(totalOriginalSize), FileTransferUtils.formatBytes(packedSize), overhead, compressionTime);
        return result;
    }

    private static long verifyAndGetFileSize(File file, long expectedMinSize) throws IOException {
        int maxRetries = 10;
        long lastSize = -1L;
        int stableCount = 0;
        for (int i = 0; i < maxRetries; ++i) {
            if (!file.exists()) {
                if (i < maxRetries - 1) {
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("\u6587\u4ef6\u9a8c\u8bc1\u88ab\u4e2d\u65ad");
                    }
                }
                throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + file.getAbsolutePath());
            }
            long currentSize = file.length();
            if (currentSize == lastSize && currentSize >= expectedMinSize) {
                if (++stableCount >= 3) {
                    logger.debug("\u6587\u4ef6\u5927\u5c0f\u9a8c\u8bc1\u6210\u529f: {} bytes (\u9884\u671f\u6700\u5c0f: {} bytes)", (Object)currentSize, (Object)expectedMinSize);
                    return currentSize;
                }
            } else {
                stableCount = 0;
            }
            lastSize = currentSize;
            if (i >= maxRetries - 1) continue;
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("\u6587\u4ef6\u9a8c\u8bc1\u88ab\u4e2d\u65ad");
            }
        }
        throw new IOException(String.format("\u6587\u4ef6\u5927\u5c0f\u9a8c\u8bc1\u5931\u8d25: \u5f53\u524d\u5927\u5c0f=%d, \u9884\u671f\u6700\u5c0f=%d, \u6587\u4ef6=%s", lastSize, expectedMinSize, file.getAbsolutePath()));
    }

    public static String calculateFileHashSafely(File file) {
        return UnifiedHashCalculator.calculateFileHash(file);
    }

    private static String getRelativePath(File file, String baseDir) {
        try {
            Path basePath = Paths.get(baseDir, new String[0]).toAbsolutePath().normalize();
            Path filePath = file.toPath().toAbsolutePath().normalize();
            return basePath.relativize(filePath).toString().replace('\\', '/');
        }
        catch (Exception e) {
            logger.warn("\u8ba1\u7b97\u76f8\u5bf9\u8def\u5f84\u5931\u8d25: {}, \u4f7f\u7528\u6587\u4ef6\u540d", (Object)file.getName(), (Object)e);
            return file.getName();
        }
    }

    public static DecompressionResult decompressBatch(String compressedFilePath, String outputDir) throws IOException {
        logger.info("\u5f00\u59cb\u89e3\u538b\u7f29\u6279\u6b21: {} \u2192 {}", (Object)compressedFilePath, (Object)outputDir);
        Files.createDirectories(Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        if (BatchCompressor.isSimplePackFormat(compressedFilePath)) {
            logger.info("\ud83d\ude80 \u68c0\u6d4b\u5230\u7eaf\u6253\u5305\u683c\u5f0f\uff0c\u4f7f\u7528SimplePack\u89e3\u5305\u5668");
            return BatchCompressor.decompressSimplePackBatch(compressedFilePath, outputDir);
        }
        logger.info("\ud83d\uddc3\ufe0f \u68c0\u6d4b\u5230ZIP\u683c\u5f0f\uff0c\u4f7f\u7528ZIP\u89e3\u538b\u5668");
        return BatchCompressor.decompressZipBatch(compressedFilePath, outputDir);
    }

    private static DecompressionResult decompressZipBatch(String compressedFilePath, String outputDir) throws IOException {
        long startTime = System.currentTimeMillis();
        String metadataJson = null;
        int processedFiles = 0;
        long totalSize = 0L;
        try (FileInputStream fis = new FileInputStream(compressedFilePath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                if ("batch_metadata.json".equals(entryName)) {
                    int bytesRead;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[0x100000];
                    while ((bytesRead = zis.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    metadataJson = baos.toString("UTF-8");
                    logger.debug("\u8bfb\u53d6\u5143\u6570\u636e: {} \u5b57\u8282", (Object)baos.size());
                } else {
                    File outputFile;
                    block37: {
                        outputFile = new File(outputDir, entryName);
                        File parentDir = outputFile.getParentFile();
                        if (parentDir != null && !parentDir.exists()) {
                            parentDir.mkdirs();
                        }
                        try (FileOutputStream fos = new FileOutputStream(outputFile);
                             BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            if (entry.getMethod() == 0) {
                                int bytesRead;
                                byte[] buffer = new byte[0x100000];
                                while ((bytesRead = zis.read(buffer)) != -1) {
                                    bos.write(buffer, 0, bytesRead);
                                    totalSize += (long)bytesRead;
                                }
                                break block37;
                            }
                            DataInputStream dis = new DataInputStream(zis);
                            try {
                                while (true) {
                                    int totalRead;
                                    int read;
                                    int originalLength = dis.readInt();
                                    int compressedLength = dis.readInt();
                                    byte[] compressedData = new byte[compressedLength];
                                    for (totalRead = 0; totalRead < compressedLength && (read = zis.read(compressedData, totalRead, compressedLength - totalRead)) != -1; totalRead += read) {
                                    }
                                    if (totalRead != compressedLength) {
                                        throw new IOException("\u538b\u7f29\u6570\u636e\u8bfb\u53d6\u4e0d\u5b8c\u6574: \u671f\u671b=" + compressedLength + ", \u5b9e\u9645=" + totalRead);
                                    }
                                    byte[] decompressed = decompressor.decompress(compressedData, originalLength);
                                    bos.write(decompressed);
                                    totalSize += (long)originalLength;
                                }
                            }
                            catch (EOFException eOFException) {
                                // empty catch block
                            }
                        }
                    }
                    outputFile.setLastModified(entry.getTime());
                    ++processedFiles;
                    logger.debug("\u5df2\u89e3\u538b\u6587\u4ef6: {} ({})", (Object)entryName, (Object)FileTransferUtils.formatBytes(outputFile.length()));
                }
                zis.closeEntry();
            }
        }
        long decompressionTime = System.currentTimeMillis() - startTime;
        DecompressionResult result = new DecompressionResult(metadataJson, processedFiles, totalSize, decompressionTime);
        logger.info("\u6279\u6b21\u89e3\u538b\u5b8c\u6210: {} \u6587\u4ef6, {}, \u8017\u65f6: {}ms", processedFiles, FileTransferUtils.formatBytes(totalSize), decompressionTime);
        return result;
    }

    private static boolean isSimplePackFormat(String filePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            RandomAccessFile raf;
            block15: {
                block14: {
                    boolean bl;
                    raf = new RandomAccessFile(filePath, "r");
                    try {
                        if (raf.length() >= 20L) break block14;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    raf.close();
                    return bl;
                }
                raf.seek(raf.length() - 4L);
                int endMagic = raf.readInt();
                if (endMagic == 0x454E44) break block15;
                boolean bl = false;
                raf.close();
                return bl;
            }
            raf.seek(raf.length() - 12L);
            long indexOffset = raf.readLong();
            raf.seek(indexOffset);
            int magic = raf.readInt();
            boolean bl = magic == 1346454347;
            raf.close();
            return bl;
        }
    }

    private static DecompressionResult decompressSimplePackBatch(String packedFilePath, String outputDir) throws IOException {
        long startTime = System.currentTimeMillis();
        int processedFiles = 0;
        long totalSize = 0L;
        logger.info("\ud83d\ude80 \u4f7f\u7528\u7eaf\u6253\u5305\u89e3\u5305\u6a21\u5f0f: {}", (Object)packedFilePath);
        Files.createDirectories(Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        try (RandomAccessFile raf = new RandomAccessFile(packedFilePath, "r");){
            raf.seek(raf.length() - 12L);
            long indexOffset = raf.readLong();
            raf.seek(indexOffset);
            int magic = raf.readInt();
            if (magic != 1346454347) {
                throw new IOException("\u65e0\u6548\u7684\u7eaf\u6253\u5305\u683c\u5f0f");
            }
            int version = raf.readInt();
            if (version != 1) {
                throw new IOException("\u4e0d\u652f\u6301\u7684\u7248\u672c: " + version);
            }
            int fileCount = raf.readInt();
            logger.debug("\u8bfb\u53d6\u6587\u4ef6\u5934: {} \u4e2a\u6587\u4ef6", (Object)fileCount);
            ArrayList<SimplePackEntry> entries = new ArrayList<SimplePackEntry>();
            for (int i = 0; i < fileCount; ++i) {
                short pathLength = raf.readShort();
                byte[] pathBytes = new byte[pathLength];
                raf.readFully(pathBytes);
                String relativePath = new String(pathBytes, "UTF-8");
                long fileSize = raf.readLong();
                long offset = raf.readLong();
                entries.add(new SimplePackEntry(relativePath, fileSize, offset));
            }
            byte[] buffer = new byte[65536];
            for (SimplePackEntry entry : entries) {
                String outputPath = outputDir + File.separator + entry.relativePath.replace('/', File.separatorChar);
                File outputFile = new File(outputPath);
                File parentDir = outputFile.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(outputFile);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    int bytesRead;
                    raf.seek(entry.offset);
                    for (long remaining = entry.fileSize; remaining > 0L; remaining -= (long)bytesRead) {
                        int toRead = (int)Math.min((long)buffer.length, remaining);
                        bytesRead = raf.read(buffer, 0, toRead);
                        if (bytesRead == -1) {
                            throw new IOException("\u610f\u5916\u7684\u6587\u4ef6\u672b\u5c3e: " + entry.relativePath);
                        }
                        bos.write(buffer, 0, bytesRead);
                    }
                }
                ++processedFiles;
                totalSize += entry.fileSize;
                logger.debug("\u89e3\u5305\u6587\u4ef6: {} ({})", (Object)entry.relativePath, (Object)FileTransferUtils.formatBytes(entry.fileSize));
            }
        }
        long decompressionTime = System.currentTimeMillis() - startTime;
        logger.info("\ud83d\ude80 \u7eaf\u6253\u5305\u89e3\u5305\u5b8c\u6210: {} \u4e2a\u6587\u4ef6, {}, \u8017\u65f6: {}ms", processedFiles, FileTransferUtils.formatBytes(totalSize), decompressionTime);
        return new DecompressionResult(null, processedFiles, totalSize, decompressionTime);
    }

    public static class CompressionResult {
        private final String compressedFilePath;
        private final long originalSize;
        private final long compressedSize;
        private final double compressionRatio;
        private final String compressionMd5;
        private final long compressionTimeMs;
        private final boolean usedTinyMode;

        public CompressionResult(String compressedFilePath, long originalSize, long compressedSize, String compressionMd5, long compressionTimeMs, boolean usedTinyMode) {
            this.compressedFilePath = compressedFilePath;
            this.originalSize = originalSize;
            this.compressedSize = compressedSize;
            this.compressionMd5 = compressionMd5;
            this.compressionTimeMs = compressionTimeMs;
            this.usedTinyMode = usedTinyMode;
            this.compressionRatio = originalSize > 0L ? (double)compressedSize / (double)originalSize : 1.0;
        }

        public String getCompressedFilePath() {
            return this.compressedFilePath;
        }

        public long getOriginalSize() {
            return this.originalSize;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public double getCompressionRatio() {
            return this.compressionRatio;
        }

        public String getCompressionMd5() {
            return this.compressionMd5;
        }

        public long getCompressionTimeMs() {
            return this.compressionTimeMs;
        }

        public boolean getUsedTinyMode() {
            return this.usedTinyMode;
        }

        public double getCompressionSpeedMBps() {
            if (this.compressionTimeMs <= 0L) {
                return 0.0;
            }
            return (double)this.originalSize / 1024.0 / 1024.0 / ((double)this.compressionTimeMs / 1000.0);
        }

        public String getSummary() {
            double savePercentage = (1.0 - this.compressionRatio) * 100.0;
            String resultText = savePercentage > 0.0 ? String.format("%.1f%%\u8282\u7701", savePercentage) : String.format("+%.1f%%\u589e\u5927", Math.abs(savePercentage));
            return String.format("%s \u2192 %s (%s, %.1fMB/s)", FileTransferUtils.formatBytes(this.originalSize), FileTransferUtils.formatBytes(this.compressedSize), resultText, this.getCompressionSpeedMBps());
        }
    }

    private static class FileEntry {
        File file;
        String entryName;
        long lastModified;
        long crc32 = -1L;

        private FileEntry() {
        }
    }

    private static class SimplePackEntry {
        final String relativePath;
        final long fileSize;
        final long offset;

        SimplePackEntry(String relativePath, long fileSize, long offset) {
            this.relativePath = relativePath;
            this.fileSize = fileSize;
            this.offset = offset;
        }
    }

    public static class DecompressionResult {
        private final String metadataJson;
        private final int processedFiles;
        private final long totalSize;
        private final long decompressionTimeMs;

        public DecompressionResult(String metadataJson, int processedFiles, long totalSize, long decompressionTimeMs) {
            this.metadataJson = metadataJson;
            this.processedFiles = processedFiles;
            this.totalSize = totalSize;
            this.decompressionTimeMs = decompressionTimeMs;
        }

        public String getMetadataJson() {
            return this.metadataJson;
        }

        public int getProcessedFiles() {
            return this.processedFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getDecompressionTimeMs() {
            return this.decompressionTimeMs;
        }

        public double getDecompressionSpeedMBps() {
            if (this.decompressionTimeMs <= 0L) {
                return 0.0;
            }
            return (double)this.totalSize / 1024.0 / 1024.0 / ((double)this.decompressionTimeMs / 1000.0);
        }
    }
}

