/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.protocol.EncryptedMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageCategory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionUtils.class);
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH = 256;
    private static final int IV_LENGTH = 16;
    private static final String FIXED_KEY = "FileTransferSecretKey2024!@#$%";
    private static final SecureRandom random = new SecureRandom();

    public static SecretKey generateKeyFromPassword(String password) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] key = sha.digest(password.getBytes("UTF-8"));
            return new SecretKeySpec(key, ALGORITHM);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5bc6\u94a5\u5931\u8d25", e);
            throw new RuntimeException("\u751f\u6210\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    public static SecretKey getDefaultKey() {
        return EncryptionUtils.generateKeyFromPassword(FIXED_KEY);
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    public static Message encryptMessage(Message message, SecretKey key) {
        if (message == null) {
            return null;
        }
        if (!MessageCategory.needsEncryption(message.getType())) {
            logger.debug("\u63a7\u5236\u6d88\u606f\u4e0d\u52a0\u5bc6: {}", (Object)message.getType());
            return message;
        }
        try {
            byte[] messageData = EncryptionUtils.serializeMessage(message);
            byte[] iv = EncryptionUtils.generateIV();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            byte[] encryptedData = cipher.doFinal(messageData);
            EncryptedMessage encryptedMessage = new EncryptedMessage(message.getSessionId(), message.getType(), encryptedData, iv);
            logger.debug("\u6d88\u606f\u52a0\u5bc6\u6210\u529f: {} -> ENCRYPTED_DATA", (Object)message.getType());
            return encryptedMessage;
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u52a0\u5bc6\u5931\u8d25: {}", (Object)message.getType(), (Object)e);
            throw new RuntimeException("\u6d88\u606f\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static Message decryptMessage(EncryptedMessage encryptedMessage, SecretKey key) {
        if (encryptedMessage == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)key, new IvParameterSpec(encryptedMessage.getIv()));
            byte[] decryptedData = cipher.doFinal(encryptedMessage.getEncryptedData());
            Message originalMessage = EncryptionUtils.deserializeMessage(decryptedData);
            logger.debug("\u6d88\u606f\u89e3\u5bc6\u6210\u529f: ENCRYPTED_DATA -> {}", (Object)originalMessage.getType());
            return originalMessage;
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u89e3\u5bc6\u5931\u8d25", e);
            throw new RuntimeException("\u6d88\u606f\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] serializeMessage(Message message) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(message);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private static Message deserializeMessage(byte[] data) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Message message;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                message = (Message)ois.readObject();
            }
            return message;
        }
    }

    public static boolean isEncryptedMessage(Message message) {
        return message instanceof EncryptedMessage;
    }

    public static Message processMessage(Message message, SecretKey key, boolean encrypt) {
        if (message == null) {
            return null;
        }
        if (encrypt) {
            return EncryptionUtils.encryptMessage(message, key);
        }
        if (EncryptionUtils.isEncryptedMessage(message)) {
            return EncryptionUtils.decryptMessage((EncryptedMessage)message, key);
        }
        return message;
    }
}

