/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.OptimizedFileHashUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedHashCalculator {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedHashCalculator.class);
    private static final long TINY_FILE_THRESHOLD = 512L;
    private static final long SMALL_FILE_THRESHOLD = 65536L;
    private static final long MEDIUM_FILE_THRESHOLD = 0xA00000L;
    private static final int BUFFER_SIZE = 65536;
    private static final int HEADER_TAIL_SIZE = 262144;
    private static final int SEGMENT_COUNT = 5;
    private static final String EMPTY_FILE_HASH = "d41d8cd98f00b204e9800998ecf8427e";
    private static final ConcurrentHashMap<String, String> hashCache = new ConcurrentHashMap();
    private static final long CACHE_MAX_SIZE = 1000L;

    public static String calculateFileHash(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("\u65e0\u6548\u6587\u4ef6: " + (file != null ? file.getPath() : "null"));
        }
        long fileSize = file.length();
        if (fileSize == 0L) {
            logger.debug("0\u5b57\u8282\u6587\u4ef6\u4f7f\u7528\u56fa\u5b9a\u54c8\u5e0c: {}", (Object)file.getName());
            return EMPTY_FILE_HASH;
        }
        try {
            long xxhash = OptimizedFileHashUtil.calculate_file_hash_optimized(file.getAbsolutePath());
            String hexHash = Long.toHexString(xxhash);
            String cacheKey = UnifiedHashCalculator.generateCacheKey(file);
            UnifiedHashCalculator.putCache(cacheKey, hexHash);
            logger.debug("\ud83d\ude80 XXHash64\u8ba1\u7b97\u5b8c\u6210: {} -> {}", (Object)file.getName(), (Object)hexHash);
            return hexHash;
        }
        catch (IOException e) {
            logger.error("XXHash64\u8ba1\u7b97\u5931\u8d25\uff0c\u964d\u7ea7\u5230\u4f20\u7edfMD5: {}", (Object)file.getPath(), (Object)e);
            return UnifiedHashCalculator.calculateTraditionalMD5Hash(file);
        }
    }

    private static String calculateTraditionalMD5Hash(File file) {
        long fileSize = file.length();
        String cacheKey = UnifiedHashCalculator.generateCacheKey(file);
        String cachedHash = hashCache.get(cacheKey);
        if (cachedHash != null) {
            logger.debug("\u7f13\u5b58\u547d\u4e2d: {}", (Object)file.getName());
            return cachedHash;
        }
        try {
            String hash;
            if (fileSize <= 512L) {
                hash = UnifiedHashCalculator.calculateFullContentHash(file);
                logger.debug("\u6781\u5c0f\u6587\u4ef6\u5b8c\u6574\u54c8\u5e0c: {} ({}\u5b57\u8282)", (Object)file.getName(), (Object)fileSize);
            } else if (fileSize <= 65536L) {
                hash = UnifiedHashCalculator.calculateFullContentHash(file);
                logger.debug("\u5c0f\u6587\u4ef6\u5b8c\u6574\u54c8\u5e0c: {} ({}KB)", (Object)file.getName(), (Object)(fileSize / 1024L));
            } else if (fileSize <= 0xA00000L) {
                hash = UnifiedHashCalculator.calculateSegmentedHash(file);
                logger.debug("\u4e2d\u7b49\u6587\u4ef6\u5206\u6bb5\u54c8\u5e0c: {} ({}MB)", (Object)file.getName(), (Object)(fileSize / 1024L / 1024L));
            } else {
                hash = UnifiedHashCalculator.calculateHeaderTailHash(file);
                logger.debug("\u5927\u6587\u4ef6\u5934\u5c3e\u54c8\u5e0c: {} ({}MB)", (Object)file.getName(), (Object)(fileSize / 1024L / 1024L));
            }
            UnifiedHashCalculator.putCache(cacheKey, hash);
            return hash;
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u6587\u4ef6\u54c8\u5e0c\u5931\u8d25: {}", (Object)file.getPath(), (Object)e);
            return "error_" + System.currentTimeMillis();
        }
    }

    private static boolean isBatchTransferFile(File file) {
        String fileName = file.getName();
        return fileName.matches("batch_\\d+\\.pack");
    }

    /*
     * Exception decompiling
     */
    private static String calculateDeterministicHash(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String calculateFullContentHash(File file) throws IOException {
        MessageDigest md5 = UnifiedHashCalculator.getMD5Digest();
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis, 65536);){
            int bytesRead;
            byte[] buffer = new byte[65536];
            while ((bytesRead = bis.read(buffer)) != -1) {
                md5.update(buffer, 0, bytesRead);
            }
        }
        return UnifiedHashCalculator.bytesToHex(md5.digest());
    }

    private static String calculateSegmentedHash(File file) throws IOException {
        MessageDigest md5 = UnifiedHashCalculator.getMD5Digest();
        long fileSize = file.length();
        long segmentSize = fileSize / 5L;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] buffer = new byte[65536];
            for (int i = 0; i < 5; ++i) {
                int toRead;
                int bytesRead;
                long segmentStart = (long)i * segmentSize;
                long segmentEnd = i == 4 ? fileSize : (long)(i + 1) * segmentSize;
                long segmentLength = segmentEnd - segmentStart;
                raf.seek(segmentStart);
                for (long remaining = segmentLength; remaining > 0L && (bytesRead = raf.read(buffer, 0, toRead = (int)Math.min((long)buffer.length, remaining))) != -1; remaining -= (long)bytesRead) {
                    md5.update(buffer, 0, bytesRead);
                }
            }
        }
        md5.update(UnifiedHashCalculator.longToBytes(fileSize));
        return UnifiedHashCalculator.bytesToHex(md5.digest());
    }

    private static String calculateHeaderTailHash(File file) throws IOException {
        long fileSize;
        MessageDigest md5;
        block8: {
            md5 = UnifiedHashCalculator.getMD5Digest();
            fileSize = file.length();
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                int bytesRead;
                int toRead;
                int bytesRead2;
                byte[] buffer = new byte[65536];
                raf.seek(0L);
                for (long headerRemaining = Math.min(262144L, fileSize); headerRemaining > 0L && (bytesRead2 = raf.read(buffer, 0, toRead = (int)Math.min((long)buffer.length, headerRemaining))) != -1; headerRemaining -= (long)bytesRead2) {
                    md5.update(buffer, 0, bytesRead2);
                }
                if (fileSize <= 524288L) break block8;
                raf.seek(fileSize - 262144L);
                for (long tailRemaining = 262144L; tailRemaining > 0L; tailRemaining -= (long)bytesRead) {
                    int toRead2 = (int)Math.min((long)buffer.length, tailRemaining);
                    bytesRead = raf.read(buffer, 0, toRead2);
                    if (bytesRead == -1) {
                        break;
                    }
                    md5.update(buffer, 0, bytesRead);
                }
            }
        }
        md5.update(UnifiedHashCalculator.longToBytes(fileSize));
        return UnifiedHashCalculator.bytesToHex(md5.digest());
    }

    private static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(value >> 8 * i);
        }
        return bytes;
    }

    private static String generateCacheKey(File file) {
        return file.getAbsolutePath() + "_" + file.length() + "_" + file.lastModified();
    }

    private static void putCache(String key, String hash) {
        if ((long)hashCache.size() >= 1000L) {
            String oldestKey = hashCache.keys().nextElement();
            hashCache.remove(oldestKey);
        }
        hashCache.put(key, hash);
    }

    public static void clearCache() {
        hashCache.clear();
        logger.info("\u54c8\u5e0c\u7f13\u5b58\u5df2\u6e05\u7406");
    }

    public static String getCacheStats() {
        return String.format("\u7f13\u5b58\u5927\u5c0f: %d/%d", hashCache.size(), 1000L);
    }

    public static String getProcessingStrategy(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return "\u65e0\u6548\u6587\u4ef6";
        }
        long fileSize = file.length();
        if (fileSize == 0L) {
            return "0\u5b57\u8282\u6587\u4ef6 -> \u56fa\u5b9a\u54c8\u5e0c";
        }
        if (UnifiedHashCalculator.isBatchTransferFile(file)) {
            if (fileSize <= 65536L) {
                return String.format("\u6279\u6b21\u5305\u6587\u4ef6(\u5c0f) -> \u5b8c\u6574MD5\u54c8\u5e0c (%s)", UnifiedHashCalculator.formatSize(fileSize));
            }
            if (fileSize <= 0xA00000L) {
                return String.format("\u6279\u6b21\u5305\u6587\u4ef6(\u4e2d) -> %d\u6bb5MD5\u54c8\u5e0c (%s)", 5, UnifiedHashCalculator.formatSize(fileSize));
            }
            return String.format("\u6279\u6b21\u5305\u6587\u4ef6(\u5927) -> \u5934\u5c3eMD5\u54c8\u5e0c (%s)", UnifiedHashCalculator.formatSize(fileSize));
        }
        if (fileSize <= 512L) {
            return String.format("\u666e\u901a\u6587\u4ef6(\u5fae) -> \u5b8c\u6574MD5\u54c8\u5e0c (%s)", UnifiedHashCalculator.formatSize(fileSize));
        }
        if (fileSize <= 65536L) {
            return String.format("\u666e\u901a\u6587\u4ef6(\u5c0f) -> \u5b8c\u6574MD5\u54c8\u5e0c (%s)", UnifiedHashCalculator.formatSize(fileSize));
        }
        if (fileSize <= 0xA00000L) {
            return String.format("\u666e\u901a\u6587\u4ef6(\u4e2d) -> %d\u6bb5MD5\u54c8\u5e0c (%s)", 5, UnifiedHashCalculator.formatSize(fileSize));
        }
        return String.format("\u666e\u901a\u6587\u4ef6(\u5927) -> \u5934\u5c3eMD5\u54c8\u5e0c (%s)", UnifiedHashCalculator.formatSize(fileSize));
    }

    private static String formatSize(long size) {
        if (size < 1024L) {
            return size + "B";
        }
        if (size < 0x100000L) {
            return String.format("%.1fKB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.1fMB", (double)size / 1048576.0);
        }
        return String.format("%.1fGB", (double)size / 1.073741824E9);
    }
}

