/*
 * Decompiled with CFR 0.152.
 */
package com.test.pake;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SimplePAKE {
    private static final BigInteger PRIME = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger GENERATOR = BigInteger.valueOf(2L);
    private static final SecureRandom RANDOM = new SecureRandom();

    public static void demonstrate_pake() {
        System.out.println("=== PAKE \u5bc6\u94a5\u4ea4\u6362\u6f14\u793a ===");
        String password = "shared_secret_password";
        PAKEParty alice = new PAKEParty(password);
        PAKEParty bob = new PAKEParty(password);
        System.out.println("1. Alice \u548c Bob \u90fd\u77e5\u9053\u76f8\u540c\u7684\u5bc6\u7801");
        System.out.println("2. \u751f\u6210\u516c\u5f00\u503c...");
        BigInteger alice_public = alice.generate_public_value();
        BigInteger bob_public = bob.generate_public_value();
        System.out.println("   Alice \u516c\u5f00\u503c\u957f\u5ea6: " + alice_public.bitLength() + " bits");
        System.out.println("   Bob \u516c\u5f00\u503c\u957f\u5ea6: " + bob_public.bitLength() + " bits");
        System.out.println("3. \u8ba1\u7b97\u5171\u4eab\u5bc6\u94a5...");
        alice.compute_shared_key(bob_public);
        bob.compute_shared_key(alice_public);
        boolean keys_match = alice.get_shared_key().equals(bob.get_shared_key());
        System.out.println("   \u5171\u4eab\u5bc6\u94a5\u662f\u5426\u5339\u914d: " + keys_match);
        System.out.println("   \u5171\u4eab\u5bc6\u94a5\u957f\u5ea6: " + alice.get_shared_key().bitLength() + " bits");
        System.out.println("4. \u76f8\u4e92\u8ba4\u8bc1...");
        byte[] alice_auth = alice.generate_auth_code("Alice");
        byte[] bob_auth = bob.generate_auth_code("Bob");
        boolean alice_verified = bob.verify_auth_code(alice_auth, "Alice");
        boolean bob_verified = alice.verify_auth_code(bob_auth, "Bob");
        System.out.println("   Alice \u8ba4\u8bc1\u901a\u8fc7: " + alice_verified);
        System.out.println("   Bob \u8ba4\u8bc1\u901a\u8fc7: " + bob_verified);
        if (keys_match && alice_verified && bob_verified) {
            System.out.println("\n\u2713 PAKE \u534f\u8bae\u6267\u884c\u6210\u529f\uff01\u53cc\u65b9\u5efa\u7acb\u4e86\u5b89\u5168\u7684\u5171\u4eab\u5bc6\u94a5");
        } else {
            System.out.println("\n\u2717 PAKE \u534f\u8bae\u6267\u884c\u5931\u8d25");
        }
    }

    public static void demonstrate_wrong_password() {
        System.out.println("\n=== \u9519\u8bef\u5bc6\u7801\u6f14\u793a ===");
        PAKEParty alice = new PAKEParty("correct_password");
        PAKEParty bob = new PAKEParty("wrong_password");
        System.out.println("1. Alice \u548c Bob \u4f7f\u7528\u4e0d\u540c\u7684\u5bc6\u7801");
        BigInteger alice_public = alice.generate_public_value();
        BigInteger bob_public = bob.generate_public_value();
        alice.compute_shared_key(bob_public);
        bob.compute_shared_key(alice_public);
        boolean keys_match = alice.get_shared_key().equals(bob.get_shared_key());
        System.out.println("2. \u5171\u4eab\u5bc6\u94a5\u662f\u5426\u5339\u914d: " + keys_match);
        byte[] alice_auth = alice.generate_auth_code("Alice");
        boolean alice_verified = bob.verify_auth_code(alice_auth, "Alice");
        System.out.println("3. Alice \u8ba4\u8bc1\u901a\u8fc7: " + alice_verified);
        System.out.println("4. \u2713 \u7cfb\u7edf\u6b63\u786e\u68c0\u6d4b\u5230\u5bc6\u7801\u4e0d\u5339\u914d");
    }

    public static void main(String[] args) {
        SimplePAKE.demonstrate_pake();
        SimplePAKE.demonstrate_wrong_password();
    }

    public static class PAKEParty {
        private final String password;
        private final BigInteger private_key;
        private BigInteger public_value;
        private BigInteger shared_key;

        public PAKEParty(String password) {
            this.password = password;
            this.private_key = new BigInteger(2047, RANDOM).add(BigInteger.ONE);
        }

        public BigInteger generate_public_value() {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] password_hash = md.digest(this.password.getBytes("UTF-8"));
                BigInteger password_factor = new BigInteger(1, password_hash).mod(PRIME);
                BigInteger dh_component = GENERATOR.modPow(this.private_key, PRIME);
                BigInteger password_component = GENERATOR.modPow(password_factor, PRIME);
                this.public_value = dh_component.multiply(password_component).mod(PRIME);
                return this.public_value;
            }
            catch (Exception e) {
                throw new RuntimeException("\u751f\u6210\u516c\u5f00\u503c\u5931\u8d25", e);
            }
        }

        public void compute_shared_key(BigInteger other_public_value) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] password_hash = md.digest(this.password.getBytes("UTF-8"));
                BigInteger password_factor = new BigInteger(1, password_hash).mod(PRIME);
                BigInteger password_component = GENERATOR.modPow(password_factor, PRIME);
                BigInteger dh_value = other_public_value.multiply(password_component.modInverse(PRIME)).mod(PRIME);
                this.shared_key = dh_value.modPow(this.private_key, PRIME);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8ba1\u7b97\u5171\u4eab\u5bc6\u94a5\u5931\u8d25", e);
            }
        }

        public byte[] generate_auth_code(String identifier) {
            try {
                if (this.shared_key == null) {
                    throw new IllegalStateException("\u5fc5\u987b\u5148\u8ba1\u7b97\u5171\u4eab\u5bc6\u94a5");
                }
                byte[] key_bytes = this.shared_key.toByteArray();
                SecretKeySpec key_spec = new SecretKeySpec(key_bytes, "HmacSHA256");
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(key_spec);
                return mac.doFinal(identifier.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("\u751f\u6210\u8ba4\u8bc1\u7801\u5931\u8d25", e);
            }
        }

        public boolean verify_auth_code(byte[] received_code, String identifier) {
            byte[] expected_code = this.generate_auth_code(identifier);
            return Arrays.equals(expected_code, received_code);
        }

        public BigInteger get_shared_key() {
            return this.shared_key;
        }
    }
}

