/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import org.nutz.dao.TableName;
import org.nutz.lang.segment.CharSegment;

public abstract class EntityName {
    public static EntityName create(String s) {
        CharSegment seg = new CharSegment(s);
        if (seg.keys().size() > 0) {
            return new DynamicEntityName(seg);
        }
        return new StaticEntityName(s);
    }

    public abstract String value();

    public abstract String getOrignalString();

    public String toString() {
        return this.value();
    }

    public static class DynamicEntityName
    extends EntityName {
        private CharSegment segment;

        private DynamicEntityName(CharSegment seg) {
            this.segment = seg;
        }

        @Override
        public String value() {
            return TableName.render(this.segment);
        }

        @Override
        public String getOrignalString() {
            return this.segment.getOrginalString();
        }
    }

    public static class StaticEntityName
    extends EntityName {
        private String value;

        private StaticEntityName(String s) {
            this.value = s;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String getOrignalString() {
            return this.value;
        }
    }
}

