/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.nutz.dao.Dao;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.SimpleDataSource;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DaoUp {
    private static final Log log = Logs.get();
    protected static DaoUp me = new DaoUp("_defult_");
    protected static Class<?> druidFactoryClass;
    protected boolean autoCloseWhenFinalize = true;
    protected Dao dao;
    protected DataSource dataSource;
    protected String name;

    public static DaoUp me() {
        return me;
    }

    protected DaoUp(String name) {
        this.name = name;
    }

    public Dao dao() {
        return this.dao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.setDao(new NutDao(dataSource));
    }

    public void setDao(Dao dao) {
        if (this.dao != null) {
            log.infof("override old Dao=%s by new Dao=%s", this.dao, dao);
        }
        this.dao = dao;
    }

    public void init(String name) throws IOException {
        this.init(new FileInputStream(Files.findFile(name)));
    }

    public void init(File f) throws IOException {
        this.init(new FileInputStream(f));
    }

    public void init(InputStream in) throws IOException {
        Properties props = new Properties();
        try {
            props.load(in);
            this.init(props);
        }
        finally {
            Streams.safeClose(in);
        }
    }

    public void init(Properties props) {
        if (this.dao != null) {
            throw new IllegalArgumentException("DaoUp is inited!!");
        }
        if (props.size() == 0) {
            throw new IllegalArgumentException("DaoUp props size=0!!!");
        }
        DataSource ds = this.buildDataSource(props);
        this.setDataSource(ds);
    }

    protected DataSource buildDataSource(Properties props) {
        if (druidFactoryClass != null) {
            log.debug("build DruidDataSource by props");
            Mirror<Class<?>> mirror = Mirror.me(druidFactoryClass);
            DataSource ds = (DataSource)mirror.invoke(null, "createDataSource", props);
            if (!props.containsKey("maxWait")) {
                Mirror.me(ds).setValue((Object)ds, "maxWait", (Object)15000);
            }
            return ds;
        }
        log.debug("build SimpleteDataSource by props");
        return SimpleDataSource.createDataSource(props);
    }

    public synchronized void close() {
        if (this.dao == null) {
            return;
        }
        log.infof("shutdown DaoUp(name=%s)", this.name);
        try {
            Mirror.me(this.dataSource).invoke(this.dataSource, "close", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dataSource = null;
        this.dao = null;
    }

    public void setAutoCloseWhenFinalize(boolean autoCloseWhenFinalize) {
        this.autoCloseWhenFinalize = autoCloseWhenFinalize;
        if (!autoCloseWhenFinalize) {
            log.warnf("DaoUp[%s] autoCloseWhenFinalize is disabled. You had been WARN!!", this.name);
        }
    }

    protected void finalize() throws Throwable {
        if (this.autoCloseWhenFinalize) {
            this.close();
        }
        super.finalize();
    }

    static {
        try {
            druidFactoryClass = Lang.loadClass("com.alibaba.druid.pool.DruidDataSourceFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

