/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.json.Json;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.util.NutMap;
import org.nutz.repo.Base64;

public class Request {
    private String url;
    private METHOD method;
    private String methodString;
    private Header header;
    private Map<String, Object> params;
    private byte[] data;
    private URL cacheUrl;
    private InputStream inputStream;
    private String enc = "UTF-8";
    private boolean offEncode;

    public static Request get(String url) {
        return Request.create(url, METHOD.GET, new HashMap<String, Object>());
    }

    public static Request get(String url, Header header) {
        return Request.create(url, METHOD.GET, new HashMap<String, Object>(), header);
    }

    public static Request post(String url) {
        return Request.create(url, METHOD.POST, new HashMap<String, Object>());
    }

    public static Request post(String url, Header header) {
        return Request.create(url, METHOD.POST, new HashMap<String, Object>(), header);
    }

    public static Request create(String url, METHOD method) {
        return Request.create(url, method, new HashMap<String, Object>());
    }

    public static Request create(String url, METHOD method, String paramsAsJson, Header header) {
        return Request.create(url, method, Json.fromJson(NutMap.class, (CharSequence)paramsAsJson), header);
    }

    public static Request create(String url, METHOD method, String paramsAsJson) {
        return Request.create(url, method, Json.fromJson(NutMap.class, (CharSequence)paramsAsJson));
    }

    public static Request create(String url, METHOD method, Map<String, Object> params) {
        return Request.create(url, method, params, Header.create());
    }

    public static Request create(String url, METHOD method, Map<String, Object> params, Header header) {
        return new Request().setMethod(method).setParams(params).setUrl(url).setHeader(header);
    }

    private Request() {
    }

    public Request offEncode(boolean off) {
        this.offEncode = off;
        return this;
    }

    public URL getUrl() {
        if (this.cacheUrl != null) {
            return this.cacheUrl;
        }
        StringBuilder sb = new StringBuilder(this.url);
        try {
            if (this.isGet() && null != this.params && this.params.size() > 0) {
                sb.append(this.url.indexOf(63) >= 0 ? (char)'&' : '?');
                sb.append(this.getURLEncodedParams());
            }
            this.cacheUrl = new URL(sb.toString());
            return this.cacheUrl;
        }
        catch (Exception e) {
            throw new HttpException(sb.toString(), e);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getURLEncodedParams() {
        final StringBuilder sb = new StringBuilder();
        if (this.params != null) {
            for (Map.Entry<String, Object> en : this.params.entrySet()) {
                final String key = en.getKey();
                Object val = en.getValue();
                if (val == null) {
                    val = "";
                }
                Lang.each(val, new Each<Object>(){

                    @Override
                    public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                        if (Request.this.offEncode) {
                            sb.append(key).append('=').append(ele).append('&');
                        } else {
                            sb.append(Http.encode(key, Request.this.enc)).append('=').append(Http.encode(ele, Request.this.enc)).append('&');
                        }
                    }
                });
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.header.get("Content-Type") == null) {
            this.header.asFormContentType(this.enc);
        }
        if (null == this.data) {
            try {
                return new ByteArrayInputStream(this.getURLEncodedParams().getBytes(this.enc));
            }
            catch (UnsupportedEncodingException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new ByteArrayInputStream(this.data);
    }

    public Request setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public Request setData(byte[] data) {
        this.data = data;
        return this;
    }

    public Request setData(String data) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public Request setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public Request setUrl(String url) {
        this.url = url != null && !url.contains("://") ? "http://" + url : url;
        return this;
    }

    public METHOD getMethod() {
        return this.method;
    }

    public boolean isGet() {
        return METHOD.GET == this.method;
    }

    public boolean isPost() {
        return METHOD.POST == this.method;
    }

    public boolean isDelete() {
        return METHOD.DELETE == this.method;
    }

    public boolean isPut() {
        return METHOD.PUT == this.method;
    }

    public Request setMethod(METHOD method) {
        this.method = method;
        return this;
    }

    public Header getHeader() {
        return this.header;
    }

    public Request setHeader(Header header) {
        if (header == null) {
            header = new Header();
        }
        this.header = header;
        return this;
    }

    public Request setCookie(Cookie cookie) {
        this.header.set("Cookie", cookie.toString());
        return this;
    }

    public Cookie getCookie() {
        String s = this.header.get("Cookie");
        if (null == s) {
            return new Cookie();
        }
        return new Cookie(s);
    }

    public Request setEnc(String reqEnc) {
        if (reqEnc != null) {
            this.enc = reqEnc;
        }
        return this;
    }

    public String getEnc() {
        return this.enc;
    }

    public Request header(String key, String value) {
        this.getHeader().set(key, value);
        return this;
    }

    public Request setMethodString(String methodString) {
        try {
            this.method = METHOD.valueOf(methodString.toUpperCase());
        }
        catch (Throwable e) {
            this.methodString = methodString;
        }
        return this;
    }

    public String getMethodString() {
        return this.methodString;
    }

    public Request basicAuth(String user, String password) {
        this.header("Authorization", "Basic " + Base64.encodeToString((user + ":" + password).getBytes(), false));
        return this;
    }

    public boolean hasInputStream() {
        return this.inputStream != null;
    }

    public static enum METHOD {
        GET,
        POST,
        OPTIONS,
        PUT,
        PATCH,
        DELETE,
        TRACE,
        CONNECT,
        HEAD;

    }
}

