/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.math.BigDecimal;
import org.nutz.lang.Strings;

public class FloatRange {
    private float left;
    private float right;

    public static FloatRange make(String s) {
        char c;
        int i;
        char[] cs = Strings.trim(s).toCharArray();
        for (i = 0; i < cs.length && (c = cs[i]) != ',' && c != ':'; ++i) {
        }
        if (i == cs.length) {
            return FloatRange.make(Float.parseFloat(new String(cs)));
        }
        float left = Float.parseFloat(String.valueOf(cs, 0, i));
        return FloatRange.make(left, Float.parseFloat(String.valueOf(cs, ++i, cs.length - i)));
    }

    public static FloatRange make(float right) {
        return FloatRange.make(0.0f, right);
    }

    public static FloatRange make(float left, float right) {
        return new FloatRange(left, right);
    }

    private FloatRange(float left, float right) {
        this.left = left;
        this.right = right;
    }

    public boolean in(float n) {
        return n > this.left && n < this.right;
    }

    public boolean on(float n) {
        return new BigDecimal(n).equals(new BigDecimal(this.left)) || new BigDecimal(n).equals(new BigDecimal(this.right));
    }

    public boolean inon(float n) {
        return this.on(n) || this.in(n);
    }

    public boolean gt(float n) {
        return n < this.left;
    }

    public boolean lt(float n) {
        return n > this.right;
    }

    public boolean linon(float n) {
        return n >= this.left && n < this.right;
    }

    public boolean rinon(float n) {
        return n > this.left && n <= this.right;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getRight() {
        return this.right;
    }

    public void setRight(float right) {
        this.right = right;
    }

    public String toString() {
        return String.format("%s:%s", Float.valueOf(this.left), Float.valueOf(this.right));
    }
}

