/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;

public class LinkedByteBuffer {
    private int maxCapacity;
    private int capacity;
    private int limit;
    private int rIndex;
    private int wIndex;
    private int unit;
    private ArrayList<byte[]> list;

    public LinkedByteBuffer() {
        this(8192, 10, 0xA00000);
    }

    public LinkedByteBuffer(int nb) {
        this(8192, nb, 0xA00000);
    }

    public LinkedByteBuffer(int unit, int nb) {
        this(unit, nb, 0xA00000);
    }

    public LinkedByteBuffer(int unit, int nb, int maxLimit) {
        this.unit = unit;
        this.capacity = unit * nb;
        this.limit = 0;
        this.rIndex = 0;
        this.wIndex = 0;
        this.maxCapacity = maxLimit;
        this.list = new ArrayList(nb);
        for (int i = 0; i < nb; ++i) {
            this.list.add(new byte[unit]);
        }
    }

    public void reset() {
        this.limit = 0;
        this.rIndex = 0;
        this.wIndex = 0;
    }

    public int skipRead(int off) {
        return this.seekRead(this.rIndex + off);
    }

    public int seekRead(int pos) {
        this.rIndex = Math.max(0, Math.min(pos, this.limit));
        return this.rIndex;
    }

    public int skipWrite(int off) {
        return this.seekWrite(this.wIndex + off);
    }

    public int seekWrite(int pos) {
        this.wIndex = Math.max(0, Math.min(pos, this.limit));
        return this.wIndex;
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        int i;
        if (this.capacity + len > this.maxCapacity) {
            throw new IOException("Output of MaxLimitation " + this.maxCapacity);
        }
        int remain = this.capacity - this.wIndex;
        if (len > remain) {
            int space = len - remain;
            int n = space / this.unit;
            if (n * this.unit < space) {
                ++n;
            }
            for (int i2 = 0; i2 < n; ++i2) {
                this.list.add(new byte[this.unit]);
            }
            this.capacity = this.list.size() * this.unit;
        }
        int row = this.wIndex / this.unit;
        int col = this.wIndex - row * this.unit;
        int padLen = len + col;
        int r_count = padLen / this.unit;
        byte[] tag = this.list.get(row);
        int x = off;
        int n = Math.min(this.unit - col, len);
        int c = 0;
        System.arraycopy(buf, x, tag, col, n);
        c += n;
        x += n;
        for (i = 1; i < r_count; ++i) {
            tag = this.list.get(row + i);
            System.arraycopy(buf, x, tag, 0, this.unit);
            c += this.unit;
            x += this.unit;
        }
        if (c < len) {
            tag = this.list.get(row + i);
            n = len - c;
            System.arraycopy(buf, x, tag, 0, n);
        }
        this.wIndex += len;
        this.limit = Math.max(this.limit, this.wIndex);
    }

    public void write(String str) throws IOException {
        byte[] buf = str.getBytes(Encoding.CHARSET_UTF8);
        this.write(buf);
    }

    public void writeLine(String str) throws IOException {
        byte[] buf = str.getBytes(Encoding.CHARSET_UTF8);
        byte[] nwl = System.lineSeparator().getBytes();
        this.write(buf);
        this.write(nwl);
    }

    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) {
        int i;
        int remain = this.limit - this.rIndex;
        if (remain <= 0) {
            return -1;
        }
        if (0 >= (len = Math.min(len, remain))) {
            return len;
        }
        int row = this.rIndex / this.unit;
        int col = this.rIndex - row * this.unit;
        int padLen = len + col;
        int r_count = padLen / this.unit;
        byte[] src = this.list.get(row);
        int x = off;
        int n = Math.min(this.unit - col, len);
        int c = 0;
        System.arraycopy(src, col, buf, x, n);
        c += n;
        x += n;
        for (i = 1; i < r_count; ++i) {
            src = this.list.get(row + i);
            System.arraycopy(src, 0, buf, x, this.unit);
            c += this.unit;
            x += this.unit;
        }
        if (c < len) {
            src = this.list.get(row + i);
            n = len - c;
            System.arraycopy(src, col, buf, x, n);
        }
        this.rIndex += len;
        return len;
    }

    public String readLine() {
        int row;
        if (this.rIndex >= this.limit) {
            return null;
        }
        int col = this.rIndex - row * this.unit;
        int max = this.limit - this.rIndex;
        int count = 0;
        boolean found = false;
        for (row = this.rIndex / this.unit; row < this.list.size(); ++row) {
            byte[] bs = this.list.get(row);
            while (col < this.unit) {
                byte b = bs[col];
                if (b == 10 || ++count >= max) {
                    found = true;
                    break;
                }
                ++col;
            }
            if (found) break;
            col = 0;
        }
        byte[] buf = new byte[count];
        this.read(buf);
        int i = buf.length - 1;
        if (buf[i] == 10) {
            --i;
        }
        if (buf[i] == 13) {
            --i;
        }
        if (buf[i] != 10) {
            ++i;
        }
        return new String(buf, 0, i, Encoding.CHARSET_UTF8);
    }

    public String readAll() {
        int len = this.limit - this.rIndex;
        if (len <= 0) {
            return null;
        }
        byte[] buf = new byte[len];
        this.read(buf);
        return new String(buf, Encoding.CHARSET_UTF8);
    }

    public byte get(int index) {
        if (this.isEmpty()) {
            return -1;
        }
        index = index < 0 ? Math.max(0, this.limit + index) : Math.min(index, this.limit - 1);
        int row = index / this.unit;
        int col = index - row * this.unit;
        return this.list.get(row)[col];
    }

    public void set(int index, int b) {
        if (this.isEmpty()) {
            return;
        }
        index = index < 0 ? Math.max(0, this.limit + index) : Math.min(index, this.limit - 1);
        int row = index / this.unit;
        int col = index - row * this.unit;
        this.list.get((int)row)[col] = (byte)b;
    }

    public boolean isEmpty() {
        return this.limit <= 0;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getLimit() {
        return this.limit;
    }

    public int truncate(int limit) {
        this.limit = Math.min(this.limit, limit);
        return this.limit;
    }

    public int getWriteIndex() {
        return this.wIndex;
    }

    public int getReadIndex() {
        return this.rIndex;
    }

    public int getUnit() {
        return this.unit;
    }

    public String sha1sum() {
        try {
            return this.digest("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public String md5sum() {
        try {
            return this.digest("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public String digest(String algorithm) throws NoSuchAlgorithmException {
        int row;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        int count = this.limit / this.unit;
        for (row = 0; row < count; ++row) {
            byte[] buf = this.list.get(row);
            md.update(buf);
        }
        int n = this.limit - count * this.unit;
        if (n > 0) {
            byte[] buf = this.list.get(row);
            md.update(buf, 0, n);
        }
        byte[] hashBytes = md.digest();
        return Lang.fixedHexString(hashBytes);
    }

    public byte[] toArray() {
        int from;
        int to;
        byte[] re = new byte[this.limit];
        for (int i = 0; i < this.list.size() && (to = Math.min(this.limit, (from = i * this.unit) + this.unit)) > from; ++i) {
            int len = to - from;
            byte[] src = this.list.get(i);
            System.arraycopy(src, 0, re, from, len);
        }
        return re;
    }

    public String toString() {
        byte[] bs = this.toArray();
        return new String(bs, Encoding.CHARSET_UTF8);
    }
}

