/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log.impl;

import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.impl.AbstractLog;
import org.nutz.log.impl.Slf4jLogger;
import org.nutz.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogAdapter
implements LogAdapter,
Plugin {
    @Override
    public Log getLogger(String className) {
        Logger logger = LoggerFactory.getLogger(className);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLogger((LocationAwareLogger)logger);
        }
        return new SimpleSlf4jLogger(logger);
    }

    @Override
    public boolean canWork() {
        try {
            Logger.class.getName();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static class SimpleSlf4jLogger
    extends AbstractLog {
        protected Logger logger;

        public SimpleSlf4jLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.logger.warn(String.valueOf(message), t);
        }

        @Override
        public void trace(Object message, Throwable t) {
            this.logger.trace(String.valueOf(message), t);
        }

        @Override
        public void info(Object message, Throwable t) {
            this.logger.info(String.valueOf(message), t);
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.logger.error(String.valueOf(message), t);
        }

        @Override
        public void error(Object message, Throwable t) {
            this.logger.error(String.valueOf(message), t);
        }

        @Override
        public void debug(Object message, Throwable t) {
            this.logger.debug(String.valueOf(message), t);
        }

        @Override
        protected void log(int level, Object message, Throwable tx) {
            String msg = String.valueOf(message);
            switch (level) {
                case 40: 
                case 50: {
                    this.logger.error(msg, tx);
                    break;
                }
                case 30: {
                    this.logger.warn(msg, tx);
                    break;
                }
                case 20: {
                    this.logger.info(msg, tx);
                    break;
                }
                case 0: {
                    this.logger.trace(msg, tx);
                    break;
                }
                default: {
                    this.logger.debug(msg, tx);
                }
            }
        }
    }
}

