/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.util.ArrayList;
import java.util.List;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.RequestMatcher;
import org.nutz.mvc.impl.reqmatcher.ApiVersionRequestMatcher;
import org.nutz.mvc.impl.reqmatcher.DefaultRequestMatcher;

public class ActionInvoker {
    private static final Log log = Logs.get();
    protected List<RequestMatcher> matchers;
    protected DefaultRequestMatcher dft = new DefaultRequestMatcher();

    public ActionInvoker() {
        this.matchers = new ArrayList<RequestMatcher>(2);
        this.matchers.add(new ApiVersionRequestMatcher());
        this.matchers.add(this.dft);
    }

    public void add(String path, ActionInfo ai, ActionChain chain) {
        for (RequestMatcher matcher : this.matchers) {
            matcher.add(path, ai, chain);
        }
    }

    public ActionChain getActionChain(ActionContext ac) {
        for (RequestMatcher matcher : this.matchers) {
            ActionChain chain = matcher.match(ac);
            if (chain == null) continue;
            ac.set("nutz.mvc.current.chain", chain);
            return chain;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Not chain for req (path=%s, method=%s)", ac.getPath(), ac.getRequest().getMethod());
        }
        return null;
    }

    public boolean invoke(ActionContext ac) {
        ActionChain chain = (ActionChain)ac.remove("nutz.mvc.current.chain");
        chain.doChain(ac);
        return ac.getBoolean("nutz.mvc.done", true);
    }

    public void addChain(String httpMethod, ActionChain chain) {
        this.dft.setDefaultChain(chain);
    }

    public void setDefaultChain(ActionChain defaultChain) {
        this.dft.setDefaultChain(defaultChain);
    }

    public void setMatchers(List<RequestMatcher> matchers) {
        this.matchers = matchers;
    }

    public List<RequestMatcher> getMatchers() {
        return this.matchers;
    }
}

