/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.codec.JsonMessageDecoder;
import com.file.netty.codec.JsonMessageEncoder;
import com.file.netty.codec.MessageDecoder;
import com.file.netty.codec.MessageEncoder;
import com.file.netty.codec.RelayMessageDecoder;
import com.file.netty.codec.RelayMessageEncoder;
import com.file.netty.config.EncryptionConfig;
import com.file.netty.utils.EncryptionUtils;
import io.netty.channel.ChannelPipeline;
import javax.crypto.SecretKey;

public class CodecFactory {
    private static final String USE_JSON_CODEC_PROPERTY = "file.transfer.use.json.codec";

    public static void addClientCodec(ChannelPipeline pipeline) {
        if (CodecFactory.useJsonCodec()) {
            CodecFactory.addJsonClientCodec(pipeline);
        } else {
            CodecFactory.addOriginalClientCodec(pipeline);
        }
    }

    public static void addRelayCodec(ChannelPipeline pipeline) {
        if (CodecFactory.useJsonCodec()) {
            CodecFactory.addJsonRelayCodec(pipeline);
        } else {
            CodecFactory.addOriginalRelayCodec(pipeline);
        }
    }

    public static void addJsonClientCodec(ChannelPipeline pipeline) {
        if (EncryptionConfig.isEncryptionEnabled()) {
            CodecFactory.addJsonClientCodecWithEncryption(pipeline, EncryptionConfig.getCurrentKey());
        } else {
            CodecFactory.addJsonClientCodecWithoutEncryption(pipeline);
        }
    }

    public static void addJsonRelayCodec(ChannelPipeline pipeline) {
        JsonMessageDecoder decoder = new JsonMessageDecoder();
        JsonMessageEncoder encoder = new JsonMessageEncoder();
        decoder.setDecryptionEnabled(false);
        encoder.setEncryptionEnabled(false);
        pipeline.addLast(decoder);
        pipeline.addLast(encoder);
    }

    public static void addJsonClientCodecWithEncryption(ChannelPipeline pipeline, SecretKey key) {
        pipeline.addLast(new JsonMessageDecoder(key));
        pipeline.addLast(new JsonMessageEncoder(key));
    }

    public static void addJsonClientCodecWithoutEncryption(ChannelPipeline pipeline) {
        JsonMessageDecoder decoder = new JsonMessageDecoder();
        JsonMessageEncoder encoder = new JsonMessageEncoder();
        decoder.setDecryptionEnabled(false);
        encoder.setEncryptionEnabled(false);
        pipeline.addLast(decoder);
        pipeline.addLast(encoder);
    }

    public static void addJsonClientCodecWithPassword(ChannelPipeline pipeline, String password) {
        SecretKey key = EncryptionUtils.generateKeyFromPassword(password);
        CodecFactory.addJsonClientCodecWithEncryption(pipeline, key);
    }

    private static boolean useJsonCodec() {
        return Boolean.parseBoolean(System.getProperty(USE_JSON_CODEC_PROPERTY, "true"));
    }

    private static void addOriginalClientCodec(ChannelPipeline pipeline) {
        if (EncryptionConfig.isEncryptionEnabled()) {
            CodecFactory.addClientCodecWithEncryption(pipeline, EncryptionConfig.getCurrentKey());
        } else {
            CodecFactory.addClientCodecWithoutEncryption(pipeline);
        }
    }

    private static void addOriginalRelayCodec(ChannelPipeline pipeline) {
        pipeline.addLast(new RelayMessageDecoder());
        pipeline.addLast(new RelayMessageEncoder());
    }

    public static void addClientCodecWithEncryption(ChannelPipeline pipeline, SecretKey key) {
        pipeline.addLast(new MessageDecoder(key));
        pipeline.addLast(new MessageEncoder(key));
    }

    public static void addClientCodecWithEncryption(ChannelPipeline pipeline) {
        CodecFactory.addClientCodecWithEncryption(pipeline, EncryptionUtils.getDefaultKey());
    }

    public static void addClientCodecWithoutEncryption(ChannelPipeline pipeline) {
        MessageDecoder decoder = new MessageDecoder();
        MessageEncoder encoder = new MessageEncoder();
        decoder.setDecryptionEnabled(false);
        encoder.setEncryptionEnabled(false);
        pipeline.addLast(decoder);
        pipeline.addLast(encoder);
    }

    public static void addClientCodec(ChannelPipeline pipeline, boolean enableEncryption) {
        if (enableEncryption) {
            CodecFactory.addClientCodecWithEncryption(pipeline);
        } else {
            CodecFactory.addClientCodecWithoutEncryption(pipeline);
        }
    }

    public static void addClientCodecWithPassword(ChannelPipeline pipeline, String password) {
        SecretKey key = EncryptionUtils.generateKeyFromPassword(password);
        CodecFactory.addClientCodecWithEncryption(pipeline, key);
    }
}

