/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.protocol.Message;
import com.file.netty.utils.EncryptionUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEncoder
extends MessageToByteEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    private SecretKey encryptionKey;
    private boolean encryptionEnabled = true;

    public MessageEncoder() {
        this.encryptionKey = EncryptionUtils.getDefaultKey();
    }

    public MessageEncoder(SecretKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) throws Exception {
        Message processedMessage = msg;
        if (this.encryptionEnabled) {
            processedMessage = EncryptionUtils.encryptMessage(msg, this.encryptionKey);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(processedMessage);
        oos.flush();
        byte[] data = bos.toByteArray();
        oos.close();
        out.writeInt(data.length);
        out.writeBytes(data);
        logger.debug("\u7f16\u7801\u6d88\u606f: {} -> {} bytes", (Object)processedMessage.getType(), (Object)data.length);
    }

    public void setEncryptionKey(SecretKey key) {
        this.encryptionKey = key;
    }

    public void setEncryptionEnabled(boolean enabled) {
        this.encryptionEnabled = enabled;
    }
}

