/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.protocol.Message;
import com.file.netty.relay.RelayServerConfig;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RelayMessageDecoder.class);

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int length = in.readInt();
        if (length > RelayServerConfig.getMaxMessageSize()) {
            in.resetReaderIndex();
            throw new IllegalArgumentException("\u6d88\u606f\u5927\u5c0f\u8d85\u8fc7\u9650\u5236: " + length + " bytes (\u6700\u5927\u5141\u8bb8: " + RelayServerConfig.getMaxMessageSize() + " bytes)");
        }
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        if (!RelayServerConfig.hasEnoughDirectMemory(length)) {
            in.resetReaderIndex();
            throw new DecoderException("\u76f4\u63a5\u5185\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5904\u7406\u5927\u5c0f\u4e3a " + length + " \u5b57\u8282\u7684\u6d88\u606f");
        }
        byte[] data = new byte[length];
        in.readBytes(data);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            Message message = (Message)ois.readObject();
            out.add(message);
            logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u89e3\u7801\u6d88\u606f: {}", (Object)message.getType());
        }
        catch (OutOfMemoryError e) {
            logger.error("\u53cd\u5e8f\u5217\u5316\u6d88\u606f\u65f6\u5185\u5b58\u6ea2\u51fa: {}", (Object)e.getMessage());
            throw new DecoderException("\u5185\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u53cd\u5e8f\u5217\u5316\u6d88\u606f", e);
        }
    }
}

