/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.codec;

import com.file.netty.protocol.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayMessageEncoder
extends MessageToByteEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(RelayMessageEncoder.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(msg);
        oos.flush();
        byte[] data = bos.toByteArray();
        oos.close();
        out.writeInt(data.length);
        out.writeBytes(data);
        logger.debug("\u4e2d\u7ee7\u670d\u52a1\u5668\u7f16\u7801\u6d88\u606f: {} -> {} bytes", (Object)msg.getType(), (Object)data.length);
    }
}

