/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.config;

import com.file.netty.utils.EncryptionUtils;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionConfig {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionConfig.class);
    private static boolean encryptionEnabled = true;
    private static SecretKey currentKey = null;
    private static String customPassword = null;

    public static void setEncryptionEnabled(boolean enabled) {
        encryptionEnabled = enabled;
        logger.info("\u52a0\u5bc6\u72b6\u6001\u5df2\u53d8\u66f4\u4e3a: {}", (Object)enabled);
    }

    public static boolean isEncryptionEnabled() {
        return encryptionEnabled;
    }

    public static void setCustomPassword(String password) {
        if (password != null && !password.trim().isEmpty()) {
            customPassword = password;
            currentKey = EncryptionUtils.generateKeyFromPassword(password);
            logger.info("\u5df2\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5bc6\u7801\uff0c\u5bc6\u94a5\u5df2\u66f4\u65b0");
        }
    }

    public static SecretKey getCurrentKey() {
        return currentKey;
    }

    public static void resetToDefault() {
        encryptionEnabled = true;
        customPassword = null;
        currentKey = EncryptionUtils.getDefaultKey();
        logger.info("\u52a0\u5bc6\u914d\u7f6e\u5df2\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c");
    }

    public static String getConfigInfo() {
        return String.format("\ud83d\udd12 \u52a0\u5bc6\u542f\u7528: %s, \u4f7f\u7528\u81ea\u5b9a\u4e49\u5bc6\u7801: %s", encryptionEnabled, customPassword != null);
    }

    static {
        currentKey = EncryptionUtils.getDefaultKey();
        logger.info("\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u52a0\u5bc6\u72b6\u6001: {}", (Object)encryptionEnabled);
    }
}

