/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.config;

import com.file.netty.config.RelayInfo;
import com.file.netty.config.RelayPriority;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRelayConfig {
    private static final Logger logger = LoggerFactory.getLogger(MultiRelayConfig.class);
    private static final String CONFIG_FILE_NAME = "relay-config.properties";
    private static final String CONFIG_FILE_PATH = System.getProperty("user.home") + "/.croc/" + "relay-config.properties";
    private static final String ENV_RELAY_SERVERS = "CROC_RELAY_SERVERS";
    private static final Map<String, RelayInfo> relayServers = new ConcurrentHashMap<String, RelayInfo>();

    private static void initializeDefaultRelays() {
        RelayInfo defaultRelay = new RelayInfo("relay.daodaovps.com", 8001, RelayPriority.DEFAULT, "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7");
        relayServers.put(MultiRelayConfig.getRelayKey(defaultRelay), defaultRelay);
        logger.info("\u5df2\u6dfb\u52a0\u9ed8\u8ba4\u4e2d\u7ee7: {}", (Object)defaultRelay);
    }

    private static void loadConfigFromFile() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            logger.debug("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)CONFIG_FILE_PATH);
            return;
        }
        try (FileInputStream is = new FileInputStream(configFile);){
            Properties props = new Properties();
            props.load(is);
            MultiRelayConfig.parseRelayServers(props.getProperty("relay.servers", ""));
            logger.info("\u6210\u529f\u4ece\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u4e2d\u7ee7\u914d\u7f6e: {}", (Object)CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            logger.warn("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private static void loadConfigFromEnvironment() {
        String envServers = System.getenv(ENV_RELAY_SERVERS);
        if (envServers != null && !envServers.trim().isEmpty()) {
            MultiRelayConfig.parseRelayServers(envServers);
            logger.info("\u6210\u529f\u4ece\u73af\u5883\u53d8\u91cf\u52a0\u8f7d\u4e2d\u7ee7\u914d\u7f6e: {}", (Object)ENV_RELAY_SERVERS);
        }
    }

    private static void parseRelayServers(String serversConfig) {
        String[] servers;
        if (serversConfig == null || serversConfig.trim().isEmpty()) {
            return;
        }
        for (String server : servers = serversConfig.split(",")) {
            try {
                String[] parts = server.trim().split(":");
                if (parts.length < 2) continue;
                String host = parts[0].trim();
                int port = Integer.parseInt(parts[1].trim());
                RelayPriority priority = RelayPriority.MEDIUM;
                if (parts.length >= 3) {
                    try {
                        priority = RelayPriority.valueOf(parts[2].trim().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn("\u65e0\u6548\u7684\u4f18\u5148\u7ea7: {}, \u4f7f\u7528\u9ed8\u8ba4\u4f18\u5148\u7ea7", (Object)parts[2]);
                    }
                }
                RelayInfo relayInfo = new RelayInfo(host, port, priority);
                MultiRelayConfig.addRelayServer(relayInfo);
                logger.info("\u6dfb\u52a0\u4e2d\u7ee7\u670d\u52a1\u5668: {}", (Object)relayInfo);
            }
            catch (NumberFormatException e) {
                logger.warn("\u65e0\u6548\u7684\u4e2d\u7ee7\u670d\u52a1\u5668\u914d\u7f6e: {}", (Object)server);
            }
        }
    }

    public static void addRelayServer(RelayInfo relayInfo) {
        String key = MultiRelayConfig.getRelayKey(relayInfo);
        relayServers.put(key, relayInfo);
    }

    public static void removeRelayServer(String host, int port) {
        String key = host + ":" + port;
        relayServers.remove(key);
    }

    public static void setCommandLineRelay(String host, int port) {
        relayServers.entrySet().removeIf(entry -> ((RelayInfo)entry.getValue()).getName().contains("\u547d\u4ee4\u884c\u6307\u5b9a"));
        RelayInfo cmdRelay = new RelayInfo(host, port, RelayPriority.HIGH, "\u547d\u4ee4\u884c\u6307\u5b9a\u4e2d\u7ee7");
        MultiRelayConfig.addRelayServer(cmdRelay);
        logger.info("\u8bbe\u7f6e\u547d\u4ee4\u884c\u4e2d\u7ee7: {}", (Object)cmdRelay);
    }

    public static List<RelayInfo> getOrderedRelayList() {
        return relayServers.values().stream().filter(relay -> relay.getPriority() != RelayPriority.LOCAL).sorted((r1, r2) -> Integer.compare(r2.getConnectionScore(), r1.getConnectionScore())).collect(Collectors.toList());
    }

    public static List<RelayInfo> getAllRelayList() {
        return relayServers.values().stream().sorted((r1, r2) -> Integer.compare(r2.getConnectionScore(), r1.getConnectionScore())).collect(Collectors.toList());
    }

    public static void addLocalRelay(String host, int port) {
        RelayInfo localRelay = new RelayInfo(host, port, RelayPriority.LOCAL, "\u672c\u5730\u4e2d\u7ee7");
        MultiRelayConfig.addRelayServer(localRelay);
        logger.info("\u53d1\u73b0\u672c\u5730\u4e2d\u7ee7: {}", (Object)localRelay);
    }

    public static void removeLocalRelay() {
        relayServers.entrySet().removeIf(entry -> ((RelayInfo)entry.getValue()).getPriority() == RelayPriority.LOCAL);
    }

    public static void markRelaySuccess(String host, int port) {
        String key = host + ":" + port;
        RelayInfo relay = relayServers.get(key);
        if (relay != null) {
            relay.resetFailureCount();
            relay.updateLastConnectTime();
            logger.debug("\u6807\u8bb0\u4e2d\u7ee7\u8fde\u63a5\u6210\u529f: {}", (Object)relay);
        }
    }

    public static void markRelayFailure(String host, int port) {
        String key = host + ":" + port;
        RelayInfo relay = relayServers.get(key);
        if (relay != null) {
            relay.incrementFailureCount();
            logger.debug("\u6807\u8bb0\u4e2d\u7ee7\u8fde\u63a5\u5931\u8d25: {}", (Object)relay);
        }
    }

    public static void saveConfigToFile() {
        try {
            File configDir = new File(CONFIG_FILE_PATH).getParentFile();
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(CONFIG_FILE_PATH);){
                Properties props = new Properties();
                String serversConfig = relayServers.values().stream().filter(relay -> relay.getPriority() != RelayPriority.LOCAL && relay.getPriority() != RelayPriority.DEFAULT).map(relay -> String.format("%s:%d:%s", relay.getHost(), relay.getPort(), relay.getPriority().name())).collect(Collectors.joining(","));
                props.setProperty("relay.servers", serversConfig);
                props.store(os, "Croc Multi-Relay Configuration");
                logger.info("\u914d\u7f6e\u5df2\u4fdd\u5b58\u5230\u6587\u4ef6: {}", (Object)CONFIG_FILE_PATH);
            }
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private static String getRelayKey(RelayInfo relay) {
        return relay.getHost() + ":" + relay.getPort();
    }

    public static String getConfigSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("\u4e2d\u7ee7\u670d\u52a1\u5668\u914d\u7f6e\u7edf\u8ba1:\n");
        Map<RelayPriority, Long> priorityCount = relayServers.values().stream().collect(Collectors.groupingBy(RelayInfo::getPriority, Collectors.counting()));
        for (RelayPriority priority : RelayPriority.values()) {
            long count = priorityCount.getOrDefault((Object)priority, 0L);
            summary.append(String.format("  %s: %d \u4e2a\n", priority.getDescription(), count));
        }
        long healthyCount = relayServers.values().stream().mapToLong(relay -> relay.isHealthy() ? 1L : 0L).sum();
        summary.append(String.format("  \u5065\u5eb7\u72b6\u6001: %d/%d\n", healthyCount, relayServers.size()));
        return summary.toString();
    }

    public static void resetAllRelayHealth() {
        relayServers.values().forEach(RelayInfo::resetFailureCount);
        logger.info("\u5df2\u91cd\u7f6e\u6240\u6709\u4e2d\u7ee7\u7684\u5065\u5eb7\u72b6\u6001");
    }

    static {
        MultiRelayConfig.initializeDefaultRelays();
        MultiRelayConfig.loadConfigFromFile();
        MultiRelayConfig.loadConfigFromEnvironment();
    }
}

