/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.config;

import com.file.netty.codec.RelayMessageDecoder;
import com.file.netty.codec.RelayMessageEncoder;
import com.file.netty.config.MultiRelayConfig;
import com.file.netty.config.RelayInfo;
import com.file.netty.config.RelayPriority;
import com.file.netty.discovery.BroadcastDiscoverer;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMultiRelayManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMultiRelayManager.class);

    public static RelayConnectionInfo getBestRelayInfo(String sessionId) {
        System.out.println("\ud83d\udd0d \u641c\u7d22\u53ef\u7528\u7684\u4e2d\u7ee7\u670d\u52a1\u5668...");
        logger.info("\u5f00\u59cb\u667a\u80fd\u4e2d\u7ee7\u9009\u62e9\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
        System.out.print("\ud83d\udce1 \u68c0\u67e5\u672c\u5730\u7f51\u7edc... ");
        RelayConnectionInfo localRelay = SimpleMultiRelayManager.tryLocalDiscovery(sessionId);
        if (localRelay != null) {
            System.out.println("\u2705 \u53d1\u73b0\u672c\u5730\u4e2d\u7ee7");
            logger.info("\u53d1\u73b0\u672c\u5730\u4e2d\u7ee7: {}", (Object)localRelay);
            MultiRelayConfig.addLocalRelay(localRelay.getHost(), localRelay.getPort());
            return localRelay;
        }
        System.out.println("\u672a\u53d1\u73b0");
        List<RelayInfo> allRelays = MultiRelayConfig.getOrderedRelayList();
        int maxRetries = 2;
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            if (attempt > 1) {
                System.out.println("\ud83d\udd04 \u91cd\u8bd5\u4e2d\u7ee7\u8fde\u63a5... (" + attempt + "/" + maxRetries + ")");
            }
            for (RelayInfo relay : allRelays) {
                if (!relay.isHealthy() || relay.getPriority() == RelayPriority.DEFAULT) continue;
                System.out.print("\ud83d\udce1 \u6d4b\u8bd5 " + relay.getName() + "... ");
                if (SimpleMultiRelayManager.testRelayConnection(relay.getHost(), relay.getPort(), sessionId)) {
                    System.out.println("\u2705 \u8fde\u63a5\u6210\u529f");
                    logger.info("\u5916\u90e8\u4e2d\u7ee7\u8fde\u63a5\u6210\u529f: {}", (Object)relay);
                    return new RelayConnectionInfo(relay.getHost(), relay.getPort(), relay.getPriority(), relay.getName());
                }
                System.out.println("\u274c \u672a\u627e\u5230\u4f1a\u8bdd");
                logger.debug("\u5916\u90e8\u4e2d\u7ee7\u6d4b\u8bd5\u5931\u8d25: {} (\u5c1d\u8bd5 {}/{})", relay, attempt, maxRetries);
                if (attempt != maxRetries) continue;
                SimpleMultiRelayManager.markRelayFailure(relay.getHost(), relay.getPort());
            }
            System.out.print("\ud83d\udce1 \u6d4b\u8bd5\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7... ");
            if (SimpleMultiRelayManager.testRelayConnection("relay.daodaovps.com", 8001, sessionId)) {
                System.out.println("\u2705 \u8fde\u63a5\u6210\u529f");
                logger.info("\u9ed8\u8ba4\u4e2d\u7ee7\u8fde\u63a5\u6210\u529f");
                return new RelayConnectionInfo("relay.daodaovps.com", 8001, RelayPriority.DEFAULT, "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7");
            }
            System.out.println("\u274c \u672a\u627e\u5230\u4f1a\u8bdd");
            logger.debug("\u9ed8\u8ba4\u4e2d\u7ee7\u6d4b\u8bd5\u5931\u8d25 (\u5c1d\u8bd5 {}/{})", (Object)attempt, (Object)maxRetries);
            if (attempt >= maxRetries) continue;
            System.out.print("\u23f3 \u7b49\u5f851\u79d2\u540e\u91cd\u8bd5... ");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            System.out.println();
        }
        System.out.println("\u26a0\ufe0f \u5c1d\u8bd5\u5907\u9009\u8fde\u63a5\u65b9\u5f0f...");
        logger.warn("sessionId\u9a8c\u8bc1\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f20\u7edf\u8fde\u63a5\u65b9\u5f0f...");
        return SimpleMultiRelayManager.getBestRelayInfoFallback();
    }

    public static List<RelayConnectionInfo> getAllAvailableRelays(String sessionId) {
        ArrayList<RelayConnectionInfo> availableRelays = new ArrayList<RelayConnectionInfo>();
        logger.info("\u83b7\u53d6\u6240\u6709\u53ef\u7528\u4e2d\u7ee7\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
        RelayConnectionInfo localRelay = SimpleMultiRelayManager.tryLocalDiscovery(sessionId);
        if (localRelay != null) {
            availableRelays.add(localRelay);
            MultiRelayConfig.addLocalRelay(localRelay.getHost(), localRelay.getPort());
        }
        List<RelayInfo> allRelays = MultiRelayConfig.getOrderedRelayList();
        for (RelayInfo relayInfo : allRelays) {
            if (!relayInfo.isHealthy() || relayInfo.getPriority() == RelayPriority.DEFAULT || !SimpleMultiRelayManager.testSimpleTcpConnection(relayInfo.getHost(), relayInfo.getPort())) continue;
            String displayName = relayInfo.getPriority() == RelayPriority.HIGH ? "\u81ea\u5b9a\u4e49\u4e2d\u7ee7(\u9ad8)" : (relayInfo.getPriority() == RelayPriority.MEDIUM ? "\u81ea\u5b9a\u4e49\u4e2d\u7ee7(\u4e2d)" : (relayInfo.getPriority() == RelayPriority.LOW ? "\u81ea\u5b9a\u4e49\u4e2d\u7ee7(\u4f4e)" : "\u81ea\u5b9a\u4e49\u4e2d\u7ee7"));
            availableRelays.add(new RelayConnectionInfo(relayInfo.getHost(), relayInfo.getPort(), relayInfo.getPriority(), displayName));
        }
        if (SimpleMultiRelayManager.testSimpleTcpConnection("relay.daodaovps.com", 8001)) {
            availableRelays.add(new RelayConnectionInfo("relay.daodaovps.com", 8001, RelayPriority.DEFAULT, "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7"));
        }
        if (availableRelays.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u53ef\u7528\u7684\u4e2d\u7ee7\u670d\u52a1\u5668");
        }
        System.out.println("\ud83d\udd0d \u667a\u80fd\u4e2d\u7ee7\u9009\u62e9: \u53d1\u73b0 " + availableRelays.size() + " \u4e2a\u53ef\u7528\u4e2d\u7ee7");
        for (RelayConnectionInfo relayConnectionInfo : availableRelays) {
            System.out.println("  \ud83d\udce1 " + relayConnectionInfo.getDescription() + ": " + relayConnectionInfo.getHost() + ":" + relayConnectionInfo.getPort());
        }
        return availableRelays;
    }

    private static RelayConnectionInfo getBestRelayInfoFallback() {
        System.out.println("\ud83d\udd27 \u4f7f\u7528TCP\u8fde\u63a5\u6d4b\u8bd5...");
        logger.info("\u4f7f\u7528\u5907\u9009\u8fde\u63a5\u65b9\u6848");
        List<RelayInfo> externalRelays = MultiRelayConfig.getOrderedRelayList();
        for (RelayInfo relay : externalRelays) {
            if (!relay.isHealthy() || relay.getPriority() == RelayPriority.DEFAULT) continue;
            System.out.print("\ud83d\udd27 TCP\u6d4b\u8bd5 " + relay.getName() + "... ");
            if (SimpleMultiRelayManager.testSimpleTcpConnection(relay.getHost(), relay.getPort())) {
                System.out.println("\u2705 \u53ef\u8fde\u63a5");
                logger.info("\u5916\u90e8\u4e2d\u7ee7TCP\u8fde\u63a5\u6210\u529f: {}", (Object)relay);
                return new RelayConnectionInfo(relay.getHost(), relay.getPort(), relay.getPriority(), relay.getName() + " (TCP\u8fde\u63a5)");
            }
            System.out.println("\u274c \u8fde\u63a5\u5931\u8d25");
        }
        System.out.print("\ud83d\udd27 TCP\u6d4b\u8bd5\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7... ");
        if (SimpleMultiRelayManager.testSimpleTcpConnection("relay.daodaovps.com", 8001)) {
            System.out.println("\u2705 \u53ef\u8fde\u63a5");
            logger.info("\u9ed8\u8ba4\u4e2d\u7ee7TCP\u8fde\u63a5\u6210\u529f");
            return new RelayConnectionInfo("relay.daodaovps.com", 8001, RelayPriority.DEFAULT, "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7 (TCP\u8fde\u63a5)");
        }
        System.out.println("\u274c \u8fde\u63a5\u5931\u8d25");
        System.out.println("\u274c \u6240\u6709\u4e2d\u7ee7\u90fd\u65e0\u6cd5\u8fde\u63a5");
        throw new RuntimeException("\u6240\u6709\u4e2d\u7ee7\u90fd\u65e0\u6cd5\u8fde\u63a5");
    }

    private static boolean testSimpleTcpConnection(String host, int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), 2000);
            socket.close();
            logger.debug("TCP\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f: {}:{}", (Object)host, (Object)port);
            return true;
        }
        catch (Exception e) {
            logger.debug("TCP\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25: {}:{} - {}", host, port, e.getMessage());
            return false;
        }
    }

    private static boolean testRelayConnection(String host, int port, String sessionId) {
        try {
            return SimpleMultiRelayManager.testRelayWithJoin(host, port, sessionId);
        }
        catch (Exception e) {
            logger.debug("\u4e2d\u7ee7\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25: {}:{} - {}", host, port, e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testRelayWithJoin(String host, int port, final String sessionId) {
        final CompletableFuture resultFuture = new CompletableFuture();
        Bootstrap bootstrap = new Bootstrap();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 2000)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new RelayMessageEncoder(), new RelayMessageDecoder(), new SimpleChannelInboundHandler<Message>(){

                        @Override
                        public void channelActive(ChannelHandlerContext ctx) {
                            JoinMessage joinMsg = new JoinMessage(sessionId);
                            ctx.writeAndFlush(joinMsg);
                        }

                        @Override
                        protected void channelRead0(ChannelHandlerContext ctx, Message msg) {
                            if (msg.getType() == MessageType.JOIN_RESULT) {
                                JoinResultMessage result = (JoinResultMessage)msg;
                                resultFuture.complete(result.isSuccess());
                                ctx.close();
                            }
                        }

                        @Override
                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            resultFuture.complete(false);
                            ctx.close();
                        }
                    });
                }
            });
            ChannelFuture connectFuture = bootstrap.connect(host, port).sync();
            Boolean success = (Boolean)resultFuture.get(2L, TimeUnit.SECONDS);
            connectFuture.channel().close().sync();
            if (success.booleanValue()) {
                logger.info("\u2705 \u4e2d\u7ee7\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f\uff0c\u627e\u5230\u4f1a\u8bdd: {}:{} - sessionId: {}", host, port, sessionId);
            } else {
                logger.info("\u274c \u4e2d\u7ee7\u4e0a\u672a\u627e\u5230\u4f1a\u8bdd: {}:{} - sessionId: {}", host, port, sessionId);
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            logger.debug("\u4e2d\u7ee7\u8fde\u63a5\u6d4b\u8bd5\u5f02\u5e38: {}:{} - {}", host, port, e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static RelayConnectionInfo tryLocalDiscovery(String sessionId) {
        try {
            System.out.print("\ud83d\udd0d \u68c0\u6d4b\u672c\u5730\u7f51\u7edc");
            logger.info("\u5f00\u59cb\u672c\u5730UDP\u5e7f\u64ad\u53d1\u73b0\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
            BroadcastDiscoverer discoverer = new BroadcastDiscoverer();
            boolean found = discoverer.waitForSessionId(sessionId, 8000L);
            if (found) {
                String host = discoverer.getDiscoveredRelayHost();
                int port = discoverer.getDiscoveredRelayPort();
                if (host != null && port > 0) {
                    System.out.println();
                    System.out.println("\u2705 \u53d1\u73b0\u672c\u5730\u4e2d\u7ee7: " + host + ":" + port);
                    logger.info("\u672c\u5730\u53d1\u73b0\u6210\u529f: {}:{}", (Object)host, (Object)port);
                    return new RelayConnectionInfo(host, port, RelayPriority.LOCAL, "\u672c\u5730\u4e2d\u7ee7");
                }
                System.out.println();
                System.out.println("\u274c \u672c\u5730\u4e2d\u7ee7\u4fe1\u606f\u65e0\u6548");
                logger.warn("\u672c\u5730\u53d1\u73b0\u8fd4\u56detrue\u4f46\u4e3b\u673a\u4fe1\u606f\u65e0\u6548: host={}, port={}", (Object)host, (Object)port);
            } else {
                System.out.println();
                System.out.println("\u274c \u672a\u53d1\u73b0\uff08\u53ef\u80fd\u4e0d\u5728\u540c\u4e00\u5c40\u57df\u7f51\u6216\u9632\u706b\u5899\u963b\u6b62\uff09");
                logger.info("\u672c\u5730\u53d1\u73b0\u8d85\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u4f1a\u8bddID: {}", (Object)sessionId);
            }
            return null;
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("\u274c \u672c\u5730\u53d1\u73b0\u5f02\u5e38: " + e.getMessage());
            logger.warn("\u672c\u5730\u53d1\u73b0\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static void markRelaySuccess(String host, int port) {
        MultiRelayConfig.markRelaySuccess(host, port);
        logger.debug("\u6807\u8bb0\u4e2d\u7ee7\u8fde\u63a5\u6210\u529f: {}:{}", (Object)host, (Object)port);
    }

    public static void markRelayFailure(String host, int port) {
        MultiRelayConfig.markRelayFailure(host, port);
        logger.debug("\u6807\u8bb0\u4e2d\u7ee7\u8fde\u63a5\u5931\u8d25: {}:{}", (Object)host, (Object)port);
    }

    public static String getConnectionSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("\u591a\u4e2d\u7ee7\u8fde\u63a5\u7edf\u8ba1:\n");
        summary.append(MultiRelayConfig.getConfigSummary());
        List<RelayInfo> relays = MultiRelayConfig.getAllRelayList();
        if (!relays.isEmpty()) {
            summary.append("\u5f53\u524d\u4e2d\u7ee7\u5217\u8868:\n");
            for (RelayInfo relay : relays) {
                summary.append(String.format("  %s - %s\n", relay.toString(), relay.isHealthy() ? "\u5065\u5eb7" : "\u4e0d\u5065\u5eb7"));
            }
        }
        return summary.toString();
    }

    public static void resetAllRelayHealth() {
        MultiRelayConfig.resetAllRelayHealth();
        logger.info("\u5df2\u91cd\u7f6e\u6240\u6709\u4e2d\u7ee7\u5065\u5eb7\u72b6\u6001");
    }

    public static class RelayConnectionInfo {
        private final String host;
        private final int port;
        private final RelayPriority priority;
        private final String description;

        public RelayConnectionInfo(String host, int port, RelayPriority priority, String description) {
            this.host = host;
            this.port = port;
            this.priority = priority;
            this.description = description;
        }

        public RelayConnectionInfo(String host, int port, String description) {
            this.host = host;
            this.port = port;
            this.priority = RelayPriority.LOCAL;
            this.description = description;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public RelayPriority getPriority() {
            return this.priority;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("%s (%s:%d)", this.description, this.host, this.port);
        }
    }
}

