/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.discovery;

import com.file.netty.discovery.BroadcastDiscoverer;
import com.file.netty.discovery.BroadcastPublisher;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastDemo {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastDemo.class);

    public static void main(String[] args) {
        String mode;
        logger.info("=== UDP\u5e7f\u64ad\u7cfb\u7edf\u6f14\u793a\u7a0b\u5e8f ===");
        if (args.length == 0) {
            BroadcastDemo.show_usage();
            return;
        }
        switch (mode = args[0].toLowerCase()) {
            case "publisher": 
            case "pub": {
                BroadcastDemo.run_publisher_demo(args);
                break;
            }
            case "discoverer": 
            case "disc": {
                BroadcastDemo.run_discoverer_demo(args);
                break;
            }
            case "both": 
            case "auto": {
                BroadcastDemo.run_auto_test(args);
                break;
            }
            case "interactive": 
            case "i": {
                BroadcastDemo.run_interactive_mode();
                break;
            }
            default: {
                logger.error("\u672a\u77e5\u6a21\u5f0f: {}", (Object)mode);
                BroadcastDemo.show_usage();
            }
        }
    }

    private static void show_usage() {
        System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
        System.out.println("  java BroadcastDemo publisher [port] [session-id]     - \u542f\u52a8\u5e7f\u64ad\u53d1\u5e03\u5668");
        System.out.println("  java BroadcastDemo discoverer [session-id] [timeout] - \u542f\u52a8\u5e7f\u64ad\u53d1\u73b0\u5668");
        System.out.println("  java BroadcastDemo both                              - \u81ea\u52a8\u6d4b\u8bd5\u6a21\u5f0f");
        System.out.println("  java BroadcastDemo interactive                       - \u4ea4\u4e92\u6a21\u5f0f");
        System.out.println();
        System.out.println("\u793a\u4f8b:");
        System.out.println("  # \u542f\u52a8\u53d1\u5e03\u5668\uff0c\u7aef\u53e38080\uff0c\u4f1a\u8bddID\u4e3atest-123");
        System.out.println("  java BroadcastDemo publisher 8080 test-123");
        System.out.println();
        System.out.println("  # \u542f\u52a8\u53d1\u73b0\u5668\uff0c\u67e5\u627e\u4f1a\u8bddID\u4e3atest-123\u7684\u670d\u52a1\uff0c\u8d85\u65f610\u79d2");
        System.out.println("  java BroadcastDemo discoverer test-123 10000");
        System.out.println();
        System.out.println("  # \u81ea\u52a8\u6d4b\u8bd5\uff08\u540c\u65f6\u542f\u52a8\u53d1\u5e03\u5668\u548c\u53d1\u73b0\u5668\uff09");
        System.out.println("  java BroadcastDemo both");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run_publisher_demo(String[] args) {
        int port = 8080;
        String session_id = "test-session-12345-" + System.currentTimeMillis();
        if (args.length > 1) {
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                logger.error("\u7aef\u53e3\u53f7\u683c\u5f0f\u9519\u8bef: {}", (Object)args[1]);
                return;
            }
        }
        if (args.length > 2) {
            session_id = args[2];
        }
        logger.info("=== \u5e7f\u64ad\u53d1\u5e03\u5668\u6f14\u793a ===");
        logger.info("\u7aef\u53e3: {}", (Object)port);
        logger.info("\u4f1a\u8bddID: {}", (Object)session_id);
        logger.info("\u6309 Enter \u952e\u505c\u6b62\u5e7f\u64ad...");
        BroadcastPublisher publisher = new BroadcastPublisher();
        try {
            boolean success = publisher.publishService(port, session_id);
            if (!success) {
                logger.error("\u5e7f\u64ad\u670d\u52a1\u542f\u52a8\u5931\u8d25");
                return;
            }
            logger.info("\u2705 \u5e7f\u64ad\u670d\u52a1\u5df2\u542f\u52a8\uff0c\u6b63\u5728\u53d1\u9001\u5e7f\u64ad\u6d88\u606f...");
            logger.info("\u5176\u4ed6\u8bbe\u5907\u53ef\u4ee5\u4f7f\u7528\u4ee5\u4e0b\u547d\u4ee4\u53d1\u73b0\u6b64\u670d\u52a1:");
            logger.info("java BroadcastDemo discoverer {} 10000", (Object)session_id);
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
        }
        catch (Exception e) {
            logger.error("\u53d1\u5e03\u5668\u8fd0\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
        finally {
            publisher.stop();
            logger.info("\u5e7f\u64ad\u670d\u52a1\u5df2\u505c\u6b62");
        }
    }

    private static void run_discoverer_demo(String[] args) {
        String session_id = "test-session-12345";
        long timeout = 30000L;
        if (args.length > 1) {
            session_id = args[1];
        }
        if (args.length > 2) {
            try {
                timeout = Long.parseLong(args[2]);
            }
            catch (NumberFormatException e) {
                logger.error("\u8d85\u65f6\u65f6\u95f4\u683c\u5f0f\u9519\u8bef: {}", (Object)args[2]);
                return;
            }
        }
        logger.info("=== \u5e7f\u64ad\u53d1\u73b0\u5668\u6f14\u793a ===");
        logger.info("\u76ee\u6807\u4f1a\u8bddID: {}", (Object)session_id);
        logger.info("\u8d85\u65f6\u65f6\u95f4: {} \u6beb\u79d2", (Object)timeout);
        BroadcastDiscoverer discoverer = new BroadcastDiscoverer();
        try {
            logger.info("\ud83d\udd0d \u5f00\u59cb\u641c\u7d22\u670d\u52a1...");
            boolean found = discoverer.waitForSessionId(session_id, timeout);
            if (found) {
                logger.info("\u2705 \u53d1\u73b0\u670d\u52a1\u6210\u529f!");
                logger.info("\u4e3b\u673a\u5730\u5740: {}", (Object)discoverer.getDiscoveredRelayHost());
                logger.info("\u7aef\u53e3\u53f7: {}", (Object)discoverer.getDiscoveredRelayPort());
                logger.info("\u5b8c\u6574\u5730\u5740: {}:{}", (Object)discoverer.getDiscoveredRelayHost(), (Object)discoverer.getDiscoveredRelayPort());
            } else {
                logger.info("\u274c \u672a\u627e\u5230\u5339\u914d\u7684\u670d\u52a1");
                logger.info("\u53ef\u80fd\u7684\u539f\u56e0:");
                logger.info("1. \u76ee\u6807\u670d\u52a1\u672a\u542f\u52a8");
                logger.info("2. \u4f1a\u8bddID\u4e0d\u5339\u914d");
                logger.info("3. \u7f51\u7edc\u8fde\u63a5\u95ee\u9898");
                logger.info("4. \u9632\u706b\u5899\u963b\u6b62UDP\u5e7f\u64ad");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u73b0\u5668\u8fd0\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run_auto_test(String[] args) {
        logger.info("=== \u81ea\u52a8\u6d4b\u8bd5\u6a21\u5f0f ===");
        String session_id = "auto-test-" + System.currentTimeMillis();
        int port = 8080;
        long timeout = 8000L;
        logger.info("\u6d4b\u8bd5\u4f1a\u8bddID: {}", (Object)session_id);
        logger.info("\u6d4b\u8bd5\u7aef\u53e3: {}", (Object)port);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        BroadcastPublisher publisher = new BroadcastPublisher();
        try {
            logger.info("1. \u542f\u52a8\u5e7f\u64ad\u53d1\u5e03\u5668...");
            boolean publish_success = publisher.publishService(port, session_id);
            if (!publish_success) {
                logger.error("\u274c \u53d1\u5e03\u5668\u542f\u52a8\u5931\u8d25");
                return;
            }
            logger.info("\u2705 \u53d1\u5e03\u5668\u542f\u52a8\u6210\u529f");
            Thread.sleep(2000L);
            logger.info("2. \u542f\u52a8\u5e7f\u64ad\u53d1\u73b0\u5668...");
            Future<Boolean> discovery_task = executor.submit(() -> {
                BroadcastDiscoverer discoverer = new BroadcastDiscoverer();
                return discoverer.waitForSessionId(session_id, timeout);
            });
            boolean found = discovery_task.get();
            if (found) {
                logger.info("\u2705 \u81ea\u52a8\u6d4b\u8bd5\u6210\u529f!");
                logger.info("\ud83c\udf89 \u5e7f\u64ad\u53d1\u5e03\u5668\u548c\u53d1\u73b0\u5668\u5de5\u4f5c\u6b63\u5e38");
                logger.info("\ud83d\udce1 Java\u7248\u672c\u4e0eNode.js\u7248\u672c\u5e94\u8be5\u80fd\u591f\u4e92\u76f8\u53d1\u73b0");
            } else {
                logger.info("\u274c \u81ea\u52a8\u6d4b\u8bd5\u5931\u8d25");
                logger.info("\u8bf7\u68c0\u67e5\u7f51\u7edc\u914d\u7f6e\u548c\u9632\u706b\u5899\u8bbe\u7f6e");
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u6d4b\u8bd5\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
        finally {
            publisher.stop();
            executor.shutdown();
            logger.info("\u6d4b\u8bd5\u5b8c\u6210\uff0c\u8d44\u6e90\u5df2\u6e05\u7406");
        }
    }

    private static void run_interactive_mode() {
        Scanner scanner = new Scanner(System.in);
        logger.info("=== \u4ea4\u4e92\u6a21\u5f0f ===");
        logger.info("\u8bf7\u9009\u62e9\u64cd\u4f5c:");
        logger.info("1. \u542f\u52a8\u53d1\u5e03\u5668");
        logger.info("2. \u542f\u52a8\u53d1\u73b0\u5668");
        logger.info("3. \u81ea\u52a8\u6d4b\u8bd5");
        logger.info("4. \u9000\u51fa");
        block14: while (true) {
            System.out.print("\n\u8bf7\u8f93\u5165\u9009\u9879 (1-4): ");
            try {
                String input;
                switch (input = scanner.nextLine().trim()) {
                    case "1": {
                        BroadcastDemo.interactive_publisher(scanner);
                        continue block14;
                    }
                    case "2": {
                        BroadcastDemo.interactive_discoverer(scanner);
                        continue block14;
                    }
                    case "3": {
                        BroadcastDemo.run_auto_test(new String[0]);
                        continue block14;
                    }
                    case "4": {
                        logger.info("\u7a0b\u5e8f\u9000\u51fa");
                        return;
                    }
                }
                logger.info("\u65e0\u6548\u9009\u9879: {}", (Object)input);
                continue;
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8f93\u5165\u65f6\u53d1\u751f\u9519\u8bef", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interactive_publisher(Scanner scanner) {
        System.out.print("\u8bf7\u8f93\u5165\u7aef\u53e3\u53f7 [10000]: ");
        String port_input = scanner.nextLine().trim();
        int port = port_input.isEmpty() ? 10000 : Integer.parseInt(port_input);
        System.out.print("\u8bf7\u8f93\u5165\u4f1a\u8bddID [test-session-12345]: ");
        String session_input = scanner.nextLine().trim();
        String session_id = session_input.isEmpty() ? "test-session-12345" : session_input;
        logger.info("\u542f\u52a8\u53d1\u5e03\u5668: \u7aef\u53e3={}, \u4f1a\u8bddID={}", (Object)port, (Object)session_id);
        BroadcastPublisher publisher = new BroadcastPublisher();
        try {
            if (publisher.publishService(port, session_id)) {
                logger.info("\u53d1\u5e03\u5668\u5df2\u542f\u52a8\uff0c\u6309 Enter \u505c\u6b62...");
                scanner.nextLine();
            } else {
                logger.error("\u53d1\u5e03\u5668\u542f\u52a8\u5931\u8d25");
            }
        }
        finally {
            publisher.stop();
        }
    }

    private static void interactive_discoverer(Scanner scanner) {
        System.out.print("\u8bf7\u8f93\u5165\u76ee\u6807\u4f1a\u8bddID [test-session-12345]: ");
        String session_input = scanner.nextLine().trim();
        String session_id = session_input.isEmpty() ? "test-session-12345" : session_input;
        System.out.print("\u8bf7\u8f93\u5165\u8d85\u65f6\u65f6\u95f4(\u6beb\u79d2) [10000]: ");
        String timeout_input = scanner.nextLine().trim();
        long timeout = timeout_input.isEmpty() ? 10000L : Long.parseLong(timeout_input);
        logger.info("\u542f\u52a8\u53d1\u73b0\u5668: \u4f1a\u8bddID={}, \u8d85\u65f6={}ms", (Object)session_id, (Object)timeout);
        BroadcastDiscoverer discoverer = new BroadcastDiscoverer();
        boolean found = discoverer.waitForSessionId(session_id, timeout);
        if (found) {
            logger.info("\u53d1\u73b0\u670d\u52a1: {}:{}", (Object)discoverer.getDiscoveredRelayHost(), (Object)discoverer.getDiscoveredRelayPort());
        } else {
            logger.info("\u672a\u53d1\u73b0\u5339\u914d\u7684\u670d\u52a1");
        }
    }
}

