/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.discovery;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastPublisher {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastPublisher.class);
    private static final int BROADCAST_PORT = 8901;
    private static final int BROADCAST_INTERVAL_SECONDS = 2;
    private DatagramSocket socket;
    private ScheduledExecutorService scheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private String broadcast_message;
    private String primary_local_ip;

    public boolean publishService(int port, String sessionId) {
        try {
            this.primary_local_ip = this.getPrimaryLocalIP();
            if (this.primary_local_ip == null) {
                logger.error("\u65e0\u6cd5\u83b7\u53d6\u672c\u673a\u771f\u5b9eIP\u5730\u5740");
                return false;
            }
            logger.info("\u4f7f\u7528\u672c\u673aIP\u5730\u5740\u8fdb\u884c\u5e7f\u64ad: {}", (Object)this.primary_local_ip);
            String device_name = this.getDeviceName();
            this.broadcast_message = sessionId + ":" + port + ":" + device_name + ":" + this.primary_local_ip;
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.running.set(true);
            this.send_broadcast();
            this.scheduler.scheduleAtFixedRate(this::send_broadcast, 0L, 2L, TimeUnit.SECONDS);
            logger.info("\u5e7f\u64ad\u670d\u52a1\u5df2\u542f\u52a8: \u7aef\u53e3={}, \u4f1a\u8bddID={}, \u672c\u673aIP={}", port, sessionId, this.primary_local_ip);
            return true;
        }
        catch (Exception e) {
            logger.error("\u542f\u52a8\u5e7f\u64ad\u670d\u52a1\u5931\u8d25", e);
            return false;
        }
    }

    private String getPrimaryLocalIP() {
        ArrayList<String> candidateIPs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                String interfaceName = networkInterface.getName();
                String displayName = networkInterface.getDisplayName();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    String ip = address.getHostAddress();
                    if (address.isLinkLocalAddress()) {
                        logger.debug("\u8df3\u8fc7\u94fe\u8def\u672c\u5730\u5730\u5740: {} (\u63a5\u53e3: {})", (Object)ip, (Object)interfaceName);
                        continue;
                    }
                    int priority = this.getInterfacePriority(interfaceName, displayName);
                    int ipPriority = this.getIPAddressPriority(ip);
                    candidateIPs.add((priority += ipPriority) + ":" + ip + ":" + interfaceName + ":" + displayName);
                }
            }
            if (!candidateIPs.isEmpty()) {
                candidateIPs.sort((a, b) -> {
                    int priorityA = Integer.parseInt(a.split(":")[0]);
                    int priorityB = Integer.parseInt(b.split(":")[0]);
                    return Integer.compare(priorityA, priorityB);
                });
                String bestCandidate = (String)candidateIPs.get(0);
                String[] parts = bestCandidate.split(":", 4);
                String bestIP = parts[1];
                String bestInterface = parts[2];
                String bestDisplayName = parts.length > 3 ? parts[3] : "";
                logger.info("\u9009\u62e9\u6700\u4f73IP\u5730\u5740: {} (\u63a5\u53e3: {}, \u663e\u793a\u540d: {}, \u4f18\u5148\u7ea7: {}, \u603b\u5019\u9009\u6570: {})", bestIP, bestInterface, bestDisplayName, parts[0], candidateIPs.size());
                logger.info("\u6240\u6709\u5019\u9009IP\u5217\u8868:");
                for (int i = 0; i < Math.min(candidateIPs.size(), 10); ++i) {
                    String candidate = (String)candidateIPs.get(i);
                    String[] candidateParts = candidate.split(":", 4);
                    String displayName = candidateParts.length > 3 ? candidateParts[3] : "";
                    logger.info("  #{}: IP={} (\u63a5\u53e3:{}, \u663e\u793a\u540d:{}, \u4f18\u5148\u7ea7:{})", i + 1, candidateParts[1], candidateParts[2], displayName, candidateParts[0]);
                }
                return bestIP;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u5730IP\u5730\u5740\u5931\u8d25", e);
        }
        logger.warn("\u65e0\u6cd5\u83b7\u53d6\u5408\u9002\u7684\u672c\u5730IP\u5730\u5740\uff0c\u8fd4\u56denull");
        return null;
    }

    private int getIPAddressPriority(String ip) {
        try {
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return 100;
            }
            int first = Integer.parseInt(parts[0]);
            int second = Integer.parseInt(parts[1]);
            if (first == 10) {
                return 0;
            }
            if (first == 192 && second == 168) {
                return 0;
            }
            if (first == 172 && second >= 16 && second <= 31) {
                return 0;
            }
            if (first == 169 && second == 254) {
                return 50;
            }
            return 10;
        }
        catch (Exception e) {
            return 100;
        }
    }

    private int getInterfacePriority(String interfaceName, String displayName) {
        String lowerDisplayName;
        String lowerName = interfaceName.toLowerCase();
        String string = lowerDisplayName = displayName != null ? displayName.toLowerCase() : "";
        if (lowerDisplayName.contains("vmware") || lowerDisplayName.contains("virtualbox") || lowerDisplayName.contains("virtual ethernet") || lowerDisplayName.contains("virtual adapter")) {
            return 70;
        }
        if (lowerDisplayName.contains("tailscale") || lowerDisplayName.contains("vpn") || lowerDisplayName.contains("tunnel")) {
            logger.debug("\u68c0\u6d4b\u5230VPN\u63a5\u53e3: {} ({})", (Object)interfaceName, (Object)displayName);
            return 80;
        }
        if (lowerName.startsWith("eth") || lowerName.startsWith("en") || lowerName.contains("ethernet") || lowerName.contains("bridge")) {
            if (lowerName.contains("vmware") || lowerName.contains("virtualbox") || lowerName.contains("virtual") || lowerName.contains("vmnet")) {
                return 70;
            }
            logger.debug("\u68c0\u6d4b\u5230\u771f\u5b9e\u4ee5\u592a\u7f51\u63a5\u53e3: {} ({})", (Object)interfaceName, (Object)displayName);
            return 10;
        }
        if (lowerName.startsWith("wlan") || lowerName.contains("wi") || lowerName.contains("wireless") || lowerName.contains("wifi") || lowerDisplayName.contains("wi-fi") || lowerDisplayName.contains("wireless") || lowerDisplayName.contains("wifi")) {
            logger.debug("\u68c0\u6d4b\u5230\u65e0\u7ebf\u7f51\u7edc\u63a5\u53e3: {} ({})", (Object)interfaceName, (Object)displayName);
            return 15;
        }
        if (lowerName.contains("vmware") || lowerName.contains("vmnet") || lowerName.contains("virtualbox") || lowerName.contains("vbox")) {
            return 70;
        }
        if (lowerName.contains("tun") || lowerName.contains("tap") || lowerName.contains("vpn") || lowerName.contains("ppp") || lowerName.contains("tailscale")) {
            return 80;
        }
        if (lowerName.contains("docker") || lowerName.contains("br-") || lowerName.contains("veth")) {
            return 75;
        }
        if (lowerName.contains("bluetooth") || lowerName.contains("\u84dd\u7259") || lowerDisplayName.contains("bluetooth") || lowerDisplayName.contains("\u84dd\u7259")) {
            return 85;
        }
        if (lowerName.contains("virtual") || lowerName.contains("loopback") || lowerName.contains("teredo") || lowerName.contains("isatap")) {
            return 90;
        }
        logger.debug("\u672a\u77e5\u63a5\u53e3\u7c7b\u578b: {} ({})", (Object)interfaceName, (Object)displayName);
        return 50;
    }

    private void send_broadcast() {
        if (!this.running.get()) {
            return;
        }
        try {
            byte[] data = this.broadcast_message.getBytes();
            List<String> broadcast_addresses = this.getPrivateNetworkBroadcastAddresses();
            int successCount = 0;
            for (String broadcast_addr : broadcast_addresses) {
                try {
                    DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(broadcast_addr), 8901);
                    this.socket.send(packet);
                    ++successCount;
                    logger.debug("\u6210\u529f\u53d1\u9001\u5e7f\u64ad\u5230: {} (\u6d88\u606f: {})", (Object)broadcast_addr, (Object)this.broadcast_message);
                }
                catch (Exception e) {
                    logger.debug("\u53d1\u9001\u5e7f\u64ad\u5230 {} \u5931\u8d25: {}", (Object)broadcast_addr, (Object)e.getMessage());
                }
            }
            if (successCount > 0) {
                logger.debug("\u5e7f\u64ad\u53d1\u9001\u5b8c\u6210: \u6210\u529f {}/{} \u4e2a\u5730\u5740", (Object)successCount, (Object)broadcast_addresses.size());
            } else {
                logger.warn("\u6240\u6709\u5e7f\u64ad\u5730\u5740\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5e7f\u64ad\u5931\u8d25", e);
        }
    }

    private List<String> getPrivateNetworkBroadcastAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress address = interfaceAddress.getAddress();
                    InetAddress broadcast = interfaceAddress.getBroadcast();
                    if (!(address instanceof Inet4Address) || broadcast == null) continue;
                    String ipAddress = address.getHostAddress();
                    if (this.isPrivateNetworkIP(ipAddress)) {
                        String broadcastAddr = broadcast.getHostAddress();
                        if (addresses.contains(broadcastAddr)) continue;
                        addresses.add(broadcastAddr);
                        logger.debug("\u6dfb\u52a0\u5185\u7f51\u5e7f\u64ad\u5730\u5740: {} (\u6765\u81ea\u63a5\u53e3: {}, IP: {})", broadcastAddr, networkInterface.getName(), ipAddress);
                        continue;
                    }
                    logger.debug("\u8df3\u8fc7\u516c\u7f51IP\u7684\u5e7f\u64ad: {} (\u63a5\u53e3: {})", (Object)ipAddress, (Object)networkInterface.getName());
                }
            }
        }
        catch (Exception e) {
            logger.debug("\u83b7\u53d6\u5185\u7f51\u5e7f\u64ad\u5730\u5740\u5931\u8d25: {}", (Object)e.getMessage());
        }
        if (addresses.isEmpty()) {
            logger.warn("\u672a\u627e\u5230\u5185\u7f51\u63a5\u53e3\uff0c\u4e0d\u8fdb\u884c\u5e7f\u64ad\u4ee5\u907f\u514d\u4fe1\u606f\u6cc4\u9732");
        }
        return addresses;
    }

    private boolean isPrivateNetworkIP(String ip) {
        try {
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return false;
            }
            int first = Integer.parseInt(parts[0]);
            int second = Integer.parseInt(parts[1]);
            if (first == 10) {
                return true;
            }
            if (first == 172 && second >= 16 && second <= 31) {
                return true;
            }
            if (first == 192 && second == 168) {
                return true;
            }
            if (first == 127) {
                return true;
            }
            return first == 169 && second == 254;
        }
        catch (Exception e) {
            logger.debug("\u89e3\u6790IP\u5730\u5740\u5931\u8d25: {}", (Object)ip);
            return false;
        }
    }

    private String getDeviceName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "FileTransfer";
        }
    }

    public void stop() {
        this.running.set(false);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        logger.info("\u5e7f\u64ad\u670d\u52a1\u5df2\u505c\u6b62");
    }
}

