/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import java.util.List;
import java.util.Map;

public class BatchFileAckMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private int batchId;
    private List<String> acceptedFiles;
    private List<String> skippedFiles;
    private Map<String, String> errorFiles;
    private boolean allProcessed;

    public BatchFileAckMessage() {
        super(MessageType.BATCH_FILE_ACK);
    }

    public BatchFileAckMessage(String sessionId, int batchId) {
        super(MessageType.BATCH_FILE_ACK, sessionId);
        this.batchId = batchId;
    }

    public BatchFileAckMessage(String sessionId, int batchId, List<String> acceptedFiles, List<String> skippedFiles, Map<String, String> errorFiles) {
        super(MessageType.BATCH_FILE_ACK, sessionId);
        this.batchId = batchId;
        this.acceptedFiles = acceptedFiles;
        this.skippedFiles = skippedFiles;
        this.errorFiles = errorFiles;
        this.allProcessed = false;
    }

    public int getAcceptedCount() {
        return this.acceptedFiles != null ? this.acceptedFiles.size() : 0;
    }

    public int getSkippedCount() {
        return this.skippedFiles != null ? this.skippedFiles.size() : 0;
    }

    public int getErrorCount() {
        return this.errorFiles != null ? this.errorFiles.size() : 0;
    }

    public boolean isFileAccepted(String fileName) {
        return this.acceptedFiles != null && this.acceptedFiles.contains(fileName);
    }

    public boolean isFileSkipped(String fileName) {
        return this.skippedFiles != null && this.skippedFiles.contains(fileName);
    }

    public boolean isFileError(String fileName) {
        return this.errorFiles != null && this.errorFiles.containsKey(fileName);
    }

    public String getFileError(String fileName) {
        return this.errorFiles != null ? this.errorFiles.get(fileName) : null;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public List<String> getAcceptedFiles() {
        return this.acceptedFiles;
    }

    public void setAcceptedFiles(List<String> acceptedFiles) {
        this.acceptedFiles = acceptedFiles;
    }

    public List<String> getSkippedFiles() {
        return this.skippedFiles;
    }

    public void setSkippedFiles(List<String> skippedFiles) {
        this.skippedFiles = skippedFiles;
    }

    public Map<String, String> getErrorFiles() {
        return this.errorFiles;
    }

    public void setErrorFiles(Map<String, String> errorFiles) {
        this.errorFiles = errorFiles;
    }

    public boolean isAllProcessed() {
        return this.allProcessed;
    }

    public void setAllProcessed(boolean allProcessed) {
        this.allProcessed = allProcessed;
    }
}

