/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import java.io.Serializable;
import java.util.List;

public class BatchFileInfoMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private List<BatchFileEntry> files;
    private int batchId;
    private long totalSize;
    private int totalFiles;

    public BatchFileInfoMessage() {
        super(MessageType.BATCH_FILE_INFO);
    }

    public BatchFileInfoMessage(String sessionId, List<BatchFileEntry> files, int batchId) {
        super(MessageType.BATCH_FILE_INFO, sessionId);
        this.files = files;
        this.batchId = batchId;
        this.totalFiles = files.size();
        this.totalSize = files.stream().mapToLong(BatchFileEntry::getFileSize).sum();
    }

    public List<BatchFileEntry> getFiles() {
        return this.files;
    }

    public void setFiles(List<BatchFileEntry> files) {
        this.files = files;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    public void setTotalFiles(int totalFiles) {
        this.totalFiles = totalFiles;
    }

    public static class BatchFileEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String fileName;
        private long fileSize;
        private String md5;
        private int chunks;
        private int chunkSize;
        private boolean isEmpty;

        public BatchFileEntry() {
        }

        public BatchFileEntry(String fileName, long fileSize, String md5, int chunks, int chunkSize) {
            this.fileName = fileName;
            this.fileSize = fileSize;
            this.md5 = md5;
            this.chunks = chunks;
            this.chunkSize = chunkSize;
            this.isEmpty = fileSize == 0L;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public int getChunks() {
            return this.chunks;
        }

        public void setChunks(int chunks) {
            this.chunks = chunks;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public void setEmpty(boolean empty) {
            this.isEmpty = empty;
        }
    }
}

