/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import java.util.Map;

public class CompressedBatchCompleteMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private int batchId;
    private boolean success;
    private int processedFiles;
    private int failedFiles;
    private long processedSize;
    private long processingTimeMs;
    private Map<String, String> failedFileReasons;
    private String errorMessage;

    public CompressedBatchCompleteMessage() {
        super(MessageType.COMPRESSED_BATCH_COMPLETE);
    }

    public CompressedBatchCompleteMessage(String sessionId, int batchId, boolean success) {
        super(MessageType.COMPRESSED_BATCH_COMPLETE, sessionId);
        this.batchId = batchId;
        this.success = success;
    }

    public static CompressedBatchCompleteMessage createSuccess(String sessionId, int batchId, int processedFiles, long processedSize, long processingTimeMs) {
        CompressedBatchCompleteMessage msg = new CompressedBatchCompleteMessage(sessionId, batchId, true);
        msg.setProcessedFiles(processedFiles);
        msg.setProcessedSize(processedSize);
        msg.setProcessingTimeMs(processingTimeMs);
        return msg;
    }

    public static CompressedBatchCompleteMessage createFailure(String sessionId, int batchId, String errorMessage) {
        CompressedBatchCompleteMessage msg = new CompressedBatchCompleteMessage(sessionId, batchId, false);
        msg.setErrorMessage(errorMessage);
        return msg;
    }

    public static CompressedBatchCompleteMessage createPartialSuccess(String sessionId, int batchId, int processedFiles, int failedFiles, long processedSize, long processingTimeMs, Map<String, String> failedFileReasons) {
        CompressedBatchCompleteMessage msg = new CompressedBatchCompleteMessage(sessionId, batchId, true);
        msg.setProcessedFiles(processedFiles);
        msg.setFailedFiles(failedFiles);
        msg.setProcessedSize(processedSize);
        msg.setProcessingTimeMs(processingTimeMs);
        msg.setFailedFileReasons(failedFileReasons);
        return msg;
    }

    public double getProcessingSpeedMBps() {
        if (this.processingTimeMs <= 0L || this.processedSize <= 0L) {
            return 0.0;
        }
        double sizeInMB = (double)this.processedSize / 1024.0 / 1024.0;
        double timeInSeconds = (double)this.processingTimeMs / 1000.0;
        return sizeInMB / timeInSeconds;
    }

    public double getSuccessRate() {
        int totalFiles = this.processedFiles + this.failedFiles;
        return totalFiles > 0 ? (double)this.processedFiles / (double)totalFiles : 1.0;
    }

    public String getProcessingSummary() {
        if (!this.success && this.errorMessage != null) {
            return "\u5904\u7406\u5931\u8d25: " + this.errorMessage;
        }
        if (this.failedFiles == 0) {
            return String.format("\u5168\u90e8\u6210\u529f: %d\u6587\u4ef6, %.1fMB/s", this.processedFiles, this.getProcessingSpeedMBps());
        }
        return String.format("\u90e8\u5206\u6210\u529f: %d\u6210\u529f/%d\u5931\u8d25, %.1f%%\u6210\u529f\u7387", this.processedFiles, this.failedFiles, this.getSuccessRate() * 100.0);
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getProcessedFiles() {
        return this.processedFiles;
    }

    public void setProcessedFiles(int processedFiles) {
        this.processedFiles = processedFiles;
    }

    public int getFailedFiles() {
        return this.failedFiles;
    }

    public void setFailedFiles(int failedFiles) {
        this.failedFiles = failedFiles;
    }

    public long getProcessedSize() {
        return this.processedSize;
    }

    public void setProcessedSize(long processedSize) {
        this.processedSize = processedSize;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    public void setProcessingTimeMs(long processingTimeMs) {
        this.processingTimeMs = processingTimeMs;
    }

    public Map<String, String> getFailedFileReasons() {
        return this.failedFileReasons;
    }

    public void setFailedFileReasons(Map<String, String> failedFileReasons) {
        this.failedFileReasons = failedFileReasons;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

