/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;

public class CompressedBatchDataMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private int batchId;
    private String compressedFileName;
    private long originalSize;
    private long compressedSize;
    private double compressionRatio;
    private String compressionMd5;
    private int fileCount;

    public CompressedBatchDataMessage() {
        super(MessageType.COMPRESSED_BATCH_DATA);
    }

    public CompressedBatchDataMessage(String sessionId, int batchId, String compressedFileName, long originalSize, long compressedSize, String compressionMd5, int fileCount) {
        super(MessageType.COMPRESSED_BATCH_DATA, sessionId);
        this.batchId = batchId;
        this.compressedFileName = compressedFileName;
        this.originalSize = originalSize;
        this.compressedSize = compressedSize;
        this.compressionMd5 = compressionMd5;
        this.fileCount = fileCount;
        this.compressionRatio = originalSize > 0L ? (double)compressedSize / (double)originalSize : 1.0;
    }

    public String getCompressionSummary() {
        double savePercentage = (1.0 - this.compressionRatio) * 100.0;
        return String.format("%s \u2192 %s (%.1f%% \u8282\u7701)", this.formatBytes(this.originalSize), this.formatBytes(this.compressedSize), savePercentage);
    }

    public boolean isCompressionEffective() {
        return this.compressionRatio < 0.95;
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1024.0 / 1024.0);
        }
        return String.format("%.1fGB", (double)bytes / 1024.0 / 1024.0 / 1024.0);
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public String getCompressedFileName() {
        return this.compressedFileName;
    }

    public void setCompressedFileName(String compressedFileName) {
        this.compressedFileName = compressedFileName;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
        this.compressionRatio = originalSize > 0L ? (double)this.compressedSize / (double)originalSize : 1.0;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
        this.compressionRatio = this.originalSize > 0L ? (double)compressedSize / (double)this.originalSize : 1.0;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public String getCompressionMd5() {
        return this.compressionMd5;
    }

    public void setCompressionMd5(String compressionMd5) {
        this.compressionMd5 = compressionMd5;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }
}

