/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import java.util.List;
import java.util.Map;

public class CompressedBatchManifestAckMessage
extends Message {
    private static final long serialVersionUID = 1L;
    private int batchId;
    private List<String> requiredFiles;
    private List<String> skippedFiles;
    private Map<String, String> errorFiles;
    private long requiredTotalSize;
    private long skippedTotalSize;
    private int requiredCount;
    private int skippedCount;
    private boolean acceptBatch = true;
    private String rejectReason;

    public CompressedBatchManifestAckMessage() {
        super(MessageType.COMPRESSED_BATCH_MANIFEST_ACK);
    }

    public CompressedBatchManifestAckMessage(String sessionId, int batchId, List<String> requiredFiles, List<String> skippedFiles, Map<String, String> errorFiles) {
        super(MessageType.COMPRESSED_BATCH_MANIFEST_ACK, sessionId);
        this.batchId = batchId;
        this.requiredFiles = requiredFiles;
        this.skippedFiles = skippedFiles;
        this.errorFiles = errorFiles;
        this.requiredCount = requiredFiles != null ? requiredFiles.size() : 0;
        this.skippedCount = skippedFiles != null ? skippedFiles.size() : 0;
    }

    public void setStatistics(long requiredTotalSize, long skippedTotalSize) {
        this.requiredTotalSize = requiredTotalSize;
        this.skippedTotalSize = skippedTotalSize;
    }

    public static CompressedBatchManifestAckMessage createReject(String sessionId, int batchId, String reason) {
        CompressedBatchManifestAckMessage msg = new CompressedBatchManifestAckMessage();
        msg.setSessionId(sessionId);
        msg.setBatchId(batchId);
        msg.setAcceptBatch(false);
        msg.setRejectReason(reason);
        return msg;
    }

    public boolean hasFilesToTransfer() {
        return this.acceptBatch && this.requiredFiles != null && !this.requiredFiles.isEmpty();
    }

    public List<String> getFilesToTransfer() {
        return this.hasFilesToTransfer() ? this.requiredFiles : null;
    }

    public String getDeduplicationSummary() {
        int totalFiles = this.requiredCount + this.skippedCount;
        if (totalFiles == 0) {
            return "\u65e0\u6587\u4ef6";
        }
        double skipPercentage = (double)this.skippedCount / (double)totalFiles * 100.0;
        return String.format("\u53bb\u91cd: %d/%d\u6587\u4ef6 (%.1f%%), \u8282\u7701: %s", this.skippedCount, totalFiles, skipPercentage, this.formatBytes(this.skippedTotalSize));
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1024.0 / 1024.0);
        }
        return String.format("%.1fGB", (double)bytes / 1024.0 / 1024.0 / 1024.0);
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public List<String> getRequiredFiles() {
        return this.requiredFiles;
    }

    public void setRequiredFiles(List<String> requiredFiles) {
        this.requiredFiles = requiredFiles;
        this.requiredCount = requiredFiles != null ? requiredFiles.size() : 0;
    }

    public List<String> getSkippedFiles() {
        return this.skippedFiles;
    }

    public void setSkippedFiles(List<String> skippedFiles) {
        this.skippedFiles = skippedFiles;
        this.skippedCount = skippedFiles != null ? skippedFiles.size() : 0;
    }

    public Map<String, String> getErrorFiles() {
        return this.errorFiles;
    }

    public void setErrorFiles(Map<String, String> errorFiles) {
        this.errorFiles = errorFiles;
    }

    public long getRequiredTotalSize() {
        return this.requiredTotalSize;
    }

    public void setRequiredTotalSize(long requiredTotalSize) {
        this.requiredTotalSize = requiredTotalSize;
    }

    public long getSkippedTotalSize() {
        return this.skippedTotalSize;
    }

    public void setSkippedTotalSize(long skippedTotalSize) {
        this.skippedTotalSize = skippedTotalSize;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public int getErrorCount() {
        return this.errorFiles != null ? this.errorFiles.size() : 0;
    }

    public boolean isAcceptBatch() {
        return this.acceptBatch;
    }

    public void setAcceptBatch(boolean acceptBatch) {
        this.acceptBatch = acceptBatch;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }
}

