/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.protocol;

import com.file.netty.protocol.MessageType;

public enum MessageCategory {
    CONTROL,
    DATA;


    public static MessageCategory getCategory(MessageType type) {
        switch (type) {
            case REGISTER: 
            case REGISTER_RESULT: 
            case JOIN: 
            case JOIN_RESULT: 
            case TRANSFER_ACK: 
            case FOLDER_INFO_ACK: 
            case FOLDER_COMPLETE_ACK: 
            case BATCH_FILE_ACK: 
            case ERROR: 
            case HEARTBEAT: {
                return CONTROL;
            }
            case FILE_INFO: 
            case FILE_CHUNK: 
            case FOLDER_INFO: 
            case FOLDER_COMPLETE: 
            case TRANSFER_COMPLETE: 
            case BATCH_FILE_INFO: {
                return DATA;
            }
        }
        return CONTROL;
    }

    public static boolean needsEncryption(MessageType type) {
        return MessageCategory.getCategory(type) == DATA;
    }
}

