/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.receiver;

import com.file.netty.codec.CodecFactory;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.FileSkipMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import com.file.netty.protocol.TransferAckMessage;
import com.file.netty.utils.ConsoleFormatter;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.HandlerExceptionUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReceiver {
    private static final Logger logger = LoggerFactory.getLogger(FileReceiver.class);
    private final String saveDir;
    private Channel channel;
    private String sessionId;
    private EventLoopGroup group;
    private CountDownLatch connectionLatch;
    private FileOutputStream fos;
    private FileChannel fileChannel;
    private String fileName;
    private String filePath;
    private long fileSize;
    private int totalChunks;
    private int chunkSize;
    private AtomicInteger receivedChunks = new AtomicInteger(0);
    private ConcurrentHashMap<Integer, Boolean> receivedChunkMap = new ConcurrentHashMap();
    private volatile boolean transferCompleted = false;
    private volatile boolean fileSkipped = false;
    private volatile boolean completionMessageDisplayed = false;
    private String expectedMd5;
    private volatile boolean filesClosed = false;
    private long transferStartTime;

    public FileReceiver(String host, int port, String saveDir) {
        this(host, port, saveDir, true);
    }

    public FileReceiver(String host, int port, String saveDir, boolean autoDiscoverRelay) {
        this.saveDir = saveDir;
        this.connectionLatch = new CountDownLatch(1);
    }

    private void closeCurrentConnection() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close().sync();
            }
            catch (InterruptedException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean connectToRelay(String relayHost, int relayPort) {
        try {
            logger.info("\u5c1d\u8bd5\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668: " + relayHost + ":" + relayPort);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, 30, 0));
                    CodecFactory.addClientCodec(p);
                }
            });
            ChannelFuture future = b.connect(relayHost, relayPort);
            future.awaitUninterruptibly(5000L);
            if (future.isSuccess()) {
                this.channel = future.channel();
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)relayHost, (Object)relayPort);
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
                this.joinSession();
                this.channel.closeFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        FileReceiver.this.closeFile();
                    }
                });
                return true;
            }
            logger.warn("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}:{}", (Object)relayHost, (Object)relayPort);
            return false;
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), e);
            return false;
        }
    }

    public void joinSession() {
        if (this.channel != null && this.channel.isActive()) {
            JoinMessage joinMsg = new JoinMessage(this.sessionId);
            this.channel.writeAndFlush(joinMsg);
            logger.info("\u53d1\u9001\u52a0\u5165\u4f1a\u8bdd\u8bf7\u6c42, \u4f1a\u8bddID: {}", (Object)this.sessionId);
        }
    }

    public void sessionJoined() {
        this.connectionLatch.countDown();
    }

    public void handleFileInfo(FileInfoMessage msg) throws IOException {
        this.fileName = msg.getFileName();
        this.fileSize = msg.getFileSize();
        this.totalChunks = msg.getChunks();
        this.chunkSize = msg.getChunkSize();
        this.expectedMd5 = msg.getMd5();
        this.transferStartTime = System.currentTimeMillis();
        logger.info("\u63a5\u6536\u6587\u4ef6\u4fe1\u606f: \u6587\u4ef6\u540d={}, \u5927\u5c0f={}, \u603b\u5757\u6570={}, MD5={}", this.fileName, FileTransferUtils.formatFileSize(this.fileSize), this.totalChunks, this.expectedMd5);
        File file = new File(this.saveDir, this.fileName);
        this.filePath = file.getAbsolutePath();
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udce5 \u63a5\u6536\u8fdb\u5ea6");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        if (this.shouldSkipFile(file, this.fileSize, this.expectedMd5)) {
            System.out.println("\ud83d\udce5 \u6587\u4ef6\u5df2\u5b58\u5728: " + file.getAbsolutePath());
            System.out.println("\u2705 \u6587\u4ef6\u5b8c\u6574\u6027\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8df3\u8fc7\u4f20\u8f93");
            FileSkipMessage skipMsg = new FileSkipMessage(msg.getSessionId(), this.fileName, "\u6587\u4ef6\u5df2\u5b58\u5728\u4e14MD5\u76f8\u540c", this.fileSize);
            this.channel.writeAndFlush(skipMsg);
            logger.info("\u23ed\ufe0f \u8df3\u8fc7\u6587\u4ef6: {} (\u6587\u4ef6\u5df2\u5b58\u5728\u4e14MD5\u76f8\u540c)", (Object)this.fileName);
            this.fileSkipped = true;
            this.transferCompleted = true;
            return;
        }
        if (file.exists()) {
            logger.info("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\u4f46\u9700\u8981\u91cd\u65b0\u4f20\u8f93\uff0c\u5c06\u5220\u9664: {}", (Object)file.getAbsolutePath());
            if (!file.delete()) {
                logger.warn("\u65e0\u6cd5\u5220\u9664\u5df2\u5b58\u5728\u7684\u6587\u4ef6: {}", (Object)file.getAbsolutePath());
            }
        }
        this.fos = new FileOutputStream(file);
        this.fileChannel = this.fos.getChannel();
        if (this.fileSize > 0L) {
            this.fileChannel.position(this.fileSize - 1L);
            this.fileChannel.write(ByteBuffer.wrap(new byte[1]));
            this.fileChannel.position(0L);
        } else {
            logger.info("\u521b\u5efa0\u5927\u5c0f\u6587\u4ef6: {}", (Object)file.getAbsolutePath());
        }
        logger.info("\u6587\u4ef6\u5df2\u521b\u5efa: {}", (Object)file.getAbsolutePath());
        TransferAckMessage readyMsg = new TransferAckMessage(msg.getSessionId());
        this.channel.writeAndFlush(readyMsg);
        logger.info("\u5df2\u53d1\u9001\u6587\u4ef6\u51c6\u5907\u5c31\u7eea\u786e\u8ba4: {}", (Object)this.fileName);
        this.connectionLatch.countDown();
    }

    public void handleFileChunk(FileChunkMessage msg) throws IOException {
        int chunkIndex = msg.getChunkIndex();
        byte[] data = msg.getData();
        if (this.receivedChunkMap.putIfAbsent(chunkIndex, Boolean.TRUE) != null) {
            logger.debug("\u5757\u5df2\u63a5\u6536\uff0c\u5ffd\u7565: {}", (Object)chunkIndex);
            return;
        }
        long position = (long)chunkIndex * (long)this.chunkSize;
        this.fileChannel.position(position);
        this.fileChannel.write(ByteBuffer.wrap(data));
        int received = this.receivedChunks.incrementAndGet();
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.transferStartTime;
        if (elapsedTime >= 0L) {
            long bytesReceived = (long)received * (long)data.length;
            double progressPercent = (double)received / (double)this.totalChunks * 100.0;
            double speedMBps = (double)bytesReceived / 1024.0 / 1024.0 / ((double)elapsedTime / 1000.0);
            if (received % 2 == 0 && received != this.totalChunks) {
                long transferredBytes = (long)received * (long)this.chunkSize;
                if (transferredBytes > this.fileSize) {
                    transferredBytes = this.fileSize;
                }
                String transferredSize = FileTransferUtils.formatFileSize(transferredBytes);
                String totalSize = FileTransferUtils.formatFileSize(this.fileSize);
                System.out.printf("\r\ud83d\udce5 \u63a5\u6536\u8fdb\u5ea6: %s | %s/%s (%.1f%%) | %d/%d \u5757 | %.2f MB/s", this.fileName, transferredSize, totalSize, progressPercent, received, this.totalChunks, speedMBps);
                System.out.flush();
            }
        }
    }

    public void handleTransferComplete() {
        if (this.transferCompleted) {
            logger.debug("\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\u5df2\u5904\u7406\u8fc7\uff0c\u8df3\u8fc7\u91cd\u590d\u5904\u7406");
            return;
        }
        if (this.receivedChunks.get() == this.totalChunks) {
            this.transferCompleted = true;
            long endTime = System.currentTimeMillis();
            long startTime = this.transferStartTime;
            long totalTime = endTime - startTime;
            double speedMBps = this.calculateTransferSpeed(this.fileSize, totalTime);
            this.closeFile();
            boolean isValid = true;
            if (this.expectedMd5 != null && !this.expectedMd5.trim().isEmpty()) {
                System.out.println();
                System.out.println("\ud83d\udd0d \u6b63\u5728\u9a8c\u8bc1\u6587\u4ef6\u5b8c\u6574\u6027...");
                String receivedMd5 = FileTransferUtils.calculateFileMD5(new File(this.saveDir, this.fileName));
                if (!this.expectedMd5.equals(receivedMd5)) {
                    logger.error("\u6587\u4ef6MD5\u4e0d\u5339\u914d: \u9884\u671f={}, \u5b9e\u9645={}", (Object)this.expectedMd5, (Object)receivedMd5);
                    System.out.println("\u274c \u6587\u4ef6\u5b8c\u6574\u6027\u9a8c\u8bc1\u5931\u8d25\uff01");
                    System.out.println("\u9884\u671fMD5: " + this.expectedMd5);
                    System.out.println("\u5b9e\u9645MD5: " + receivedMd5);
                    isValid = false;
                    return;
                }
                logger.info("\u6587\u4ef6MD5\u9a8c\u8bc1\u6210\u529f: {}", (Object)receivedMd5);
                System.out.println("\u2705 \u6587\u4ef6\u5b8c\u6574\u6027\u9a8c\u8bc1\u901a\u8fc7");
            }
            TransferAckMessage ackMsg = new TransferAckMessage(this.sessionId);
            this.channel.writeAndFlush(ackMsg);
            this.transferCompleted = true;
            logger.debug("\u6587\u4ef6\u63a5\u6536\u5b8c\u6210: {}, \u603b\u5171{}\u5757, \u8017\u65f6: {} \u79d2, \u5e73\u5747\u901f\u5ea6: {:.2f} MB/s", this.fileName, this.totalChunks, (double)totalTime / 1000.0, speedMBps);
            if (!this.completionMessageDisplayed) {
                this.completionMessageDisplayed = true;
                ConsoleFormatter.printFileReceiveComplete(this.fileName, this.fileSize, this.saveDir, totalTime, speedMBps);
            }
            this.channel.close();
        } else {
            logger.warn("\u6536\u5230\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\uff0c\u4f46\u4ecd\u6709\u5757\u672a\u63a5\u6536: \u5df2\u63a5\u6536={}, \u603b\u5757\u6570={}", (Object)this.receivedChunks.get(), (Object)this.totalChunks);
        }
    }

    private double calculateTransferSpeed(long bytes, long timeMs) {
        if (timeMs <= 0L) {
            return 0.0;
        }
        return (double)bytes / 1024.0 / 1024.0 / ((double)timeMs / 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() {
        if (this.filesClosed) {
            logger.debug("\u6587\u4ef6\u5df2\u7ecf\u5173\u95ed\uff0c\u8df3\u8fc7\u91cd\u590d\u5173\u95ed\u64cd\u4f5c");
            return;
        }
        FileReceiver fileReceiver = this;
        synchronized (fileReceiver) {
            if (this.filesClosed) {
                return;
            }
            this.filesClosed = true;
        }
        logger.debug("\u5f00\u59cb\u5173\u95ed\u6587\u4ef6\u8d44\u6e90...");
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
                logger.debug("\u6587\u4ef6\u901a\u9053\u5f3a\u5236\u5237\u65b0\u5b8c\u6210");
            }
            catch (IOException e) {
                logger.warn("\u5f3a\u5236\u5237\u65b0\u6587\u4ef6\u901a\u9053\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            }
            try {
                this.fileChannel.close();
                logger.debug("\u6587\u4ef6\u901a\u9053\u5173\u95ed\u5b8c\u6210");
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u901a\u9053\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
            finally {
                this.fileChannel = null;
            }
        }
        if (this.fos != null) {
            try {
                this.fos.flush();
                logger.debug("\u6587\u4ef6\u8f93\u51fa\u6d41\u5237\u65b0\u5b8c\u6210");
            }
            catch (IOException e) {
                logger.warn("\u5237\u65b0\u6587\u4ef6\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            }
            try {
                this.fos.close();
                logger.debug("\u6587\u4ef6\u8f93\u51fa\u6d41\u5173\u95ed\u5b8c\u6210");
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
            finally {
                this.fos = null;
            }
        }
        logger.debug("\u6587\u4ef6\u8d44\u6e90\u5173\u95ed\u64cd\u4f5c\u5b8c\u6210");
    }

    public void shutdown() {
        logger.debug("\u5f00\u59cb\u91ca\u653eFileReceiver\u8d44\u6e90");
        if (!this.filesClosed) {
            this.closeFile();
        }
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close().sync();
            }
            catch (InterruptedException e) {
                logger.warn("\u7b49\u5f85\u901a\u9053\u5173\u95ed\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.group != null && !this.group.isShutdown()) {
            this.group.shutdownGracefully();
        }
        logger.debug("FileReceiver\u8d44\u6e90\u91ca\u653e\u5b8c\u6210");
    }

    public void setExistingConnection(Channel channel, String sessionId) {
        this.channel = channel;
        this.sessionId = sessionId;
    }

    public void handleMessage(Message msg) throws Exception {
        if (msg.getType() == MessageType.FILE_INFO) {
            this.handleFileInfo((FileInfoMessage)msg);
        } else if (msg.getType() == MessageType.FILE_CHUNK) {
            this.handleFileChunk((FileChunkMessage)msg);
        } else if (msg.getType() == MessageType.TRANSFER_COMPLETE) {
            this.handleTransferComplete();
        } else if (msg.getType() == MessageType.ERROR) {
            ErrorMessage errorMsg = (ErrorMessage)msg;
            logger.error("\u6536\u5230\u9519\u8bef\u6d88\u606f: {}", (Object)errorMsg.getErrorMsg());
            logger.info("\u670d\u52a1\u5668\u9519\u8bef: " + errorMsg.getErrorMsg());
            HandlerExceptionUtils.handleException(this.channel.pipeline().lastContext(), new RuntimeException("\u63a5\u6536\u7aef\u9519\u8bef: " + errorMsg.getErrorMsg()), FileReceiver.class.getName());
        }
    }

    public boolean isFileSkipped() {
        return this.fileSkipped;
    }

    private boolean shouldSkipFile(File targetFile, long expectedSize, String expectedMd5) {
        try {
            if (!targetFile.exists()) {
                logger.debug("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u4f20\u8f93: {}", (Object)targetFile.getName());
                return false;
            }
            long existingSize = targetFile.length();
            if (existingSize != expectedSize) {
                logger.debug("\u6587\u4ef6\u5927\u5c0f\u4e0d\u5339\u914d\uff0c\u9700\u8981\u4f20\u8f93: {} (\u73b0\u6709: {}, \u671f\u671b: {})", targetFile.getName(), existingSize, expectedSize);
                return false;
            }
            logger.debug("\ud83d\udd0d \u6b63\u5728\u6821\u9a8c\u73b0\u6709\u6587\u4ef6: {}", (Object)targetFile.getName());
            String existingMd5 = null;
            try {
                existingMd5 = targetFile.length() == 0L ? "d41d8cd98f00b204e9800998ecf8427e" : FileTransferUtils.calculateFileMD5(targetFile);
            }
            catch (Exception e) {
                logger.warn("\u8ba1\u7b97\u6587\u4ef6MD5\u5931\u8d25\uff0c\u5c06\u91cd\u65b0\u4f20\u8f93: {} - {}", (Object)targetFile.getName(), (Object)e.getMessage());
                return false;
            }
            if (expectedMd5 != null && expectedMd5.equals(existingMd5)) {
                logger.info("\u2705 MD5\u5339\u914d\uff0c\u53ef\u8df3\u8fc7\u6587\u4ef6: {}", (Object)targetFile.getName());
                return true;
            }
            logger.debug("MD5\u4e0d\u5339\u914d\uff0c\u9700\u8981\u4f20\u8f93: {} (\u73b0\u6709: {}, \u671f\u671b: {})", targetFile.getName(), existingMd5, expectedMd5);
            return false;
        }
        catch (Exception e) {
            logger.warn("\u68c0\u67e5\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5c06\u91cd\u65b0\u4f20\u8f93: {} - {}", (Object)targetFile.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

