/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.sender;

import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.FileSkipMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.RegisterMessage;
import com.file.netty.protocol.RegisterResultMessage;
import com.file.netty.sender.FileSender;
import com.file.netty.utils.HandlerExceptionUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSender_with_pub_relay_hanlder
extends SimpleChannelInboundHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(FileSender_with_pub_relay_hanlder.class);
    private final FileSender sender;

    public FileSender_with_pub_relay_hanlder(FileSender sender) {
        this.sender = sender;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        RegisterMessage registerMsg = new RegisterMessage(this.sender.getSingleSessionId());
        ctx.writeAndFlush(registerMsg);
        logger.debug("\u5411\u516c\u7f51\u4e2d\u7ee7\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\uff0c\u4f7f\u7528\u9884\u8bbe\u4f1a\u8bddID: {}", (Object)this.sender.getSingleSessionId());
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        logger.debug("\u4ece\u516c\u7f51\u4e2d\u7ee7\u6536\u5230\u6d88\u606f: \u7c7b\u578b={}", (Object)msg.getType());
        switch (msg.getType()) {
            case REGISTER_RESULT: {
                RegisterResultMessage registerResult = (RegisterResultMessage)msg;
                if (registerResult.isSuccess()) {
                    logger.info("\u516c\u7f51\u4e2d\u7ee7\u4f1a\u8bdd\u5df2\u6ce8\u518c\uff0cID: {}", (Object)registerResult.getSessionId());
                    if (registerResult.getSessionId().equals(this.sender.getSingleSessionId())) break;
                    logger.warn("\u516c\u7f51\u4e2d\u7ee7\u8fd4\u56de\u7684\u4f1a\u8bddID\u4e0e\u9884\u8bbe\u4e0d\u4e00\u81f4: {} vs {}", (Object)registerResult.getSessionId(), (Object)this.sender.getSingleSessionId());
                    break;
                }
                logger.error("\u516c\u7f51\u4e2d\u7ee7\u6ce8\u518c\u4f1a\u8bdd\u5931\u8d25");
                ctx.close();
                break;
            }
            case JOIN_RESULT: {
                JoinResultMessage joinResult = (JoinResultMessage)msg;
                if (!joinResult.isSuccess()) break;
                logger.info("\u63a5\u6536\u7aef\u901a\u8fc7\u516c\u5171\u4e2d\u7ee7\u8fde\u63a5");
                this.sender.onReceiverConnectedViaPublic();
                break;
            }
            case TRANSFER_ACK: {
                if (this.sender.isAllDataSent()) {
                    logger.info("\u2705 \u63a5\u6536\u7aef\u786e\u8ba4\u4f20\u8f93\u5b8c\u6210");
                    this.sender.onTransferComplete();
                    break;
                }
                logger.info("\u2705 \u63a5\u6536\u7aef\u786e\u8ba4\u53ef\u4ee5\u4f20\u8f93\u6587\u4ef6");
                this.sender.onFileTransferAck();
                break;
            }
            case ERROR: {
                ErrorMessage errorMsg = (ErrorMessage)msg;
                String error = errorMsg.getErrorMsg();
                logger.error("\u4ece\u516c\u7f51\u4e2d\u7ee7\u6536\u5230\u9519\u8bef\u6d88\u606f: {}", (Object)error);
                if (this.sender.isTransferSuccessfullyCompleted() && (error.contains("\u63a5\u6536\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5") || error.contains("\u53d1\u9001\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5"))) {
                    logger.info("\u4f20\u8f93\u5b8c\u6210\u540e\u516c\u5171\u4e2d\u7ee7\u6b63\u5e38\u65ad\u5f00\u8fde\u63a5: {}", (Object)error);
                    this.sender.showExitMessage("\u516c\u5171\u4e2d\u7ee7");
                    break;
                }
                System.out.println("\u26a0\ufe0f \u4e2d\u7ee7\u670d\u52a1\u5668\u9519\u8bef: " + error);
                this.sender.onError(error);
                break;
            }
            case FILE_SKIP: {
                FileSkipMessage skipMsg = (FileSkipMessage)msg;
                logger.info("\u23ed\ufe0f \u63a5\u6536\u7aef\u8bf7\u6c42\u8df3\u8fc7\u6587\u4ef6: {} ({})", (Object)skipMsg.getFileName(), (Object)skipMsg.getReason());
                this.sender.onFileSkipped(skipMsg.getFileName(), skipMsg.getReason(), skipMsg.getFileSize());
                break;
            }
            default: {
                logger.warn("\u4ece\u516c\u7f51\u4e2d\u7ee7\u6536\u5230\u672a\u5904\u7406\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)msg.getType());
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info("\u4e0e\u516c\u7f51\u4e2d\u7ee7\u670d\u52a1\u5668\u8fde\u63a5\u65ad\u5f00");
        if (this.sender.isSilentClosing() || !this.sender.isActiveTransfer()) {
            logger.debug("\u9759\u9ed8\u5173\u95ed\u5907\u7528\u8fde\u63a5\u6216\u975e\u6d3b\u8dc3\u4f20\u8f93\u8fde\u63a5\u65ad\u5f00\uff0c\u4e0d\u89e6\u53d1\u4f20\u8f93\u5b8c\u6210\u903b\u8f91");
            super.channelInactive(ctx);
            return;
        }
        if (this.sender.isTransferSuccessfullyCompleted()) {
            logger.info("\u4f20\u8f93\u5df2\u6210\u529f\u5b8c\u6210\uff0c\u516c\u5171\u4e2d\u7ee7\u8fde\u63a5\u6b63\u5e38\u65ad\u5f00");
            this.sender.showExitMessage("\u516c\u5171\u4e2d\u7ee7");
        } else {
            HandlerExceptionUtils.handleException(ctx, new RuntimeException("\u63a5\u6536\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5"), FileSender_with_pub_relay_hanlder.class.getName());
        }
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        HandlerExceptionUtils.handleException(ctx, cause, FileSender_with_pub_relay_hanlder.class.getName());
    }
}

