/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.sender;

import com.file.netty.codec.CodecFactory;
import com.file.netty.config.RelayConfig;
import com.file.netty.protocol.BatchFileAckMessage;
import com.file.netty.protocol.BatchFileInfoMessage;
import com.file.netty.protocol.CompressedBatchCompleteMessage;
import com.file.netty.protocol.CompressedBatchDataMessage;
import com.file.netty.protocol.CompressedBatchManifestAckMessage;
import com.file.netty.protocol.CompressedBatchManifestMessage;
import com.file.netty.protocol.FileChunkMessage;
import com.file.netty.protocol.FileEntryInfo;
import com.file.netty.protocol.FileInfoMessage;
import com.file.netty.protocol.FolderCompleteMessage;
import com.file.netty.protocol.FolderInfoMessage;
import com.file.netty.protocol.HeartbeatMessage;
import com.file.netty.protocol.RegisterMessage;
import com.file.netty.protocol.TransferCompleteMessage;
import com.file.netty.protocol.TransferStatsMessage;
import com.file.netty.sender.FileSender;
import com.file.netty.sender.FolderSender_with_local_relay_hanlder;
import com.file.netty.sender.FolderSender_with_pub_relay_hanlder;
import com.file.netty.unified.UnifiedSender;
import com.file.netty.utils.BatchCompressor;
import com.file.netty.utils.BatchProgressTracker;
import com.file.netty.utils.CompressedBatchBuilder;
import com.file.netty.utils.ConsoleFormatter;
import com.file.netty.utils.ConsoleUtils;
import com.file.netty.utils.DynamicTimeoutCalculator;
import com.file.netty.utils.ExitMessageFormatter;
import com.file.netty.utils.FileSizeCategory;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.HandlerExceptionUtils;
import com.file.netty.utils.ParallelHashCalculator;
import com.file.netty.utils.TransferStrategyDecider;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderSender {
    private static final Logger logger = LoggerFactory.getLogger(FolderSender.class);
    private final String host;
    private final int port;
    private final File folder;
    private final int chunkSize;
    private String sessionId;
    private Channel channel;
    private volatile boolean receiverConnected = false;
    private volatile boolean transferComplete = false;
    private volatile boolean transferSuccessfullyCompleted = false;
    private volatile boolean exitMessageShown = false;
    private final AtomicInteger skippedFiles = new AtomicInteger(0);
    private final AtomicLong skippedSize = new AtomicLong(0L);
    private final Set<String> transmittedFiles;
    public static final int DEFAULT_MAX_FILES_LIMIT = 100000;
    public static final long SMALL_FILE_THRESHOLD = 0x100000L;
    public static final int BATCH_SIZE = 50;
    public static final int MAX_CONCURRENT_BATCHES = 3;
    private int totalFiles;
    private long totalSize;
    private volatile AtomicInteger filesSent;
    private volatile AtomicInteger filesConfirmed;
    private Map<String, CountDownLatch> fileLatchMap;
    private final Path basePath;
    private Channel publicRelayChannel;
    private boolean publicRelayConnected;
    private int localRelayPort;
    private String singleSessionId;
    private CountDownLatch receiverLatch;
    private Channel activeChannel;
    private volatile int currentSingleFileIndex;
    private volatile int currentSingleFilesTotal;
    private volatile boolean isInSingleFileTransferMode;
    private volatile String currentSendingFile;
    private volatile CountDownLatch currentFileLatch;
    private volatile boolean currentFileSkipped;
    private volatile CountDownLatch folderInfoConfirmationLatch;
    private final CountDownLatch publicRelayLatch;
    private boolean enableRelayServer;
    private volatile boolean silentClosing;
    private final Map<String, Double> transferSpeeds;
    private volatile double averageTransferSpeed;
    private volatile DynamicTimeoutCalculator.NetworkCondition networkCondition;
    private volatile boolean isActiveTransfer;
    private final AtomicInteger globalBatchIdCounter;
    private final Map<Integer, CountDownLatch> batchLatchMap;
    private final Map<Integer, BatchFileAckMessage> batchAckMap;
    private final Map<Integer, CountDownLatch> compressedBatchLatchMap;
    private final Map<Integer, CompressedBatchManifestAckMessage> compressedBatchAckMap;
    private final Map<Integer, CountDownLatch> compressedBatchManifestLatchMap;
    private final Map<Integer, CompressedBatchManifestAckMessage> compressedBatchManifestAckMap;
    private final ExecutorService batchExecutor;
    private final AtomicInteger activeBatches;
    private BatchProgressTracker batchProgressTracker;
    private UnifiedSender parentSender;
    private long folderStartTime;
    private long actualTransferStartTime;
    private volatile boolean heartbeatRunning;

    public FolderSender(String host, int port, File folder, int chunkSize) {
        new ConcurrentHashMap();
        this.transmittedFiles = ConcurrentHashMap.newKeySet();
        this.filesSent = new AtomicInteger(0);
        this.filesConfirmed = new AtomicInteger(0);
        this.fileLatchMap = new ConcurrentHashMap<String, CountDownLatch>();
        this.publicRelayConnected = false;
        this.receiverLatch = new CountDownLatch(1);
        this.currentSingleFileIndex = 0;
        this.currentSingleFilesTotal = 0;
        this.isInSingleFileTransferMode = false;
        this.currentSendingFile = null;
        this.currentFileLatch = null;
        this.currentFileSkipped = false;
        this.publicRelayLatch = new CountDownLatch(1);
        this.enableRelayServer = true;
        this.silentClosing = false;
        this.transferSpeeds = new ConcurrentHashMap<String, Double>();
        this.averageTransferSpeed = 0.0;
        this.networkCondition = DynamicTimeoutCalculator.NetworkCondition.UNKNOWN;
        this.isActiveTransfer = false;
        this.globalBatchIdCounter = new AtomicInteger(1);
        this.batchLatchMap = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.batchAckMap = new ConcurrentHashMap<Integer, BatchFileAckMessage>();
        this.compressedBatchLatchMap = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.compressedBatchAckMap = new ConcurrentHashMap<Integer, CompressedBatchManifestAckMessage>();
        this.compressedBatchManifestLatchMap = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.compressedBatchManifestAckMap = new ConcurrentHashMap<Integer, CompressedBatchManifestAckMessage>();
        this.batchExecutor = Executors.newFixedThreadPool(3);
        this.activeBatches = new AtomicInteger(0);
        this.heartbeatRunning = true;
        this.host = host;
        this.port = port;
        this.folder = folder;
        this.chunkSize = chunkSize;
        this.basePath = folder.toPath();
        this.singleSessionId = FileTransferUtils.generateSessionId();
    }

    public void setParentSender(UnifiedSender parentSender) {
        this.parentSender = parentSender;
    }

    public void disableRelayServer() {
        this.enableRelayServer = false;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.singleSessionId = sessionId;
    }

    public void start() throws Exception {
        if (!this.folder.exists() || !this.folder.isDirectory()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6\u5939: " + this.folder.getAbsolutePath());
        }
        this.startTransfer();
    }

    public void startTransfer() throws Exception {
        this.initializeNetworkCondition();
        if (!this.folder.exists() || !this.folder.isDirectory()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u4ef6\u5939: " + this.folder.getAbsolutePath());
        }
        this.prepareFileEntries();
        NioEventLoopGroup group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        try {
            if ("localhost".equals(this.host) || "127.0.0.1".equals(this.host)) {
                this.connectToLocalRelay(group);
            } else {
                this.connectToSpecificRelay(group, this.host, this.port);
            }
            boolean receiverConnected = this.receiverLatch.await(30L, TimeUnit.MINUTES);
            if (!receiverConnected) {
                logger.warn("\u63a5\u6536\u7aef\u8fde\u63a5\u8d85\u65f6");
                logger.info("\u7b49\u5f85\u63a5\u6536\u7aef\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u786e\u4fdd\u63a5\u6536\u7aef\u6b63\u786e\u8f93\u5165\u63a5\u6536\u7801");
            }
            if (this.channel != null) {
                this.channel.closeFuture().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private void prepareFileEntries() {
        logger.info("\ud83d\ude80 \u6b63\u5728\u626b\u63cf\u6587\u4ef6\u5939\uff08\u4f18\u5316\u6a21\u5f0f\uff09: " + this.folder.getAbsolutePath());
        List<String> emptyDirectories = FileTransferUtils.getEmptyDirectories(this.folder, this.basePath);
        logger.info("\u53d1\u73b0 {} \u4e2a\u7a7a\u76ee\u5f55", (Object)emptyDirectories.size());
        this.totalFiles = FileTransferUtils.countFiles(this.folder.getAbsolutePath());
        this.totalSize = FileTransferUtils.calculateFolderSize(this.folder.getAbsolutePath());
        logger.info("\u2705 \u626b\u63cf\u5b8c\u6210\uff0c\u5171\u53d1\u73b0 {} \u4e2a\u6587\u4ef6\uff0c{} \u4e2a\u7a7a\u76ee\u5f55\uff0c\u603b\u5927\u5c0f: {}", this.totalFiles, emptyDirectories.size(), FileTransferUtils.formatFileSize(this.totalSize));
    }

    public void onReceiverConnectedViaLocal() {
        if (this.receiverConnected) {
            logger.info("\u63a5\u6536\u7aef\u8fde\u63a5\u5df2\u5904\u7406\u8fc7\uff0c\u5ffd\u7565\u91cd\u590d\u8fde\u63a5 - \u672c\u5730\u4e2d\u7ee7: {}:{}", (Object)this.host, (Object)this.port);
            return;
        }
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7\u672c\u5730\u4e2d\u7ee7\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
        String relayInfo = "\u672c\u5730\u4e2d\u7ee7 " + this.host + ":" + this.port;
        if (this.parentSender != null && !this.parentSender.handleGlobalReceiverConnection(relayInfo, this)) {
            logger.info("\u5176\u4ed6\u53d1\u9001\u5668\u5df2\u5904\u7406\u63a5\u6536\u7aef\u8fde\u63a5\uff0c\u672c\u8fde\u63a5\u88ab\u5ffd\u7565");
            return;
        }
        this.isActiveTransfer = true;
        this.activeChannel = this.channel;
        this.onReceiverConnected("\u672c\u5730\u4e2d\u7ee7");
    }

    public void onReceiverConnectedViaPublic() {
        if (this.receiverConnected) {
            logger.info("\u63a5\u6536\u7aef\u8fde\u63a5\u5df2\u5904\u7406\u8fc7\uff0c\u5ffd\u7565\u91cd\u590d\u8fde\u63a5 - \u4e2d\u7ee7: {}:{}", (Object)this.host, (Object)this.port);
            return;
        }
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7\u5916\u90e8\u4e2d\u7ee7\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
        String relayType = this.host.equals("relay.daodaovps.com") && this.port == 8001 ? "\u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7" : "\u5916\u90e8\u4e2d\u7ee7";
        String relayInfo = relayType + " " + this.host + ":" + this.port;
        if (this.parentSender != null && !this.parentSender.handleGlobalReceiverConnection(relayInfo, this)) {
            logger.info("\u5176\u4ed6\u53d1\u9001\u5668\u5df2\u5904\u7406\u63a5\u6536\u7aef\u8fde\u63a5\uff0c\u672c\u8fde\u63a5\u88ab\u5ffd\u7565");
            return;
        }
        this.isActiveTransfer = true;
        this.activeChannel = this.channel;
        this.onReceiverConnected(relayType);
    }

    private void onReceiverConnected(String relayType) {
        this.receiverConnected = true;
        logger.info("\u63a5\u6536\u7aef\u901a\u8fc7{}\u5df2\u8fde\u63a5\uff0c\u5f00\u59cb\u53d1\u9001\u6587\u4ef6\u5939...", (Object)relayType);
        System.out.println("\u2705 \u63a5\u6536\u7aef\u5df2\u8fde\u63a5 (" + relayType + ")\uff0c\u5f00\u59cb\u4f20\u8f93\u6587\u4ef6\u5939...");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc1 \u6587\u4ef6\u5939\u4f20\u8f93\u8fdb\u5ea6");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        this.folderStartTime = System.currentTimeMillis();
        this.receiverLatch.countDown();
        this.startHeartbeat();
        List<String> emptyDirectories = FileTransferUtils.getEmptyDirectories(this.folder, this.basePath);
        FolderInfoMessage folderInfoMsg = new FolderInfoMessage(this.sessionId, this.folder.getName(), emptyDirectories, this.totalFiles, this.totalSize, this.chunkSize);
        if (this.activeChannel != null && this.activeChannel.isActive()) {
            this.folderInfoConfirmationLatch = new CountDownLatch(1);
            this.activeChannel.writeAndFlush(folderInfoMsg);
            logger.info("\u6587\u4ef6\u5939\u4fe1\u606f\u5df2\u53d1\u9001\uff0c\u7b49\u5f85\u63a5\u6536\u7aef\u786e\u8ba4...");
            new Thread(() -> {
                try {
                    System.out.println("\u23f3 \u7b49\u5f85\u63a5\u6536\u7aef\u786e\u8ba4\u6587\u4ef6\u5939\u7ed3\u6784...");
                    logger.debug("\u7b49\u5f85\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4...");
                    boolean confirmed = this.folderInfoConfirmationLatch.await(60L, TimeUnit.SECONDS);
                    if (confirmed) {
                        System.out.println("\u2705 \u63a5\u6536\u7aef\u5df2\u786e\u8ba4\u6587\u4ef6\u5939\u7ed3\u6784");
                        logger.info("\u63a5\u6536\u7aef\u5df2\u786e\u8ba4\u6587\u4ef6\u5939\u7ed3\u6784\u521b\u5efa\u5b8c\u6210\uff0c\u5f00\u59cb\u53d1\u9001\u6587\u4ef6...");
                        this.sendFilesInNewThread();
                    } else {
                        logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u786e\u8ba4\u6587\u4ef6\u5939\u4fe1\u606f\u8d85\u65f6\uff0c\u5c06\u4e0d\u4f1a\u53d1\u9001\u6587\u4ef6");
                        logger.info("\u7b49\u5f85\u63a5\u6536\u7aef\u5904\u7406\u6587\u4ef6\u5939\u7ed3\u6784\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\u6216\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5");
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u786e\u8ba4\u6587\u4ef6\u5939\u4fe1\u606f\u65f6\u88ab\u4e2d\u65ad", e);
                    Thread.currentThread().interrupt();
                }
            }, "FolderInfoConfirmationThread").start();
        } else {
            logger.error("\u6d3b\u8dc3\u901a\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u53d1\u9001\u6587\u4ef6\u5939\u4fe1\u606f");
        }
    }

    private void sendFilesInNewThread() {
        int currentConfirmed;
        System.out.print("\ud83d\ude80 \u6b63\u5728\u542f\u52a8\u4f18\u5316\u4f20\u8f93\u6a21\u5f0f...");
        System.out.flush();
        List<FileEntryInfo> sortedEntries = FileTransferUtils.getAllFileEntries(this.folder, this.basePath);
        Collections.sort(sortedEntries, (a, b) -> {
            if (a.isDirectory() && !b.isDirectory()) {
                return -1;
            }
            if (!a.isDirectory() && b.isDirectory()) {
                return 1;
            }
            return a.getRelativePath().compareTo(b.getRelativePath());
        });
        System.out.println(" \u5b8c\u6210");
        System.out.flush();
        System.out.print("\ud83d\udcca \u6b63\u5728\u5206\u6790\u6587\u4ef6\u5927\u5c0f\u5206\u7c7b...");
        System.out.flush();
        Map<FileSizeCategory, List<FileEntryInfo>> categoryGroups = this.groupFilesByCategory(sortedEntries);
        System.out.println(" \u5b8c\u6210");
        System.out.flush();
        logger.info("\ud83d\udcca \u6587\u4ef6\u5206\u7ea7\u7edf\u8ba1:");
        for (FileSizeCategory category : FileSizeCategory.values()) {
            List<FileEntryInfo> filesInCategory = categoryGroups.get((Object)category);
            if (filesInCategory == null || filesInCategory.isEmpty()) continue;
            logger.info("   {} {}: {} \u4e2a\u6587\u4ef6 (\u6279\u6b21\u5927\u5c0f: {})", category.getIcon(), category.getDisplayName(), filesInCategory.size(), category.getBatchSize());
        }
        boolean allFilesSuccessfullySent = true;
        try {
            this.sendTransferStatsBeforeTransfer(categoryGroups);
            allFilesSuccessfullySent = this.sendAllFilesByCategory(categoryGroups);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4f20\u8f93\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
            allFilesSuccessfullySent = false;
        }
        if (allFilesSuccessfullySent) {
            int currentSent = this.filesSent.get();
            currentConfirmed = this.filesConfirmed.get();
            int currentSkipped = this.skippedFiles.get();
            logger.info("\ud83d\udcca \u53d1\u9001\u7aef\u5b8c\u6210\u7edf\u8ba1: \u5df2\u53d1\u9001={}, \u5df2\u786e\u8ba4={}, \u5df2\u8df3\u8fc7={}, \u603b\u8ba1={}/{}", currentSent, currentConfirmed, currentSkipped, currentSent, this.totalFiles);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            logger.info("\u6240\u6709\u6587\u4ef6\u53d1\u9001\u5b8c\u6210\uff0c\u53d1\u9001\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\u6d88\u606f");
            FolderCompleteMessage completeMsg = new FolderCompleteMessage(this.sessionId, this.folder.getName(), this.totalFiles, this.totalSize);
            this.activeChannel.writeAndFlush(completeMsg);
            logger.info("\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\u5df2\u53d1\u9001\uff0c\u7b49\u5f85\u63a5\u6536\u7aef\u5904\u7406\u5b8c\u6210...");
        } else {
            int currentSent = this.filesSent.get();
            currentConfirmed = this.filesConfirmed.get();
            int currentSkipped = this.skippedFiles.get();
            logger.error("\ud83d\udcca \u6587\u4ef6\u4f20\u8f93\u672a\u5168\u90e8\u5b8c\u6210: \u5df2\u53d1\u9001={}, \u5df2\u786e\u8ba4={}, \u5df2\u8df3\u8fc7={}, \u603b\u8ba1={}/{}, \u4e0d\u53d1\u9001\u6587\u4ef6\u5939\u5b8c\u6210\u6d88\u606f", currentSent, currentConfirmed, currentSkipped, currentSent, this.totalFiles);
        }
    }

    private int getFileIndex(FileEntryInfo entry) {
        return 1;
    }

    private int getFileIndexByName(String fileName) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFileAndWaitCompletion(FileEntryInfo entry, int fileIndex, int totalFiles) throws Exception {
        CountDownLatch fileLatch;
        this.currentSingleFileIndex = fileIndex;
        this.currentSingleFilesTotal = totalFiles;
        this.isInSingleFileTransferMode = true;
        if (this.transmittedFiles.contains(entry.getRelativePath())) {
            logger.debug("\u8df3\u8fc7\u5df2\u4f20\u8f93\u6587\u4ef6: {}", (Object)entry.getRelativePath());
            this.filesConfirmed.incrementAndGet();
            return true;
        }
        String normalizedPath = FileTransferUtils.normalizePath(entry.getRelativePath());
        File file = new File(this.folder, entry.getRelativePath());
        if (!file.exists() || !file.isFile()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)file.getAbsolutePath());
            return false;
        }
        if (file.length() == 0L) {
            logger.debug("\ud83d\udd04 \u5904\u7406\u7a7a\u6587\u4ef6\uff08\u65b0\u6d41\u7a0b\uff09: {}", (Object)entry.getRelativePath());
            System.out.printf("\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6 (%d/%d): %s | 0 B/0 B (100.00%%) | \u7a7a\u6587\u4ef6\u4f20\u8f93\u4e2d\n", fileIndex, totalFiles, entry.getRelativePath());
            System.out.flush();
            String md5 = "d41d8cd98f00b204e9800998ecf8427e";
            int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(0L);
            FileInfoMessage fileInfoMsg = new FileInfoMessage(this.sessionId, normalizedPath, 0L, 0, optimalChunkSize, md5);
            CountDownLatch infoLatch = new CountDownLatch(1);
            ChannelFuture infoFuture = this.activeChannel.writeAndFlush(fileInfoMsg);
            infoFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    logger.error("\u7a7a\u6587\u4ef6\u4fe1\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)entry.getRelativePath());
                }
                infoLatch.countDown();
            }));
            if (!infoLatch.await(10L, TimeUnit.SECONDS)) {
                logger.error("\u53d1\u9001\u7a7a\u6587\u4ef6\u4fe1\u606f\u8d85\u65f6: {}", (Object)entry.getRelativePath());
                return false;
            }
            CountDownLatch ackLatch = new CountDownLatch(1);
            this.currentSendingFile = entry.getRelativePath();
            this.currentFileLatch = ackLatch;
            this.currentFileSkipped = false;
            logger.debug("\ud83d\udd04 \u7a7a\u6587\u4ef6\u7b49\u5f85ACK\u786e\u8ba4: {}", (Object)entry.getRelativePath());
            try {
                boolean ackReceived = ackLatch.await(30L, TimeUnit.SECONDS);
                this.currentSendingFile = null;
                this.currentFileLatch = null;
                if (!ackReceived) {
                    logger.error("\u7b49\u5f85\u7a7a\u6587\u4ef6ACK\u8d85\u65f6: {}", (Object)entry.getRelativePath());
                    return false;
                }
                if (this.currentFileSkipped) {
                    logger.debug("\ud83d\udd04 \u7a7a\u6587\u4ef6\u88ab\u8df3\u8fc7: {}", (Object)entry.getRelativePath());
                    PrintStream printStream = System.out;
                    synchronized (printStream) {
                        System.out.printf("\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6 (%d/%d): %s | 0 B/0 B (100.00%%) | \u6587\u4ef6\u68c0\u67e5\u4e2d\n", fileIndex, totalFiles, entry.getRelativePath());
                        System.out.flush();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        System.out.printf("\u2705 \u53d1\u9001\u5b8c\u6210 (%d/%d): %s | 0 B (\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93)\n\n", fileIndex, totalFiles, entry.getRelativePath());
                        System.out.flush();
                    }
                    return true;
                }
                int sent = this.filesSent.incrementAndGet();
                double progress = (double)sent / (double)totalFiles * 100.0;
                System.out.printf("\u2705 \u53d1\u9001\u5b8c\u6210 (%d/%d): %s | 0 B\n\n", fileIndex, totalFiles, entry.getRelativePath());
                return true;
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u7a7a\u6587\u4ef6ACK\u65f6\u88ab\u4e2d\u65ad: {}", (Object)entry.getRelativePath(), (Object)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        String md5 = FileTransferUtils.calculateFileMD5(file);
        logger.info("\u6587\u4ef6MD5: {}", (Object)md5);
        int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(file.length());
        int totalChunks = FileTransferUtils.calculateChunks(file.length(), optimalChunkSize);
        logger.debug("\u6587\u4ef6\u4f20\u8f93\u53c2\u6570\u8ba1\u7b97: \u6587\u4ef6={}, \u5927\u5c0f={}\u5b57\u8282, \u5757\u5927\u5c0f={}KB, \u5757\u6570={}", entry.getRelativePath(), file.length(), optimalChunkSize / 1024, totalChunks);
        FileInfoMessage fileInfoMsg = new FileInfoMessage(this.sessionId, normalizedPath, file.length(), totalChunks, optimalChunkSize, md5);
        CountDownLatch infoLatch = new CountDownLatch(1);
        ChannelFuture infoFuture = this.activeChannel.writeAndFlush(fileInfoMsg);
        infoFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                logger.info("\u6587\u4ef6\u4fe1\u606f\u53d1\u9001\u6210\u529f: {}", (Object)entry.getRelativePath());
            } else {
                logger.error("\u6587\u4ef6\u4fe1\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)entry.getRelativePath());
            }
            infoLatch.countDown();
        }));
        if (!infoLatch.await(10L, TimeUnit.SECONDS)) {
            logger.error("\u53d1\u9001\u6587\u4ef6\u4fe1\u606f\u8d85\u65f6: {}", (Object)entry.getRelativePath());
            return false;
        }
        CountDownLatch responseLatch = new CountDownLatch(1);
        this.currentSendingFile = entry.getRelativePath();
        this.currentFileLatch = responseLatch;
        this.currentFileSkipped = false;
        logger.info("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u6587\u4ef6\u4f20\u8f93\u8bf7\u6c42: {}", (Object)entry.getRelativePath());
        try {
            if (!responseLatch.await(30L, TimeUnit.SECONDS)) {
                logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u8d85\u65f6: {}", (Object)entry.getRelativePath());
                return false;
            }
        }
        catch (InterruptedException e) {
            logger.error("\u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\u65f6\u88ab\u4e2d\u65ad: {}", (Object)entry.getRelativePath(), (Object)e);
            Thread.currentThread().interrupt();
            return false;
        }
        if (this.currentFileSkipped) {
            logger.info("\u6587\u4ef6\u88ab\u63a5\u6536\u7aef\u8df3\u8fc7: {}", (Object)entry.getRelativePath());
            String totalSize = FileTransferUtils.formatFileSize(entry.getFileSize());
            PrintStream progress = System.out;
            synchronized (progress) {
                System.out.printf("\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6 (%d/%d): %s | %s/%s (100.00%%) | \u6587\u4ef6\u68c0\u67e5\u4e2d\n", fileIndex, totalFiles, entry.getRelativePath(), totalSize, totalSize);
                System.out.flush();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                System.out.printf("\u2705 \u53d1\u9001\u5b8c\u6210 (%d/%d): %s | %s (\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93)\n\n", fileIndex, totalFiles, entry.getRelativePath(), totalSize);
                System.out.flush();
            }
            return true;
        }
        logger.info("\u63a5\u6536\u7aef\u786e\u8ba4\u53ef\u4ee5\u4f20\u8f93\u6587\u4ef6: {}", (Object)entry.getRelativePath());
        this.currentFileLatch = fileLatch = new CountDownLatch(1);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] buffer = new byte[optimalChunkSize];
            long startTime = System.currentTimeMillis();
            long totalBytesSent = 0L;
            for (int i = 0; i < totalChunks; ++i) {
                long offset = (long)i * (long)optimalChunkSize;
                int n = (int)Math.min((long)optimalChunkSize, file.length() - offset);
                raf.seek(offset);
                int bytesRead = raf.read(buffer, 0, n);
                byte[] data = Arrays.copyOf(buffer, bytesRead);
                FileChunkMessage chunkMsg = new FileChunkMessage(this.sessionId, i, data);
                boolean sent = this.sendChunkAsync(chunkMsg);
                if (!sent) {
                    logger.error("\u53d1\u9001\u6587\u4ef6\u5757\u5931\u8d25\uff0c\u4e2d\u6b62\u6587\u4ef6\u4f20\u8f93: {} - \u5757\u7d22\u5f15: {}", (Object)entry.getRelativePath(), (Object)i);
                    boolean bl = false;
                    return bl;
                }
                totalBytesSent += (long)bytesRead;
                long currentTime = System.currentTimeMillis();
                long elapsedTime = currentTime - startTime;
                if (elapsedTime <= 0L) {
                    elapsedTime = 1L;
                }
                long bytesSent = totalBytesSent;
                double progress = (double)bytesSent / (double)file.length() * 100.0;
                double speedMBps = (double)bytesSent / 1024.0 / 1024.0 / ((double)elapsedTime / 1000.0);
                boolean shouldShow = false;
                if (totalChunks == 1) {
                    shouldShow = i == 0;
                } else if (totalChunks <= 5) {
                    shouldShow = true;
                } else if (totalChunks <= 20) {
                    shouldShow = i == 0 || i % 2 == 0 || i == totalChunks - 1;
                } else {
                    boolean bl = shouldShow = i == 0 || i % 10 == 0 || i == totalChunks - 1;
                }
                if (!shouldShow) continue;
                logger.info("\u6587\u4ef6\u53d1\u9001\u8fdb\u5ea6: {} - {}%, \u901f\u5ea6: {:.2f} MB/s, \u5757: {}/{}", entry.getRelativePath(), String.format("%.2f", progress), speedMBps, i + 1, totalChunks);
                long sentBytes = bytesSent;
                if (sentBytes > file.length()) {
                    sentBytes = file.length();
                }
                String sentSize = FileTransferUtils.formatFileSize(sentBytes);
                String totalSize = FileTransferUtils.formatFileSize(file.length());
                System.out.printf("\r\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6 (%d/%d): %s | %s/%s (%.2f%%) | %.2f MB/s", fileIndex, totalFiles, entry.getRelativePath(), sentSize, totalSize, progress, speedMBps);
                if (i == totalChunks - 1) {
                    System.out.println();
                }
                System.out.flush();
                if (totalChunks > 10) continue;
                try {
                    int delayMs = totalChunks == 1 ? 200 : (totalChunks <= 3 ? 150 : 100);
                    Thread.sleep(delayMs);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            TransferCompleteMessage completeMsg = new TransferCompleteMessage(this.sessionId);
            CountDownLatch completeLatch = new CountDownLatch(1);
            ChannelFuture completeFuture = this.activeChannel.writeAndFlush(completeMsg);
            completeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    logger.info("\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\u53d1\u9001\u6210\u529f: {}", (Object)entry.getRelativePath());
                } else {
                    logger.error("\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)entry.getRelativePath());
                }
                completeLatch.countDown();
            }));
            if (!completeLatch.await(10L, TimeUnit.SECONDS)) {
                logger.error("\u53d1\u9001\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\u6d88\u606f\u8d85\u65f6: {}", (Object)entry.getRelativePath());
                boolean bl = false;
                return bl;
            }
            int n = this.calculateSingleFileTimeout(entry.getFileSize());
            logger.info("\u7b49\u5f85\u6587\u4ef6\u786e\u8ba4: {} (\u52a8\u6001\u8d85\u65f6: {}\u79d2, \u6587\u4ef6\u5927\u5c0f: {})", entry.getRelativePath(), n, FileTransferUtils.formatFileSize(entry.getFileSize()));
            boolean confirmed = fileLatch.await(n, TimeUnit.SECONDS);
            this.currentSendingFile = null;
            this.currentFileLatch = null;
            if (!confirmed) {
                logger.error("\u7b49\u5f85\u6587\u4ef6\u786e\u8ba4\u8d85\u65f6: {}", (Object)entry.getRelativePath());
                boolean data = false;
                return data;
            }
            int sent = this.filesSent.incrementAndGet();
            int skipped = this.skippedFiles.get();
            String totalSize = FileTransferUtils.formatFileSize(file.length());
            System.out.printf("\u2705 \u53d1\u9001\u5b8c\u6210 (%d/%d): %s | %s\n\n", fileIndex, totalFiles, entry.getRelativePath(), totalSize);
            boolean bl = true;
            return bl;
        }
    }

    private boolean sendChunkAsync(FileChunkMessage chunkMsg) throws InterruptedException {
        int maxRetries = 1;
        for (int retry = 0; retry < maxRetries; ++retry) {
            if (!this.activeChannel.isActive()) {
                logger.error("\u901a\u9053\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d1\u9001\u6587\u4ef6\u5757");
                return false;
            }
            if (!this.activeChannel.isWritable()) {
                logger.warn("\u901a\u9053\u4e0d\u53ef\u5199\uff0c\u7b49\u5f85\u6062\u590d...");
                for (int wait = 0; wait < 10; ++wait) {
                    Thread.sleep(100L);
                    if (this.activeChannel.isWritable()) break;
                }
                if (!this.activeChannel.isWritable()) {
                    logger.warn("\u901a\u9053\u6301\u7eed\u4e0d\u53ef\u5199\uff0c\u91cd\u8bd5\u53d1\u9001");
                    continue;
                }
            }
            try {
                CountDownLatch chunkLatch = new CountDownLatch(1);
                AtomicBoolean chunkSuccess = new AtomicBoolean(false);
                ChannelFuture future = this.activeChannel.writeAndFlush(chunkMsg);
                future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                    chunkSuccess.set(f.isSuccess());
                    chunkLatch.countDown();
                }));
                if (chunkLatch.await(60L, TimeUnit.SECONDS) && chunkSuccess.get()) {
                    return true;
                }
                if (retry >= maxRetries - 1) continue;
                logger.warn("\u6587\u4ef6\u5757\u53d1\u9001\u5931\u8d25\uff0c\u91cd\u8bd5 {}/{}", (Object)(retry + 1), (Object)maxRetries);
                Thread.sleep(500L);
                System.out.println("\u23f1\ufe0f \u91cd\u8bd5\u53d1\u9001 (" + (retry + 1) + "/" + maxRetries + ")");
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6587\u4ef6\u5757\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
                if (retry >= maxRetries - 1) continue;
                Thread.sleep(1000L);
            }
        }
        return false;
    }

    private boolean shouldContinueAfterFailure(FileEntryInfo failedEntry) {
        long fileSize;
        File file = new File(this.folder, failedEntry.getRelativePath());
        long l = fileSize = file.exists() ? file.length() : failedEntry.getFileSize();
        if (fileSize < 0xA00000L) {
            logger.info("\u5c0f\u6587\u4ef6\u4f20\u8f93\u5931\u8d25\uff0c\u7ee7\u7eed\u4f20\u8f93\u5176\u4ed6\u6587\u4ef6");
            return true;
        }
        logger.error("\u5927\u6587\u4ef6\u4f20\u8f93\u5931\u8d25\uff0c\u505c\u6b62\u6574\u4e2a\u4f20\u8f93\u8fc7\u7a0b");
        return false;
    }

    public void onFileTransferAck() {
        if (this.currentFileLatch != null) {
            this.currentFileLatch.countDown();
            logger.info("\u63a5\u6536\u5230\u6587\u4ef6\u4f20\u8f93\u786e\u8ba4: {}", (Object)this.currentSendingFile);
        }
        int confirmed = this.filesConfirmed.incrementAndGet();
        logger.info("\u5df2\u786e\u8ba4 {}/{} \u6587\u4ef6", (Object)confirmed, (Object)this.totalFiles);
    }

    public void onFileSkipped(String fileName, String reason, long fileSize) {
        int displayTotalFiles;
        int displayFileIndex;
        this.skippedFiles.incrementAndGet();
        this.skippedSize.addAndGet(fileSize);
        if (this.currentSendingFile != null && this.currentSendingFile.equals(fileName)) {
            this.currentFileSkipped = true;
            if (this.currentFileLatch != null) {
                this.currentFileLatch.countDown();
                logger.info("\u6587\u4ef6\u8df3\u8fc7\uff0c\u53d6\u6d88\u7b49\u5f85\u4f20\u8f93\u786e\u8ba4: {}", (Object)fileName);
            }
            this.currentSendingFile = null;
            this.currentFileLatch = null;
        }
        int sent = this.filesSent.incrementAndGet();
        int confirmed = this.filesConfirmed.incrementAndGet();
        double progress = (double)sent / (double)this.totalFiles * 100.0;
        if (this.isInSingleFileTransferMode) {
            displayFileIndex = this.currentSingleFileIndex;
            displayTotalFiles = this.currentSingleFilesTotal;
            logger.debug("\u4f7f\u7528\u5355\u6587\u4ef6\u4f20\u8f93\u4e0a\u4e0b\u6587\u663e\u793a: {}/{} for {}", displayFileIndex, displayTotalFiles, fileName);
        } else {
            displayFileIndex = this.getFileIndexByName(fileName);
            displayTotalFiles = this.totalFiles;
            logger.debug("\u4f7f\u7528\u5168\u5c40\u6587\u4ef6\u7d22\u5f15\u663e\u793a: {}/{} for {}", displayFileIndex, displayTotalFiles, fileName);
        }
        String totalSize = FileTransferUtils.formatFileSize(fileSize);
        logger.info("\ud83d\udd27 \u6587\u4ef6\u88ab\u8df3\u8fc7: {} ({}/{}) - {} (\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93) [\u4e0d\u5728\u5f02\u6b65\u56de\u8c03\u4e2d\u8f93\u51fa]", fileName, displayFileIndex, displayTotalFiles, totalSize);
        logger.info("\u6587\u4ef6\u8df3\u8fc7\u7edf\u8ba1: \u5df2\u8df3\u8fc7 {} \u4e2a\u6587\u4ef6, \u8282\u7701 {} \u4f20\u8f93", (Object)this.skippedFiles.get(), (Object)this.formatFileSize(this.skippedSize.get()));
    }

    private String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", (double)size / 1024.0 / 1024.0);
        }
        return String.format("%.2f GB", (double)size / 1024.0 / 1024.0 / 1024.0);
    }

    public void onFolderTransferComplete() {
        if (this.transferComplete) {
            return;
        }
        this.transferComplete = true;
        this.transferSuccessfullyCompleted = true;
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - this.folderStartTime;
        long actualTransferTime = endTime - (this.actualTransferStartTime > 0L ? this.actualTransferStartTime : this.folderStartTime);
        double speedMBps = this.calculateTransferSpeed(this.totalSize, actualTransferTime);
        logger.info("\u63a5\u6536\u7aef\u786e\u8ba4\u4f20\u8f93\u5b8c\u6210\uff0c\u5f00\u59cb\u6e05\u7406\u5de5\u4f5c");
        logger.info("\u4f20\u8f93\u65f6\u95f4\u7edf\u8ba1 - \u5b8c\u6574\u65f6\u95f4: {}ms, \u5b9e\u9645\u4f20\u8f93\u65f6\u95f4: {}ms, \u9884\u5904\u7406\u65f6\u95f4: {}ms", totalTime, actualTransferTime, this.actualTransferStartTime - this.folderStartTime);
        ConsoleFormatter.printFolderTransferComplete(this.folder, this.totalFiles, this.totalSize, actualTransferTime, speedMBps);
        this.stopHeartbeatThread();
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                logger.info("\u5f00\u59cb\u5173\u95ed\u8fde\u63a5...");
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.publicRelayConnected && this.publicRelayChannel != null) {
                    this.publicRelayChannel.close();
                }
                Thread.sleep(1000L);
                logger.info("\u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210\uff0c\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa");
                System.exit(0);
            }
            catch (InterruptedException e) {
                System.exit(0);
            }
        }, "DelayedExit").start();
    }

    private double calculateTransferSpeed(long bytes, long timeMs) {
        if (timeMs <= 0L) {
            return 0.0;
        }
        return (double)bytes / 1024.0 / 1024.0 / ((double)timeMs / 1000.0);
    }

    private Map<FileSizeCategory, List<FileEntryInfo>> groupFilesByCategory(List<FileEntryInfo> entries) {
        EnumMap<FileSizeCategory, List<FileEntryInfo>> categoryGroups = new EnumMap<FileSizeCategory, List<FileEntryInfo>>(FileSizeCategory.class);
        for (FileEntryInfo entry : entries) {
            if (entry.isDirectory()) continue;
            FileSizeCategory category = FileSizeCategory.categorizeFile(entry.getFileSize());
            categoryGroups.computeIfAbsent(category, k -> new ArrayList()).add(entry);
        }
        return categoryGroups;
    }

    private boolean sendAllFilesByCategory(Map<FileSizeCategory, List<FileEntryInfo>> categoryGroups) throws Exception {
        ArrayList<FileEntryInfo> allFiles = new ArrayList<FileEntryInfo>();
        for (List<FileEntryInfo> filesInCategory : categoryGroups.values()) {
            if (filesInCategory == null) continue;
            allFiles.addAll(filesInCategory);
        }
        if (allFiles.isEmpty()) {
            System.out.println("\u26a0\ufe0f \u6ca1\u6709\u6587\u4ef6\u9700\u8981\u4f20\u8f93");
            return true;
        }
        System.out.printf("\ud83d\udccb \u6574\u7406\u6587\u4ef6\u5217\u8868: \u603b\u5171 %d \u4e2a\u6587\u4ef6\n", allFiles.size());
        System.out.flush();
        System.out.print("\ud83d\udd0d \u6b63\u5728\u8fc7\u6ee4\u5df2\u4f20\u8f93\u7684\u6587\u4ef6...");
        System.out.flush();
        ArrayList<FileEntryInfo> pendingFiles = new ArrayList<FileEntryInfo>();
        int filteredCount = 0;
        for (FileEntryInfo file : allFiles) {
            if (this.transmittedFiles.contains(file.getRelativePath())) {
                ++filteredCount;
                continue;
            }
            pendingFiles.add(file);
        }
        if (filteredCount > 0) {
            System.out.printf(" \u8fc7\u6ee4\u6389 %d \u4e2a\u5df2\u4f20\u8f93\u6587\u4ef6\n", filteredCount);
        } else {
            System.out.println(" \u5b8c\u6210");
        }
        System.out.flush();
        if (filteredCount > 0) {
            logger.debug("\u8fc7\u6ee4\u6389 {} \u4e2a\u5df2\u901a\u8fc7\u6279\u6b21\u4f20\u8f93\u7684\u6587\u4ef6", (Object)filteredCount);
        }
        System.out.print("\ud83d\udd0d \u6b63\u5728\u5206\u6790\u6587\u4ef6\u4f20\u8f93\u7b56\u7565...");
        System.out.flush();
        TransferStrategyDecider.TransferDecision decision = TransferStrategyDecider.decideTransferStrategy(pendingFiles);
        System.out.println(" \u5b8c\u6210");
        System.out.flush();
        System.out.printf("\ud83c\udfaf \u4f20\u8f93\u7b56\u7565\u51b3\u7b56: %s\n", decision.toString());
        List<FileEntryInfo> batchFiles = decision.getBatchFiles();
        ArrayList<FileEntryInfo> singleFiles = new ArrayList<FileEntryInfo>(decision.getSingleFiles());
        boolean success = true;
        if (decision.shouldUseBatchTransfer() && !batchFiles.isEmpty()) {
            System.out.print("\ud83d\udce6 \u6b63\u5728\u51c6\u5907\u6279\u6b21\u4f20\u8f93...");
            System.out.flush();
            this.actualTransferStartTime = System.currentTimeMillis();
            System.out.println(" \u5b8c\u6210");
            System.out.flush();
            System.out.println("\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            System.out.println("\ud83d\ude80 \u9636\u6bb51: \u6279\u6b21\u4f20\u8f93\u5f00\u59cb");
            System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            BatchTransferResult batchResult = this.sendAllFilesInBatches(batchFiles);
            success = batchResult.isSuccess();
            List<FileEntryInfo> additionalSingleFiles = batchResult.getUnbatchableFiles();
            if (!additionalSingleFiles.isEmpty()) {
                System.out.printf("\u26a0\ufe0f \u5c06 %d \u4e2a\u65e0\u6cd5\u6279\u6b21\u4f20\u8f93\u7684\u6587\u4ef6\u6dfb\u52a0\u5230\u5355\u6587\u4ef6\u4f20\u8f93\u5217\u8868\n", additionalSingleFiles.size());
                singleFiles.addAll(additionalSingleFiles);
            }
        }
        if (success && !singleFiles.isEmpty()) {
            if (this.actualTransferStartTime == 0L) {
                this.actualTransferStartTime = System.currentTimeMillis();
            }
            System.out.println("\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            System.out.println("\ud83d\udcc4 \u9636\u6bb52: \u5355\u6587\u4ef6\u5217\u8868\u53d1\u9001");
            System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            System.out.printf("\ud83d\udcc4 \u5355\u6587\u4ef6\u4f20\u8f93: %d \u4e2a\u6587\u4ef6\n", singleFiles.size());
            success = this.sendLargeFilesIndividually(singleFiles, FileSizeCategory.LARGE);
        }
        return success;
    }

    private BatchTransferResult sendAllFilesInBatches(List<FileEntryInfo> batchFiles) throws Exception {
        System.out.print("\ud83d\udce6 \u6b63\u5728\u8fdb\u884c\u667a\u80fd\u5206\u7ec4...");
        System.out.flush();
        TransferStrategyDecider.BatchGroupResult groupResult = TransferStrategyDecider.createBatchGroupsWithRemainder(batchFiles);
        List<List<FileEntryInfo>> batchGroups = groupResult.getBatchGroups();
        List<FileEntryInfo> unbatchableFiles = groupResult.getUnbatchableFiles();
        if (batchGroups.isEmpty() && unbatchableFiles.isEmpty()) {
            System.out.println(" \u5931\u8d25");
            System.out.println("\u274c \u667a\u80fd\u5206\u7ec4\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u6279\u6b21\u5305");
            return new BatchTransferResult(false, new ArrayList<FileEntryInfo>());
        }
        System.out.println(" \u5b8c\u6210");
        System.out.flush();
        System.out.printf("\ud83d\udce6 \u667a\u80fd\u5206\u7ec4\u5b8c\u6210: %d \u4e2a\u6587\u4ef6\u5206\u6210 %d \u4e2a\u6279\u6b21\u5305 + %d \u4e2a\u6587\u4ef6\u8f6c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93\n", batchFiles.size(), batchGroups.size(), unbatchableFiles.size());
        if (!unbatchableFiles.isEmpty()) {
            System.out.printf("\u26a0\ufe0f \u6709 %d \u4e2a\u6587\u4ef6\u4e0d\u6ee1\u8db3\u6279\u6b21\u4f20\u8f93\u6761\u4ef6(\u6587\u4ef6\u6570<5)\uff0c\u5c06\u8f6c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93\n", unbatchableFiles.size());
        }
        int successfulBatches = 0;
        for (int i = 0; i < batchGroups.size(); ++i) {
            List<FileEntryInfo> batchGroup = batchGroups.get(i);
            int batchIndex = i + 1;
            List<File> batchFileList = batchGroup.stream().map(entry -> new File(this.folder, entry.getRelativePath())).collect(Collectors.toList());
            long batchSize = batchFileList.stream().mapToLong(File::length).sum();
            System.out.println("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            System.out.printf("\ud83d\udce6 \u7b2c%d/%d\u6279\u6b21\u5305\u5f00\u59cb\n", batchIndex, batchGroups.size());
            System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            System.out.printf("\ud83d\udce6 \u6279\u6b21\u4fe1\u606f: %d \u4e2a\u6587\u4ef6, \u5408\u8ba1 %s (\u76ee\u6807: \u63a5\u8fd1100MB)\n", batchFileList.size(), FileTransferUtils.formatFileSize(batchSize));
            boolean batchSuccess = this.tryUltraFastBatch(batchFileList, batchIndex, batchGroups.size());
            if (batchSuccess) {
                ++successfulBatches;
                for (File file : batchFileList) {
                    String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                    this.transmittedFiles.add(relativePath);
                    this.filesConfirmed.incrementAndGet();
                }
            } else {
                System.out.printf("\u274c \u7b2c%d/%d\u6279\u6b21\u5305\u5931\u8d25\uff0c\u6279\u6b21\u4f20\u8f93\u7ec8\u6b62\n", batchIndex, batchGroups.size());
                System.out.printf("\u26a0\ufe0f \u5931\u8d25\u6587\u4ef6\u6570\u91cf: %d \u4e2a\u6587\u4ef6\n", batchFileList.size());
                logger.error("\u6279\u6b21\u4f20\u8f93\u5931\u8d25\uff1a\u7b2c{}\u4e2a\u6279\u6b21\u5305\u542b{}\u4e2a\u6587\u4ef6\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7", (Object)batchIndex, (Object)batchFileList.size());
                return new BatchTransferResult(false, unbatchableFiles);
            }
            System.out.printf("\u2705 \u7b2c%d/%d\u6279\u6b21\u5305\u5b8c\u6210\uff0c\u5269\u4f59 %d \u4e2a\u6279\u6b21\u5305\n", batchIndex, batchGroups.size(), batchGroups.size() - batchIndex);
        }
        System.out.printf("\u2705 \u6279\u6b21\u4f20\u8f93\u9636\u6bb5\u5b8c\u6210: %d/%d \u4e2a\u6279\u6b21\u5305\u6210\u529f\u4f20\u8f93\n", successfulBatches, batchGroups.size());
        return new BatchTransferResult(successfulBatches == batchGroups.size(), unbatchableFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendLargeFilesIndividually(List<FileEntryInfo> files, FileSizeCategory category) throws Exception {
        boolean hasLargeFiles = files.stream().anyMatch(file -> file.getFileSize() > 0x6400000L);
        long maxFileSize = files.stream().mapToLong(FileEntryInfo::getFileSize).max().orElse(0L);
        if (hasLargeFiles) {
            System.out.printf("\ud83d\udd04 \u5f00\u59cb\u5927\u6587\u4ef6\u4f20\u8f93: %d \u4e2a\u5927\u6587\u4ef6 (>100MB, \u7f51\u7edc\u53c2\u6570\u5df2\u4f18\u5316)\n", files.size());
            String chunkInfo = maxFileSize > 0x6400000L ? "1MB\u5757" : (maxFileSize > 0xA00000L ? "512KB\u5757" : "256KB\u5757");
            System.out.printf("\ud83d\ude80 \u5927\u6587\u4ef6\u4f20\u8f93\u4f18\u5316: %s, 16MB\u7f51\u7edc\u7f13\u51b2\u533a\n", chunkInfo);
        } else {
            System.out.printf("\ud83d\udd04 \u5f00\u59cb\u5355\u6587\u4ef6\u4f20\u8f93: %d \u4e2a\u6587\u4ef6 (\u4e0d\u6ee1\u8db3\u6279\u91cf\u5904\u7406\u6761\u4ef6)\n", files.size());
        }
        for (int i = 0; i < files.size(); ++i) {
            FileEntryInfo entry = files.get(i);
            int currentIndex = i + 1;
            if (i > 0) {
                System.out.println();
            }
            String fileTypeLabel = entry.getFileSize() > 0x6400000L ? "\u5927\u6587\u4ef6" : "\u6587\u4ef6";
            System.out.printf("\ud83d\udce4 %s (%d/%d): %s (%s)\n", fileTypeLabel, currentIndex, files.size(), entry.getRelativePath(), FileTransferUtils.formatFileSize(entry.getFileSize()));
            System.out.flush();
            logger.debug("\ud83d\udd27 \u5f00\u59cb\u5904\u7406\u6587\u4ef6 {}/{}: {}", currentIndex, files.size(), entry.getRelativePath());
            boolean success = this.sendFileAndWaitCompletion(entry, currentIndex, files.size());
            logger.debug("\ud83d\udd27 \u6587\u4ef6\u5904\u7406\u7ed3\u679c {}/{}: {} -> {}", currentIndex, files.size(), entry.getRelativePath(), success ? "\u6210\u529f" : "\u5931\u8d25");
            if (success) continue;
            System.out.printf("\u274c \u6587\u4ef6\u4f20\u8f93\u5931\u8d25: %s\n", entry.getRelativePath());
            this.isInSingleFileTransferMode = false;
            return false;
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.isInSingleFileTransferMode = false;
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.printf("\u2705 %d \u4e2a\u6587\u4ef6\u4f20\u8f93\u5b8c\u6210\n", files.size());
            System.out.flush();
        }
        return true;
    }

    private boolean couldTriggerUltraFastMode(List<File> files) {
        int fileCount = files.size();
        long totalSize = files.stream().mapToLong(File::length).sum();
        if (fileCount >= 5 && fileCount <= 1000 && totalSize <= 0x6400000L) {
            return true;
        }
        if (totalSize > 0x6400000L) {
            System.out.printf("\u26a0\ufe0f \u6279\u6b21\u5927\u5c0f\u8d85\u9650: %.1fMB > 100MB\uff0c\u4e0d\u9002\u5408\u6279\u6b21\u4f20\u8f93\n", (double)totalSize / 1024.0 / 1024.0);
        }
        return false;
    }

    private boolean tryUltraFastBatch(List<File> batchFiles, int batchIndex, int totalBatches) throws Exception {
        int currentBatchId = this.globalBatchIdCounter.getAndIncrement();
        long totalSize = batchFiles.stream().mapToLong(File::length).sum();
        String batchName = String.format("\ud83d\udce6\u6279\u6b21%d", batchIndex);
        System.out.printf("\ud83e\uddea \u6d4b\u8bd5 %s: %d \u4e2a\u6587\u4ef6, \u603b\u5927\u5c0f: %s (%.1fMB)\n", batchName, batchFiles.size(), FileTransferUtils.formatFileSize(totalSize), (double)totalSize / 1024.0 / 1024.0);
        if (!this.couldTriggerUltraFastMode(batchFiles)) {
            System.out.printf("\ud83d\udcc4 %s: \u6587\u4ef6\u7279\u5f81\u4e0d\u6ee1\u8db3\u8d85\u9ad8\u901f\u6761\u4ef6\uff0c\u8df3\u8fc7\u7f51\u7edc\u6d4b\u8bd5\n", batchName);
            return false;
        }
        System.out.printf("\u2705 %s: \u9884\u68c0\u67e5\u901a\u8fc7\uff0c\u7ee7\u7eed\u53bb\u91cd\u8fc7\u6ee4\u548c\u538b\u7f29\u6d4b\u8bd5\n", batchName);
        int timeoutSeconds = Math.max(60, batchFiles.size() / 100);
        return this.buildBatchManifestParallel(batchName, batchFiles, currentBatchId, timeoutSeconds, batchIndex, totalBatches);
    }

    private boolean buildBatchManifestParallel(String batchName, List<File> batchFiles, int currentBatchId, int timeoutSeconds, int batchIndex, int totalBatches) {
        boolean ackReceived;
        System.out.printf("\ud83d\udccb %s: \u5f00\u59cb\u5e76\u884c\u6784\u5efa\u6e05\u5355 (%d \u4e2a\u6587\u4ef6)...\n", batchName, batchFiles.size());
        if (batchFiles.isEmpty()) {
            System.out.printf("\u274c %s: \u9519\u8bef - \u6279\u6b21\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff01\n", batchName);
            return false;
        }
        long manifestStartTime = System.currentTimeMillis();
        System.out.printf("\ud83d\udd10 \u5f00\u59cb\u8ba1\u7b97\u6587\u4ef6\u6821\u9a8c\u503c: %s (%d \u4e2a\u6587\u4ef6)\n", batchName, batchFiles.size());
        System.out.println("\u23f3 \u8fd9\u53ef\u80fd\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85...");
        ParallelHashCalculator.ConsoleProgressCallback callback = new ParallelHashCalculator.ConsoleProgressCallback(batchName);
        ParallelHashCalculator.HashResult hashResult = ParallelHashCalculator.calculateHashesParallel(batchFiles, callback);
        if (hashResult.hasErrors()) {
            System.out.printf("\u26a0\ufe0f %s: MD5\u8ba1\u7b97\u5b8c\u6210\uff0c\u4f46\u6709 %d \u4e2a\u6587\u4ef6\u5931\u8d25\n", batchName, hashResult.getErrorCount());
            for (Map.Entry<File, Exception> entry : hashResult.getErrorMap().entrySet()) {
                System.out.printf("\u274c %s: MD5\u5931\u8d25 - %s: %s\n", batchName, entry.getKey().getName(), entry.getValue().getMessage());
            }
        }
        ArrayList<CompressedBatchManifestMessage.BatchFileManifest> manifestList = new ArrayList<CompressedBatchManifestMessage.BatchFileManifest>();
        Map<File, String> hashMap = hashResult.getHashMap();
        for (File file : batchFiles) {
            String md5 = hashMap.get(file);
            if (md5 == null) continue;
            try {
                String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                boolean isTextFile = this.isTextFile(file);
                CompressedBatchManifestMessage.BatchFileManifest manifest = new CompressedBatchManifestMessage.BatchFileManifest(relativePath, file.length(), md5, file.lastModified(), isTextFile);
                manifestList.add(manifest);
            }
            catch (Exception e) {
                System.out.printf("\u274c %s: \u6784\u5efa\u6e05\u5355\u6761\u76ee\u5931\u8d25 - %s: %s\n", batchName, file.getName(), e.getMessage());
            }
        }
        long totalTime = System.currentTimeMillis() - manifestStartTime;
        System.out.printf("\ud83d\udccb %s: \u6e05\u5355\u6784\u5efa\u5b8c\u6210 (%d/%d \u4e2a\u6587\u4ef6\u6210\u529f) | \u603b\u8017\u65f6:%.1fs | \u5e73\u5747\u901f\u5ea6:%.1f\u6587\u4ef6/\u79d2\n", batchName, manifestList.size(), batchFiles.size(), (double)totalTime / 1000.0, hashResult.getAvgSpeed());
        if (manifestList.isEmpty()) {
            System.out.printf("\u274c %s: \u8b66\u544a - \u6e05\u5355\u4e3a\u7a7a\uff01\u6240\u6709\u6587\u4ef6\u5904\u7406\u90fd\u5931\u8d25\u4e86\n", batchName);
            return false;
        }
        CompressedBatchManifestMessage manifestMsg = new CompressedBatchManifestMessage(this.sessionId, currentBatchId, batchName, manifestList, batchIndex, totalBatches);
        System.out.printf("\ud83d\udccb %s: \u51c6\u5907\u53d1\u9001\u6e05\u5355\u6d88\u606f (\u5305\u542b %d \u4e2a\u6587\u4ef6)\n", batchName, manifestMsg.getFiles().size());
        System.out.flush();
        CountDownLatch manifestLatch = new CountDownLatch(1);
        this.compressedBatchManifestLatchMap.put(currentBatchId, manifestLatch);
        this.activeChannel.writeAndFlush(manifestMsg);
        System.out.printf("\ud83d\udccb %s: \u53d1\u9001\u6e05\u5355\uff0c\u7b49\u5f85\u63a5\u6536\u7aef\u53bb\u91cd\u786e\u8ba4\n", batchName);
        System.out.flush();
        System.out.printf("\ud83d\udccb %s: \u7b49\u5f85\u63a5\u6536\u7aef\u54cd\u5e94\uff08\u8d85\u65f6: %d\u79d2\uff09\n", batchName, timeoutSeconds);
        System.out.flush();
        try {
            ackReceived = manifestLatch.await(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.out.printf("\u274c %s: \u7b49\u5f85\u8fc7\u7a0b\u88ab\u4e2d\u65ad\n", batchName);
            this.compressedBatchManifestLatchMap.remove(currentBatchId);
            return false;
        }
        this.compressedBatchManifestLatchMap.remove(currentBatchId);
        if (!ackReceived) {
            System.out.printf("\u23f0 %s: \u6e05\u5355\u786e\u8ba4\u8d85\u65f6\uff0c\u8df3\u8fc7\u6b64\u6279\u6b21\n", batchName);
            return false;
        }
        CompressedBatchManifestAckMessage ackMsg = this.compressedBatchManifestAckMap.remove(currentBatchId);
        if (ackMsg == null || !ackMsg.isAcceptBatch()) {
            String reason = ackMsg != null ? ackMsg.getRejectReason() : "\u672a\u77e5\u539f\u56e0";
            System.out.printf("\u274c %s: \u6279\u6b21\u88ab\u62d2\u7edd - %s\n", batchName, reason);
            return false;
        }
        List<String> requiredFiles = ackMsg.getRequiredFiles();
        List<String> skippedFiles = ackMsg.getSkippedFiles();
        int totalFiles = manifestList.size();
        int skipCount = skippedFiles.size();
        long skipSize = 0L;
        block8: for (String string : skippedFiles) {
            for (CompressedBatchManifestMessage.BatchFileManifest batchFileManifest : manifestList) {
                if (!batchFileManifest.getRelativePath().equals(string)) continue;
                skipSize += batchFileManifest.getFileSize();
                continue block8;
            }
        }
        System.out.printf("\ud83d\udcca %s: \u53bb\u91cd\u7ed3\u679c - \u9700\u8981\u4f20\u8f93: %d \u4e2a\u6587\u4ef6, \u53bb\u91cd: %d/%d\u6587\u4ef6 (%.1f%%), \u8282\u7701: %s\n", batchName, requiredFiles.size(), skipCount, totalFiles, totalFiles > 0 ? (double)skipCount * 100.0 / (double)totalFiles : 0.0, FileTransferUtils.formatBytes(skipSize));
        if (requiredFiles.isEmpty()) {
            System.out.printf("\u2705 %s: \u5b8c\u6210 - \u6240\u6709\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93\n", batchName);
            for (File file : batchFiles) {
                String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                this.transmittedFiles.add(relativePath);
                this.filesConfirmed.incrementAndGet();
            }
            return true;
        }
        System.out.printf("\ud83d\udce6 %s: \u5f00\u59cb\u538b\u7f29 %d \u4e2a\u9700\u8981\u4f20\u8f93\u7684\u6587\u4ef6...\n", batchName, requiredFiles.size());
        ArrayList<File> filesToTransfer = new ArrayList<File>();
        block11: for (String requiredPath : requiredFiles) {
            for (File file : batchFiles) {
                String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                if (!relativePath.equals(requiredPath)) continue;
                filesToTransfer.add(file);
                continue block11;
            }
        }
        try {
            String string = System.getProperty("java.io.tmpdir") + File.separator + "batch_" + currentBatchId + "_" + System.currentTimeMillis() + ".pack";
            BatchCompressor.CompressionResult result = BatchCompressor.compressBatch(filesToTransfer, this.basePath.toString(), string, "batch_" + currentBatchId);
            if (result == null) {
                System.out.printf("\u274c %s: \u538b\u7f29\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u9002\u5408\u6279\u6b21\u4f20\u8f93\n", batchName);
                return false;
            }
            System.out.printf("\ud83d\udce6 %s: \u538b\u7f29\u5b8c\u6210 - %s\n", batchName, result.getSummary());
            boolean bl = this.transferCompressedBatchFile(batchName, currentBatchId, string);
            new File(string).delete();
            if (bl) {
                long compressedSize = result.getCompressedSize();
                int completeTimeoutSeconds = this.calculateBatchCompleteTimeout(compressedSize, filesToTransfer.size());
                logger.debug("\u7b49\u5f85\u6279\u6b21\u5b8c\u6210\u786e\u8ba4\uff0c\u52a8\u6001\u8d85\u65f6: {}\u79d2 (\u6279\u6b21: {}, \u6570\u636e: {})", completeTimeoutSeconds, batchName, FileTransferUtils.formatFileSize(compressedSize));
                boolean completeSuccess = this.waitForCompressedBatchComplete(currentBatchId, completeTimeoutSeconds * 1000);
                if (!completeSuccess) {
                    System.out.printf("\u274c %s: \u5b8c\u6210\u786e\u8ba4\u8d85\u65f6\n", batchName);
                    return false;
                }
                for (File file : filesToTransfer) {
                    String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                    this.transmittedFiles.add(relativePath);
                    this.filesConfirmed.incrementAndGet();
                }
                System.out.printf("\u2705 %s: \u6279\u6b21\u4f20\u8f93\u6210\u529f\u5b8c\u6210\n", batchName);
                return true;
            }
            System.out.printf("\u274c %s: \u6279\u6b21\u4f20\u8f93\u5931\u8d25\n", batchName);
            return false;
        }
        catch (Exception exception) {
            System.out.printf("\u274c %s: \u538b\u7f29/\u4f20\u8f93\u8fc7\u7a0b\u5f02\u5e38 - %s\n", batchName, exception.getMessage());
            logger.error("\u6279\u6b21\u4f20\u8f93\u5f02\u5e38", exception);
            return false;
        }
    }

    private boolean sendSingleCompressedBatch(CompressedBatchBuilder.CompressedBatch batch) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            int originalFileCount;
            List<String> skippedFiles;
            CompressedBatchManifestAckMessage ackMessage = this.sendBatchManifestAndWaitResponse(batch);
            if (ackMessage == null) {
                System.out.printf("\u274c \u6279\u6b21\u6e05\u5355\u786e\u8ba4\u8d85\u65f6: %s\n", batch.getBatchName());
                return false;
            }
            if (!ackMessage.isAcceptBatch()) {
                System.out.printf("\u274c \u6279\u6b21\u88ab\u62d2\u7edd: %s, \u539f\u56e0: %s\n", batch.getBatchName(), ackMessage.getRejectReason());
                return false;
            }
            List<String> requiredFiles = ackMessage.getRequiredFiles();
            int responseFileCount = (requiredFiles != null ? requiredFiles.size() : 0) + ((skippedFiles = ackMessage.getSkippedFiles()) != null ? skippedFiles.size() : 0);
            if (responseFileCount != (originalFileCount = batch.getFiles().size())) {
                System.out.printf("\u274c %s: \u54cd\u5e94\u6587\u4ef6\u6570\u91cf\u4e0d\u5339\u914d\uff01\u53d1\u9001: %d, \u54cd\u5e94: %d (\u9700\u8981: %d, \u8df3\u8fc7: %d)\n", batch.getBatchName(), originalFileCount, responseFileCount, requiredFiles != null ? requiredFiles.size() : 0, skippedFiles != null ? skippedFiles.size() : 0);
                logger.error("\u6279\u6b21 {} \u54cd\u5e94\u9a8c\u8bc1\u5931\u8d25\uff1a\u53d1\u9001\u6587\u4ef6\u6570={}, \u54cd\u5e94\u6587\u4ef6\u6570={}", batch.getBatchName(), originalFileCount, responseFileCount);
                return false;
            }
            if (requiredFiles == null || requiredFiles.isEmpty()) {
                System.out.printf("\u2705 %s \u5b8c\u6210 - \u6240\u6709\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93 (%s)\n", batch.getBatchName(), ackMessage.getDeduplicationSummary());
                for (File file : batch.getFiles()) {
                    String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                    this.transmittedFiles.add(relativePath);
                    this.filesConfirmed.incrementAndGet();
                }
                logger.debug("\u5df2\u8bb0\u5f55 {} \u4e2a\u8df3\u8fc7\u7684\u6279\u6b21\u6587\u4ef6\uff0c\u5f53\u524d\u5df2\u5904\u7406\u603b\u6570: {}", (Object)batch.getFiles().size(), (Object)this.transmittedFiles.size());
                return true;
            }
            if (ackMessage.getSkippedCount() > 0) {
                System.out.printf("\ud83d\udd04 %s: %s\n", batch.getBatchName(), ackMessage.getDeduplicationSummary());
            }
            List<File> filesToTransfer = this.filterRequiredFiles(batch.getFiles(), requiredFiles);
            long totalSize = filesToTransfer.stream().mapToLong(File::length).sum();
            for (File file : batch.getFiles()) {
                String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                this.transmittedFiles.add(relativePath);
                boolean isRequired = requiredFiles.contains(relativePath);
                if (isRequired) continue;
                this.filesConfirmed.incrementAndGet();
            }
            logger.debug("\u5df2\u8bb0\u5f55 {} \u4e2a\u6279\u6b21\u6587\u4ef6\uff08{} \u4e2a\u9700\u4f20\u8f93\uff0c{} \u4e2a\u8df3\u8fc7\uff09", batch.getFiles().size(), filesToTransfer.size(), batch.getFiles().size() - filesToTransfer.size());
            String tempCompressedFile = this.createTempCompressedFile(batch.getBatchId());
            String metadataJson = this.createBatchMetadata(batch, filesToTransfer);
            BatchCompressor.CompressionResult compressionResult = BatchCompressor.compressBatch(filesToTransfer, this.folder.getAbsolutePath(), tempCompressedFile, metadataJson);
            if (compressionResult == null) {
                System.out.printf("\ud83d\udcc4 %s: \u4e0d\u6ee1\u8db3\u8d85\u9ad8\u901f\u6761\u4ef6\uff0c\u6539\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93 %d \u4e2a\u6587\u4ef6\n", batch.getBatchName(), filesToTransfer.size());
                ArrayList<FileEntryInfo> fileEntries = new ArrayList<FileEntryInfo>();
                for (File file : filesToTransfer) {
                    String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                    fileEntries.add(new FileEntryInfo(relativePath, file.length(), false));
                }
                return this.sendFilesIndividuallyFromBatch(fileEntries);
            }
            System.out.printf("\ud83d\ude80 %s: %d\u6587\u4ef6 %s \u2192 %s [\u8d85\u9ad8\u901f\u6a21\u5f0f]\n", batch.getBatchName(), filesToTransfer.size(), FileTransferUtils.formatFileSize(compressionResult.getOriginalSize()), FileTransferUtils.formatFileSize(compressionResult.getCompressedSize()));
            String fileName = "batch_" + batch.getBatchId() + ".pack";
            CompressedBatchDataMessage dataMessage = new CompressedBatchDataMessage(this.sessionId, batch.getBatchId(), fileName, compressionResult.getOriginalSize(), compressionResult.getCompressedSize(), compressionResult.getCompressionMd5(), filesToTransfer.size());
            this.activeChannel.writeAndFlush(dataMessage);
            System.out.printf("\ud83d\udce4 \u4f20\u8f93\u538b\u7f29\u5305: %s (%s)\n", fileName, FileTransferUtils.formatFileSize(compressionResult.getCompressedSize()));
            boolean transferSuccess = this.transferCompressedFile(tempCompressedFile, dataMessage);
            new File(tempCompressedFile).delete();
            System.out.printf("", new Object[0]);
            if (!transferSuccess) {
                System.out.printf("\u274c \u4f20\u8f93\u5931\u8d25: %s\n", batch.getBatchName());
                return false;
            }
            long compressedSize = compressionResult.getCompressedSize();
            int timeoutSeconds = this.calculateBatchCompleteTimeout(compressedSize, batch.getFiles().size());
            logger.info("\u7b49\u5f85\u6279\u6b21\u5b8c\u6210\u786e\u8ba4\uff0c\u52a8\u6001\u8d85\u65f6: {}\u79d2 (\u6570\u636e: {}, \u7f51\u7edc: {})", new Object[]{timeoutSeconds, FileTransferUtils.formatFileSize(compressedSize), this.networkCondition});
            boolean completeSuccess = this.waitForCompressedBatchComplete(batch.getBatchId(), timeoutSeconds * 1000);
            if (!completeSuccess) {
                System.out.printf("\u274c \u5b8c\u6210\u786e\u8ba4\u8d85\u65f6: %s\n", batch.getBatchName());
                return false;
            }
            long endTime = System.currentTimeMillis();
            double speedMBps = this.calculateTransferSpeed(compressionResult.getOriginalSize(), endTime - startTime);
            this.recordTransferSpeed(batch.getBatchName(), speedMBps, compressionResult.getOriginalSize());
            System.out.printf("\u2705 %s \u5b8c\u6210 - %.1fMB/s\n", batch.getBatchName(), speedMBps);
            return true;
        }
        catch (Exception e) {
            System.out.printf("\u274c %s \u4f20\u8f93\u5f02\u5e38: %s\n", batch.getBatchName(), e.getMessage());
            logger.error("\u538b\u7f29\u6279\u6b21\u4f20\u8f93\u5f02\u5e38\u8be6\u60c5", e);
            return false;
        }
    }

    private boolean sendFilesIndividuallyFromBatch(List<FileEntryInfo> files) throws Exception {
        System.out.printf("\ud83d\udcc4 \u5355\u6587\u4ef6\u4f20\u8f93\u6a21\u5f0f: %d \u4e2a\u6587\u4ef6\n", files.size());
        for (int i = 0; i < files.size(); ++i) {
            FileEntryInfo entry = files.get(i);
            int currentIndex = i + 1;
            System.out.printf("\ud83d\udce4 \u6587\u4ef6 (%d/%d): %s (%s)\n", currentIndex, files.size(), entry.getRelativePath(), FileTransferUtils.formatFileSize(entry.getFileSize()));
            boolean success = this.sendFileAndWaitCompletion(entry, currentIndex, files.size());
            if (success) continue;
            System.out.printf("\u274c \u6587\u4ef6\u4f20\u8f93\u5931\u8d25: %s\n", entry.getRelativePath());
            return false;
        }
        return true;
    }

    private CompressedBatchManifestAckMessage sendBatchManifestAndWaitResponse(CompressedBatchBuilder.CompressedBatch batch) throws Exception {
        ArrayList<CompressedBatchManifestMessage.BatchFileManifest> manifests = new ArrayList<CompressedBatchManifestMessage.BatchFileManifest>();
        int failedFiles = 0;
        for (File file : batch.getFiles()) {
            try {
                String md5;
                String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
                if (relativePath.contains("\n") || relativePath.contains("\r") || relativePath.contains("\t")) {
                    logger.warn("\u6587\u4ef6\u8def\u5f84\u5305\u542b\u7279\u6b8a\u5b57\u7b26: {} (\u6279\u6b21ID={})", (Object)relativePath.replaceAll("[\r\n\t]", "?"), (Object)batch.getBatchId());
                }
                if (file.length() == 0L) {
                    md5 = "d41d8cd98f00b204e9800998ecf8427e";
                    logger.debug("\u7a7a\u6587\u4ef6: {} (\u6279\u6b21ID={})", (Object)relativePath, (Object)batch.getBatchId());
                } else {
                    md5 = FileTransferUtils.calculateFileMD5(file);
                }
                boolean isTextFile = this.isTextFile(file);
                manifests.add(new CompressedBatchManifestMessage.BatchFileManifest(relativePath, file.length(), md5, file.lastModified(), isTextFile));
            }
            catch (Exception e) {
                ++failedFiles;
                logger.error("\u5904\u7406\u6587\u4ef6\u5931\u8d25: {} (\u6279\u6b21ID={})", file.getAbsolutePath(), batch.getBatchId(), e);
            }
        }
        if (failedFiles > 0) {
            logger.warn("\u6279\u6b21ID={} \u6709 {} \u4e2a\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u6210\u529f\u5904\u7406 {} \u4e2a\u6587\u4ef6", batch.getBatchId(), failedFiles, manifests.size());
        }
        if (manifests.isEmpty()) {
            logger.error("\u6279\u6b21ID={} \u6ca1\u6709\u6709\u6548\u7684\u6587\u4ef6\u53ef\u53d1\u9001\uff01", (Object)batch.getBatchId());
            throw new RuntimeException("\u6279\u6b21\u6ca1\u6709\u6709\u6548\u7684\u6587\u4ef6: " + batch.getBatchName());
        }
        CompressedBatchManifestMessage manifestMessage = new CompressedBatchManifestMessage(this.sessionId, batch.getBatchId(), batch.getBatchName(), manifests, 1, 1);
        logger.info("\u51c6\u5907\u53d1\u9001\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6279\u6b21\u540d={}, \u6587\u4ef6\u6570={}", batch.getBatchId(), batch.getBatchName(), manifests.size());
        this.activeChannel.writeAndFlush(manifestMessage);
        logger.info("\u5df2\u53d1\u9001\u6279\u6b21\u6e05\u5355: \u6279\u6b21ID={}, \u6587\u4ef6\u6570={}", (Object)batch.getBatchId(), (Object)manifests.size());
        CompressedBatchManifestAckMessage ackMessage = this.waitForCompressedBatchAck(batch.getBatchId(), 30000L);
        if (ackMessage == null) {
            logger.error("\u7b49\u5f85\u6279\u6b21\u6e05\u5355\u786e\u8ba4\u8d85\u65f6: \u6279\u6b21ID={}", (Object)batch.getBatchId());
            throw new RuntimeException("\u7b49\u5f85\u6279\u6b21\u6e05\u5355\u786e\u8ba4\u8d85\u65f6");
        }
        return ackMessage;
    }

    private List<File> filterRequiredFiles(List<File> allFiles, List<String> requiredRelativePaths) {
        ArrayList<File> requiredFiles = new ArrayList<File>();
        for (File file : allFiles) {
            String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
            if (!requiredRelativePaths.contains(relativePath)) continue;
            requiredFiles.add(file);
        }
        return requiredFiles;
    }

    private boolean isTextFile(File file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".txt") || fileName.endsWith(".md") || fileName.endsWith(".java") || fileName.endsWith(".js") || fileName.endsWith(".css") || fileName.endsWith(".html") || fileName.endsWith(".xml") || fileName.endsWith(".json") || fileName.endsWith(".yml") || fileName.endsWith(".yaml") || fileName.endsWith(".properties") || fileName.endsWith(".log") || fileName.endsWith(".csv") || fileName.endsWith(".sql") || fileName.endsWith(".py") || fileName.endsWith(".rb") || fileName.endsWith(".php") || fileName.endsWith(".go") || fileName.endsWith(".sh") || fileName.endsWith(".bat") || fileName.endsWith(".c") || fileName.endsWith(".cpp") || fileName.endsWith(".h") || fileName.endsWith(".hpp");
    }

    private CompressedBatchManifestAckMessage waitForCompressedBatchAck(int batchId, long timeoutMs) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.compressedBatchLatchMap.put(batchId, latch);
        if (latch.await(timeoutMs, TimeUnit.MILLISECONDS)) {
            return this.compressedBatchAckMap.remove(batchId);
        }
        this.compressedBatchLatchMap.remove(batchId);
        return null;
    }

    private boolean waitForCompressedBatchComplete(int batchId, long timeoutMs) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.compressedBatchLatchMap.put(batchId, latch);
        return latch.await(timeoutMs, TimeUnit.MILLISECONDS);
    }

    private String createTempCompressedFile(int batchId) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), "croc-temp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return new File(tempDir, "compressed_batch_" + batchId + "_" + System.currentTimeMillis() + ".pack").getAbsolutePath();
    }

    private String createBatchMetadata(CompressedBatchBuilder.CompressedBatch batch, List<File> files) {
        StringBuilder json = new StringBuilder();
        json.append("{\n");
        if (batch != null) {
            json.append("  \"batchId\": ").append(batch.getBatchId()).append(",\n");
            json.append("  \"batchName\": \"").append(batch.getBatchName()).append("\",\n");
            json.append("  \"category\": \"").append(batch.getCategory().getDisplayName()).append("\",\n");
            json.append("  \"totalSize\": ").append(batch.getTotalSize()).append(",\n");
            json.append("  \"estimatedCompressionRatio\": ").append(batch.getEstimatedCompressionRatio()).append(",\n");
        } else {
            json.append("  \"batchId\": -1,\n");
            json.append("  \"batchName\": \"precheck\",\n");
            json.append("  \"category\": \"UNKNOWN\",\n");
            long totalSize = files.stream().mapToLong(File::length).sum();
            json.append("  \"totalSize\": ").append(totalSize).append(",\n");
            json.append("  \"estimatedCompressionRatio\": 0.5,\n");
        }
        json.append("  \"fileCount\": ").append(files.size()).append(",\n");
        json.append("  \"createTime\": \"").append(new Date()).append("\",\n");
        json.append("  \"files\": [\n");
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            String relativePath = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
            json.append("    {\n");
            json.append("      \"path\": \"").append(relativePath).append("\",\n");
            json.append("      \"size\": ").append(file.length()).append(",\n");
            json.append("      \"lastModified\": ").append(file.lastModified()).append("\n");
            json.append("    }");
            if (i < files.size() - 1) {
                json.append(",");
            }
            json.append("\n");
        }
        json.append("  ]\n");
        json.append("}");
        return json.toString();
    }

    private boolean transferCompressedFile(String compressedFilePath, CompressedBatchDataMessage dataMessage) throws Exception {
        File compressedFile = new File(compressedFilePath);
        if (!compressedFile.exists()) {
            logger.error("\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)compressedFilePath);
            return false;
        }
        int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(dataMessage.getCompressedSize());
        int chunks = FileTransferUtils.calculateChunks(dataMessage.getCompressedSize(), optimalChunkSize);
        logger.info("\u538b\u7f29\u5305\u4f20\u8f93\u53c2\u6570: \u6587\u4ef6={}, \u5927\u5c0f={}\u5b57\u8282, \u5757\u5927\u5c0f={}KB, \u5757\u6570={}", dataMessage.getCompressedFileName(), dataMessage.getCompressedSize(), optimalChunkSize / 1024, chunks);
        FileInfoMessage fileInfo = new FileInfoMessage(this.sessionId, dataMessage.getCompressedFileName(), dataMessage.getCompressedSize(), chunks, optimalChunkSize, dataMessage.getCompressionMd5());
        this.activeChannel.writeAndFlush(fileInfo);
        logger.debug("\u7b49\u5f85\u538b\u7f29\u5305\u4f20\u8f93\u786e\u8ba4...");
        if (!this.waitForTransferAck(60000L)) {
            logger.error("\u4f20\u8f93\u786e\u8ba4\u8d85\u65f6 (60\u79d2)");
            return false;
        }
        logger.debug("\u538b\u7f29\u5305\u4f20\u8f93\u786e\u8ba4\u6210\u529f");
        try (RandomAccessFile raf = new RandomAccessFile(compressedFile, "r");){
            long totalSize = compressedFile.length();
            long sentBytes = 0L;
            int chunkIndex = 0;
            while (sentBytes < totalSize) {
                int displayInterval;
                int currentChunkSize = (int)Math.min((long)optimalChunkSize, totalSize - sentBytes);
                byte[] chunk = new byte[currentChunkSize];
                raf.readFully(chunk);
                FileChunkMessage chunkMsg = new FileChunkMessage(this.sessionId, chunkIndex++, chunk);
                this.activeChannel.writeAndFlush(chunkMsg);
                int totalChunks = (int)Math.ceil((double)totalSize / (double)this.chunkSize);
                int n = totalChunks <= 20 ? 1 : (displayInterval = totalChunks <= 100 ? 5 : 20);
                if (chunkIndex % displayInterval == 0 || (sentBytes += (long)currentChunkSize) == totalSize) {
                    double progress = (double)sentBytes / (double)totalSize * 100.0;
                    System.out.printf("\r\ud83d\udce4 \u53d1\u9001\u8fdb\u5ea6: %s | %.1f%% (%s/%s)", dataMessage.getCompressedFileName(), progress, FileTransferUtils.formatBytes(sentBytes), FileTransferUtils.formatBytes(totalSize));
                    if (sentBytes == totalSize) {
                        System.out.println();
                    }
                }
                Thread.sleep(10L);
            }
        }
        logger.info("\ud83d\udce6 \u538b\u7f29\u5305\u4f20\u8f93\u5b8c\u6210: {}", (Object)dataMessage.getCompressedFileName());
        return true;
    }

    private boolean transferCompressedBatchFile(String batchName, int batchId, String compressedFilePath) throws Exception {
        File compressedFile = new File(compressedFilePath);
        if (!compressedFile.exists()) {
            logger.error("\u538b\u7f29\u6279\u6b21\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)compressedFilePath);
            return false;
        }
        long compressedSize = compressedFile.length();
        String compressionMd5 = BatchCompressor.calculateFileHashSafely(compressedFile);
        String fileName = "batch_" + batchId + ".pack";
        CompressedBatchDataMessage dataMessage = new CompressedBatchDataMessage(this.sessionId, batchId, fileName, compressedSize, compressedSize, compressionMd5, 0);
        this.activeChannel.writeAndFlush(dataMessage);
        return this.transferCompressedFile(compressedFilePath, dataMessage);
    }

    private boolean waitForTransferAck(long timeoutMs) throws InterruptedException {
        CountDownLatch ackLatch;
        this.currentFileLatch = ackLatch = new CountDownLatch(1);
        return ackLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void handleCompressedBatchManifestAck(CompressedBatchManifestAckMessage ackMsg) {
        try {
            CountDownLatch manifestLatch;
            int batchId = ackMsg.getBatchId();
            logger.info("\ud83d\udcca \u6536\u5230\u538b\u7f29\u6279\u6b21\u6e05\u5355\u786e\u8ba4\uff1a\u6279\u6b21ID={}, \u63a5\u53d7={}, \u9700\u8981\u4f20\u8f93={}, \u8df3\u8fc7={}", batchId, ackMsg.isAcceptBatch(), ackMsg.getRequiredCount(), ackMsg.getSkippedCount());
            this.compressedBatchAckMap.put(batchId, ackMsg);
            this.compressedBatchManifestAckMap.put(batchId, ackMsg);
            CountDownLatch latch = this.compressedBatchLatchMap.remove(batchId);
            if (latch != null) {
                latch.countDown();
            }
            if ((manifestLatch = this.compressedBatchManifestLatchMap.remove(batchId)) != null) {
                manifestLatch.countDown();
                logger.debug("\ud83d\udd13 \u91ca\u653e\u6279\u6b21 {} \u6e05\u5355\u7b49\u5f85\u9501\u6210\u529f", (Object)batchId);
            }
            if (ackMsg.isAcceptBatch()) {
                logger.info("\u2705 \u6279\u6b21 {} \u88ab\u63a5\u53d7 - {}", (Object)batchId, (Object)ackMsg.getDeduplicationSummary());
            } else {
                logger.warn("\u274c \u6279\u6b21 {} \u88ab\u62d2\u7edd - {}", (Object)batchId, (Object)ackMsg.getRejectReason());
            }
        }
        catch (Exception e) {
            logger.error("\u274c \u5904\u7406\u538b\u7f29\u6279\u6b21\u6e05\u5355\u786e\u8ba4\u6d88\u606f\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public void handleCompressedBatchComplete(CompressedBatchCompleteMessage completeMessage) {
        int batchId = completeMessage.getBatchId();
        logger.info("\u2705 \u63a5\u6536\u7aef\u786e\u8ba4\u538b\u7f29\u6279\u6b21\u5904\u7406\u5b8c\u6210: \u6279\u6b21{} - {}", (Object)batchId, (Object)completeMessage.getProcessingSummary());
        CountDownLatch latch = this.compressedBatchLatchMap.remove(batchId);
        if (latch != null) {
            latch.countDown();
        }
    }

    private void stopHeartbeatThread() {
        this.heartbeatRunning = false;
        logger.info("\u5fc3\u8df3\u7ebf\u7a0b\u505c\u6b62");
    }

    private void startHeartbeat() {
        this.heartbeatRunning = true;
        new Thread(() -> {
            try {
                logger.info("\u5fc3\u8df3\u7ebf\u7a0b\u542f\u52a8");
                while (this.heartbeatRunning && !this.transferComplete) {
                    try {
                        Thread.sleep(10000L);
                        if (!this.heartbeatRunning || this.transferComplete) {
                            logger.debug("\u5fc3\u8df3\u7ebf\u7a0b\u9000\u51fa\u6761\u4ef6\u6ee1\u8db3\uff0c\u505c\u6b62\u53d1\u9001\u5fc3\u8df3");
                            break;
                        }
                        if (this.activeChannel == null || !this.activeChannel.isActive()) {
                            logger.warn("\u5fc3\u8df3\u53d1\u9001\u5931\u8d25\uff1a\u901a\u9053\u65e0\u6548\uff0c\u505c\u6b62\u5fc3\u8df3");
                            break;
                        }
                        String currentFile = this.currentSendingFile;
                        logger.info("\u5fc3\u8df3  \u6587\u4ef6\u4f20\u8f93\u72b6\u6001\uff1a\u5df2\u53d1\u9001 {}/{} \u6587\u4ef6\uff0c\u5f53\u524d\u5904\u7406\u6587\u4ef6: {}", this.filesSent.get(), this.totalFiles, currentFile != null ? currentFile : "\u65e0");
                        try {
                            HeartbeatMessage heartbeat = new HeartbeatMessage();
                            heartbeat.setSessionId(this.sessionId);
                            this.activeChannel.writeAndFlush(heartbeat).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                                if (future.isSuccess()) {
                                    logger.debug("\u5fc3\u8df3\u6d88\u606f\u53d1\u9001\u6210\u529f");
                                } else {
                                    logger.debug("\u5fc3\u8df3\u6d88\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)future.cause().getMessage());
                                }
                            }));
                        }
                        catch (Exception writeEx) {
                            logger.debug("\u5fc3\u8df3\u6d88\u606f\u5199\u5165\u5f02\u5e38: {}", (Object)writeEx.getMessage());
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info("\u5fc3\u8df3\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("\u53d1\u9001\u5fc3\u8df3\u6d88\u606f\u5f02\u5e38: {}", (Object)e.getMessage());
                    }
                }
                logger.info("\u5fc3\u8df3\u7ebf\u7a0b\u9000\u51fa: heartbeatRunning={}, transferComplete={}", (Object)this.heartbeatRunning, (Object)this.transferComplete);
            }
            catch (Exception e) {
                logger.error("\u5fc3\u8df3\u7ebf\u7a0b\u610f\u5916\u7ec8\u6b62: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                this.heartbeatRunning = false;
            }
        }, "FolderTransferHeartbeat").start();
    }

    private void connectToLocalRelay(EventLoopGroup group) throws InterruptedException {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x800000)).option(ChannelOption.SO_RCVBUF, 0x800000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new IdleStateHandler(0, 30, 0));
                CodecFactory.addClientCodec(p);
                p.addLast(new FolderSender_with_local_relay_hanlder(FolderSender.this));
            }
        });
        this.channel = b.connect(this.host, this.port).sync().channel();
        RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
        this.channel.writeAndFlush(registerMsg);
        logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u672c\u5730\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
    }

    private void connectToSpecificRelay(EventLoopGroup group, String relayHost, int relayPort) throws Exception {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new IdleStateHandler(0, 30, 0));
                CodecFactory.addClientCodec(p);
                p.addLast(new FolderSender_with_pub_relay_hanlder(FolderSender.this));
            }
        });
        this.channel = b.connect(relayHost, relayPort).sync().channel();
        RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
        this.channel.writeAndFlush(registerMsg);
        logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u6307\u5b9a\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
    }

    private void connectToPublicRelay() {
        try {
            String publicRelayHost = RelayConfig.getPublicRelayHost();
            int publicRelayPort = RelayConfig.getPublicRelayPort();
            logger.info("\u5c1d\u8bd5\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)publicRelayHost, (Object)publicRelayPort);
            NioEventLoopGroup publicGroup = new NioEventLoopGroup();
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(publicGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_SNDBUF, 0x400000)).option(ChannelOption.SO_RCVBUF, 0x400000)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 0x400000)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 0x100000)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, 30, 0));
                    CodecFactory.addClientCodec(p);
                    p.addLast(new FolderSender_with_pub_relay_hanlder(FolderSender.this));
                }
            });
            this.publicRelayChannel = b.connect(publicRelayHost, publicRelayPort).sync().channel();
            this.publicRelayConnected = true;
            this.publicRelayLatch.countDown();
            boolean isCustomRelay = RelayConfig.isUsingCustomRelay();
            if (isCustomRelay) {
                ConsoleUtils.infof("\u5df2\u8fde\u63a5 \u81ea\u5b9a\u4e49\u4e2d\u7ee7: %s:%d", publicRelayHost, publicRelayPort);
            } else {
                ConsoleUtils.infof("\u5df2\u8fde\u63a5 \u9ed8\u8ba4\u516c\u5171\u4e2d\u7ee7: %s:%d", publicRelayHost, publicRelayPort);
            }
            RegisterMessage registerMsg = new RegisterMessage(this.singleSessionId);
            this.publicRelayChannel.writeAndFlush(registerMsg);
            logger.debug("\u53d1\u9001\u6ce8\u518c\u8bf7\u6c42\u5230\u516c\u5171\u4e2d\u7ee7\uff0c\u4f7f\u7528\u4f1a\u8bddID: {}", (Object)this.singleSessionId);
            this.publicRelayConnected = true;
        }
        catch (Exception e) {
            logger.warn("\u8fde\u63a5\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}", (Object)e.getMessage());
            ConsoleUtils.error("\u8fde\u63a5\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25");
        }
    }

    public String getSingleSessionId() {
        return this.singleSessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.activeChannel = channel;
    }

    public void onFolderInfoAcknowledged() {
        if (this.folderInfoConfirmationLatch != null) {
            this.folderInfoConfirmationLatch.countDown();
            logger.info("\u6536\u5230\u6587\u4ef6\u5939\u4fe1\u606f\u786e\u8ba4");
        }
    }

    public void onError(String errorMsg) {
        HandlerExceptionUtils.handleException(null, new RuntimeException(errorMsg), FileSender.class.getName());
    }

    public boolean isTransferSuccessfullyCompleted() {
        return this.transferSuccessfullyCompleted;
    }

    public synchronized void showExitMessage(String connectionType) {
        if (!this.exitMessageShown) {
            this.exitMessageShown = true;
            ExitMessageFormatter.showConnectionClosed(connectionType);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                    ExitMessageFormatter.showSenderExit();
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    System.exit(0);
                }
            }, "ExitHandler").start();
        }
    }

    public void silentClose() {
        try {
            logger.debug("\u9759\u9ed8\u5173\u95ed\u6587\u4ef6\u5939\u53d1\u9001\u5668\u8fde\u63a5: {}:{}", (Object)this.host, (Object)this.port);
            this.silentClosing = true;
            if (this.channel != null && this.channel.isActive()) {
                this.channel.close();
            }
            if (this.publicRelayChannel != null && this.publicRelayChannel.isActive()) {
                this.publicRelayChannel.close();
            }
        }
        catch (Exception e) {
            logger.debug("\u9759\u9ed8\u5173\u95ed\u6587\u4ef6\u5939\u53d1\u9001\u5668\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    public boolean isSilentClosing() {
        return this.silentClosing;
    }

    public boolean isActiveTransfer() {
        return this.isActiveTransfer;
    }

    private boolean sendSmallFilesBatch(List<FileEntryInfo> smallFiles) {
        List<List<FileEntryInfo>> batches = this.createBatches(smallFiles, 50);
        this.batchProgressTracker = new BatchProgressTracker(batches.size());
        this.batchProgressTracker.setPendingCount(smallFiles.size());
        System.out.println("\ud83d\udce6 \u5f00\u59cb\u6279\u91cf\u4f20\u8f93 " + smallFiles.size() + " \u4e2a\u5c0f\u6587\u4ef6\uff08\u5171" + batches.size() + "\u4e2a\u6279\u6b21\uff09");
        boolean allBatchesSuccess = true;
        int failedBatchCount = 0;
        for (int batchIndex = 0; batchIndex < batches.size(); ++batchIndex) {
            List<FileEntryInfo> batch = batches.get(batchIndex);
            int batchId = this.globalBatchIdCounter.getAndIncrement();
            try {
                boolean batchSuccess = this.sendSingleBatch(batch, batchId, batchIndex + 1, batches.size());
                if (batchSuccess) continue;
                ++failedBatchCount;
                logger.warn("\u6279\u6b21 {}/{} \u4f20\u8f93\u5931\u8d25\uff0c\u7ee7\u7eed\u5904\u7406\u4e0b\u4e00\u6279\u6b21", (Object)(batchIndex + 1), (Object)batches.size());
                allBatchesSuccess = false;
                continue;
            }
            catch (Exception e) {
                ++failedBatchCount;
                logger.error("\u6279\u6b21 {}/{} \u4f20\u8f93\u5f02\u5e38\uff0c\u7ee7\u7eed\u5904\u7406\u4e0b\u4e00\u6279\u6b21", batchIndex + 1, batches.size(), e);
                allBatchesSuccess = false;
            }
        }
        if (failedBatchCount > 0) {
            logger.warn("\u6279\u91cf\u4f20\u8f93\u5b8c\u6210\uff0c\u4f46\u6709 {} \u4e2a\u6279\u6b21\u5931\u8d25", (Object)failedBatchCount);
        }
        if (this.batchProgressTracker != null) {
            this.batchProgressTracker.complete();
            int totalTransmitted = this.batchProgressTracker.getTransmittedCount();
            int totalSkipped = this.batchProgressTracker.getSkippedCount();
            logger.info("\u6279\u91cf\u4f20\u8f93\u5b8c\u6210\uff0c\u540c\u6b65\u5168\u5c40\u8ba1\u6570\u5668\uff1a\u4f20\u8f93={}, \u8df3\u8fc7={}", (Object)totalTransmitted, (Object)totalSkipped);
            this.filesSent.addAndGet(totalTransmitted);
            this.skippedFiles.addAndGet(totalSkipped);
            this.filesConfirmed.addAndGet(totalTransmitted);
        }
        return allBatchesSuccess;
    }

    private boolean sendSingleBatch(List<FileEntryInfo> batchFiles, int batchId, int batchNum, int totalBatches) throws Exception {
        this.batchProgressTracker.startBatch(batchNum, batchFiles.size());
        ArrayList<BatchFileInfoMessage.BatchFileEntry> batchEntries = new ArrayList<BatchFileInfoMessage.BatchFileEntry>();
        for (FileEntryInfo fileEntry : batchFiles) {
            File file = new File(this.folder, fileEntry.getRelativePath());
            String md5 = FileTransferUtils.calculateFileMD5(file);
            int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(fileEntry.getFileSize());
            int chunks = FileTransferUtils.calculateChunks(fileEntry.getFileSize(), optimalChunkSize);
            BatchFileInfoMessage.BatchFileEntry batchEntry = new BatchFileInfoMessage.BatchFileEntry(fileEntry.getRelativePath(), fileEntry.getFileSize(), md5, chunks, optimalChunkSize);
            batchEntries.add(batchEntry);
        }
        BatchFileInfoMessage batchInfoMsg = new BatchFileInfoMessage(this.sessionId, batchEntries, batchId);
        CountDownLatch batchLatch = new CountDownLatch(1);
        this.batchLatchMap.put(batchId, batchLatch);
        this.activeChannel.writeAndFlush(batchInfoMsg);
        logger.debug("\u53d1\u9001\u6279\u91cf\u6587\u4ef6\u4fe1\u606f\uff0c\u6279\u6b21ID: {}", (Object)batchId);
        int timeoutSeconds = Math.max(60, batchFiles.size() * 2);
        logger.debug("\u7b49\u5f85\u6279\u6b21 {} \u786e\u8ba4\uff0c\u5305\u542b {} \u4e2a\u6587\u4ef6\uff0c\u8d85\u65f6\u65f6\u95f4: {} \u79d2", batchId, batchFiles.size(), timeoutSeconds);
        boolean ackReceived = batchLatch.await(timeoutSeconds, TimeUnit.SECONDS);
        if (!ackReceived) {
            logger.error("\u6279\u6b21 {} \u786e\u8ba4\u8d85\u65f6\uff08{}\u79d2\uff09\uff0c\u5305\u542b\u6587\u4ef6\u6570: {}\uff0c\u8df3\u8fc7\u6b64\u6279\u6b21", batchId, timeoutSeconds, batchFiles.size());
            this.batchLatchMap.remove(batchId);
            return false;
        }
        logger.debug("\u6279\u6b21 {} \u786e\u8ba4\u6210\u529f", (Object)batchId);
        BatchFileAckMessage batchAck = this.batchAckMap.remove(batchId);
        if (batchAck == null) {
            logger.error("\u672a\u627e\u5230\u6279\u6b21 {} \u7684\u786e\u8ba4\u6d88\u606f", (Object)batchId);
            return false;
        }
        List<String> acceptedFiles = batchAck.getAcceptedFiles();
        int transmittedCount = 0;
        int failedCount = 0;
        long totalTransmittedBytes = 0L;
        for (FileEntryInfo fileEntry : batchFiles) {
            if (acceptedFiles != null && acceptedFiles.contains(fileEntry.getRelativePath())) {
                try {
                    int globalFileIndex = this.filesSent.get() + this.skippedFiles.get() + ++transmittedCount;
                    this.batchProgressTracker.updateCurrentFile(globalFileIndex, fileEntry.getRelativePath());
                    boolean success = this.sendFileDataOnly(fileEntry, batchNum, totalBatches, acceptedFiles.size(), transmittedCount);
                    if (success) {
                        totalTransmittedBytes += fileEntry.getFileSize();
                        continue;
                    }
                    ++failedCount;
                    return false;
                }
                catch (Exception e) {
                    logger.error("\u6279\u6b21\u4e2d\u6587\u4ef6 {} \u4f20\u8f93\u5931\u8d25", (Object)fileEntry.getRelativePath(), (Object)e);
                    ++failedCount;
                    return false;
                }
            }
            logger.debug("\u8df3\u8fc7\u6587\u4ef6: {} (\u672a\u88ab\u63a5\u6536\u7aef\u63a5\u53d7)", (Object)fileEntry.getRelativePath());
        }
        int skippedCount = batchFiles.size() - transmittedCount;
        this.batchProgressTracker.completeBatch(transmittedCount, skippedCount, failedCount, totalTransmittedBytes);
        return true;
    }

    private boolean sendFileDataOnly(FileEntryInfo entry, int batchNum, int totalBatches, int totalAcceptedFiles, int currentIndex) throws Exception {
        File file = new File(this.folder, entry.getRelativePath());
        if (file.length() == 0L) {
            logger.debug("\u8df3\u8fc7\u7a7a\u6587\u4ef6\u6570\u636e\u53d1\u9001: {}", (Object)entry.getRelativePath());
            return true;
        }
        long fileSize = file.length();
        int optimalChunkSize = FileTransferUtils.getOptimalChunkSize(fileSize);
        int totalChunks = FileTransferUtils.calculateChunks(fileSize, optimalChunkSize);
        String md5 = FileTransferUtils.calculateFileMD5(file);
        logger.debug("\u6279\u6b21\u6587\u4ef6\u4f20\u8f93\u53c2\u6570: \u6587\u4ef6={}, \u5927\u5c0f={}\u5b57\u8282, \u5757\u5927\u5c0f={}KB, \u5757\u6570={}", entry.getRelativePath(), fileSize, optimalChunkSize / 1024, totalChunks);
        FileInfoMessage fileInfoMsg = new FileInfoMessage(this.sessionId, entry.getRelativePath(), fileSize, totalChunks, optimalChunkSize, md5);
        this.activeChannel.writeAndFlush(fileInfoMsg);
        logger.debug("\u6279\u91cf\u4f20\u8f93\u53d1\u9001FILE_INFO: {} (\u786e\u4fdd\u6b63\u786e\u6587\u4ef6\u5339\u914d)", (Object)entry.getRelativePath());
        Thread.sleep(50L);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            for (int i = 0; i < totalChunks; ++i) {
                long start = (long)i * (long)optimalChunkSize;
                int currentChunkSize = (int)Math.min((long)optimalChunkSize, fileSize - start);
                byte[] buffer = new byte[currentChunkSize];
                raf.seek(start);
                raf.readFully(buffer);
                FileChunkMessage chunkMsg = new FileChunkMessage(this.sessionId, i, buffer);
                this.activeChannel.writeAndFlush(chunkMsg);
                if (totalChunks <= 1 || i >= totalChunks - 1) continue;
                Thread.sleep(10L);
            }
        }
        return true;
    }

    private List<List<FileEntryInfo>> createBatches(List<FileEntryInfo> files, int batchSize) {
        ArrayList<List<FileEntryInfo>> batches = new ArrayList<List<FileEntryInfo>>();
        for (int i = 0; i < files.size(); i += batchSize) {
            int end = Math.min(i + batchSize, files.size());
            batches.add(new ArrayList<FileEntryInfo>(files.subList(i, end)));
        }
        return batches;
    }

    public void handleBatchFileAck(BatchFileAckMessage msg) {
        try {
            int batchId = msg.getBatchId();
            logger.info("\ud83c\udfaf \u6536\u5230\u6279\u91cf\u6587\u4ef6\u786e\u8ba4\uff1a\u6279\u6b21={}, \u63a5\u53d7={}, \u8df3\u8fc7={}, \u9519\u8bef={}", batchId, msg.getAcceptedCount(), msg.getSkippedCount(), msg.getErrorCount());
            this.batchAckMap.put(batchId, msg);
            logger.debug("\u2705 \u6279\u91cf\u786e\u8ba4\u6d88\u606f\u5df2\u5b58\u50a8\uff0c\u6279\u6b21ID: {}", (Object)batchId);
            CountDownLatch batchLatch = this.batchLatchMap.remove(batchId);
            if (batchLatch != null) {
                batchLatch.countDown();
                logger.info("\ud83d\udd13 \u91ca\u653e\u6279\u6b21 {} \u7684\u7b49\u5f85\u9501\u6210\u529f", (Object)batchId);
            } else {
                logger.warn("\u26a0\ufe0f \u672a\u627e\u5230\u6279\u6b21 {} \u7684\u7b49\u5f85\u9501", (Object)batchId);
            }
            if (msg.getSkippedCount() > 0) {
                this.skippedFiles.addAndGet(msg.getSkippedCount());
                logger.debug("\ud83d\udcca \u6279\u6b21 {} \u8df3\u8fc7\u4e86 {} \u4e2a\u6587\u4ef6", (Object)batchId, (Object)msg.getSkippedCount());
            }
            logger.info("\u2705 \u6279\u91cf\u6587\u4ef6\u786e\u8ba4\u5904\u7406\u5b8c\u6210\uff0c\u6279\u6b21ID: {}", (Object)batchId);
        }
        catch (Exception e) {
            logger.error("\u274c \u5904\u7406\u6279\u91cf\u6587\u4ef6\u786e\u8ba4\u6d88\u606f\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    private boolean isUsingLocalRelay() {
        if (this.activeChannel == null) {
            return false;
        }
        String remoteAddress = this.activeChannel.remoteAddress().toString();
        return remoteAddress.contains("127.0.0.1") || remoteAddress.contains("localhost") || remoteAddress.contains("192.168.") || remoteAddress.contains("10.") || remoteAddress.contains("172.");
    }

    public void cleanup() {
        try {
            this.compressedBatchManifestLatchMap.clear();
            this.compressedBatchManifestAckMap.clear();
            this.compressedBatchLatchMap.clear();
            this.compressedBatchAckMap.clear();
            this.batchLatchMap.clear();
            this.batchAckMap.clear();
            if (this.batchExecutor != null && !this.batchExecutor.isShutdown()) {
                this.batchExecutor.shutdown();
                try {
                    if (!this.batchExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.batchExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.batchExecutor.shutdownNow();
                }
            }
            logger.info("\ud83e\uddfd \u6e05\u7406\u5b8c\u6210\uff1aFolderSender \u8d44\u6e90\u5df2\u91ca\u653e");
        }
        catch (Exception e) {
            logger.error("\u274c \u6e05\u7406\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    private int calculateBatchCompleteTimeout(long compressedSize, int fileCount) {
        DynamicTimeoutCalculator.BatchTransferTimeout batchTimeout = new DynamicTimeoutCalculator.BatchTransferTimeout(compressedSize, fileCount, DynamicTimeoutCalculator.TransferType.COMPRESSED_BATCH);
        if (this.averageTransferSpeed > 0.0) {
            batchTimeout.withHistoricalSpeed(this.averageTransferSpeed);
        } else {
            batchTimeout.withNetworkCondition(this.networkCondition);
        }
        int timeout = batchTimeout.calculate();
        int confirmationBufferTime = Math.max(30, (int)(compressedSize / 0xA00000L));
        timeout += confirmationBufferTime;
        timeout = Math.max(timeout, 120);
        logger.debug("\u6279\u6b21\u786e\u8ba4\u8d85\u65f6\u8ba1\u7b97: \u57fa\u7840={}s, \u786e\u8ba4\u7f13\u51b2={}s, \u6700\u7ec8={}s", batchTimeout.calculate(), confirmationBufferTime, timeout);
        return timeout;
    }

    private void recordTransferSpeed(String identifier, double speedMBps, long dataSize) {
        if (dataSize > 102400L && speedMBps > 0.01) {
            this.transferSpeeds.put(identifier, speedMBps);
            if (this.transferSpeeds.size() > 15) {
                String oldestTransfer = this.transferSpeeds.keySet().iterator().next();
                this.transferSpeeds.remove(oldestTransfer);
            }
            this.averageTransferSpeed = this.transferSpeeds.values().stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            this.networkCondition = DynamicTimeoutCalculator.assessNetworkCondition(this.averageTransferSpeed);
            logger.debug("\u8bb0\u5f55\u4f20\u8f93\u901f\u5ea6: {} - {:.2f} MB/s, \u5e73\u5747\u901f\u5ea6: {:.2f} MB/s, \u7f51\u7edc\u72b6\u51b5: {}", new Object[]{identifier, speedMBps, this.averageTransferSpeed, this.networkCondition});
        }
    }

    private void initializeNetworkCondition() {
        if (this.localRelayPort > 0) {
            this.networkCondition = DynamicTimeoutCalculator.NetworkCondition.FAST;
            logger.info("\u68c0\u6d4b\u5230\u672c\u5730\u4e2d\u7ee7\uff0c\u521d\u59cb\u7f51\u7edc\u72b6\u51b5: FAST");
        } else if (this.publicRelayConnected) {
            this.networkCondition = DynamicTimeoutCalculator.NetworkCondition.MEDIUM;
            logger.info("\u68c0\u6d4b\u5230\u516c\u5171\u4e2d\u7ee7\uff0c\u521d\u59cb\u7f51\u7edc\u72b6\u51b5: MEDIUM");
        } else {
            this.networkCondition = DynamicTimeoutCalculator.NetworkCondition.SLOW;
            logger.info("\u672a\u77e5\u8fde\u63a5\u7c7b\u578b\uff0c\u4fdd\u5b88\u8bbe\u7f6e\u7f51\u7edc\u72b6\u51b5: SLOW");
        }
    }

    private int calculateSingleFileTimeout(long fileSize) {
        int timeout = DynamicTimeoutCalculator.calculateTimeout(fileSize, DynamicTimeoutCalculator.TransferType.SINGLE_FILE, this.networkCondition, this.averageTransferSpeed);
        int md5BufferTime = Math.max(10, (int)(fileSize / 0x3200000L));
        timeout += md5BufferTime;
        timeout = Math.max(timeout, 90);
        logger.debug("\u5355\u6587\u4ef6\u8d85\u65f6\u8ba1\u7b97: \u57fa\u7840={}s, MD5\u7f13\u51b2={}s, \u6700\u7ec8={}s", timeout - md5BufferTime, md5BufferTime, timeout);
        return timeout;
    }

    private void sendTransferStatsBeforeTransfer(Map<FileSizeCategory, List<FileEntryInfo>> categoryGroups) {
        try {
            ArrayList allFiles = new ArrayList();
            for (List<FileEntryInfo> filesInCategory : categoryGroups.values()) {
                if (filesInCategory == null) continue;
                allFiles.addAll(filesInCategory);
            }
            ArrayList<FileEntryInfo> pendingFiles = new ArrayList<FileEntryInfo>();
            for (FileEntryInfo file : allFiles) {
                if (this.transmittedFiles.contains(file.getRelativePath())) continue;
                pendingFiles.add(file);
            }
            TransferStrategyDecider.TransferDecision decision = TransferStrategyDecider.decideTransferStrategy(pendingFiles);
            List<FileEntryInfo> batchFiles = decision.getBatchFiles();
            ArrayList<FileEntryInfo> singleFiles = new ArrayList<FileEntryInfo>(decision.getSingleFiles());
            int totalBatches = 0;
            int totalSingleFiles = singleFiles.size();
            if (decision.shouldUseBatchTransfer() && !batchFiles.isEmpty()) {
                TransferStrategyDecider.BatchGroupResult previewResult = TransferStrategyDecider.createBatchGroupsWithRemainder(batchFiles);
                totalBatches = previewResult.getBatchGroups().size();
                totalSingleFiles += previewResult.getUnbatchableFiles().size();
            }
            this.sendTransferStatsToReceiver(totalBatches, totalSingleFiles);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendTransferStatsToReceiver(int totalBatches, int totalSingleFiles) {
        try {
            TransferStatsMessage statsMessage = new TransferStatsMessage(this.sessionId, totalBatches, totalSingleFiles);
            if (this.activeChannel != null && this.activeChannel.isActive()) {
                ChannelFuture future = this.activeChannel.writeAndFlush(statsMessage);
                future.await(10L, TimeUnit.SECONDS);
                if (future.isSuccess()) {
                    logger.info("\ud83d\udcca \u5df2\u53d1\u9001\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f\u7ed9\u63a5\u6536\u7aef: {} \u4e2a\u6279\u6b21\u5305 + {} \u4e2a\u5355\u6587\u4ef6", (Object)totalBatches, (Object)totalSingleFiles);
                } else {
                    logger.warn("\u53d1\u9001\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: {}", (Object)(future.cause() != null ? future.cause().getMessage() : "\u672a\u77e5\u9519\u8bef"));
                }
            } else {
                logger.warn("\u65e0\u6cd5\u53d1\u9001\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f: \u901a\u9053\u672a\u6fc0\u6d3b");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static class BatchTransferResult {
        private final boolean success;
        private final List<FileEntryInfo> unbatchableFiles;

        public BatchTransferResult(boolean success, List<FileEntryInfo> unbatchableFiles) {
            this.success = success;
            this.unbatchableFiles = unbatchableFiles;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public List<FileEntryInfo> getUnbatchableFiles() {
            return this.unbatchableFiles;
        }
    }
}

