/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.unified;

import com.file.netty.codec.CodecFactory;
import com.file.netty.config.RelayConfig;
import com.file.netty.config.SimpleMultiRelayManager;
import com.file.netty.discovery.BroadcastDiscoverer;
import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.JoinMessage;
import com.file.netty.protocol.Message;
import com.file.netty.protocol.MessageType;
import com.file.netty.receiver.FileReceiver;
import com.file.netty.receiver.FolderReceiver;
import com.file.netty.unified.UnifiedReceiverHandler;
import com.file.netty.utils.ConsoleFormatter;
import com.file.netty.utils.FileTransferUtils;
import com.file.netty.utils.HandlerExceptionUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedReceiver {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedReceiver.class);
    private volatile long lastActivityTime = System.currentTimeMillis();
    private BroadcastDiscoverer broadcastDiscoverer;
    private volatile boolean sessionJoinedFlag = false;
    private static final long QUICK_DISCOVERY_TIMEOUT = 5000L;
    private static final long CONNECT_RELAY_TIMEOUT = 5000L;
    private String host;
    private int port;
    private final String saveDir;
    private Channel channel;
    private String sessionId;
    private EventLoopGroup group;
    private List<SimpleMultiRelayManager.RelayConnectionInfo> availableRelays;
    private int currentRelayIndex = 0;
    private boolean isMultiRelayMode = false;
    private CountDownLatch connectionLatch;
    private UnifiedReceiverHandler currentHandler;
    private boolean autoDiscoverRelay = true;
    private String discoveredRelayHost = null;
    private int discoveredRelayPort = -1;
    public boolean isUsingLocalRelay = false;
    private boolean isUsingPublicRelay = false;
    private volatile boolean sessionJoined = false;
    private volatile boolean transferInProgress = false;
    private volatile boolean transferCompleted = false;
    private volatile boolean fileSkipped = false;
    private volatile boolean connectionActive = false;
    private volatile boolean codeInvalid = false;
    private TransferType transferType = TransferType.UNKNOWN;
    private FileReceiver fileReceiver;
    private FolderReceiver folderReceiver;
    private static final long CONNECTION_TIMEOUT = 30000L;

    public UnifiedReceiver(String host, int port, String saveDir, boolean silentMode) {
        this.host = host;
        this.port = port;
        this.saveDir = saveDir;
        this.connectionLatch = new CountDownLatch(1);
    }

    public void updateLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public boolean isFileSkipped() {
        return this.fileSkipped;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String sessionId) throws Exception {
        this.sessionId = sessionId;
        this.connectionLatch = new CountDownLatch(1);
        FileTransferUtils.ensureDirectoryExists(this.saveDir);
        this.lastActivityTime = System.currentTimeMillis();
        logger.info("\u6b63\u5728\u4f7f\u7528\u5e7f\u64ad\u67e5\u627e\u4f1a\u8bddID: {}", (Object)sessionId);
        System.out.println("\ud83d\udd0d \u6b63\u5728\u67e5\u627e\u4f1a\u8bddID: " + sessionId);
        this.broadcastDiscoverer = new BroadcastDiscoverer();
        boolean found = this.broadcastDiscoverer.waitForSessionId(sessionId, 5000L);
        if (found) {
            System.out.println("\u2705 \u53d1\u73b0\u672c\u5730\u670d\u52a1!");
            System.out.println("\ud83c\udd94 \u670d\u52a1ID: " + ConsoleFormatter.brightGreen(sessionId));
            this.discoveredRelayHost = this.broadcastDiscoverer.getDiscoveredRelayHost();
            this.discoveredRelayPort = this.broadcastDiscoverer.getDiscoveredRelayPort();
            System.out.println("\ud83d\udd17 \u8fde\u63a5\u5730\u5740: " + this.discoveredRelayHost + ":" + this.discoveredRelayPort);
            logger.info("\u53d1\u73b0\u5339\u914d\u4f1a\u8bddID\u7684\u670d\u52a1: {}:{}", (Object)this.discoveredRelayHost, (Object)this.discoveredRelayPort);
        } else {
            logger.info("\u672a\u627e\u5230\u5339\u914d\u4f1a\u8bddID\u7684\u670d\u52a1\uff0c\u5c06\u5c1d\u8bd5\u4f7f\u7528\u6307\u5b9a\u4e2d\u7ee7\u670d\u52a1\u5668");
            System.out.println("\u26a0\ufe0f \u672a\u627e\u5230\u672c\u5730\u670d\u52a1\uff0c\u5c1d\u8bd5\u516c\u5171\u4e2d\u7ee7...");
        }
        this.group = new NioEventLoopGroup();
        try {
            boolean connected = false;
            if (this.discoveredRelayHost != null && this.discoveredRelayPort > 0) {
                logger.info("\u6b63\u5728\u8fde\u63a5\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668...");
                if (this.connectToRelay(this.discoveredRelayHost, this.discoveredRelayPort)) {
                    this.isUsingLocalRelay = true;
                    connected = true;
                    if (this.connectionLatch.await(10L, TimeUnit.SECONDS)) {
                        this.waitForTransferCompletion();
                        return;
                    }
                    logger.info("\u672c\u5730\u4e2d\u7ee7\u8fde\u63a5\u8d85\u65f6\uff0c\u5c06\u5c1d\u8bd5\u4f7f\u7528\u6307\u5b9a\u4e2d\u7ee7\u670d\u52a1\u5668...");
                    connected = false;
                    this.closeCurrentConnection();
                } else {
                    logger.info("\u8fde\u63a5\u672c\u5730\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25\uff0c\u5c06\u5c1d\u8bd5\u4f7f\u7528\u6307\u5b9a\u4e2d\u7ee7\u670d\u52a1\u5668...");
                }
            }
            if (!connected) {
                String relayHost = RelayConfig.getPublicRelayHost();
                int relayPort = RelayConfig.getPublicRelayPort();
                boolean isCustomRelay = RelayConfig.isUsingCustomRelay();
                if (isCustomRelay) {
                    logger.info("\u5c1d\u8bd5\u8fde\u63a5\u81ea\u5b9a\u4e49\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)relayHost, (Object)relayPort);
                    System.out.println("\ud83d\udd17 \u8fde\u63a5\u81ea\u5b9a\u4e49\u4e2d\u7ee7: " + relayHost + ":" + relayPort);
                } else {
                    logger.info("\u5c1d\u8bd5\u8fde\u63a5\u9ed8\u8ba4\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)relayHost, (Object)relayPort);
                    System.out.println("\ud83d\udd17 \u8fde\u63a5\u9ed8\u8ba4\u516c\u5171\u4e2d\u7ee7...");
                }
                if (!this.connectToRelay(relayHost, relayPort)) {
                    logger.info("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25");
                    throw new IOException("\u65e0\u6cd5\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u6216\u7a0d\u540e\u91cd\u8bd5");
                }
                this.isUsingLocalRelay = false;
                this.isUsingPublicRelay = !isCustomRelay;
                connected = true;
                if (!this.connectionLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                    logger.info("\u4e2d\u7ee7\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
                    System.out.println("\u274c \u4e2d\u7ee7\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
                    connected = false;
                    this.closeCurrentConnection();
                    throw new IOException("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u6216\u7a0d\u540e\u91cd\u8bd5");
                }
                System.out.println("\u2705 \u8fde\u63a5\u5df2\u5efa\u7acb\uff0c\u7b49\u5f85\u4f20\u8f93\u5b8c\u6210");
                this.waitForTransferCompletion();
                return;
            }
            if (connected) return;
            if (this.codeInvalid) {
                logger.info("\u914d\u5bf9\u7801\u65e0\u6548\uff0c\u7ec8\u6b62\u64cd\u4f5c");
                return;
            }
            logger.warn("\u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668");
            throw new IOException("\u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55\u4e2d\u7ee7\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u6216\u7a0d\u540e\u91cd\u8bd5");
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    private void waitForTransferCompletion() {
        if (this.channel != null) {
            try {
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u4f20\u8f93\u5b8c\u6210\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeCurrentConnection() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close().sync();
            }
            catch (InterruptedException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u65f6\u88ab\u4e2d\u65ad", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean connectToRelay(String relayHost, int relayPort) {
        try {
            logger.info("\u5c1d\u8bd5\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668: " + relayHost + ":" + relayPort);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new IdleStateHandler(0, 30, 0));
                    CodecFactory.addClientCodec(p);
                    UnifiedReceiver.this.currentHandler = new UnifiedReceiverHandler(UnifiedReceiver.this, UnifiedReceiver.this.isMultiRelayMode);
                    p.addLast("unifiedReceiverHandler", (ChannelHandler)UnifiedReceiver.this.currentHandler);
                }
            });
            ChannelFuture future = b.connect(relayHost, relayPort);
            future.awaitUninterruptibly(5000L);
            if (future.isSuccess()) {
                this.channel = future.channel();
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668: {}:{}", (Object)relayHost, (Object)relayPort);
                logger.info("\u6210\u529f\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
                this.connectionActive = true;
                this.joinSession();
                this.channel.closeFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        UnifiedReceiver.this.connectionActive = false;
                        if (UnifiedReceiver.this.fileReceiver != null) {
                            UnifiedReceiver.this.fileReceiver.shutdown();
                        }
                        if (UnifiedReceiver.this.folderReceiver != null) {
                            UnifiedReceiver.this.folderReceiver.shutdown();
                        }
                    }
                });
                this.host = relayHost;
                this.port = relayPort;
                return true;
            }
            logger.warn("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u5931\u8d25: {}:{}", (Object)relayHost, (Object)relayPort);
            return false;
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), e);
            return false;
        }
    }

    public void joinSession() {
        if (this.channel != null && this.channel.isActive()) {
            JoinMessage joinMsg = new JoinMessage(this.sessionId);
            this.channel.writeAndFlush(joinMsg);
            logger.info("\u53d1\u9001\u52a0\u5165\u4f1a\u8bdd\u8bf7\u6c42, \u4f1a\u8bddID: {}", (Object)this.sessionId);
        }
    }

    public void sessionJoined() {
        this.sessionJoined = true;
        this.stopBroadcastDiscovery();
        this.connectionLatch.countDown();
    }

    private void stopBroadcastDiscovery() {
        if (this.broadcastDiscoverer != null) {
            try {
                this.broadcastDiscoverer.stop();
                logger.info("\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1\u5df2\u505c\u6b62");
            }
            catch (Exception e) {
                logger.warn("\u505c\u6b62\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
    }

    public void handleMessage(Message msg) throws Exception {
        this.updateLastActivityTime();
        if (this.transferType == TransferType.UNKNOWN) {
            this.identifyTransferType(msg);
        }
        if (msg.getType() == MessageType.TRANSFER_COMPLETE && this.transferType == TransferType.FILE) {
            if (!this.transferCompleted) {
                this.fileReceiver.handleMessage(msg);
                this.transferCompleted = true;
                if (this.currentHandler != null) {
                    this.currentHandler.markTransferCompleted();
                }
            }
            return;
        }
        if (msg.getType() == MessageType.FOLDER_COMPLETE && this.transferType == TransferType.FOLDER) {
            if (!this.transferCompleted) {
                this.folderReceiver.handleMessage(msg);
                this.transferCompleted = true;
                if (this.currentHandler != null) {
                    this.currentHandler.markTransferCompleted();
                }
            }
            return;
        }
        if (msg.getType() == MessageType.ERROR) {
            HandlerExceptionUtils.handleException(null, new RuntimeException(((ErrorMessage)msg).getErrorMsg()), "UnifiedReceiverHandler");
        } else if (this.transferType == TransferType.FILE) {
            this.fileReceiver.handleMessage(msg);
            if (this.fileReceiver.isFileSkipped()) {
                this.fileSkipped = true;
                this.transferCompleted = true;
                if (this.currentHandler != null) {
                    this.currentHandler.markTransferCompleted();
                }
            }
        } else if (this.transferType == TransferType.FOLDER) {
            this.folderReceiver.handleMessage(msg);
        }
    }

    private void identifyTransferType(Message msg) throws Exception {
        if (msg.getType() == MessageType.FILE_INFO) {
            this.transferType = TransferType.FILE;
            logger.info("\u68c0\u6d4b\u5230\u6587\u4ef6\u4f20\u8f93");
            this.initializeFileReceiver();
        } else if (msg.getType() == MessageType.FOLDER_INFO) {
            this.transferType = TransferType.FOLDER;
            logger.info("\u68c0\u6d4b\u5230\u6587\u4ef6\u5939\u4f20\u8f93");
            this.initializeFolderReceiver();
        }
    }

    private void initializeFileReceiver() {
        this.fileReceiver = new FileReceiver(this.host, this.port, this.saveDir, true);
        this.fileReceiver.setExistingConnection(this.channel, this.sessionId);
    }

    private void initializeFolderReceiver() {
        this.folderReceiver = new FolderReceiver(this.host, this.port, this.saveDir, true);
        this.folderReceiver.setExistingConnection(this.channel, this.sessionId);
    }

    public void onCodeInvalid() {
        this.codeInvalid = true;
        if (this.connectionLatch != null && this.connectionLatch.getCount() > 0L) {
            this.connectionLatch.countDown();
        }
        if (this.availableRelays != null && this.currentRelayIndex < this.availableRelays.size() - 1) {
            logger.info("\u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u5c06\u5c1d\u8bd5\u4e0b\u4e00\u4e2a\u4e2d\u7ee7");
            System.out.println("\u274c \u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u4e2d\u7ee7\u4e0a\u65e0\u6b64\u4f1a\u8bdd");
            return;
        }
        logger.info("\u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u7a0b\u5e8f\u5c06\u5728 1 \u79d2\u540e\u9000\u51fa...");
        System.out.println("\u274c \u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u7a0b\u5e8f\u5c06\u5728 1 \u79d2\u540e\u9000\u51fa...");
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }).start();
    }

    public void switchToPublicRelay() {
        if (this.codeInvalid) {
            logger.info("\u914d\u5bf9\u7801\u5df2\u786e\u8ba4\u65e0\u6548\uff0c\u4e0d\u518d\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7");
            logger.info("\u914d\u5bf9\u7801\u65e0\u6548\uff0c\u7a0b\u5e8f\u5373\u5c06\u9000\u51fa");
            System.out.println("\u274c \u914d\u5bf9\u7801\u65e0\u6548\uff0c\u7a0b\u5e8f\u5373\u5c06\u9000\u51fa");
            return;
        }
        if (this.isUsingPublicRelay || this.transferCompleted) {
            logger.info("\u4e0d\u9700\u8981\u5207\u6362\u5230\u516c\u7f51\u4e2d\u7ee7\uff1a{}", (Object)(this.transferCompleted ? "\u4f20\u8f93\u5df2\u5b8c\u6210" : "\u5df2\u5728\u4f7f\u7528\u516c\u7f51\u4e2d\u7ee7"));
            return;
        }
        logger.info("\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
        logger.info("\u6b63\u5728\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668...");
        System.out.println("\ud83d\udd04 \u6b63\u5728\u5207\u6362\u5230\u516c\u5171\u4e2d\u7ee7...");
        this.closeCurrentConnection();
        String relayHost = RelayConfig.getPublicRelayHost();
        int relayPort = RelayConfig.getPublicRelayPort();
        if (this.connectToRelay(relayHost, relayPort)) {
            this.isUsingLocalRelay = false;
            this.isUsingPublicRelay = true;
            logger.info("\u6210\u529f\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
            System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\uff01");
        } else {
            logger.info("\u65e0\u6cd5\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668\uff0c\u4f20\u8f93\u5931\u8d25");
            System.out.println("\u274c \u65e0\u6cd5\u8fde\u63a5\u5230\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668");
        }
    }

    public void shutdown() {
        this.stopBroadcastDiscovery();
        if (this.fileReceiver != null) {
            this.fileReceiver.shutdown();
        }
        if (this.folderReceiver != null) {
            this.folderReceiver.shutdown();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    public void startWithMultiRelay(String sessionId) throws Exception {
        this.sessionId = sessionId;
        this.connectionLatch = new CountDownLatch(1);
        this.currentRelayIndex = 0;
        this.isMultiRelayMode = true;
        FileTransferUtils.ensureDirectoryExists(this.saveDir);
        this.lastActivityTime = System.currentTimeMillis();
        System.out.println("\ud83d\udd12 \u4f1a\u8bddID: " + ConsoleFormatter.brightGreen(sessionId));
        try {
            this.availableRelays = SimpleMultiRelayManager.getAllAvailableRelays(sessionId);
            boolean connected = false;
            this.currentRelayIndex = 0;
            while (this.currentRelayIndex < this.availableRelays.size()) {
                SimpleMultiRelayManager.RelayConnectionInfo relayInfo = this.availableRelays.get(this.currentRelayIndex);
                System.out.println("\ud83d\udd04 \u5c1d\u8bd5\u4e2d\u7ee7: " + relayInfo);
                try {
                    connected = this.tryConnectToRelay(relayInfo);
                    if (connected) {
                        System.out.println("\u2705 \u6700\u7ec8\u9009\u62e9: " + relayInfo.getDescription() + " (" + relayInfo.getHost() + ":" + relayInfo.getPort() + ")");
                        this.waitForTransferCompletion();
                        break;
                    }
                }
                catch (Exception e) {
                    logger.debug("\u8fde\u63a5\u4e2d\u7ee7\u5931\u8d25: {} - {}", (Object)relayInfo, (Object)e.getMessage());
                    this.closeCurrentConnection();
                    if (this.currentRelayIndex < this.availableRelays.size() - 1) {
                        // empty if block
                    }
                }
                ++this.currentRelayIndex;
            }
            if (!connected) {
                System.out.println("\u274c \u6240\u6709\u4e2d\u7ee7\u90fd\u65e0\u6cd5\u8fde\u63a5\u6216\u9a8c\u8bc1\u914d\u5bf9\u7801\u5931\u8d25");
                throw new IOException("\u6240\u6709\u4e2d\u7ee7\u90fd\u65e0\u6cd5\u8fde\u63a5\u6216\u9a8c\u8bc1\u914d\u5bf9\u7801\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u591a\u4e2d\u7ee7\u8fde\u63a5\u5931\u8d25", e);
            System.out.println("\u274c \u591a\u4e2d\u7ee7\u8fde\u63a5\u5931\u8d25: " + e.getMessage());
            this.closeCurrentConnection();
            throw e;
        }
    }

    private boolean tryConnectToRelay(SimpleMultiRelayManager.RelayConnectionInfo relayInfo) throws Exception {
        this.host = relayInfo.getHost();
        this.port = relayInfo.getPort();
        if (this.group != null) {
            this.group.shutdownGracefully().await(1L, TimeUnit.SECONDS);
        }
        this.group = new NioEventLoopGroup();
        this.connectionLatch = new CountDownLatch(1);
        this.codeInvalid = false;
        boolean connected = this.connectToRelay(this.host, this.port);
        if (connected) {
            SimpleMultiRelayManager.markRelaySuccess(this.host, this.port);
            System.out.println("\u2705 \u8fde\u63a5\u6210\u529f: " + relayInfo.getDescription());
            if (!this.connectionLatch.await(10L, TimeUnit.SECONDS)) {
                logger.info("\u4e2d\u7ee7\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
                System.out.println("\u274c \u4e2d\u7ee7\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
                throw new IOException("\u8fde\u63a5\u4e2d\u7ee7\u670d\u52a1\u5668\u8d85\u65f6");
            }
            if (this.codeInvalid) {
                throw new IOException("\u914d\u5bf9\u7801\u9a8c\u8bc1\u5931\u8d25");
            }
            System.out.println("\u2705 \u914d\u5bf9\u7801\u9a8c\u8bc1\u6210\u529f\uff0c\u4f20\u8f93\u5c06\u5f00\u59cb");
            return true;
        }
        SimpleMultiRelayManager.markRelayFailure(this.host, this.port);
        throw new IOException("\u65e0\u6cd5\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668: " + relayInfo);
    }

    public FolderReceiver getFolderReceiver() {
        return this.folderReceiver;
    }

    public FileReceiver getFileReceiver() {
        return this.fileReceiver;
    }

    private static enum TransferType {
        UNKNOWN,
        FILE,
        FOLDER;

    }
}

