/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.unified;

import com.file.netty.protocol.ErrorMessage;
import com.file.netty.protocol.JoinResultMessage;
import com.file.netty.protocol.Message;
import com.file.netty.receiver.FileReceiver;
import com.file.netty.receiver.FolderReceiver;
import com.file.netty.unified.UnifiedReceiver;
import com.file.netty.utils.ExitMessageFormatter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedReceiverHandler
extends SimpleChannelInboundHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedReceiverHandler.class);
    private final UnifiedReceiver receiver;
    private boolean receivedMessage = false;
    private boolean receivedDataMessage = false;
    private boolean transferCompleted = false;
    private boolean codeInvalidConfirmed = false;
    private volatile long lastHeartbeatTime = System.currentTimeMillis();
    private volatile boolean connectionHealthy = true;
    private ScheduledExecutorService healthCheckExecutor;
    private boolean isMultiRelayMode = false;

    public UnifiedReceiverHandler(UnifiedReceiver receiver) {
        this.receiver = receiver;
        this.startConnectionHealthCheck();
    }

    public UnifiedReceiverHandler(UnifiedReceiver receiver, boolean isMultiRelayMode) {
        this.receiver = receiver;
        this.isMultiRelayMode = isMultiRelayMode;
        this.startConnectionHealthCheck();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        this.receiver.updateLastActivityTime();
        this.lastHeartbeatTime = System.currentTimeMillis();
        this.receivedMessage = true;
        switch (msg.getType()) {
            case JOIN_RESULT: {
                JoinResultMessage joinResult = (JoinResultMessage)msg;
                if (joinResult.isSuccess()) {
                    logger.info("\u6210\u529f\u52a0\u5165\u4f1a\u8bdd\uff0c\u7b49\u5f85\u6570\u636e...");
                    logger.info("\u6210\u529f\u52a0\u5165\u4f1a\u8bdd\uff0c\u7b49\u5f85\u6570\u636e...");
                    this.receiver.sessionJoined();
                    break;
                }
                logger.error("\u52a0\u5165\u4f1a\u8bdd\u5931\u8d25\uff0c\u914d\u5bf9\u7801\u65e0\u6548");
                logger.info("\u52a0\u5165\u4f1a\u8bdd\u5931\u8d25\uff0c\u914d\u5bf9\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f");
                this.codeInvalidConfirmed = true;
                ctx.close();
                this.receiver.onCodeInvalid();
                break;
            }
            case FILE_INFO: 
            case FOLDER_INFO: 
            case BATCH_FILE_INFO: 
            case COMPRESSED_BATCH_MANIFEST: 
            case COMPRESSED_BATCH_DATA: 
            case TRANSFER_STATS: {
                this.receivedDataMessage = true;
                this.receiver.handleMessage(msg);
                break;
            }
            case FILE_CHUNK: 
            case TRANSFER_COMPLETE: 
            case FOLDER_COMPLETE: 
            case FOLDER_INFO_ACK: 
            case BATCH_FILE_ACK: 
            case COMPRESSED_BATCH_MANIFEST_ACK: 
            case COMPRESSED_BATCH_COMPLETE: 
            case HEARTBEAT: {
                this.receiver.handleMessage(msg);
                break;
            }
            case ERROR: {
                ErrorMessage errorMsg = (ErrorMessage)msg;
                String error = errorMsg.getErrorMsg();
                logger.error("\u6536\u5230\u9519\u8bef\u6d88\u606f: {}", (Object)error);
                if (this.receiver.isFileSkipped() && (error.contains("\u53d1\u9001\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5") || error.contains("\u63a5\u6536\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5"))) {
                    logger.info("\u6587\u4ef6\u8df3\u8fc7\u540e\u53d1\u9001\u7aef\u6b63\u5e38\u65ad\u5f00\u8fde\u63a5: {}", (Object)error);
                    if (this.isMultiRelayMode) break;
                    this.showSmartCompletionMessage();
                    System.exit(0);
                    break;
                }
                logger.info("\u670d\u52a1\u5668\u9519\u8bef: " + error);
                this.receiver.handleMessage(errorMsg);
                break;
            }
            default: {
                logger.warn("\u6536\u5230\u672a\u5904\u7406\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)msg.getType());
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info("\u901a\u9053\u65ad\u5f00 - \u7cfb\u7edf: {}", (Object)System.getProperty("os.name"));
        if (this.connectionHealthy) {
            this.handleSenderDisconnection();
        }
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String osName = System.getProperty("os.name");
        logger.info("\u5f02\u5e38\u6355\u83b7 - \u7cfb\u7edf: {}, \u5f02\u5e38: {}", (Object)osName, (Object)cause.getMessage());
        System.out.println("\u26a0\ufe0f \u8fde\u63a5\u5f02\u5e38: " + cause.getMessage());
        if (this.connectionHealthy) {
            this.handleSenderDisconnection();
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.healthCheckExecutor != null) {
            this.healthCheckExecutor.shutdown();
        }
        super.handlerRemoved(ctx);
    }

    public void markTransferCompleted() {
        this.transferCompleted = true;
        logger.info("\u6807\u8bb0\u4f20\u8f93\u5df2\u5b8c\u6210");
    }

    private void startConnectionHealthCheck() {
        this.healthCheckExecutor = Executors.newSingleThreadScheduledExecutor();
        this.healthCheckExecutor.scheduleWithFixedDelay(() -> {
            try {
                long now = System.currentTimeMillis();
                long timeSinceLastActivity = now - this.receiver.getLastActivityTime();
                if (timeSinceLastActivity > 30000L) {
                    logger.warn("\u8fde\u63a5{}\u79d2\u65e0\u6d3b\u52a8\uff0c\u68c0\u67e5\u8fde\u63a5\u5065\u5eb7\u72b6\u6001", (Object)(timeSinceLastActivity / 1000L));
                    if (timeSinceLastActivity > 60000L) {
                        logger.error("\u8fde\u63a5{}\u79d2\u65e0\u6d3b\u52a8\uff0c\u5224\u65ad\u53d1\u9001\u7aef\u5df2\u9000\u51fa", (Object)(timeSinceLastActivity / 1000L));
                        this.handleSenderDisconnection();
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8fde\u63a5\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38", e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private void handleSenderDisconnection() {
        if (!this.connectionHealthy) {
            return;
        }
        if (this.transferCompleted) {
            if (this.receiver.isFileSkipped()) {
                System.out.println();
                this.showSmartCompletionMessage();
                System.exit(0);
            } else {
                this.handleSenderExit();
            }
            return;
        }
        this.connectionHealthy = false;
        if (this.isMultiRelayMode) {
            logger.info("\u591a\u4e2d\u7ee7\u6a21\u5f0f\u4e0b\u68c0\u6d4b\u5230\u8fde\u63a5\u65ad\u5f00\uff0c\u4e0d\u9000\u51fa\u7a0b\u5e8f");
            if (this.healthCheckExecutor != null) {
                this.healthCheckExecutor.shutdown();
            }
            return;
        }
        System.out.println("\n\u26a0\ufe0f \u68c0\u6d4b\u5230\u53d1\u9001\u7aef\u8fde\u63a5\u5f02\u5e38\u6216\u5df2\u9000\u51fa");
        System.out.println("\ud83d\udd0c \u4f20\u8f93\u53ef\u80fd\u88ab\u4e2d\u65ad\uff0c\u7a0b\u5e8f\u5c06\u9000\u51fa");
        if (this.healthCheckExecutor != null) {
            this.healthCheckExecutor.shutdown();
        }
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }, "ExitHandler").start();
    }

    private void handleSenderExit() {
        System.out.println();
        ExitMessageFormatter.showSenderDisconnected();
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }, "ExitHandler").start();
    }

    private void showSmartCompletionMessage() {
        try {
            if (this.receiver.getFolderReceiver() != null) {
                FolderReceiver folderReceiver = this.receiver.getFolderReceiver();
                int receivedFiles = folderReceiver.getReceivedFiles();
                int skippedFiles = folderReceiver.getSkippedFiles();
                int totalFiles = folderReceiver.getTotalFiles();
                ExitMessageFormatter.showSmartTransferComplete(receivedFiles, skippedFiles, totalFiles);
            } else if (this.receiver.getFileReceiver() != null) {
                FileReceiver fileReceiver = this.receiver.getFileReceiver();
                String fileName = fileReceiver.getFileName();
                long fileSize = fileReceiver.getFileSize();
                String filePath = fileReceiver.getFilePath();
                boolean skipped = fileReceiver.isFileSkipped();
                if (fileName != null && fileSize > 0L) {
                    ExitMessageFormatter.showSingleFileComplete(fileName, fileSize, skipped, filePath);
                } else if (this.receiver.isFileSkipped()) {
                    System.out.println("\u2705 \u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93");
                } else {
                    System.out.println("\u2705 \u6587\u4ef6\u4f20\u8f93\u5b8c\u6210");
                }
                ExitMessageFormatter.showSenderDisconnected();
            } else {
                if (this.receiver.isFileSkipped()) {
                    System.out.println("\u2705 \u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4f20\u8f93");
                } else {
                    System.out.println("\u2705 \u4f20\u8f93\u5b8c\u6210");
                }
                ExitMessageFormatter.showSenderDisconnected();
            }
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u4f20\u8f93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u9000\u51fa\u6d88\u606f: {}", (Object)e.getMessage());
            ExitMessageFormatter.showSenderDisconnected();
        }
    }
}

