/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.unified;

import com.file.netty.config.EncryptionConfig;
import com.file.netty.config.RelayConfig;
import com.file.netty.unified.UnifiedReceiver;
import com.file.netty.unified.UnifiedSender;
import com.file.netty.utils.FileTransferUtils;
import java.util.Scanner;

public class UnifiedTransfer {
    private static void printUsage() {
        System.out.println("=================================================");
        System.out.println("           \u7edf\u4e00\u6587\u4ef6\u4f20\u8f93\u7cfb\u7edf v1.0");
        System.out.println("=================================================");
        System.out.println();
        System.out.println("\u7528\u6cd5:");
        System.out.println("  java -jar croc-cli.jar <\u6a21\u5f0f> [\u53c2\u6570] [\u9009\u9879]");
        System.out.println();
        System.out.println("\u652f\u6301\u7684\u6a21\u5f0f:");
        System.out.println("  send <\u8def\u5f84>          \u53d1\u9001\u6587\u4ef6\u6216\u6587\u4ef6\u5939");
        System.out.println("  receive [\u63a5\u6536\u7801]     \u63a5\u6536\u6587\u4ef6\u6216\u6587\u4ef6\u5939");
        System.out.println("  help                 \u663e\u793a\u6b64\u5e2e\u52a9\u4fe1\u606f");
        System.out.println();
        System.out.println("\u901a\u7528\u9009\u9879:");
        System.out.println("  --password <\u5bc6\u7801>        \u8bbe\u7f6e\u81ea\u5b9a\u4e49\u52a0\u5bc6\u5bc6\u7801");
        System.out.println("  --help, -h               \u663e\u793a\u5e2e\u52a9\u4fe1\u606f");
        System.out.println();
        System.out.println("\u53d1\u9001\u6a21\u5f0f\u53c2\u6570:");
        System.out.println("  <\u8def\u5f84>                   \u8981\u53d1\u9001\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u8def\u5f84");
        System.out.println("                           \u652f\u6301\u7edd\u5bf9\u8def\u5f84\u548c\u76f8\u5bf9\u8def\u5f84");
        System.out.println();
        System.out.println("\u63a5\u6536\u6a21\u5f0f\u53c2\u6570:");
        System.out.println("  [\u63a5\u6536\u7801]                 \u53ef\u9009\u7684\u63a5\u6536\u7801\uff0c\u672a\u6307\u5b9a\u65f6\u4f1a\u63d0\u793a\u8f93\u5165");
        System.out.println("                           \u63a5\u6536\u7801\u7531\u53d1\u9001\u7aef\u751f\u6210\u5e76\u663e\u793a");
        System.out.println();
        System.out.println("\u57fa\u7840\u4f7f\u7528\u793a\u4f8b:");
        System.out.println("  # \u53d1\u9001\u5355\u4e2a\u6587\u4ef6 (\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e)");
        System.out.println("  java -jar croc-cli.jar send report.pdf");
        System.out.println();
        System.out.println("  # \u53d1\u9001\u6587\u4ef6\u5939");
        System.out.println("  java -jar croc-cli.jar send /home/user/documents");
        System.out.println();
        System.out.println("  # \u63a5\u6536\u6587\u4ef6 (\u4ea4\u4e92\u5f0f\u8f93\u5165\u63a5\u6536\u7801)");
        System.out.println("  java -jar croc-cli.jar receive");
        System.out.println();
        System.out.println("  # \u63a5\u6536\u6587\u4ef6 (\u76f4\u63a5\u6307\u5b9a\u63a5\u6536\u7801)");
        System.out.println("  java -jar croc-cli.jar receive abcd1234");
        System.out.println();
        System.out.println("\u5b89\u5168\u4f20\u8f93\u793a\u4f8b:");
        System.out.println("  # \u4f7f\u7528\u81ea\u5b9a\u4e49\u5bc6\u7801\u53d1\u9001");
        System.out.println("  java -jar croc-cli.jar send file.txt --password mySecretPass123");
        System.out.println();
        System.out.println("  # \u4f7f\u7528\u76f8\u540c\u5bc6\u7801\u63a5\u6536 (\u914d\u7f6e\u5fc5\u987b\u5339\u914d)");
        System.out.println("  java -jar croc-cli.jar receive xyz56789 --password mySecretPass123");
        System.out.println();
        System.out.println("\u591a\u4e2d\u7ee7\u667a\u80fd\u9009\u62e9\u793a\u4f8b:");
        System.out.println("  # \u7cfb\u7edf\u81ea\u52a8\u9009\u62e9\u6700\u4f73\u4e2d\u7ee7\uff08\u9ed8\u8ba4\u884c\u4e3a\uff09");
        System.out.println("  java -jar croc-cli.jar send folder/");
        System.out.println("  java -jar croc-cli.jar receive abc123");
        System.out.println();
        System.out.println("\u52a0\u5bc6\u4f20\u8f93\u793a\u4f8b:");
        System.out.println("  # \u4f7f\u7528\u81ea\u5b9a\u4e49\u5bc6\u7801\u4f20\u8f93");
        System.out.println("  java -jar croc-cli.jar send data.zip --password strongPass456");
        System.out.println("  java -jar croc-cli.jar receive def789 --password strongPass456");
        System.out.println();
        System.out.println("\u591a\u4e2d\u7ee7\u914d\u7f6e:");
        System.out.println("  # \u914d\u7f6e\u6587\u4ef6: ~/.croc/relay-config.properties");
        System.out.println("  # \u683c\u5f0f: relay.servers=host1:port1:HIGH,host2:port2:MEDIUM");
        System.out.println("  # \u73af\u5883\u53d8\u91cf: CROC_RELAY_SERVERS=host1:port1:HIGH,host2:port2:MEDIUM");
        System.out.println();
        System.out.println("  # \u8fde\u63a5\u4f18\u5148\u7ea7: \u672c\u5730\u4e2d\u7ee7 \u2192 \u914d\u7f6e\u7684\u4e2d\u7ee7 \u2192 \u9ed8\u8ba4\u516c\u7f51\u4e2d\u7ee7");
        System.out.println();
        System.out.println("\u8de8\u5e73\u53f0\u8def\u5f84\u793a\u4f8b:");
        System.out.println("  # Windows \u8def\u5f84");
        System.out.println("  java -jar croc-cli.jar send \"D:\\\u6587\u6863\\\u9879\u76ee\u8d44\u6599\"");
        System.out.println();
        System.out.println("  # Linux/Mac \u8def\u5f84");
        System.out.println("  java -jar croc-cli.jar send ~/Documents/project");
        System.out.println();
        System.out.println("  # \u76f8\u5bf9\u8def\u5f84");
        System.out.println("  java -jar croc-cli.jar send ./data/");
        System.out.println();
        System.out.println("\u26a0\ufe0f  \u91cd\u8981\u6ce8\u610f\u4e8b\u9879:");
        System.out.println("  1. \u53d1\u9001\u7aef\u548c\u63a5\u6536\u7aef\u7684\u914d\u7f6e\u9009\u9879\u5fc5\u987b\u5b8c\u5168\u4e00\u81f4");
        System.out.println("     (\u4e2d\u7ee7\u670d\u52a1\u5668\u3001\u7aef\u53e3\u3001\u5bc6\u7801\u7b49)");
        System.out.println("  2. \u63a5\u6536\u7801\u7531\u53d1\u9001\u7aef\u751f\u6210\uff0c\u4f20\u8f93\u7ed9\u63a5\u6536\u7aef\u4f7f\u7528");
        System.out.println("  3. \u4f20\u8f93\u8fc7\u7a0b\u4e2d\u8bf7\u4fdd\u6301\u7f51\u7edc\u8fde\u63a5\u7a33\u5b9a");
        System.out.println("  4. \u5927\u6587\u4ef6\u4f20\u8f93\u4f1a\u81ea\u52a8\u5206\u5757\u5e76\u8fdb\u884c\u5b8c\u6574\u6027\u6821\u9a8c");
        System.out.println("  5. \u6587\u4ef6\u5939\u4f20\u8f93\u4f1a\u4fdd\u6301\u539f\u6709\u7684\u76ee\u5f55\u7ed3\u6784");
        System.out.println();
        System.out.println("\ud83d\udd10 \u5b89\u5168\u5efa\u8bae:");
        System.out.println("  \u2022 \u5efa\u8bae\u4f7f\u7528\u5f3a\u5bc6\u7801 (\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26)");
        System.out.println("  \u2022 \u5728\u53ef\u80fd\u7684\u60c5\u51b5\u4e0b\u4f7f\u7528\u79c1\u6709\u7f51\u7edc\u4e2d\u7ee7\u670d\u52a1\u5668");
        System.out.println("  \u2022 \u907f\u514d\u5728\u4e0d\u5b89\u5168\u7684\u7f51\u7edc\u73af\u5883\u4e2d\u7981\u7528\u52a0\u5bc6");
        System.out.println("  \u2022 \u4f20\u8f93\u5b8c\u6210\u540e\u53ca\u65f6\u5220\u9664\u4e34\u65f6\u6587\u4ef6");
        System.out.println();
        System.out.println("\ud83c\udf10 \u7f51\u7edc\u8fde\u63a5:");
        System.out.println("  \u7cfb\u7edf\u4f1a\u81ea\u52a8\u5c1d\u8bd5\u6700\u4f18\u8fde\u63a5\u8def\u5f84:");
        System.out.println("  1. \u672c\u5730\u7f51\u7edc\u4e2d\u7ee7 (mDNS\u81ea\u52a8\u53d1\u73b0, \u6700\u5feb)");
        System.out.println("  2. \u81ea\u5b9a\u4e49\u4e2d\u7ee7\u670d\u52a1\u5668 (\u7528\u6237\u6307\u5b9a)");
        System.out.println("  3. \u9ed8\u8ba4\u516c\u5171\u4e2d\u7ee7\u670d\u52a1\u5668 (\u5907\u9009\u65b9\u6848)");
        System.out.println();
        System.out.println("\ud83d\udcdd \u5e38\u89c1\u95ee\u9898:");
        System.out.println("  Q: \u63d0\u793a '\u914d\u5bf9\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f'");
        System.out.println("  A: \u68c0\u67e5\u53cc\u65b9\u914d\u7f6e\u662f\u5426\u4e00\u81f4\uff0c\u786e\u8ba4\u63a5\u6536\u7801\u8f93\u5165\u6b63\u786e");
        System.out.println();
        System.out.println("  Q: \u65e0\u6cd5\u8fde\u63a5\u5230\u4e2d\u7ee7\u670d\u52a1\u5668");
        System.out.println("  A: \u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\uff0c\u9632\u706b\u5899\u8bbe\u7f6e\uff0c\u6216\u5c1d\u8bd5\u9ed8\u8ba4\u4e2d\u7ee7");
        System.out.println();
        System.out.println("  Q: \u4f20\u8f93\u4e2d\u65ad\u6216\u5931\u8d25");
        System.out.println("  A: \u786e\u8ba4\u7f51\u7edc\u7a33\u5b9a\uff0c\u68c0\u67e5\u78c1\u76d8\u7a7a\u95f4\uff0c\u9a8c\u8bc1\u914d\u7f6e\u5339\u914d");
        System.out.println();
        System.out.println("\ud83d\udcde \u83b7\u53d6\u5e2e\u52a9:");
        System.out.println("  java -jar croc-cli.jar help");
        System.out.println("  java -jar croc-cli.jar --help");
        System.out.println();
        System.out.println("=================================================");
    }

    private static void handleSendMode(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("\u9519\u8bef: \u53d1\u9001\u6a21\u5f0f\u9700\u8981\u6307\u5b9a\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u8def\u5f84");
            UnifiedTransfer.printUsage();
            return;
        }
        String sourcePath = args[1];
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\u2699\ufe0f \u4f20\u8f93\u914d\u7f6e");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println(EncryptionConfig.getConfigInfo());
        UnifiedSender sender = new UnifiedSender(sourcePath);
        sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleReceiveMode(String[] args) throws Exception {
        String sessionId = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (!"--password".equals(arg)) continue;
                ++i;
                continue;
            }
            sessionId = arg;
            break;
        }
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udce5 \u63a5\u6536\u914d\u7f6e");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println(EncryptionConfig.getConfigInfo());
        try (Scanner scanner = new Scanner(System.in);){
            if (sessionId == null || sessionId.trim().isEmpty()) {
                System.out.print("\ud83d\udd12 \u8bf7\u8f93\u5165\u914d\u5bf9\u7801: ");
                sessionId = scanner.nextLine().trim();
                if (sessionId.isEmpty()) {
                    System.out.println("\u914d\u5bf9\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
            }
            if (!UnifiedTransfer.isValidSessionId(sessionId)) {
                System.out.println("\u8b66\u544a: \u914d\u5bf9\u7801\u683c\u5f0f\u53ef\u80fd\u4e0d\u6b63\u786e\uff0c\u4f46\u4ecd\u5c06\u5c1d\u8bd5\u8fde\u63a5");
            }
            UnifiedReceiver receiver = new UnifiedReceiver(RelayConfig.getPublicRelayHost(), RelayConfig.getPublicRelayPort(), FileTransferUtils.getDefaultReceiveDirectory(), true);
            receiver.startWithMultiRelay(sessionId);
        }
    }

    private static boolean isValidSessionId(String sessionId) {
        if (sessionId == null || sessionId.trim().isEmpty()) {
            return false;
        }
        String cleaned = sessionId.replaceAll("[\\s\\-_]", "");
        if (cleaned.length() < 8 || cleaned.length() > 64) {
            return false;
        }
        return cleaned.matches("[a-fA-F0-9]+");
    }

    private static void parseGlobalOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--password".equals(arg) && i + 1 < args.length) {
                String password = args[i + 1];
                EncryptionConfig.setCustomPassword(password);
                System.out.println("\u5df2\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u52a0\u5bc6\u5bc6\u7801");
                ++i;
                continue;
            }
            if (!"--no-encryption".equals(arg)) continue;
            EncryptionConfig.setEncryptionEnabled(false);
            System.out.println("\u8b66\u544a: \u5df2\u7981\u7528\u52a0\u5bc6\uff0c\u6570\u636e\u4f20\u8f93\u5c06\u4e0d\u53d7\u4fdd\u62a4\uff01");
        }
        System.setProperty("croc.multi.relay.enabled", "true");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            UnifiedTransfer.printUsage();
            return;
        }
        String mode = args[0].toLowerCase();
        UnifiedTransfer.parseGlobalOptions(args);
        try {
            if ("send".equals(mode)) {
                UnifiedTransfer.handleSendMode(args);
            } else if ("receive".equals(mode)) {
                UnifiedTransfer.handleReceiveMode(args);
            } else {
                System.out.println("\u9519\u8bef: \u672a\u77e5\u6a21\u5f0f '" + mode + "'");
                UnifiedTransfer.printUsage();
            }
        }
        catch (Exception e) {
            System.out.println("\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

