/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.FileSizeCategory;
import com.file.netty.utils.FileTransferUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BatchProgressTracker {
    private final FileSizeCategory category;
    private final int totalBatches;
    private final AtomicInteger currentBatch = new AtomicInteger(0);
    private final AtomicInteger currentFileInBatch = new AtomicInteger(0);
    private final AtomicInteger filesInCurrentBatch = new AtomicInteger(0);
    private final AtomicInteger transmittedCount = new AtomicInteger(0);
    private final AtomicInteger skippedCount = new AtomicInteger(0);
    private final AtomicInteger failedCount = new AtomicInteger(0);
    private final AtomicInteger pendingCount = new AtomicInteger(0);
    private final AtomicLong totalTransmittedBytes = new AtomicLong(0L);
    private final long startTime = System.currentTimeMillis();
    private volatile String currentFileName = "";
    private volatile boolean isCompleted = false;

    public BatchProgressTracker(FileSizeCategory category, int totalBatches) {
        this.category = category;
        this.totalBatches = totalBatches;
    }

    @Deprecated
    public BatchProgressTracker(int totalBatches) {
        this(FileSizeCategory.SMALL, totalBatches);
    }

    public void startBatch(int batchNum, int filesInBatch) {
        this.currentBatch.set(batchNum);
        this.filesInCurrentBatch.set(filesInBatch);
        this.currentFileInBatch.set(0);
    }

    public void updateCurrentFile(int globalFileIndex, String fileName) {
        int batchLocalIndex = this.currentFileInBatch.incrementAndGet();
        this.currentFileName = fileName;
        this.updateDisplay();
    }

    public void completeBatch(int transmitted, int skipped, int failed, long transmittedBytes) {
        this.transmittedCount.addAndGet(transmitted);
        this.skippedCount.addAndGet(skipped);
        this.failedCount.addAndGet(failed);
        this.totalTransmittedBytes.addAndGet(transmittedBytes);
        this.updateDisplay();
        System.out.print(" \u2713\n");
    }

    public void complete() {
        this.isCompleted = true;
        System.out.println();
        System.out.printf("\u2705 %s %s\u4f20\u8f93\u5b8c\u6210\uff01\n", this.category.getIcon(), this.category.getDisplayName());
        this.printFinalSummary();
    }

    private void updateDisplay() {
        if (this.isCompleted) {
            return;
        }
        int batchNum = this.currentBatch.get();
        int fileInBatch = this.currentFileInBatch.get();
        int filesInBatch = this.filesInCurrentBatch.get();
        long elapsedMs = System.currentTimeMillis() - this.startTime;
        double avgSpeedMBps = elapsedMs > 0L ? (double)this.totalTransmittedBytes.get() / 1024.0 / 1024.0 / ((double)elapsedMs / 1000.0) : 0.0;
        int pending = this.pendingCount.get();
        String displayFileName = this.currentFileName.length() > 60 ? this.currentFileName.substring(0, 25) + "..." + this.currentFileName.substring(this.currentFileName.length() - 32) : this.currentFileName;
        if (this.totalBatches > 0) {
            System.out.printf("\r%s %s\u6279\u6b21(%d/%d) %d/%d | \u4f20\u8f93:%d \u8df3\u8fc7:%d \u5931\u8d25:%d \u5f85\u4f20\u8f93:%d | \u5f53\u524d\u5904\u7406: %s | %.2f MB/s  ", this.category.getIcon(), this.category.getDisplayName(), batchNum, this.totalBatches, fileInBatch, filesInBatch, this.transmittedCount.get(), this.skippedCount.get(), this.failedCount.get(), pending, displayFileName, avgSpeedMBps);
        } else {
            System.out.printf("\r%s %s\u6279\u6b21(%d) %d/%d | \u4f20\u8f93:%d \u8df3\u8fc7:%d \u5931\u8d25:%d | \u5f53\u524d\u5904\u7406: %s | %.2f MB/s  ", this.category.getIcon(), this.category.getDisplayName(), batchNum, fileInBatch, filesInBatch, this.transmittedCount.get(), this.skippedCount.get(), this.failedCount.get(), displayFileName, avgSpeedMBps);
        }
    }

    public void setPendingCount(int count) {
        this.pendingCount.set(count);
    }

    public int getTransmittedCount() {
        return this.transmittedCount.get();
    }

    public int getSkippedCount() {
        return this.skippedCount.get();
    }

    public int getFailedCount() {
        return this.failedCount.get();
    }

    public FileSizeCategory getCategory() {
        return this.category;
    }

    private void printFinalSummary() {
        long elapsedMs = System.currentTimeMillis() - this.startTime;
        double totalTimeSeconds = (double)elapsedMs / 1000.0;
        double avgSpeedMBps = totalTimeSeconds > 0.0 ? (double)this.totalTransmittedBytes.get() / 1024.0 / 1024.0 / totalTimeSeconds : 0.0;
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.printf("\ud83d\udcca %s\u4f20\u8f93\u7edf\u8ba1:\n", this.category.getDisplayName());
        System.out.printf("   \u2022 \u6587\u4ef6\u7c7b\u578b: %s (%s)\n", this.category.getDisplayName(), this.category.getSizeRange());
        if (this.totalBatches > 0) {
            System.out.printf("   \u2022 \u603b\u6279\u6b21: %d (\u6bcf\u6279%d\u4e2a\u6587\u4ef6)\n", this.totalBatches, this.category.getBatchSize());
        } else {
            System.out.printf("   \u2022 \u6279\u6b21\u5927\u5c0f: \u6bcf\u6279\u6700\u591a%d\u4e2a\u6587\u4ef6\n", this.category.getBatchSize());
        }
        System.out.printf("   \u2022 \u4f20\u8f93\u6587\u4ef6: %d\n", this.transmittedCount.get());
        System.out.printf("   \u2022 \u8df3\u8fc7\u6587\u4ef6: %d\n", this.skippedCount.get());
        System.out.printf("   \u2022 \u5931\u8d25\u6587\u4ef6: %d\n", this.failedCount.get());
        System.out.printf("   \u2022 \u4f20\u8f93\u5927\u5c0f: %s\n", FileTransferUtils.formatBytes(this.totalTransmittedBytes.get()));
        System.out.printf("   \u2022 \u603b\u8017\u65f6: %.1f \u79d2\n", totalTimeSeconds);
        System.out.printf("   \u2022 \u5e73\u5747\u901f\u5ea6: %.2f MB/s\n", avgSpeedMBps);
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }
}

