/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.FileTransferUtils;
import java.io.File;

public class ConsoleFormatter {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    public static final String BRIGHT_BLACK = "\u001b[90m";
    public static final String BRIGHT_RED = "\u001b[91m";
    public static final String BRIGHT_GREEN = "\u001b[92m";
    public static final String BRIGHT_YELLOW = "\u001b[93m";
    public static final String BRIGHT_BLUE = "\u001b[94m";
    public static final String BRIGHT_PURPLE = "\u001b[95m";
    public static final String BRIGHT_CYAN = "\u001b[96m";
    public static final String BRIGHT_WHITE = "\u001b[97m";
    public static final String BG_BLACK = "\u001b[40m";
    public static final String BG_RED = "\u001b[41m";
    public static final String BG_GREEN = "\u001b[42m";
    public static final String BG_YELLOW = "\u001b[43m";
    public static final String BG_BLUE = "\u001b[44m";
    public static final String BG_PURPLE = "\u001b[45m";
    public static final String BG_CYAN = "\u001b[46m";
    public static final String BG_WHITE = "\u001b[47m";
    public static final String BOLD = "\u001b[1m";
    public static final String UNDERLINE = "\u001b[4m";
    public static final String BLINK = "\u001b[5m";

    public static String colorize(String text, String color) {
        return color + text + RESET;
    }

    public static String green(String text) {
        return GREEN + text + RESET;
    }

    public static String brightGreen(String text) {
        return BRIGHT_GREEN + text + RESET;
    }

    public static String red(String text) {
        return RED + text + RESET;
    }

    public static String yellow(String text) {
        return YELLOW + text + RESET;
    }

    public static String blue(String text) {
        return BLUE + text + RESET;
    }

    public static String cyan(String text) {
        return CYAN + text + RESET;
    }

    public static String bold(String text) {
        return BOLD + text + RESET;
    }

    public static String underline(String text) {
        return UNDERLINE + text + RESET;
    }

    public static String boldGreen(String text) {
        return "\u001b[1m\u001b[32m" + text + RESET;
    }

    public static String boldBrightGreen(String text) {
        return "\u001b[1m\u001b[92m" + text + RESET;
    }

    public static String highlightGreen(String text) {
        return "\u001b[42m\u001b[37m\u001b[1m" + text + RESET;
    }

    public static boolean isColorSupported() {
        String os = System.getProperty("os.name").toLowerCase();
        String term = System.getenv("TERM");
        if (os.contains("windows")) {
            return System.getProperty("os.version").compareTo("10") >= 0;
        }
        return term != null && !term.equals("dumb");
    }

    public static String safeColorize(String text, String color) {
        if (ConsoleFormatter.isColorSupported()) {
            return ConsoleFormatter.colorize(text, color);
        }
        return text;
    }

    public static String safeGreen(String text) {
        return ConsoleFormatter.safeColorize(text, BRIGHT_GREEN);
    }

    public static String safeBoldBrightGreen(String text) {
        if (ConsoleFormatter.isColorSupported()) {
            return ConsoleFormatter.boldBrightGreen(text);
        }
        return "\u3010" + text + "\u3011";
    }

    public static void printFileTransferComplete(File file, double totalTimeMs, double speedMBps) {
        System.out.println();
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\ud83c\udf89 \u6587\u4ef6\u4f20\u8f93\u5b8c\u6210");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc4 " + file.getName());
        System.out.println("\ud83d\udce6 " + FileTransferUtils.formatFileSize(file.length()) + "  \u23f0 " + String.format("%.2f \u79d2", totalTimeMs / 1000.0) + "  \u26a1 " + String.format("%.2f MB/s", speedMBps));
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println();
    }

    public static void printFileReceiveComplete(String fileName, long fileSize, String saveDir, double totalTime, double speedMBps) {
        System.out.println();
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\ud83d\udce5 \u6587\u4ef6\u63a5\u6536\u5b8c\u6210");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc4 " + fileName);
        System.out.println("\ud83d\udce6 " + FileTransferUtils.formatFileSize(fileSize) + "  \u23f0 " + String.format("%.2f \u79d2", totalTime / 1000.0) + "  \u26a1 " + String.format("%.2f MB/s", speedMBps));
        System.out.println("\ud83d\udcc2 \u4fdd\u5b58\u4f4d\u7f6e: " + saveDir + File.separator + fileName);
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    public static void printFolderTransferComplete(File folder, int totalFiles, long totalSize, double totalTimeMs, double speedMBps) {
        System.out.println();
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\ud83c\udf89 \u6587\u4ef6\u5939\u4f20\u8f93\u5b8c\u6210");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc1 " + folder.getName());
        System.out.println("\ud83d\udcca " + totalFiles + " \u4e2a\u6587\u4ef6  \ud83d\udce6 " + FileTransferUtils.formatFileSize(totalSize) + "  \u23f0 " + String.format("%.2f \u79d2", totalTimeMs / 1000.0) + "  \u26a1 " + String.format("%.2f MB/s", speedMBps));
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println();
    }

    public static void printFolderReceiveComplete(String folderName, int filesReceived, int totalFiles, long totalSize, String saveDir, double totalTimeMs, double speedMBps) {
        System.out.println();
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\ud83c\udf89 \u6587\u4ef6\u5939\u63a5\u6536\u5b8c\u6210");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\ud83d\udcc1 " + folderName);
        System.out.println("\ud83d\udcca " + filesReceived + "/" + totalFiles + " \u4e2a\u6587\u4ef6  \ud83d\udce6 " + FileTransferUtils.formatFileSize(totalSize) + "  \u23f0 " + String.format("%.2f \u79d2", totalTimeMs / 1000.0) + "  \u26a1 " + String.format("%.2f MB/s", speedMBps));
        System.out.println("\ud83d\udcbe " + new File(saveDir, folderName).getAbsolutePath());
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println();
    }
}

