/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTimeoutCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DynamicTimeoutCalculator.class);
    private static final int BASE_TIMEOUT = 30;
    private static final int MIN_TIMEOUT = 15;
    private static final int MAX_TIMEOUT = 300;
    private static final int COMPRESSED_BATCH_MAX_TIMEOUT = 600;
    private static final double FAST_NETWORK_SPEED = 10.0;
    private static final double MEDIUM_NETWORK_SPEED = 1.0;
    private static final double SLOW_NETWORK_SPEED = 0.1;

    public static int calculateTimeout(long dataSize, TransferType transferType, NetworkCondition networkCondition) {
        return DynamicTimeoutCalculator.calculateTimeout(dataSize, transferType, networkCondition, 0.0);
    }

    public static int calculateTimeout(long dataSize, TransferType transferType, NetworkCondition networkCondition, double historicalSpeedMBps) {
        double safetyFactor;
        double estimatedSpeedMBps;
        int baseTimeout = 30;
        int maxTimeout = 300;
        switch (transferType) {
            case COMPRESSED_BATCH: {
                baseTimeout = 60;
                maxTimeout = 600;
                break;
            }
            case BATCH_FILE: {
                baseTimeout = 45;
                break;
            }
            case SINGLE_FILE: {
                baseTimeout = 30;
                break;
            }
            case FOLDER_INFO: {
                baseTimeout = 20;
                break;
            }
            case HEARTBEAT: {
                return 10;
            }
        }
        if (historicalSpeedMBps > 0.0) {
            estimatedSpeedMBps = historicalSpeedMBps * 0.7;
        } else {
            switch (networkCondition) {
                case FAST: {
                    estimatedSpeedMBps = 10.0;
                    break;
                }
                case MEDIUM: {
                    estimatedSpeedMBps = 1.0;
                    break;
                }
                case SLOW: {
                    estimatedSpeedMBps = 0.1;
                    break;
                }
                default: {
                    estimatedSpeedMBps = 1.0;
                }
            }
        }
        double dataSizeMB = (double)dataSize / 1048576.0;
        int estimatedTransferTime = (int)Math.ceil(dataSizeMB / estimatedSpeedMBps);
        switch (transferType) {
            case COMPRESSED_BATCH: {
                safetyFactor = 4.0;
                break;
            }
            case BATCH_FILE: {
                safetyFactor = 3.0;
                break;
            }
            default: {
                safetyFactor = 2.5;
            }
        }
        int calculatedTimeout = Math.max(baseTimeout, (int)((double)estimatedTransferTime * safetyFactor));
        int finalTimeout = Math.max(15, Math.min(calculatedTimeout, maxTimeout));
        if (logger.isDebugEnabled()) {
            logger.debug("\u52a8\u6001\u8d85\u65f6\u8ba1\u7b97 - \u6570\u636e\u5927\u5c0f: {:.2f}MB, \u4f20\u8f93\u7c7b\u578b: {}, \u7f51\u7edc\u72b6\u51b5: {}, \u5386\u53f2\u901f\u5ea6: {:.2f}MB/s, \u4f30\u7b97\u901f\u5ea6: {:.2f}MB/s, \u4f30\u7b97\u65f6\u95f4: {}s, \u5b89\u5168\u7cfb\u6570: {:.1f}, \u6700\u7ec8\u8d85\u65f6: {}s", new Object[]{dataSizeMB, transferType, networkCondition, historicalSpeedMBps, estimatedSpeedMBps, estimatedTransferTime, safetyFactor, finalTimeout});
        }
        return finalTimeout;
    }

    public static NetworkCondition assessNetworkCondition(double averageSpeedMBps) {
        if (averageSpeedMBps >= 8.0) {
            return NetworkCondition.FAST;
        }
        if (averageSpeedMBps >= 0.8) {
            return NetworkCondition.MEDIUM;
        }
        if (averageSpeedMBps >= 0.05) {
            return NetworkCondition.SLOW;
        }
        return NetworkCondition.UNKNOWN;
    }

    public static String formatTimeout(int timeoutSeconds) {
        if (timeoutSeconds < 60) {
            return timeoutSeconds + "s";
        }
        if (timeoutSeconds < 3600) {
            int minutes = timeoutSeconds / 60;
            int seconds = timeoutSeconds % 60;
            return String.format("%dm%ds", minutes, seconds);
        }
        int hours = timeoutSeconds / 3600;
        int minutes = timeoutSeconds % 3600 / 60;
        return String.format("%dh%dm", hours, minutes);
    }

    public static enum TransferType {
        SINGLE_FILE,
        BATCH_FILE,
        COMPRESSED_BATCH,
        FOLDER_INFO,
        HEARTBEAT;

    }

    public static enum NetworkCondition {
        FAST,
        MEDIUM,
        SLOW,
        UNKNOWN;

    }

    public static class BatchTransferTimeout {
        private final long totalDataSize;
        private final int fileCount;
        private final TransferType transferType;
        private double historicalSpeed = 0.0;
        private NetworkCondition networkCondition = NetworkCondition.UNKNOWN;

        public BatchTransferTimeout(long totalDataSize, int fileCount, TransferType transferType) {
            this.totalDataSize = totalDataSize;
            this.fileCount = fileCount;
            this.transferType = transferType;
        }

        public BatchTransferTimeout withHistoricalSpeed(double speedMBps) {
            this.historicalSpeed = speedMBps;
            this.networkCondition = DynamicTimeoutCalculator.assessNetworkCondition(speedMBps);
            return this;
        }

        public BatchTransferTimeout withNetworkCondition(NetworkCondition condition) {
            this.networkCondition = condition;
            return this;
        }

        public int calculate() {
            long adjustedDataSize = this.totalDataSize;
            if (this.fileCount > 100) {
                adjustedDataSize = (long)((double)this.totalDataSize * (1.0 + (double)this.fileCount / 1000.0));
            }
            return DynamicTimeoutCalculator.calculateTimeout(adjustedDataSize, this.transferType, this.networkCondition, this.historicalSpeed);
        }

        public String getDescription() {
            int timeout = this.calculate();
            double dataSizeMB = (double)this.totalDataSize / 1048576.0;
            return String.format("\u6279\u6b21\u4f20\u8f93\u8d85\u65f6: %s (\u6570\u636e: %.1fMB, \u6587\u4ef6: %d\u4e2a, \u7f51\u7edc: %s)", new Object[]{DynamicTimeoutCalculator.formatTimeout(timeout), dataSizeMB, this.fileCount, this.networkCondition});
        }
    }
}

