/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.FileTransferUtils;

public enum FileSizeCategory {
    MICRO("\u5fae\u578b\u6587\u4ef6", 0L, 1024L, 200, "\ud83d\udd2c"),
    TINY("\u5fae\u5c0f\u6587\u4ef6", 1024L, 10240L, 100, "\ud83e\udde9"),
    SMALL("\u5c0f\u6587\u4ef6", 10240L, 102400L, 50, "\ud83d\udce6"),
    MEDIUM("\u4e2d\u7b49\u6587\u4ef6", 102400L, 0x100000L, 20, "\ud83d\udcc1"),
    LARGE("\u5927\u6587\u4ef6", 0x100000L, 0xA00000L, 5, "\ud83d\udcc2"),
    HUGE("\u5de8\u5927\u6587\u4ef6", 0xA00000L, 0x6400000L, 2, "\ud83d\uddc2\ufe0f"),
    MASSIVE("\u8d85\u5927\u6587\u4ef6", 0x6400000L, Long.MAX_VALUE, 1, "\ud83c\udfe2");

    private final String displayName;
    private final long minSize;
    private final long maxSize;
    private final int batchSize;
    private final String icon;

    private FileSizeCategory(String displayName, long minSize, long maxSize, int batchSize, String icon) {
        this.displayName = displayName;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.batchSize = batchSize;
        this.icon = icon;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getIcon() {
        return this.icon;
    }

    public static FileSizeCategory categorizeFile(long fileSize) {
        for (FileSizeCategory category : FileSizeCategory.values()) {
            if (fileSize < category.minSize || fileSize >= category.maxSize) continue;
            return category;
        }
        return MASSIVE;
    }

    public String getSizeRange() {
        if (this.maxSize == Long.MAX_VALUE) {
            return String.format(">%s", FileTransferUtils.formatBytes(this.minSize));
        }
        return String.format("%s-%s", FileTransferUtils.formatBytes(this.minSize), FileTransferUtils.formatBytes(this.maxSize));
    }

    public String toString() {
        return String.format("%s %s (%s, \u6279\u6b21%d\u4e2a)", this.icon, this.displayName, this.getSizeRange(), this.batchSize);
    }
}

