/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.protocol.FileEntryInfo;
import com.file.netty.protocol.FolderInfoMessage;
import com.file.netty.utils.ParallelFolderStatsUtil;
import com.file.netty.utils.UnifiedHashCalculator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileTransferUtils.class);
    public static final int DEFAULT_CHUNK_SIZE = 262144;
    public static final int MEDIUM_FILE_CHUNK_SIZE = 524288;
    public static final int LARGE_FILE_CHUNK_SIZE = 0x100000;
    public static final long MEDIUM_FILE_THRESHOLD = 0xA00000L;
    public static final long LARGE_FILE_THRESHOLD = 0x6400000L;
    public static final int DEFAULT_THREAD_COUNT = 4;
    public static final String PERFORMANCE_VERSION = "v1.4.0-OPTIMIZED";
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 4096;

    public static int getOptimalChunkSize(long fileSize) {
        if (fileSize > 0x6400000L) {
            return 0x100000;
        }
        if (fileSize > 0xA00000L) {
            return 524288;
        }
        return 262144;
    }

    public static String generateSessionId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace('\\', '/');
    }

    public static int calculateChunks(long fileSize, int chunkSize) {
        if (fileSize <= 0L) {
            return 0;
        }
        return (int)Math.ceil((double)fileSize / (double)chunkSize);
    }

    public static String formatFileSize(long size) {
        double fileSize;
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int unitIndex = 0;
        for (fileSize = (double)size; fileSize > 1024.0 && unitIndex < units.length - 1; fileSize /= 1024.0, ++unitIndex) {
        }
        if (unitIndex == 0) {
            return String.format("%.0f %s", fileSize, units[unitIndex]);
        }
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(fileSize) + " " + units[unitIndex];
    }

    public static String calculateFileMD5(File file) {
        return UnifiedHashCalculator.calculateFileHash(file);
    }

    public static long calculateFileCRC32(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis, 65536);){
            int bytesRead;
            byte[] buffer = new byte[65536];
            while ((bytesRead = bis.read(buffer)) != -1) {
                crc32.update(buffer, 0, bytesRead);
            }
        }
        return crc32.getValue();
    }

    public static String get_processing_strategy(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return "\u65e0\u6548\u6587\u4ef6";
        }
        long file_length = file.length();
        if (file_length == 0L) {
            return "\u7a7a\u6587\u4ef6\u5904\u7406";
        }
        if (file_length <= 0x100000L) {
            return String.format("\u5c0f\u6587\u4ef6\u5168\u6587\u54c8\u5e0c (\u5927\u5c0f: %d \u5b57\u8282, \u7f13\u51b2\u533a: %d \u5b57\u8282)", file_length, Math.max(4096L, Math.min(file_length, 0x100000L)));
        }
        return String.format("\u5927\u6587\u4ef6\u5934\u5c3e\u54c8\u5e0c (\u5927\u5c0f: %d \u5b57\u8282, \u7f13\u51b2\u533a: %d \u5b57\u8282)", file_length, 0x100000);
    }

    public static boolean ensureDirectoryExists(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return true;
    }

    public static List<FileEntryInfo> getAllFileEntries(File folder, Path basePath) {
        ArrayList<FileEntryInfo> entries = new ArrayList<FileEntryInfo>();
        if (!folder.exists() || !folder.isDirectory()) {
            return entries;
        }
        logger.info("\u83b7\u53d6\u6587\u4ef6\u6761\u76ee - \u6587\u4ef6\u5939: {}, \u57fa\u7840\u8def\u5f84: {}", (Object)folder.getAbsolutePath(), (Object)basePath);
        FileTransferUtils.getAllFileEntriesRecursive(folder, basePath, entries);
        for (FileEntryInfo entry : entries) {
            logger.debug("\u6587\u4ef6\u6761\u76ee: {}, \u5927\u5c0f: {}, \u662f\u5426\u6587\u4ef6\u5939: {}", entry.getRelativePath(), FileTransferUtils.formatFileSize(entry.getFileSize()), entry.isDirectory());
        }
        return entries;
    }

    public static long calculateFolderInfoMessageSize(FolderInfoMessage folderInfoMsg) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(folderInfoMsg);
            oos.flush();
            byte[] serializedData = baos.toByteArray();
            oos.close();
            baos.close();
            return serializedData.length;
        }
        catch (IOException e) {
            throw new RuntimeException("\u8ba1\u7b97\u6d88\u606f\u5927\u5c0f\u5931\u8d25", e);
        }
    }

    private static void getAllFileEntriesRecursive(File current, Path basePath, List<FileEntryInfo> entries) {
        String relativePath;
        try {
            Path currentPath = current.toPath();
            relativePath = basePath.relativize(currentPath).toString();
            relativePath = relativePath.replace('\\', '/');
            logger.debug("\u5904\u7406: {} => \u76f8\u5bf9\u8def\u5f84: {}", (Object)current.getAbsolutePath(), (Object)relativePath);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u76f8\u5bf9\u8def\u5f84\u5931\u8d25: {}", (Object)current.getAbsolutePath(), (Object)e);
            return;
        }
        if (current.isDirectory()) {
            entries.add(new FileEntryInfo(relativePath, 0L, true));
            File[] files = current.listFiles();
            if (files != null) {
                for (File file : files) {
                    FileTransferUtils.getAllFileEntriesRecursive(file, basePath, entries);
                }
            }
        } else {
            entries.add(new FileEntryInfo(relativePath, current.length(), false));
        }
    }

    public static long calculateFolderSize(String folder_path) {
        Path path = Paths.get(folder_path, new String[0]);
        AtomicLong total_size = new AtomicLong(0L);
        try {
            ((Stream)Files.walk(path, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                try {
                    total_size.addAndGet(Files.size(p));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return total_size.get();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8ba1\u7b97\u6587\u4ef6\u5939\u5927\u5c0f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static int countFiles(String folder_path) {
        Path path = Paths.get(folder_path, new String[0]);
        AtomicInteger file_count = new AtomicInteger(0);
        try {
            ((Stream)Files.walk(path, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> file_count.incrementAndGet());
            return file_count.get();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8ba1\u7b97\u6587\u4ef6\u6570\u91cf\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static ParallelFolderStatsUtil.FolderStats getFolderStats(String folder_path) {
        return ParallelFolderStatsUtil.calculate_stats_parallel_stream(folder_path);
    }

    public static ParallelFolderStatsUtil.FolderStats getLargeFolderStats(String folder_path) {
        return ParallelFolderStatsUtil.calculate_stats_thread_pool(folder_path);
    }

    public static FolderBasicStats getBasicStats(String folder_path) {
        long start_time = System.currentTimeMillis();
        Path path = Paths.get(folder_path, new String[0]);
        AtomicLong total_size = new AtomicLong(0L);
        AtomicInteger file_count = new AtomicInteger(0);
        try {
            ((Stream)Files.walk(path, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                try {
                    long size = Files.size(p);
                    total_size.addAndGet(size);
                    file_count.incrementAndGet();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            long elapsed = System.currentTimeMillis() - start_time;
            return new FolderBasicStats(total_size.get(), file_count.get(), elapsed);
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u57fa\u672c\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static String getDefaultReceiveDirectory() {
        String currentWorkDir = System.getProperty("user.dir");
        logger.info("\u4f7f\u7528\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u4fdd\u5b58\u6587\u4ef6: {}", (Object)currentWorkDir);
        return currentWorkDir;
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    public static List<String> getEmptyDirectories(File folder, Path basePath) {
        ArrayList<String> emptyDirectories = new ArrayList<String>();
        if (!folder.exists() || !folder.isDirectory()) {
            return emptyDirectories;
        }
        logger.info("\ud83d\udd0d \u626b\u63cf\u7a7a\u76ee\u5f55: {}", (Object)folder.getAbsolutePath());
        long startTime = System.currentTimeMillis();
        try {
            Files.walk(basePath, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dirPath -> {
                try {
                    boolean isEmpty = Files.list(dirPath).noneMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                    boolean isCompletelyEmpty = Files.list(dirPath).allMatch(path -> Files.isDirectory(path, new LinkOption[0]));
                    if (isEmpty && isCompletelyEmpty) {
                        String relativePath = basePath.relativize((Path)dirPath).toString();
                        if (!(relativePath = relativePath.replace('\\', '/')).isEmpty()) {
                            emptyDirectories.add(relativePath);
                            logger.debug("\u53d1\u73b0\u7a7a\u76ee\u5f55: {}", (Object)relativePath);
                        }
                    }
                }
                catch (IOException e) {
                    logger.warn("\u626b\u63cf\u76ee\u5f55\u65f6\u51fa\u9519: {}", dirPath, (Object)e);
                }
            });
        }
        catch (IOException e) {
            logger.error("\u626b\u63cf\u7a7a\u76ee\u5f55\u5931\u8d25: {}", (Object)folder.getAbsolutePath(), (Object)e);
        }
        long elapsed = System.currentTimeMillis() - startTime;
        logger.info("\u2705 \u7a7a\u76ee\u5f55\u626b\u63cf\u5b8c\u6210\uff0c\u53d1\u73b0 {} \u4e2a\u7a7a\u76ee\u5f55\uff0c\u8017\u65f6 {}ms", (Object)emptyDirectories.size(), (Object)elapsed);
        return emptyDirectories;
    }

    static {
        logger.info("\ud83d\ude80 \u6587\u4ef6\u4f20\u8f93\u6027\u80fd\u4f18\u5316\u7248\u672c: {} - \u5757\u5927\u5c0f: {}KB", (Object)PERFORMANCE_VERSION, (Object)256);
    }

    public static class FolderBasicStats {
        private final long total_size;
        private final int file_count;
        private final long elapsed_time_ms;

        public FolderBasicStats(long total_size, int file_count, long elapsed_time_ms) {
            this.total_size = total_size;
            this.file_count = file_count;
            this.elapsed_time_ms = elapsed_time_ms;
        }

        public long getTotalSize() {
            return this.total_size;
        }

        public int getFileCount() {
            return this.file_count;
        }

        public long getElapsedTimeMs() {
            return this.elapsed_time_ms;
        }

        public String toString() {
            return String.format("\u5927\u5c0f: %s, \u6587\u4ef6\u6570: %d, \u8017\u65f6: %d ms", this.formatBytes(this.total_size), this.file_count, this.elapsed_time_ms);
        }

        private String formatBytes(long bytes) {
            if (bytes < 1024L) {
                return bytes + " B";
            }
            if (bytes < 0x100000L) {
                return String.format("%.2f KB", (double)bytes / 1024.0);
            }
            if (bytes < 0x40000000L) {
                return String.format("%.2f MB", (double)bytes / 1048576.0);
            }
            return String.format("%.2f GB", (double)bytes / 1.073741824E9);
        }
    }
}

