/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.utils.ExitMessageFormatter;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerExceptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(HandlerExceptionUtils.class);

    public static boolean isNormalConnectionClose(Throwable cause) {
        String msg = cause.getMessage();
        if (msg == null) {
            return false;
        }
        return msg.contains("Connection reset by peer") || msg.contains("\u8fdc\u7a0b\u4e3b\u673a\u5f3a\u8feb\u5173\u95ed\u4e86\u4e00\u4e2a\u73b0\u6709\u7684\u8fde\u63a5") || msg.contains("\u81ea\u5b9a\u4e49\u5df2\u65ad\u5f00\u8fde\u63a5") || msg.contains("An existing connection was forcibly closed") || msg.contains("Connection reset") || msg.contains("Broken pipe") || msg.contains("Connection timed out") || msg.contains("Software caused connection abort");
    }

    public static boolean isTransferCompleteDisconnection(Throwable cause) {
        String msg = cause.getMessage();
        if (msg == null) {
            return false;
        }
        return msg.contains("\u63a5\u6536\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5") || msg.contains("\u53d1\u9001\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5");
    }

    public static void handleException(ChannelHandlerContext ctx, Throwable cause, String handlerName) {
        if (HandlerExceptionUtils.isNormalConnectionClose(cause) || HandlerExceptionUtils.isTransferCompleteDisconnection(cause)) {
            logger.debug("{} \u8fde\u63a5\u6b63\u5e38\u65ad\u5f00: {}", (Object)handlerName, (Object)cause.getMessage());
            if (HandlerExceptionUtils.isTransferCompleteDisconnection(cause)) {
                logger.info("\u4f20\u8f93\u5b8c\u6210\u540e\u6b63\u5e38\u65ad\u5f00: {}", (Object)cause.getMessage());
                ExitMessageFormatter.showSenderExit();
            } else {
                System.out.println("\u2705 " + handlerName + " \u8fde\u63a5\u6b63\u5e38\u65ad\u5f00");
                ExitMessageFormatter.showSenderExit();
            }
            System.exit(0);
        } else {
            logger.error("{} \u5904\u7406\u5668\u5f02\u5e38: {}", handlerName, cause.getMessage(), cause);
            System.out.println("\u26a0\ufe0f \u53d1\u9001\u5931\u8d25: " + cause.getMessage());
        }
        try {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.close();
            }
        }
        catch (Exception e) {
            logger.debug("\u5173\u95ed\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }
}

